/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedAsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.RawAgreement;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.agreement.BasicRawAgreement;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.agreement.X448Agreement;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.AbstractPublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.RFC6637KDFCalculator;
import org.bouncycastle.util.Arrays;

public class BcPublicKeyDataDecryptorFactory
extends AbstractPublicKeyDataDecryptorFactory {
    private static final BcPGPKeyConverter KEY_CONVERTER = new BcPGPKeyConverter();
    private final PGPPrivateKey pgpPrivKey;

    public BcPublicKeyDataDecryptorFactory(PGPPrivateKey pGPPrivateKey) {
        this.pgpPrivKey = pGPPrivateKey;
    }

    @Override
    public byte[] recoverSessionData(int n, byte[][] byArray, int n2) throws PGPException {
        try {
            AsymmetricKeyParameter asymmetricKeyParameter = KEY_CONVERTER.getPrivateKey(this.pgpPrivKey);
            if (n == 25) {
                return this.getSessionData(byArray[0], asymmetricKeyParameter, 32, 8, 7, (RawAgreement)new X25519Agreement(), "X25519", this.containsSKAlg(n2), new PublicKeyParametersOperation(){

                    @Override
                    public AsymmetricKeyParameter getPublicKeyParameters(byte[] byArray, int n) {
                        return new X25519PublicKeyParameters(byArray, 0);
                    }
                });
            }
            if (n == 26) {
                return this.getSessionData(byArray[0], asymmetricKeyParameter, 56, 10, 9, (RawAgreement)new X448Agreement(), "X448", this.containsSKAlg(n2), new PublicKeyParametersOperation(){

                    @Override
                    public AsymmetricKeyParameter getPublicKeyParameters(byte[] byArray, int n) {
                        return new X448PublicKeyParameters(byArray, 0);
                    }
                });
            }
            if (n == 18) {
                return this.recoverECDHSessionData(byArray, asymmetricKeyParameter);
            }
            if (n == 2 || n == 1) {
                return this.recoverRSASessionData(n, byArray, asymmetricKeyParameter);
            }
            return this.recoverElgamalSessionData(n, byArray, asymmetricKeyParameter);
        }
        catch (IOException iOException) {
            throw new PGPException("exception creating user keying material: " + iOException.getMessage(), iOException);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("exception decrypting session info: " + invalidCipherTextException.getMessage(), (Exception)((Object)invalidCipherTextException));
        }
    }

    private byte[] recoverElgamalSessionData(int n, byte[][] byArray, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException, InvalidCipherTextException {
        BufferedAsymmetricBlockCipher bufferedAsymmetricBlockCipher = BcPublicKeyDataDecryptorFactory.getBufferedAsymmetricBlockCipher(n, asymmetricKeyParameter);
        ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)asymmetricKeyParameter;
        int n2 = (elGamalPrivateKeyParameters.getParameters().getP().bitLength() + 7) / 8;
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = byArray[0];
        this.processEncodedMpi(bufferedAsymmetricBlockCipher, n2, byArray2, byArray3);
        byArray3 = byArray[1];
        Arrays.fill((byte[])byArray2, (byte)0);
        this.processEncodedMpi(bufferedAsymmetricBlockCipher, n2, byArray2, byArray3);
        return bufferedAsymmetricBlockCipher.doFinal();
    }

    private byte[] recoverRSASessionData(int n, byte[][] byArray, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException, InvalidCipherTextException {
        BufferedAsymmetricBlockCipher bufferedAsymmetricBlockCipher = BcPublicKeyDataDecryptorFactory.getBufferedAsymmetricBlockCipher(n, asymmetricKeyParameter);
        byte[] byArray2 = byArray[0];
        bufferedAsymmetricBlockCipher.processBytes(byArray2, 2, byArray2.length - 2);
        return bufferedAsymmetricBlockCipher.doFinal();
    }

    private static BufferedAsymmetricBlockCipher getBufferedAsymmetricBlockCipher(int n, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException {
        BufferedAsymmetricBlockCipher bufferedAsymmetricBlockCipher = new BufferedAsymmetricBlockCipher(BcImplProvider.createPublicKeyCipher(n));
        bufferedAsymmetricBlockCipher.init(false, (CipherParameters)asymmetricKeyParameter);
        return bufferedAsymmetricBlockCipher;
    }

    private void processEncodedMpi(BufferedAsymmetricBlockCipher bufferedAsymmetricBlockCipher, int n, byte[] byArray, byte[] byArray2) {
        if (byArray2.length - 2 > n) {
            bufferedAsymmetricBlockCipher.processBytes(byArray2, 3, byArray2.length - 3);
        } else {
            System.arraycopy(byArray2, 2, byArray, byArray.length - (byArray2.length - 2), byArray2.length - 2);
            bufferedAsymmetricBlockCipher.processBytes(byArray, 0, byArray.length);
        }
    }

    private byte[] recoverECDHSessionData(byte[][] byArray, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException, IOException, InvalidCipherTextException {
        ECDomainParameters eCDomainParameters;
        byte[] byArray2;
        byte[] byArray3 = byArray[0];
        int n = (((byArray3[0] & 0xFF) << 8) + (byArray3[1] & 0xFF) + 7) / 8;
        BcPublicKeyDataDecryptorFactory.checkRange(2 + n + 1, byArray3);
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray3, 2, byArray4, 0, n);
        int n2 = byArray3[n + 2] & 0xFF;
        BcPublicKeyDataDecryptorFactory.checkRange(2 + n + 1 + n2, byArray3);
        byte[] byArray5 = new byte[n2];
        System.arraycopy(byArray3, 2 + n + 1, byArray5, 0, n2);
        ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)this.pgpPrivKey.getPublicKeyPacket().getKey();
        if (eCDHPublicBCPGKey.getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
            if (byArray4.length != 33 || 64 != byArray4[0]) {
                throw new IllegalArgumentException("Invalid Curve25519 public key");
            }
            byArray2 = BcUtil.getSecret((RawAgreement)new X25519Agreement(), asymmetricKeyParameter, (AsymmetricKeyParameter)new X25519PublicKeyParameters(byArray4, 1));
        } else if (eCDHPublicBCPGKey.getCurveOID().equals((ASN1Primitive)EdECObjectIdentifiers.id_X448)) {
            if (byArray4.length != 57 || 64 != byArray4[0]) {
                throw new IllegalArgumentException("Invalid Curve448 public key");
            }
            byArray2 = BcUtil.getSecret((RawAgreement)new X448Agreement(), asymmetricKeyParameter, (AsymmetricKeyParameter)new X448PublicKeyParameters(byArray4, 1));
        } else {
            eCDomainParameters = ((ECPrivateKeyParameters)asymmetricKeyParameter).getParameters();
            ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(eCDomainParameters.getCurve().decodePoint(byArray4), eCDomainParameters);
            byArray2 = BcUtil.getSecret((RawAgreement)new BasicRawAgreement((BasicAgreement)new ECDHBasicAgreement()), asymmetricKeyParameter, (AsymmetricKeyParameter)eCPublicKeyParameters);
        }
        byte by = eCDHPublicBCPGKey.getHashAlgorithm();
        byte by2 = eCDHPublicBCPGKey.getSymmetricKeyAlgorithm();
        byte[] byArray6 = RFC6637Utils.createUserKeyingMaterial(this.pgpPrivKey.getPublicKeyPacket(), new BcKeyFingerprintCalculator());
        RFC6637KDFCalculator rFC6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(by), by2);
        eCDomainParameters = new KeyParameter(rFC6637KDFCalculator.createKey(byArray2, byArray6));
        return PGPPad.unpadSessionData(BcPublicKeyDataDecryptorFactory.unwrapSessionData(byArray5, by2, (KeyParameter)eCDomainParameters));
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
        return BcUtil.createDataDecryptor(bl, blockCipher, byArray);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
    }

    private byte[] getSessionData(byte[] byArray, AsymmetricKeyParameter asymmetricKeyParameter, int n, int n2, int n3, RawAgreement rawAgreement, String string, boolean bl, PublicKeyParametersOperation publicKeyParametersOperation) throws PGPException, InvalidCipherTextException {
        byte[] byArray2 = Arrays.copyOf((byte[])byArray, (int)n);
        int n4 = byArray[n] & 0xFF;
        BcPublicKeyDataDecryptorFactory.checkRange(n + 1 + n4, byArray);
        int n5 = n4 - (bl ? 1 : 0);
        int n6 = n + 1 + (bl ? 1 : 0);
        byte[] byArray3 = Arrays.copyOfRange((byte[])byArray, (int)n6, (int)(n6 + n5));
        byte[] byArray4 = BcUtil.getSecret(rawAgreement, asymmetricKeyParameter, publicKeyParametersOperation.getPublicKeyParameters(byArray2, 0));
        byte[] byArray5 = RFC6637KDFCalculator.createKey(n2, n3, Arrays.concatenate((byte[])byArray2, (byte[])this.pgpPrivKey.getPublicKeyPacket().getKey().getEncoded(), (byte[])byArray4), "OpenPGP " + string);
        return BcPublicKeyDataDecryptorFactory.unwrapSessionData(byArray3, 7, new KeyParameter(byArray5));
    }

    private static byte[] unwrapSessionData(byte[] byArray, int n, KeyParameter keyParameter) throws PGPException, InvalidCipherTextException {
        Wrapper wrapper = BcImplProvider.createWrapper(n);
        wrapper.init(false, (CipherParameters)keyParameter);
        return wrapper.unwrap(byArray, 0, byArray.length);
    }

    @FunctionalInterface
    private static interface PublicKeyParametersOperation {
        public AsymmetricKeyParameter getPublicKeyParameters(byte[] var1, int var2);
    }
}

