\name{MagnitudeAndPhaseToComplexImageFilter}
\alias{MagnitudeAndPhaseToComplexImageFilter}
\title{MagnitudeAndPhaseToComplexImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Implements pixel-wise conversion of magnitude and phase data into
complex voxels.
MagnitudeAndPhaseToComplexImageFilter}
\details{
This filter is parameterized over the types of the two input images
and the type of the output image.
The filter expect all images to have the same dimension (e.g. all 2D,
or all 3D, or all ND)
See:
MagnitudeAndPhaseToComplex for the procedural interface
itk::MagnitudeAndPhaseToComplexImageFilter for the Doxygen on the original ITK class.
MagnitudeAndPhaseToComplexImageFilter}
%C++ includes: sitkMagnitudeAndPhaseToComplexImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, double constant):}{
Execute the filter with an image and a constant
}
\item{Image Execute(double constant, const Image &image2):}{}
\item{Image Execute(Image &&image1, const Image &image2):}{
Execute the filter on the input images
}
\item{Image Execute(Image &&image1, double constant):}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{ MagnitudeAndPhaseToComplexImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~MagnitudeAndPhaseToComplexImageFilter():}{
Destructor
}
}
}
