/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CThunkObject;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.PyCFuncPtrBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.PyCFuncPtrBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.ctypes.PyCFuncPtrObject;
import com.oracle.graal.python.builtins.modules.ctypes.PyCFuncPtrTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.Pointer;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.common.KeywordsStorage;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotInquiry;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PyCFuncPtr})
public final class PyCFuncPtrBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = PyCFuncPtrBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PyCFuncPtrBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        core.getContext().registerCApiHook(() -> CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_PY_TRUFFLE_CDATA_INIT_BUFFER_PROTOCOL, CApiTransitions.PythonToNativeNode.executeUncached((Object)PythonBuiltinClassType.PyCFuncPtr)));
    }

    @GenerateInline(value=false)
    protected static abstract class PyCFuncPtrFromDllNode
    extends Node {
        private static final char[] PzZ = "PzZ".toCharArray();

        protected PyCFuncPtrFromDllNode() {
        }

        abstract Object execute(VirtualFrame var1, Object var2, Object[] var3);

        @Specialization
        static Object PyCFuncPtr_FromDll(VirtualFrame frame, Object type, Object[] args, @Bind Node inliningTarget, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached CtypesModuleBuiltins.CtypesDlSymNode dlSymNode, @Cached PointerNodes.PointerFromLongNode pointerFromLongNode, @Cached PointerNodes.WritePointerNode writePointerNode, @Cached PyLongCheckNode longCheckNode, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached CastToTruffleStringNode toString, @Cached CDataTypeBuiltins.KeepRefNode keepRefNode, @Cached PyObjectGetAttr getAttributeNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached CtypesNodes.GenericPyCDataNewNode pyCDataNewNode, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached PRaiseNode raiseNode) {
            Object object;
            Pointer handlePtr;
            PTuple tuple = (PTuple)args[0];
            Object[] paramflags = null;
            if (args.length > 1 && args[1] instanceof PTuple) {
                paramflags = getArray.execute(inliningTarget, ((PTuple)args[1]).getSequenceStorage());
            }
            Object[] ftuple = getArray.execute(inliningTarget, tuple.getSequenceStorage());
            TruffleString name = toString.execute(inliningTarget, ftuple[0]);
            Object dll = ftuple[1];
            auditNode.audit(inliningTarget, "ctypes.dlsym", dll, name);
            Object obj = getAttributeNode.execute((Frame)frame, inliningTarget, dll, CDataTypeBuiltins.T__HANDLE);
            if (!longCheckNode.execute(inliningTarget, obj)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.THE_HANDLE_ATTRIBUTE_OF_THE_SECOND_ARGUMENT_MUST_BE_AN_INTEGER);
            }
            try {
                handlePtr = pointerFromLongNode.execute(inliningTarget, obj);
            }
            catch (PException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.COULD_NOT_CONVERT_THE_HANDLE_ATTRIBUTE_TO_A_POINTER);
            }
            Object address = dlSymNode.execute(frame, handlePtr, name, PythonErrorType.AttributeError);
            PyCFuncPtrFromDllNode._validate_paramflags(inliningTarget, type, paramflags, pyTypeCheck, getArray, pyTypeStgDictNode, codePointAtIndexNode, raiseNode);
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, type, raiseNode);
            PyCFuncPtrObject self = (PyCFuncPtrObject)pyCDataNewNode.execute(inliningTarget, type, dict);
            self.paramflags = paramflags;
            if (address instanceof PythonNativeVoidPtr) {
                PythonNativeVoidPtr ptr = (PythonNativeVoidPtr)address;
                object = ptr.getPointerObject();
            } else {
                object = address;
            }
            Object addressObj = object;
            writePointerNode.execute(inliningTarget, self.b_ptr, Pointer.nativeMemory(addressObj));
            keepRefNode.execute(frame, inliningTarget, self, 0, dll);
            self.callable = self;
            return self;
        }

        static void _validate_paramflags(Node inliningTarget, Object type, Object[] paramflags, CtypesNodes.PyTypeCheck pyTypeCheck, SequenceStorageNodes.GetInternalObjectArrayNode getArray, StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode, PRaiseNode raiseNode) {
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, type, raiseNode);
            Object[] argtypes = dict.argtypes;
            if (paramflags == null || dict.argtypes == null) {
                return;
            }
            if (!PGuards.isPTuple(paramflags)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.PARAMFLAGS_MUST_BE_A_TUPLE_OR_NONE);
            }
            int len = paramflags.length;
            if (len != dict.argtypes.length) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.PARAMFLAGS_MUST_HAVE_THE_SAME_LENGTH_AS_ARGTYPES);
            }
            block4: for (int i = 0; i < len; ++i) {
                PTuple item = (PTuple)paramflags[i];
                Object[] array = getArray.execute(inliningTarget, item.getSequenceStorage());
                int flag = (Integer)array[0];
                if (array.length > 1 && !PGuards.isString(array[1])) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.PARAMFLAGS_MUST_BE_A_SEQUENCE_OF_INT_STRING_VALUE_TUPLES);
                }
                Object typ = argtypes[i];
                switch (flag & 7) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 5: {
                        continue block4;
                    }
                    case 2: {
                        PyCFuncPtrFromDllNode._check_outarg_type(inliningTarget, typ, i + 1, pyTypeCheck, pyTypeStgDictNode, codePointAtIndexNode, raiseNode);
                        continue block4;
                    }
                    default: {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.PARAMFLAG_VALUE_D_NOT_SUPPORTED, flag);
                    }
                }
            }
        }

        static void _check_outarg_type(Node inliningTarget, Object arg, int index, CtypesNodes.PyTypeCheck pyTypeCheck, StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode, PRaiseNode raiseNode) {
            if (pyTypeCheck.isPyCPointerTypeObject(inliningTarget, arg)) {
                return;
            }
            if (pyTypeCheck.isPyCArrayTypeObject(inliningTarget, arg)) {
                return;
            }
            StgDictObject dict = pyTypeStgDictNode.execute(inliningTarget, arg);
            if (dict != null && PGuards.isTruffleString(dict.proto) && PyCFuncPtrFromDllNode.strchr(PzZ, codePointAtIndexNode.execute((AbstractTruffleString)((TruffleString)dict.proto), 0, PythonUtils.TS_ENCODING))) {
                return;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OUT_PARAMETER_D_MUST_BE_A_POINTER_TYPE_NOT_N, index, arg);
        }

        protected static boolean strchr(char[] chars, int code) {
            for (char c : chars) {
                if (c != code) continue;
                return true;
            }
            return false;
        }
    }

    @Slot(value=Slot.SlotKind.tp_call, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class PyCFuncPtrCallNode
    extends PythonVarargsBuiltinNode {
        private static final int poutmask_idx = 0;
        private static final int pinoutmask_idx = 0;
        private static final int pnumretvals_idx = 0;

        protected PyCFuncPtrCallNode() {
        }

        @Specialization
        Object PyCFuncPtr_call(VirtualFrame frame, PyCFuncPtrObject self, Object[] inargs, PKeyword[] kwds, @Bind Node inliningTarget, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached CallNode callNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached CastToJavaIntExactNode castToJavaIntExactNode, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached PyObjectCallMethodObjArgs callMethodObjArgs, @Cached CtypesModuleBuiltins.CallProcNode callProcNode, @Cached TruffleString.EqualNode equalNode, @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached CtypesNodes.HandleFromPointerNode handleFromPointerNode, @Cached PRaiseNode raiseNode) {
            Object v;
            Object result;
            StgDictObject dict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (dict != null) : "Cannot be NULL for PyCFuncPtrObject instances";
            Object restype = self.restype != null ? self.restype : dict.restype;
            Object[] converters = self.converters != null ? self.converters : dict.converters;
            Object checker = self.checker != null ? self.checker : dict.checker;
            Object[] argtypes = self.argtypes != null ? self.argtypes : dict.argtypes;
            Object errcheck = self.errcheck;
            int[] props = new int[3];
            CtypesModuleBuiltins.NativeFunction pProc = handleFromPointerNode.getNativeFunction(inliningTarget, readPointerNode.execute(inliningTarget, self.b_ptr));
            if (pProc == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.NotImplementedError, ErrorMessages.CTYPES_FUNCTION_CALL_COULD_NOT_OBTAIN_FUNCTION_POINTER);
            }
            Object[] callargs = this._build_callargs(frame, inliningTarget, self, argtypes, inargs, kwds, props, pyTypeCheck, getArray, castToJavaIntExactNode, castToTruffleStringNode, pyTypeStgDictNode, callNode, equalNode, raiseNode);
            int inoutmask = props[0];
            int outmask = props[0];
            int numretvals = props[0];
            if (converters != null) {
                int required = converters.length;
                int actual = callargs.length;
                if ((dict.flags & 1) == 1) {
                    if (required > actual) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.THIS_FUNCTION_TAKES_AT_LEAST_D_ARGUMENT_S_D_GIVEN, required, required == 1 ? "" : "s", actual);
                    }
                } else if (required != actual) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.THIS_FUNCTION_TAKES_D_ARGUMENT_S_D_GIVEN, required, required == 1 ? "" : "s", actual);
                }
            }
            if ((result = callProcNode.execute(frame, pProc, callargs, dict.flags, argtypes, converters, restype, checker)) != null && errcheck != null && (v = callNode.execute((Frame)frame, errcheck, result, self, callargs)) != callargs) {
                return v;
            }
            return this._build_result(frame, inliningTarget, result, callargs, outmask, inoutmask, numretvals, callMethodObjArgs);
        }

        protected Object _get_arg(Node inliningTarget, int[] pindex, TruffleString name, Object defval, Object[] inargs, PKeyword[] kwds, TruffleString.EqualNode equalNode, PRaiseNode raiseNode) {
            int v;
            if (pindex[0] < inargs.length) {
                int n = pindex[0];
                pindex[0] = n + 1;
                return inargs[n];
            }
            if (kwds != null && name != null && (v = KeywordsStorage.findStringKey(kwds, name, equalNode)) != -1) {
                pindex[0] = pindex[0] + 1;
                return kwds[v].getValue();
            }
            if (defval != null) {
                return defval;
            }
            if (name != null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.REQUIRED_ARGUMENT_S_MISSING, name);
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.NOT_ENOUGH_ARGUMENTS);
        }

        Object[] _build_callargs(VirtualFrame frame, Node inliningTarget, PyCFuncPtrObject self, Object[] argtypes, Object[] inargs, PKeyword[] kwds, int[] props, CtypesNodes.PyTypeCheck pyTypeCheck, SequenceStorageNodes.GetInternalObjectArrayNode getArray, CastToJavaIntExactNode castToJavaIntExactNode, CastToTruffleStringNode castToTruffleStringNode, StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, CallNode callNode, TruffleString.EqualNode equalNode, PRaiseNode raiseNode) {
            props[0] = 0;
            if (argtypes == null || self.paramflags == null || argtypes.length == 0) {
                return inargs;
            }
            Object[] paramflags = self.paramflags;
            int len = argtypes.length;
            Object[] callargs = new Object[len];
            int[] inargs_index = new int[1];
            block6: for (int i = 0; i < len; ++i) {
                SequenceStorage storage = ((PTuple)paramflags[i]).getSequenceStorage();
                Object[] item = getArray.execute(inliningTarget, storage);
                int tsize = storage.length();
                int flag = castToJavaIntExactNode.execute(inliningTarget, item[0]);
                TruffleString name = tsize > 1 ? castToTruffleStringNode.execute(inliningTarget, item[1]) : null;
                Object defval = tsize > 2 ? item[2] : null;
                switch (flag & 7) {
                    case 5: {
                        if (defval == null) {
                            defval = 0;
                        }
                        callargs[i] = defval;
                        continue block6;
                    }
                    case 3: {
                        props[0] = props[0] | 1 << i;
                        props[0] = props[0] + 1;
                    }
                    case 0: 
                    case 1: {
                        Object ob;
                        callargs[i] = ob = this._get_arg(inliningTarget, inargs_index, name, defval, inargs, kwds, equalNode, raiseNode);
                        continue block6;
                    }
                    case 2: {
                        if (defval != null) {
                            callargs[i] = defval;
                            props[0] = props[0] | 1 << i;
                            props[0] = props[0] + 1;
                            continue block6;
                        }
                        Object ob = argtypes[i];
                        StgDictObject dict = pyTypeStgDictNode.execute(inliningTarget, ob);
                        if (dict == null) {
                            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.NULL_STGDICT_UNEXPECTED);
                        }
                        if (PGuards.isString(dict.proto)) {
                            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.N_OUT_PARAMETER_MUST_BE_PASSED_AS_DEFAULT_VALUE, ob);
                        }
                        ob = pyTypeCheck.isPyCArrayTypeObject(inliningTarget, ob) ? callNode.execute((Frame)frame, ob, new Object[0]) : callNode.execute((Frame)frame, dict.proto, new Object[0]);
                        callargs[i] = ob;
                        props[0] = props[0] | 1 << i;
                        props[0] = props[0] + 1;
                        continue block6;
                    }
                    default: {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.PARAMFLAG_D_NOT_YET_IMPLEMENTED, flag);
                    }
                }
            }
            int actual_args = inargs.length + (kwds != null ? kwds.length : 0);
            if (actual_args != inargs_index[0]) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CALL_TAKES_EXACTLY_D_ARGUMENTS_D_GIVEN, inargs_index, actual_args);
            }
            return callargs;
        }

        Object _build_result(VirtualFrame frame, Node inliningTarget, Object result, Object[] callargs, int outmask, int inoutmask, int numretvals, PyObjectCallMethodObjArgs callMethodObjArgs) {
            Object[] tup = null;
            if (callargs == null) {
                return result;
            }
            if (result == null || numretvals == 0) {
                return result;
            }
            if (numretvals > 1) {
                tup = new Object[numretvals];
            }
            int index = 0;
            int bit = 1;
            int i = 0;
            while (i < 32) {
                if ((bit & inoutmask) != 0) {
                    v = callargs[i];
                    if (numretvals == 1) {
                        return v;
                    }
                    assert (tup != null);
                    tup[index] = v;
                    ++index;
                } else if ((bit & outmask) != 0) {
                    v = callargs[i];
                    if ((v = callMethodObjArgs.execute((Frame)frame, inliningTarget, v, PyCFuncPtrTypeBuiltins.T___CTYPES_FROM_OUTPARAM__, new Object[0])) == null || numretvals == 1) {
                        return v;
                    }
                    assert (tup != null);
                    tup[index] = v;
                    ++index;
                }
                if (index == numretvals) break;
                ++i;
                bit <<= 1;
            }
            return tup;
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        TruffleString PyCFuncPtr_repr(CDataObject self, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached TypeNodes.GetNameNode getNameNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object clazz = getClassNode.execute(inliningTarget, self);
            return simpleTruffleStringFormatNode.format("<%s object at %s>", getNameNode.execute(inliningTarget, clazz), getNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, self)));
        }
    }

    @Builtin(name="argtypes", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="specify the argument types")
    @GenerateNodeFactory
    protected static abstract class PointerArgTypesNode
    extends PythonBinaryBuiltinNode {
        protected PointerArgTypesNode() {
        }

        @Specialization(guards={"isNoValue(value)", "self.argtypes != null"})
        static Object PyCFuncPtr_get_argtypes(PyCFuncPtrObject self, PNone value, @Bind PythonLanguage language) {
            return PFactory.createTuple(language, self.argtypes);
        }

        @Specialization(guards={"isNoValue(value)", "self.argtypes == null"})
        static Object PyCFuncPtr_get_argtypes(PyCFuncPtrObject self, PNone value, @Bind Node inliningTarget, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Bind PythonLanguage language) {
            StgDictObject dict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (dict != null) : "Cannot be NULL for PyCFuncPtrObject instances";
            if (dict.argtypes != null) {
                return PFactory.createTuple(language, dict.argtypes);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object PyCFuncPtr_set_argtypes(PyCFuncPtrObject self, PNone value) {
            self.converters = null;
            self.argtypes = null;
            return value;
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object PyCFuncPtr_set_argtypes(VirtualFrame frame, PyCFuncPtrObject self, PTuple value, @Bind Node inliningTarget, @Cached.Shared @Cached PyObjectLookupAttr lookupAttr, @Cached.Shared @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached.Shared @Cached PRaiseNode raiseNode) {
            SequenceStorage storage = value.getSequenceStorage();
            Object[] ob = getArray.execute(inliningTarget, value.getSequenceStorage());
            self.converters = PyCFuncPtrTypeBuiltins.PyCFuncPtrTypeNewNode.converters_from_argtypes(frame, inliningTarget, ob, storage.length(), raiseNode, lookupAttr);
            self.argtypes = ob;
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object PyCFuncPtr_set_argtypes(VirtualFrame frame, PyCFuncPtrObject self, PList value, @Bind Node inliningTarget, @Cached.Shared @Cached PyObjectLookupAttr lookupAttr, @Cached.Shared @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached.Shared @Cached PRaiseNode raiseNode) {
            SequenceStorage storage = value.getSequenceStorage();
            Object[] ob = getArray.execute(inliningTarget, value.getSequenceStorage());
            self.converters = PyCFuncPtrTypeBuiltins.PyCFuncPtrTypeNewNode.converters_from_argtypes(frame, inliningTarget, ob, storage.length(), raiseNode, lookupAttr);
            self.argtypes = ob;
            return PNone.NONE;
        }

        @Fallback
        static Object error(Object self, Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ARGTYPES_MUST_BE_A_SEQUENCE_OF_TYPES);
        }
    }

    @Builtin(name="restype", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="specify the result type")
    @ImportStatic(value={PyCFuncPtrTypeBuiltins.class})
    @GenerateNodeFactory
    protected static abstract class PointerResTypeNode
    extends PythonBinaryBuiltinNode {
        protected PointerResTypeNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        Object PyCFuncPtr_get_restype(PyCFuncPtrObject self, PNone value, @Bind Node inliningTarget, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode) {
            if (self.restype != null) {
                return self.restype;
            }
            StgDictObject dict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (dict != null) : "Cannot be NULL for PyCFuncPtrObject instances";
            if (dict.restype != null) {
                return dict.restype;
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object PyCFuncPtr_set_restype(VirtualFrame frame, PyCFuncPtrObject self, Object value, @Bind Node inliningTarget, @Cached PyObjectLookupAttr lookupAttr, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached PyCallableCheckNode callableCheck, @Cached PRaiseNode raiseNode) {
            if (value == PNone.NONE) {
                self.checker = null;
                self.restype = null;
                return PNone.NONE;
            }
            if (pyTypeStgDictNode.execute(inliningTarget, value) == null && !callableCheck.execute(inliningTarget, value)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.RESTYPE_MUST_BE_A_TYPE_A_CALLABLE_OR_NONE);
            }
            if (!PGuards.isPFunction(value)) {
                Object checker = lookupAttr.execute((Frame)frame, inliningTarget, value, PyCFuncPtrTypeBuiltins.T__CHECK_RETVAL_);
                self.checker = checker != PNone.NO_VALUE ? checker : null;
            }
            self.restype = value;
            return PNone.NONE;
        }
    }

    @Builtin(name="errcheck", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="a function to check for errors")
    @GenerateNodeFactory
    protected static abstract class PointerErrCheckNode
    extends PythonBinaryBuiltinNode {
        protected PointerErrCheckNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        Object PyCFuncPtr_get_errcheck(PyCFuncPtrObject self, PNone value) {
            if (self.errcheck != null) {
                return self.errcheck;
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object PyCFuncPtr_set_errcheck(PyCFuncPtrObject self, Object value, @Bind Node inliningTarget, @Cached PyCallableCheckNode callableCheck, @Cached PRaiseNode raiseNode) {
            if (value != PNone.NONE && !callableCheck.execute(inliningTarget, value)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.THE_ERRCHECK_ATTRIBUTE_MUST_BE_CALLABLE);
            }
            self.errcheck = value;
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.nb_bool)
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class BoolNode
    extends TpSlotInquiry.NbBoolBuiltinNode {
        BoolNode() {
        }

        @Specialization
        static boolean bool(PyCFuncPtrObject self, @Bind Node inliningTarget, @Cached PointerNodes.ReadPointerNode readPointerNode) {
            Pointer value = readPointerNode.execute(inliningTarget, self.b_ptr);
            return !value.isNull();
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class PyCFuncPtrNewNode
    extends PythonBuiltinNode {
        protected PyCFuncPtrNewNode() {
        }

        protected static boolean isLong(Node inliningTarget, Object[] arg, PyLongCheckNode longCheckNode) {
            return arg[0] instanceof PythonNativeVoidPtr || longCheckNode.execute(inliningTarget, arg[0]);
        }

        protected static boolean isTuple(Object[] arg) {
            return PGuards.isPTuple(arg[0]);
        }

        @Specialization(guards={"args.length == 0"})
        static Object simple(Object type, Object[] args, PKeyword[] kwds, @Bind Node inliningTarget, @Cached.Exclusive @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached.Exclusive @Cached CtypesNodes.GenericPyCDataNewNode pyCDataNewNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, type, raiseNode);
            return pyCDataNewNode.execute(inliningTarget, type, dict);
        }

        @Specialization(guards={"args.length == 1", "isTuple(args)"})
        static Object fromNativeLibrary(VirtualFrame frame, Object type, Object[] args, PKeyword[] kwds, @Cached PyCFuncPtrFromDllNode pyCFuncPtrFromDllNode) {
            return pyCFuncPtrFromDllNode.execute(frame, type, args);
        }

        @Specialization(guards={"args.length == 1", "isLong(this, args, longCheckNode)"}, limit="1")
        static Object usingNativePointer(Object type, Object[] args, PKeyword[] kwds, @Bind Node inliningTarget, @Cached.Exclusive @Cached PyLongCheckNode longCheckNode, @Cached PointerNodes.PointerFromLongNode pointerFromLongNode, @Cached.Exclusive @Cached PointerNodes.WritePointerNode writePointerNode, @Cached.Exclusive @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached.Exclusive @Cached CtypesNodes.GenericPyCDataNewNode pyCDataNewNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, type, raiseNode);
            CDataObject cdata = pyCDataNewNode.execute(inliningTarget, type, dict);
            Pointer value = pointerFromLongNode.execute(inliningTarget, args[0]);
            writePointerNode.execute(inliningTarget, cdata.b_ptr, value);
            return cdata;
        }

        @Specialization(guards={"args.length > 0", "!isPTuple(args)", "!isLong(this, args, longCheckNode)"}, limit="1")
        static Object callback(VirtualFrame frame, Object type, Object[] args, PKeyword[] kwds, @Bind Node inliningTarget, @Cached.Exclusive @Cached PyLongCheckNode longCheckNode, @Cached.Exclusive @Cached PointerNodes.WritePointerNode writePointerNode, @Cached CDataTypeBuiltins.KeepRefNode keepRefNode, @Cached PyCallableCheckNode callableCheck, @Cached.Exclusive @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached.Exclusive @Cached CtypesNodes.GenericPyCDataNewNode pyCDataNewNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object callable = args[0];
            if (!callableCheck.execute(inliningTarget, callable)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ARGUMENT_MUST_BE_CALLABLE_OR_INTEGER_FUNCTION_ADDRESS);
            }
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, type, raiseNode);
            if (dict == null || dict.argtypes == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANNOT_CONSTRUCT_INSTANCE_OF_THIS_CLASS_NO_ARGTYPES);
            }
            CThunkObject thunk = PyCFuncPtrNewNode._ctypes_alloc_callback(inliningTarget, callable, dict.argtypes, dict.restype, dict.flags);
            PyCFuncPtrObject self = (PyCFuncPtrObject)pyCDataNewNode.execute(inliningTarget, type, dict);
            self.callable = callable;
            self.thunk = thunk;
            writePointerNode.execute(inliningTarget, self.b_ptr, Pointer.nativeMemory(thunk.pcl_exec));
            keepRefNode.execute(frame, inliningTarget, self, 0, thunk);
            return self;
        }

        @Specialization(guards={"args.length > 1", "!isPTuple(args)", "isLong(this, args, longCheckNode)"}, limit="1")
        static Object error(Object type, Object[] args, PKeyword[] kwds, @Cached.Exclusive @Cached PyLongCheckNode longCheckNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ARGUMENT_MUST_BE_CALLABLE_OR_INTEGER_FUNCTION_ADDRESS);
        }

        static CThunkObject CThunkObjectNew(int nArgs) {
            CThunkObject p = PFactory.createCThunkObject(PythonLanguage.get(null), nArgs);
            p.pcl_write = null;
            p.pcl_exec = null;
            p.cif = null;
            p.flags = 0;
            p.converters = null;
            p.callable = null;
            p.restype = null;
            p.setfunc = null;
            p.ffi_restype = null;
            for (int i = 0; i < nArgs; ++i) {
                p.atypes[i] = null;
            }
            return p;
        }

        static FFIType _ctypes_get_ffi_type(Object obj) {
            if (obj == null) {
                return FFIType.ffi_type_sint;
            }
            StgDictObject dict = StgDictBuiltins.PyTypeStgDictNode.executeUncached(obj);
            if (dict == null) {
                return FFIType.ffi_type_sint;
            }
            return dict.ffi_type_pointer;
        }

        @CompilerDirectives.TruffleBoundary
        static CThunkObject _ctypes_alloc_callback(Node raisingNode, Object callable, Object[] converters, Object restype, int flags) {
            int nArgs = converters.length;
            CThunkObject thunk = PyCFuncPtrNewNode.CThunkObjectNew(nArgs);
            thunk.flags = flags;
            for (int i = 0; i < nArgs; ++i) {
                Object cnv = converters[i];
                thunk.atypes[i] = PyCFuncPtrNewNode._ctypes_get_ffi_type(cnv);
            }
            thunk.restype = restype;
            if (restype == null || restype == PNone.NONE) {
                thunk.setfunc = FFIType.FieldSet.nil;
                thunk.ffi_restype = new FFIType();
            } else {
                StgDictObject dict = StgDictBuiltins.PyTypeStgDictNode.executeUncached(restype);
                if (dict == null || dict.setfunc == FFIType.FieldSet.nil) {
                    throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.TypeError, ErrorMessages.INVALID_RESULT_TYPE_FOR_CALLBACK_FUNCTION);
                }
                thunk.setfunc = dict.setfunc;
                thunk.ffi_restype = dict.ffi_type_pointer;
            }
            TruffleString signatureStr = FFIType.buildNFISignature(thunk.atypes, thunk.ffi_restype, true);
            Source source = Source.newBuilder((String)"nfi", (CharSequence)signatureStr.toJavaStringUncached(), (String)"<ctypes callback>").build();
            Object nfiSignature = PythonContext.get(raisingNode).getEnv().parseInternal(source, new String[0]).call(new Object[0]);
            thunk.pcl_write = thunk.pcl_exec = SignatureLibrary.getUncached().createClosure(nfiSignature, (Object)new CThunkObject.CtypeCallback(thunk));
            thunk.converters = converters;
            thunk.callable = callable;
            return thunk;
        }
    }
}

