/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFunFactory;
import com.oracle.graal.python.lib.PyLongAsLongAndOverflowNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public abstract class TpSlotHashFun {
    public static final TpSlot.TpSlotManaged HASH_NOT_IMPLEMENTED = new PyObjectHashNotImplemented();

    private TpSlotHashFun() {
    }

    public static class PyObjectHashNotImplemented
    extends TpSlotHashBuiltin<HashNotImplementedNode> {
        private PyObjectHashNotImplemented() {
            super(TpSlotHashFunFactory.PyObjectHashNotImplementedFactory.HashNotImplementedNodeFactory.getInstance());
        }

        @GenerateNodeFactory
        public static abstract class HashNotImplementedNode
        extends HashBuiltinNode {
            @Specialization
            static long doIt(Object obj, @Bind Node nodeForRaise) {
                throw PRaiseNode.raiseStatic(nodeForRaise, PythonBuiltinClassType.TypeError, ErrorMessages.UNHASHABLE_TYPE_P, obj);
            }
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class CallSlotHashFunPythonNode
    extends Node {
        CallSlotHashFunPythonNode() {
        }

        abstract long execute(VirtualFrame var1, TpSlot.TpSlotPythonSingle var2, Object var3);

        @Specialization
        static long doIt(VirtualFrame frame, TpSlot.TpSlotPythonSingle slot, Object self, @Bind Node inliningTarget, @Cached PythonDispatchers.UnaryPythonSlotDispatcherNode dispatcherNode, @Cached PyLongCheckNode longCheckNode, @Cached PyLongAsLongAndOverflowNode asLongNode, @Cached IntBuiltins.HashNode intHashNode, @Cached InlinedConditionProfile minusOneProfile, @Cached PRaiseNode raiseNode) {
            long hash;
            Object callable = slot.getCallable();
            if (callable == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.UNHASHABLE_TYPE_P, self);
            }
            Object result = dispatcherNode.execute(frame, inliningTarget, callable, slot.getType(), self);
            if (!longCheckNode.execute(inliningTarget, result)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.HASH_SHOULD_RETURN_INTEGER);
            }
            try {
                hash = asLongNode.execute((Frame)frame, inliningTarget, result);
            }
            catch (OverflowException e) {
                return intHashNode.executeLong(frame, result);
            }
            if (minusOneProfile.profile(inliningTarget, hash == -1L)) {
                return -2L;
            }
            return hash;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotHashFunNode
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "tp_hash");

        public abstract long execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4);

        @Specialization(guards={"cachedSlot == slot"}, limit="3")
        static long callCachedBuiltin(VirtualFrame frame, TpSlotHashBuiltin<?> slot, Object self, @Cached(value="slot") TpSlotHashBuiltin<?> cachedSlot, @Cached(value="cachedSlot.createSlotNode()") HashBuiltinNode slotNode) {
            return slotNode.executeLong(frame, self);
        }

        @Specialization
        static long callPython(VirtualFrame frame, TpSlot.TpSlotPythonSingle slot, Object self, @Cached(inline=false) CallSlotHashFunPythonNode callSlotNode) {
            return callSlotNode.execute(frame, slot, self);
        }

        @Specialization
        static long callNative(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotCExtNative slot, Object self, @Cached.Exclusive @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNode, @Cached.Exclusive @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached.Exclusive @Cached(inline=false) ExternalFunctionNodes.CheckPrimitiveFunctionResultNode checkResultNode) {
            PythonContext ctx = PythonContext.get(inliningTarget);
            PythonContext.PythonThreadState state = getThreadStateNode.execute(inliningTarget, ctx);
            Object result = externalInvokeNode.call(frame, inliningTarget, state, C_API_TIMING, SpecialMethodNames.T___HASH__, slot.callable, toNativeNode.execute(self));
            return checkResultNode.executeLong(state, SpecialMethodNames.T___HASH__, result);
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static long callGenericComplexBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotHashBuiltin<?> slot, Object self, @Cached CallDispatchers.SimpleIndirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(1);
            PArguments.setArgument(arguments, 0, self);
            RootCallTarget callTarget = PythonLanguage.get(inliningTarget).getBuiltinSlotCallTarget(slot.callTargetIndex);
            return (Long)invoke.execute((Frame)frame, inliningTarget, callTarget, arguments);
        }

        public static CallSlotHashFunNode getUncached() {
            return TpSlotHashFunFactory.CallSlotHashFunNodeGen.getUncached();
        }
    }

    @GenerateInline(value=false, inherit=true)
    public static abstract class HashBuiltinNode
    extends PythonUnaryBuiltinNode {
        public abstract long executeLong(VirtualFrame var1, Object var2);

        @Override
        public final Object execute(VirtualFrame frame, Object obj) {
            return this.executeLong(frame, obj);
        }
    }

    public static abstract class TpSlotHashBuiltin<T extends HashBuiltinNode>
    extends TpSlot.TpSlotBuiltinBase<T> {
        static final BuiltinSlotWrapperSignature SIGNATURE = BuiltinSlotWrapperSignature.UNARY;
        private final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();

        public TpSlotHashBuiltin(NodeFactory<T> nodeFactory) {
            super(nodeFactory, SIGNATURE, ExternalFunctionNodes.PExternalFunctionWrapper.HASHFUNC);
        }

        HashBuiltinNode createSlotNode() {
            return (HashBuiltinNode)((Object)this.createNode());
        }

        @Override
        public void initialize(PythonLanguage language) {
            RootCallTarget callTarget = TpSlotHashBuiltin.createSlotCallTarget(language, SIGNATURE, this.getNodeFactory(), "__hash__");
            language.setBuiltinSlotCallTarget(this.callTargetIndex, callTarget);
        }
    }
}

