/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ForwardOnlyResultSet;
import oracle.jdbc.driver.GeneratedResultSet;
import oracle.jdbc.driver.InsensitiveScrollableResultSet;
import oracle.jdbc.driver.OldUpdatableResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SensitiveScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET})
abstract class OracleResultSet
extends GeneratedResultSet {
    static final boolean DEBUG = false;
    boolean closed;
    SQLWarning sqlWarning;
    protected boolean needCommitAtClose;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;

    static OracleResultSet createResultSet(OracleStatement oracleStatement) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            OracleStatement stmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleResultSet.class, $$$methodRef$$$0, null, oracleStatement);
            }
            if (!stmt.sqlKind.isSELECT()) {
                stmt.realRsetType = ResultSetType.FORWARD_READ_ONLY;
                stmt.described = true;
            }
            if (stmt.realRsetType == ResultSetType.UNKNOWN) {
                OracleResultSet oracleResultSet = stmt.userRsetType.createResultSet(stmt);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleResultSet.class, $$$methodRef$$$0, null, oracleResultSet);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleResultSet.class, $$$methodRef$$$0, null, null);
                }
                return oracleResultSet;
            }
            OracleResultSet oracleResultSet = stmt.realRsetType.createResultSet(stmt);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleResultSet.class, $$$methodRef$$$0, null, oracleResultSet);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleResultSet.class, $$$methodRef$$$0, null, null);
            }
            return oracleResultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleResultSet.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleResultSet(PhysicalConnection c2) {
        super(c2);
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, OracleResultSet.class, $$$methodRef$$$34, null, c2);
            }
            this.closed = false;
            this.sqlWarning = null;
            this.needCommitAtClose = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, OracleResultSet.class, $$$methodRef$$$34, null);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleResultSet.class, $$$methodRef$$$34, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleResultSet.class, $$$methodRef$$$34, null, throwable2);
            }
            throw throwable;
        }
    }

    protected abstract void doneFetchingRows(boolean var1) throws SQLException;

    @Override
    public abstract OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int var1) throws SQLException;

    /*
     * WARNING - void declaration
     */
    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(String string) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void columnName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleResultSet.class, $$$methodRef$$$1, this, string);
            }
            OracleResultSet.AuthorizationIndicator authorizationIndicator = this.getAuthorizationIndicator(this.findColumn((String)columnName));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleResultSet.class, $$$methodRef$$$1, this, (Object)authorizationIndicator);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleResultSet.class, $$$methodRef$$$1, this, null);
            }
            return authorizationIndicator;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleResultSet.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isValidRow() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleResultSet.class, $$$methodRef$$$2, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "isValidRow").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleResultSet.class, $$$methodRef$$$2, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleResultSet.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            block19: {
                OracleStatement ostmt;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleResultSet.class, $$$methodRef$$$3, this, new Object[0]);
                }
                if (this.needCommitAtClose && (ostmt = this.getOracleStatement()) != null && ostmt.connection != null) {
                    Monitor.CloseableLock lock;
                    block20: {
                        lock = ostmt.connection.acquireCloseableLock();
                        Throwable throwable = null;
                        try {
                            boolean _origFlag = ostmt.connection.autoCommitSpecCompliant;
                            ostmt.connection.autoCommitSpecCompliant = false;
                            ostmt.connection.commit();
                            ostmt.connection.autoCommitSpecCompliant = _origFlag;
                            if (lock == null) break block19;
                            if (throwable == null) break block20;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                Throwable throwable4 = throwable3;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleResultSet.class, $$$methodRef$$$3, this, throwable4);
                                }
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (lock != null) {
                                    if (throwable != null) {
                                        try {
                                            lock.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                        }
                                    } else {
                                        lock.close();
                                    }
                                }
                                Throwable throwable7 = throwable5;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleResultSet.class, $$$methodRef$$$3, this, throwable7);
                                }
                                throw throwable7;
                            }
                        }
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block19;
                    }
                    lock.close();
                }
            }
            this.closed = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleResultSet.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleResultSet.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleResultSet.class, $$$methodRef$$$3, this, throwable8);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleResultSet.class, $$$methodRef$$$4, this, new Object[0]);
            }
            boolean bl2 = this.closed;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleResultSet.class, $$$methodRef$$$4, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleResultSet.class, $$$methodRef$$$4, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleResultSet.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleResultSet.class, $$$methodRef$$$5, this, new Object[0]);
            }
            if (this.closed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleResultSet.class, $$$methodRef$$$5, this, sQLException);
                }
                throw sQLException;
            }
            SQLWarning sQLWarning = this.sqlWarning;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleResultSet.class, $$$methodRef$$$5, this, sQLWarning);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleResultSet.class, $$$methodRef$$$5, this, null);
            }
            return sQLWarning;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleResultSet.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleResultSet.class, $$$methodRef$$$6, this, new Object[0]);
            }
            this.sqlWarning = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleResultSet.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleResultSet.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleResultSet.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public abstract String getCursorName() throws SQLException;

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @Override
    public abstract boolean next() throws SQLException;

    @Override
    public abstract boolean wasNull() throws SQLException;

    @Override
    public abstract boolean isBeforeFirst() throws SQLException;

    @Override
    public abstract boolean isAfterLast() throws SQLException;

    @Override
    public abstract boolean isFirst() throws SQLException;

    @Override
    public abstract boolean isLast() throws SQLException;

    @Override
    public abstract void beforeFirst() throws SQLException;

    @Override
    public abstract void afterLast() throws SQLException;

    @Override
    public abstract boolean first() throws SQLException;

    @Override
    public abstract boolean last() throws SQLException;

    @Override
    public abstract int getRow() throws SQLException;

    @Override
    public abstract boolean absolute(int var1) throws SQLException;

    @Override
    public abstract boolean relative(int var1) throws SQLException;

    @Override
    public abstract boolean previous() throws SQLException;

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleResultSet.class, $$$methodRef$$$7, this, n2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleResultSet.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleResultSet.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleResultSet.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleResultSet.class, $$$methodRef$$$8, this, new Object[0]);
            }
            if (this.closed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleResultSet.class, $$$methodRef$$$8, this, sQLException);
                }
                throw sQLException;
            }
            int n2 = 1000;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleResultSet.class, $$$methodRef$$$8, this, n2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleResultSet.class, $$$methodRef$$$8, this, null);
            }
            return 1000;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleResultSet.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public abstract void setFetchSize(int var1) throws SQLException;

    @Override
    public abstract int getFetchSize() throws SQLException;

    @Override
    public abstract int getType() throws SQLException;

    @Override
    public abstract int getConcurrency() throws SQLException;

    @Override
    public int getHoldability() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleResultSet.class, $$$methodRef$$$9, this, new Object[0]);
            }
            if (this.isClosed()) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, null).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleResultSet.class, $$$methodRef$$$9, this, sQLException);
                }
                throw sQLException;
            }
            int n2 = 1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleResultSet.class, $$$methodRef$$$9, this, n2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleResultSet.class, $$$methodRef$$$9, this, null);
            }
            return 1;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleResultSet.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void insertRow() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleResultSet.class, $$$methodRef$$$10, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "insertRow").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OracleResultSet.class, $$$methodRef$$$10, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleResultSet.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleResultSet.class, $$$methodRef$$$11, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "updateRow").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleResultSet.class, $$$methodRef$$$11, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleResultSet.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleResultSet.class, $$$methodRef$$$12, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "deleteRow").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleResultSet.class, $$$methodRef$$$12, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleResultSet.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleResultSet.class, $$$methodRef$$$13, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, null).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleResultSet.class, $$$methodRef$$$13, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleResultSet.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleResultSet.class, $$$methodRef$$$14, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "moveToInsertRow").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, OracleResultSet.class, $$$methodRef$$$14, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleResultSet.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleResultSet.class, $$$methodRef$$$15, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "cancelRowUpdates").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, OracleResultSet.class, $$$methodRef$$$15, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleResultSet.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleResultSet.class, $$$methodRef$$$16, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "moveToCurrentRow").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, OracleResultSet.class, $$$methodRef$$$16, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleResultSet.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public abstract Statement getStatement() throws SQLException;

    @Override
    public void updateNull(int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleResultSet.class, $$$methodRef$$$17, this, n2);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "updateNull").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, OracleResultSet.class, $$$methodRef$$$17, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleResultSet.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateNull(String string) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void columnName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleResultSet.class, $$$methodRef$$$18, this, string);
            }
            this.updateNull(this.findColumn((String)columnName));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleResultSet.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleResultSet.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleResultSet.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleResultSet.class, $$$methodRef$$$19, this, new Object[0]);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleResultSet.class, $$$methodRef$$$19, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleResultSet.class, $$$methodRef$$$19, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleResultSet.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleResultSet.class, $$$methodRef$$$20, this, new Object[0]);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleResultSet.class, $$$methodRef$$$20, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleResultSet.class, $$$methodRef$$$20, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleResultSet.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleResultSet.class, $$$methodRef$$$21, this, new Object[0]);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleResultSet.class, $$$methodRef$$$21, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleResultSet.class, $$$methodRef$$$21, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleResultSet.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void iface;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleResultSet.class, $$$methodRef$$$22, this, clazz);
            }
            if (iface.isInterface()) {
                boolean bl2 = iface.isInstance(this);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleResultSet.class, $$$methodRef$$$22, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleResultSet.class, $$$methodRef$$$22, this, null);
                }
                return bl2;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, OracleResultSet.class, $$$methodRef$$$22, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleResultSet.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void iface;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleResultSet.class, $$$methodRef$$$23, this, clazz);
            }
            if (iface.isInterface() && iface.isInstance(this)) {
                OracleResultSet oracleResultSet = this;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleResultSet.class, $$$methodRef$$$23, this, oracleResultSet);
                    ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleResultSet.class, $$$methodRef$$$23, this, null);
                }
                return (T)oracleResultSet;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, OracleResultSet.class, $$$methodRef$$$23, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleResultSet.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public abstract <T> T getObject(int var1, Class<T> var2) throws SQLException;

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void type;
            void columnLabel;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleResultSet.class, $$$methodRef$$$24, this, string, clazz);
            }
            T t2 = this.getObject(this.findColumn((String)columnLabel), (Class<T>)type);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleResultSet.class, $$$methodRef$$$24, this, t2);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleResultSet.class, $$$methodRef$$$24, this, null);
            }
            return t2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleResultSet.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void updateObject(int n2, Object object, SQLType sQLType) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleResultSet.class, $$$methodRef$$$25, this, n2, object, sQLType);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "updateObject").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, OracleResultSet.class, $$$methodRef$$$25, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleResultSet.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void updateObject(int n2, Object object, SQLType sQLType, int n3) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleResultSet.class, $$$methodRef$$$26, this, n2, object, sQLType, n3);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "updateObject").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleResultSet.class, $$$methodRef$$$26, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleResultSet.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateObject(String string, Object object, SQLType sQLType) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void targetSqlType;
            void value;
            void columnLabel;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleResultSet.class, $$$methodRef$$$27, this, string, object, sQLType);
            }
            this.updateObject(this.findColumn((String)columnLabel), (Object)value, (SQLType)targetSqlType);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleResultSet.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleResultSet.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleResultSet.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateObject(String string, Object object, SQLType sQLType, int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void scaleOrLength;
            void targetSqlType;
            void value;
            void columnLabel;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OracleResultSet.class, $$$methodRef$$$28, this, string, object, sQLType, n2);
            }
            this.updateObject(this.findColumn((String)columnLabel), (Object)value, (SQLType)targetSqlType, (int)scaleOrLength);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OracleResultSet.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleResultSet.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleResultSet.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OracleResultSet.class, $$$methodRef$$$29, this, new Object[0]);
            }
            PhysicalConnection physicalConnection = this.connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OracleResultSet.class, $$$methodRef$$$29, this, physicalConnection);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleResultSet.class, $$$methodRef$$$29, this, null);
            }
            return physicalConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleResultSet.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract OracleStatement getOracleStatement() throws SQLException;

    abstract int refreshRows(long var1, int var3) throws SQLException;

    void insertRow(RowId rowId) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OracleResultSet.class, $$$methodRef$$$30, this, rowId);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "call appendRow").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$30, Level.FINEST, OracleResultSet.class, $$$methodRef$$$30, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleResultSet.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract void removeCurrentRowFromCache() throws SQLException;

    abstract int getColumnCount() throws SQLException;

    boolean isComplete() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OracleResultSet.class, $$$methodRef$$$31, this, new Object[0]);
            }
            boolean bl2 = this.closed;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleResultSet.class, $$$methodRef$$$31, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleResultSet.class, $$$methodRef$$$31, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleResultSet.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getBytes(int n2, byte[] byArray, int n3) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OracleResultSet.class, $$$methodRef$$$32, this, n2, byArray, n3);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$32, Level.FINEST, OracleResultSet.class, $$$methodRef$$$32, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleResultSet.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void awaitPublishing() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, OracleResultSet.class, $$$methodRef$$$33, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, OracleResultSet.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleResultSet.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleResultSet.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$34 = OracleResultSet.class.getDeclaredConstructor(PhysicalConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleResultSet.class.getDeclaredMethod("awaitPublishing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleResultSet.class.getDeclaredMethod("getBytes", Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleResultSet.class.getDeclaredMethod("isComplete", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleResultSet.class.getDeclaredMethod("insertRow", RowId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleResultSet.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleResultSet.class.getDeclaredMethod("updateObject", String.class, Object.class, SQLType.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleResultSet.class.getDeclaredMethod("updateObject", String.class, Object.class, SQLType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleResultSet.class.getDeclaredMethod("updateObject", Integer.TYPE, Object.class, SQLType.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleResultSet.class.getDeclaredMethod("updateObject", Integer.TYPE, Object.class, SQLType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleResultSet.class.getDeclaredMethod("getObject", String.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleResultSet.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleResultSet.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleResultSet.class.getDeclaredMethod("rowDeleted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleResultSet.class.getDeclaredMethod("rowInserted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleResultSet.class.getDeclaredMethod("rowUpdated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleResultSet.class.getDeclaredMethod("updateNull", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleResultSet.class.getDeclaredMethod("updateNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleResultSet.class.getDeclaredMethod("moveToCurrentRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleResultSet.class.getDeclaredMethod("cancelRowUpdates", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleResultSet.class.getDeclaredMethod("moveToInsertRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleResultSet.class.getDeclaredMethod("refreshRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleResultSet.class.getDeclaredMethod("deleteRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleResultSet.class.getDeclaredMethod("updateRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleResultSet.class.getDeclaredMethod("insertRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleResultSet.class.getDeclaredMethod("getHoldability", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleResultSet.class.getDeclaredMethod("getFetchDirection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleResultSet.class.getDeclaredMethod("setFetchDirection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleResultSet.class.getDeclaredMethod("clearWarnings", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleResultSet.class.getDeclaredMethod("getWarnings", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleResultSet.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleResultSet.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleResultSet.class.getDeclaredMethod("isValidRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleResultSet.class.getDeclaredMethod("getAuthorizationIndicator", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleResultSet.class.getDeclaredMethod("createResultSet", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    static abstract class ResultSetType
    extends Enum<ResultSetType> {
        public static final /* enum */ ResultSetType UNKNOWN;
        public static final /* enum */ ResultSetType FORWARD_READ_ONLY;
        public static final /* enum */ ResultSetType FORWARD_UPDATABLE;
        public static final /* enum */ ResultSetType INSENSITIVE_READ_ONLY;
        public static final /* enum */ ResultSetType INSENSITIVE_UPDATABLE;
        public static final /* enum */ ResultSetType SENSITIVE_READ_ONLY;
        public static final /* enum */ ResultSetType SENSITIVE_UPDATABLE;
        private final int type;
        private final int concur;
        private final boolean isIdentifierRequired;
        private static final /* synthetic */ ResultSetType[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;

        public static ResultSetType[] values() {
            return (ResultSetType[])$VALUES.clone();
        }

        public static ResultSetType valueOf(String name) {
            return Enum.valueOf(ResultSetType.class, name);
        }

        static ResultSetType typeFor(int type, int concur) throws SQLException {
            for (ResultSetType t2 : (ResultSetType[])ResultSetType.class.getEnumConstants()) {
                if (t2.getType() != type || t2.getConcur() != concur) continue;
                return t2;
            }
            throw (SQLException)DatabaseError.createSqlException(68, "type: " + type + " concurency: " + concur).fillInStackTrace();
        }

        private ResultSetType(int t2, int c2, boolean id) {
            this.type = t2;
            this.concur = c2;
            this.isIdentifierRequired = id;
        }

        int getType() {
            return this.type;
        }

        int getConcur() {
            return this.concur;
        }

        boolean isIdentifierRequired() {
            return this.isIdentifierRequired;
        }

        boolean isForwardOnly() {
            return this.type == 1003;
        }

        boolean isScrollable() {
            return this.type != 1003;
        }

        boolean isUpdatable() {
            return this.concur == 1008;
        }

        abstract OracleResultSet createResultSet(OracleStatement var1) throws SQLException;

        abstract ResultSetType downgrade();

        static {
            try {
                $$$methodRef$$$10 = ResultSetType.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, oracle.jdbc.driver.OracleResultSet$1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = ResultSetType.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = ResultSetType.class.getDeclaredMethod("isUpdatable", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = ResultSetType.class.getDeclaredMethod("isScrollable", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = ResultSetType.class.getDeclaredMethod("isForwardOnly", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = ResultSetType.class.getDeclaredMethod("isIdentifierRequired", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = ResultSetType.class.getDeclaredMethod("getConcur", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = ResultSetType.class.getDeclaredMethod("getType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = ResultSetType.class.getDeclaredMethod("typeFor", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ResultSetType.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ResultSetType.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            UNKNOWN = new ResultSetType(-1, -1, false){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException(23, null).fillInStackTrace();
                }

                @Override
                ResultSetType downgrade() {
                    return UNKNOWN;
                }

                static {
                    try {
                        $$$methodRef$$$2 = 1.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredMethod("downgrade", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("createResultSet", OracleStatement.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            FORWARD_READ_ONLY = new ResultSetType(1003, 1007, false){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
                    return new ForwardOnlyResultSet(stmt.connection, stmt);
                }

                @Override
                ResultSetType downgrade() {
                    return FORWARD_READ_ONLY;
                }

                static {
                    try {
                        $$$methodRef$$$2 = 2.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredMethod("downgrade", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("createResultSet", OracleStatement.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            FORWARD_UPDATABLE = new ResultSetType(1003, 1008, true){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
                    ForwardOnlyResultSet rs = new ForwardOnlyResultSet(stmt.connection, stmt);
                    if (stmt.connection.isOldUpdateableResultSet) {
                        return new OldUpdatableResultSet(stmt, rs);
                    }
                    return new UpdatableResultSet(stmt, rs);
                }

                @Override
                ResultSetType downgrade() {
                    return FORWARD_READ_ONLY;
                }

                static {
                    try {
                        $$$methodRef$$$2 = 3.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 3.class.getDeclaredMethod("downgrade", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 3.class.getDeclaredMethod("createResultSet", OracleStatement.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            INSENSITIVE_READ_ONLY = new ResultSetType(1004, 1007, false){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
                    return new InsensitiveScrollableResultSet(stmt.connection, stmt);
                }

                @Override
                ResultSetType downgrade() {
                    return FORWARD_READ_ONLY;
                }

                static {
                    try {
                        $$$methodRef$$$2 = 4.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 4.class.getDeclaredMethod("downgrade", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 4.class.getDeclaredMethod("createResultSet", OracleStatement.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            INSENSITIVE_UPDATABLE = new ResultSetType(1004, 1008, true){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
                    InsensitiveScrollableResultSet rs = new InsensitiveScrollableResultSet(stmt.connection, stmt);
                    if (stmt.connection.isOldUpdateableResultSet) {
                        return new OldUpdatableResultSet(stmt, rs);
                    }
                    return new UpdatableResultSet(stmt, rs);
                }

                @Override
                ResultSetType downgrade() {
                    return INSENSITIVE_READ_ONLY;
                }

                static {
                    try {
                        $$$methodRef$$$2 = 5.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 5.class.getDeclaredMethod("downgrade", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 5.class.getDeclaredMethod("createResultSet", OracleStatement.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SENSITIVE_READ_ONLY = new ResultSetType(1005, 1007, true){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
                    return new SensitiveScrollableResultSet(stmt.connection, stmt);
                }

                @Override
                ResultSetType downgrade() {
                    return INSENSITIVE_READ_ONLY;
                }

                static {
                    try {
                        $$$methodRef$$$2 = 6.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 6.class.getDeclaredMethod("downgrade", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 6.class.getDeclaredMethod("createResultSet", OracleStatement.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SENSITIVE_UPDATABLE = new ResultSetType(1005, 1008, true){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
                    SensitiveScrollableResultSet rs = new SensitiveScrollableResultSet(stmt.connection, stmt);
                    if (stmt.connection.isOldUpdateableResultSet) {
                        return new OldUpdatableResultSet(stmt, rs);
                    }
                    return new UpdatableResultSet(stmt, rs);
                }

                @Override
                ResultSetType downgrade() {
                    return INSENSITIVE_READ_ONLY;
                }

                static {
                    try {
                        $$$methodRef$$$2 = 7.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 7.class.getDeclaredMethod("downgrade", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 7.class.getDeclaredMethod("createResultSet", OracleStatement.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            $VALUES = new ResultSetType[]{UNKNOWN, FORWARD_READ_ONLY, FORWARD_UPDATABLE, INSENSITIVE_READ_ONLY, INSENSITIVE_UPDATABLE, SENSITIVE_READ_ONLY, SENSITIVE_UPDATABLE};
        }
    }
}

