/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.introspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.stream.Stream;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotationMap;
import tools.jackson.databind.introspect.TypeResolutionContext;
import tools.jackson.databind.util.ClassUtil;

public abstract class AnnotatedMember
extends Annotated {
    protected final TypeResolutionContext _typeContext;
    protected final AnnotationMap _annotations;

    protected AnnotatedMember(TypeResolutionContext ctxt, AnnotationMap annotations) {
        this._typeContext = ctxt;
        this._annotations = annotations;
    }

    protected AnnotatedMember(AnnotatedMember base) {
        this._typeContext = base._typeContext;
        this._annotations = base._annotations;
    }

    public abstract Annotated withAnnotations(AnnotationMap var1);

    public abstract Class<?> getDeclaringClass();

    public abstract Member getMember();

    public String getFullName() {
        return this.getDeclaringClass().getName() + "#" + this.getName();
    }

    @Override
    public final <A extends Annotation> A getAnnotation(Class<A> acls) {
        if (this._annotations == null) {
            return null;
        }
        return this._annotations.get(acls);
    }

    @Override
    public final boolean hasAnnotation(Class<? extends Annotation> acls) {
        if (this._annotations == null) {
            return false;
        }
        return this._annotations.has(acls);
    }

    @Override
    public boolean hasOneOf(Class<? extends Annotation>[] annoClasses) {
        if (this._annotations == null) {
            return false;
        }
        return this._annotations.hasOneOf(annoClasses);
    }

    @Override
    public Stream<Annotation> annotations() {
        if (this._annotations == null) {
            return Stream.empty();
        }
        return this._annotations.values();
    }

    public final void fixAccess(boolean force) {
        Member m = this.getMember();
        if (m != null) {
            ClassUtil.checkAndFixAccess(m, force);
        }
    }

    public abstract void setValue(Object var1, Object var2) throws UnsupportedOperationException, IllegalArgumentException;

    public abstract Object getValue(Object var1) throws UnsupportedOperationException, IllegalArgumentException;

    @Deprecated
    public AnnotationMap _annotationMap() {
        return this._annotations;
    }
}

