/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.nfi.backend.libffi.LibFFIContext;
import com.oracle.truffle.nfi.backend.libffi.NFIUnsupportedException;
import java.util.Iterator;
import java.util.List;

abstract class LoadFlags {
    static LoadFlags initLoadFlags(LibFFIContext ctx) {
        switch (InternalResource.OS.getCurrent()) {
            case LINUX: 
            case DARWIN: {
                return new PosixFlags(ctx);
            }
            case WINDOWS: {
                return new WindowsFlags();
            }
        }
        return new UnknownFlags();
    }

    abstract int parseFlags(List<String> var1);

    private LoadFlags() {
    }

    static final class PosixFlags
    extends LoadFlags {
        private final LibFFIContext ctx;

        PosixFlags(LibFFIContext ctx) {
            this.ctx = ctx;
        }

        @Override
        int parseFlags(List<String> flagNames) {
            int flags = 0;
            boolean lazyOrNow = false;
            if (flagNames != null) {
                Iterator<String> iterator = flagNames.iterator();
                while (iterator.hasNext()) {
                    String flag;
                    switch (flag = iterator.next()) {
                        case "RTLD_GLOBAL": {
                            flags |= this.ctx.RTLD_GLOBAL;
                            break;
                        }
                        case "RTLD_LOCAL": {
                            flags |= this.ctx.RTLD_LOCAL;
                            break;
                        }
                        case "RTLD_LAZY": {
                            flags |= this.ctx.RTLD_LAZY;
                            lazyOrNow = true;
                            break;
                        }
                        case "RTLD_NOW": {
                            flags |= this.ctx.RTLD_NOW;
                            lazyOrNow = true;
                            break;
                        }
                        case "ISOLATED_NAMESPACE": {
                            if (this.ctx.ISOLATED_NAMESPACE == 0) {
                                throw new NFIUnsupportedException("isolated namespace not supported");
                            }
                            flags |= this.ctx.ISOLATED_NAMESPACE;
                        }
                    }
                }
            }
            if (!lazyOrNow) {
                flags |= this.ctx.RTLD_NOW;
            }
            return flags;
        }
    }

    static final class WindowsFlags
    extends LoadFlags {
        WindowsFlags() {
        }

        @Override
        int parseFlags(List<String> flagNames) {
            int flags = 0;
            if (flagNames != null) {
                Iterator<String> iterator = flagNames.iterator();
                while (iterator.hasNext()) {
                    String flag;
                    switch (flag = iterator.next()) {
                        case "LOAD_LIBRARY_SEARCH_APPLICATION_DIR": {
                            flags |= 0x200;
                            break;
                        }
                        case "LOAD_LIBRARY_SEARCH_DEFAULT_DIRS": {
                            flags |= 0x1000;
                            break;
                        }
                        case "LOAD_LIBRARY_SEARCH_DLL_LOAD_DIR": {
                            flags |= 0x100;
                            break;
                        }
                        case "LOAD_LIBRARY_SEARCH_SYSTEM32": {
                            flags |= 0x800;
                            break;
                        }
                        case "LOAD_LIBRARY_SEARCH_USER_DIRS": {
                            flags |= 0x400;
                            break;
                        }
                        case "LOAD_WITH_ALTERED_SEARCH_PATH": {
                            flags |= 8;
                            break;
                        }
                        case "ISOLATED_NAMESPACE": {
                            throw new NFIUnsupportedException("isolated namespace not supported");
                        }
                    }
                }
            }
            return flags;
        }
    }

    static final class UnknownFlags
    extends LoadFlags {
        UnknownFlags() {
        }

        @Override
        int parseFlags(List<String> flagNames) {
            return 0;
        }
    }
}

