//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// Status bar buttons are the visual representation of `NSStatusItem`s, and are primarily displayed on the right side of the menu bar.
    /// When a template image is set as the `image` property of the status bar button, it is rendered with the correct menu bar style. This guarantees that the button will look correct in various button states and appearances (such as dark menu bar).
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstatusbarbutton?language=objc)
    #[unsafe(super(NSButton, NSControl, NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(
        feature = "NSButton",
        feature = "NSControl",
        feature = "NSResponder",
        feature = "NSView"
    ))]
    pub struct NSStatusBarButton;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSStatusBarButton {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityButton for NSStatusBarButton {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSStatusBarButton {}
);

#[cfg(all(
    feature = "NSAnimation",
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSStatusBarButton {}
);

#[cfg(all(
    feature = "NSAppearance",
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSStatusBarButton {}
);

#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSCoding for NSStatusBarButton {}
);

#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSStatusBarButton {}
);

#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSStatusBarButton {}
);

#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceCompression",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceCompression for NSStatusBarButton {}
);

#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSStatusBarButton {}
);

#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceValidation",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceValidations for NSStatusBarButton {}
);

#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
impl NSStatusBarButton {
    extern_methods!(
        /// If `YES`, the status bar icon has a disabled/off appearance while still being functional, such as allowing selection and actions. Defaults to `NO`.
        #[unsafe(method(appearsDisabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn appearsDisabled(&self) -> bool;

        /// Setter for [`appearsDisabled`][Self::appearsDisabled].
        #[unsafe(method(setAppearsDisabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAppearsDisabled(&self, appears_disabled: bool);
    );
}

/// Methods declared on superclass `NSButton`.
#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
impl NSStatusBarButton {
    extern_methods!(
        #[cfg(feature = "NSImage")]
        /// Creates a standard push button with a title and image.
        ///
        /// Parameter `title`: The localized title string that is displayed on the button.
        ///
        /// Parameter `image`: The image that is displayed alongside the title. In left-to-right localizations, the image is displayed to the left of the title. In right-to-left localizations, it is displayed to the right.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(buttonWithTitle:image:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn buttonWithTitle_image_target_action(
            title: &NSString,
            image: &NSImage,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Creates a standard push button with the provided title.
        ///
        /// Parameter `title`: The localized title string that is displayed on the button.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(buttonWithTitle:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn buttonWithTitle_target_action(
            title: &NSString,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "NSImage")]
        /// Creates a standard push button with the provided image. Set the image's accessibilityDescription property to ensure accessibility for this control.
        ///
        /// Parameter `image`: The image to display in the body of the button.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(buttonWithImage:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn buttonWithImage_target_action(
            image: &NSImage,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Creates a standard checkbox with the provided title.
        ///
        /// Parameter `title`: The localized title string that is displayed alongside the checkbox.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(checkboxWithTitle:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn checkboxWithTitle_target_action(
            title: &NSString,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Creates a standard radio button with the provided title.
        ///
        /// Parameter `title`: The localized title string that is displayed alongside the radio button.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(radioButtonWithTitle:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn radioButtonWithTitle_target_action(
            title: &NSString,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSControl`.
#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
impl NSStatusBarButton {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
impl NSStatusBarButton {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(
    feature = "NSButton",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
impl NSStatusBarButton {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
