#![feature(test)]

extern crate oxipng;
extern crate test;

use std::path::PathBuf;

use oxipng::{internal_tests::*, *};
use test::Bencher;

#[bench]
fn filters_minsum(b: &mut Bencher) {
    let input = test::black_box(PathBuf::from("tests/files/rgb_8_should_be_rgb_8.png"));
    let png = PngData::new(&input, &Options::default()).unwrap();

    b.iter(|| png.raw.filter_image(FilterStrategy::MinSum, false));
}

#[bench]
fn filters_entropy(b: &mut Bencher) {
    let input = test::black_box(PathBuf::from("tests/files/rgb_8_should_be_rgb_8.png"));
    let png = PngData::new(&input, &Options::default()).unwrap();

    b.iter(|| png.raw.filter_image(FilterStrategy::Entropy, false));
}

#[bench]
fn filters_bigrams(b: &mut Bencher) {
    let input = test::black_box(PathBuf::from("tests/files/rgb_8_should_be_rgb_8.png"));
    let png = PngData::new(&input, &Options::default()).unwrap();

    b.iter(|| png.raw.filter_image(FilterStrategy::Bigrams, false));
}

#[bench]
fn filters_bigent(b: &mut Bencher) {
    let input = test::black_box(PathBuf::from("tests/files/rgb_8_should_be_rgb_8.png"));
    let png = PngData::new(&input, &Options::default()).unwrap();

    b.iter(|| png.raw.filter_image(FilterStrategy::BigEnt, false));
}

#[bench]
fn filters_brute(b: &mut Bencher) {
    let input = test::black_box(PathBuf::from("tests/files/rgb_8_should_be_rgb_8.png"));
    let png = PngData::new(&input, &Options::default()).unwrap();

    b.iter(|| {
        png.raw.filter_image(
            FilterStrategy::Brute {
                num_lines: 4,
                level: 1,
            },
            false,
        )
    });
}
