package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSuspEventDetail invokes the aegis.DescribeSuspEventDetail API synchronously
// api document: https://help.aliyun.com/api/aegis/describesuspeventdetail.html
func (client *Client) DescribeSuspEventDetail(request *DescribeSuspEventDetailRequest) (response *DescribeSuspEventDetailResponse, err error) {
	response = CreateDescribeSuspEventDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSuspEventDetailWithChan invokes the aegis.DescribeSuspEventDetail API asynchronously
// api document: https://help.aliyun.com/api/aegis/describesuspeventdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSuspEventDetailWithChan(request *DescribeSuspEventDetailRequest) (<-chan *DescribeSuspEventDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeSuspEventDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSuspEventDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSuspEventDetailWithCallback invokes the aegis.DescribeSuspEventDetail API asynchronously
// api document: https://help.aliyun.com/api/aegis/describesuspeventdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSuspEventDetailWithCallback(request *DescribeSuspEventDetailRequest, callback func(response *DescribeSuspEventDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSuspEventDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeSuspEventDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSuspEventDetailRequest is the request struct for api DescribeSuspEventDetail
type DescribeSuspEventDetailRequest struct {
	*requests.RpcRequest
	SuspiciousEventId requests.Integer `position:"Query" name:"SuspiciousEventId"`
	SourceIp          string           `position:"Query" name:"SourceIp"`
	From              string           `position:"Query" name:"From"`
	Lang              string           `position:"Query" name:"Lang"`
}

// DescribeSuspEventDetailResponse is the response struct for api DescribeSuspEventDetail
type DescribeSuspEventDetailResponse struct {
	*responses.BaseResponse
	RequestId       string      `json:"RequestId" xml:"RequestId"`
	LastTime        string      `json:"LastTime" xml:"LastTime"`
	Id              int         `json:"Id" xml:"Id"`
	InstanceName    string      `json:"InstanceName" xml:"InstanceName"`
	InternetIp      string      `json:"InternetIp" xml:"InternetIp"`
	IntranetIp      string      `json:"IntranetIp" xml:"IntranetIp"`
	Uuid            string      `json:"Uuid" xml:"Uuid"`
	EventDesc       string      `json:"EventDesc" xml:"EventDesc"`
	EventTypeDesc   string      `json:"EventTypeDesc" xml:"EventTypeDesc"`
	Level           string      `json:"Level" xml:"Level"`
	EventStatus     string      `json:"EventStatus" xml:"EventStatus"`
	SaleVersion     string      `json:"SaleVersion" xml:"SaleVersion"`
	DataSource      string      `json:"DataSource" xml:"DataSource"`
	Type            string      `json:"Type" xml:"Type"`
	OperateMsg      string      `json:"OperateMsg" xml:"OperateMsg"`
	SasId           string      `json:"SasId" xml:"SasId"`
	EventName       string      `json:"EventName" xml:"EventName"`
	CanBeDealOnLine bool        `json:"CanBeDealOnLine" xml:"CanBeDealOnLine"`
	Details         []QuaraFile `json:"Details" xml:"Details"`
}

// CreateDescribeSuspEventDetailRequest creates a request to invoke DescribeSuspEventDetail API
func CreateDescribeSuspEventDetailRequest() (request *DescribeSuspEventDetailRequest) {
	request = &DescribeSuspEventDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeSuspEventDetail", "vipaegis", "openAPI")
	return
}

// CreateDescribeSuspEventDetailResponse creates a response to parse from DescribeSuspEventDetail response
func CreateDescribeSuspEventDetailResponse() (response *DescribeSuspEventDetailResponse) {
	response = &DescribeSuspEventDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
