package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBaseExperiment invokes the airec.DescribeBaseExperiment API synchronously
func (client *Client) DescribeBaseExperiment(request *DescribeBaseExperimentRequest) (response *DescribeBaseExperimentResponse, err error) {
	response = CreateDescribeBaseExperimentResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBaseExperimentWithChan invokes the airec.DescribeBaseExperiment API asynchronously
func (client *Client) DescribeBaseExperimentWithChan(request *DescribeBaseExperimentRequest) (<-chan *DescribeBaseExperimentResponse, <-chan error) {
	responseChan := make(chan *DescribeBaseExperimentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBaseExperiment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBaseExperimentWithCallback invokes the airec.DescribeBaseExperiment API asynchronously
func (client *Client) DescribeBaseExperimentWithCallback(request *DescribeBaseExperimentRequest, callback func(response *DescribeBaseExperimentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBaseExperimentResponse
		var err error
		defer close(result)
		response, err = client.DescribeBaseExperiment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBaseExperimentRequest is the request struct for api DescribeBaseExperiment
type DescribeBaseExperimentRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"instanceId"`
	SceneId    string `position:"Path" name:"sceneId"`
}

// DescribeBaseExperimentResponse is the response struct for api DescribeBaseExperiment
type DescribeBaseExperimentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateDescribeBaseExperimentRequest creates a request to invoke DescribeBaseExperiment API
func CreateDescribeBaseExperimentRequest() (request *DescribeBaseExperimentRequest) {
	request = &DescribeBaseExperimentRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "DescribeBaseExperiment", "/v2/openapi/instances/[instanceId]/scenes/[sceneId]/base-experiment", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeBaseExperimentResponse creates a response to parse from DescribeBaseExperiment response
func CreateDescribeBaseExperimentResponse() (response *DescribeBaseExperimentResponse) {
	response = &DescribeBaseExperimentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
