package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopDelete invokes the cloudwf.ShopDelete API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopdelete.html
func (client *Client) ShopDelete(request *ShopDeleteRequest) (response *ShopDeleteResponse, err error) {
	response = CreateShopDeleteResponse()
	err = client.DoAction(request, response)
	return
}

// ShopDeleteWithChan invokes the cloudwf.ShopDelete API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopdelete.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopDeleteWithChan(request *ShopDeleteRequest) (<-chan *ShopDeleteResponse, <-chan error) {
	responseChan := make(chan *ShopDeleteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopDelete(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopDeleteWithCallback invokes the cloudwf.ShopDelete API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopdelete.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopDeleteWithCallback(request *ShopDeleteRequest, callback func(response *ShopDeleteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopDeleteResponse
		var err error
		defer close(result)
		response, err = client.ShopDelete(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopDeleteRequest is the request struct for api ShopDelete
type ShopDeleteRequest struct {
	*requests.RpcRequest
	Sid requests.Integer `position:"Query" name:"Sid"`
}

// ShopDeleteResponse is the response struct for api ShopDelete
type ShopDeleteResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopDeleteRequest creates a request to invoke ShopDelete API
func CreateShopDeleteRequest() (request *ShopDeleteRequest) {
	request = &ShopDeleteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopDelete", "cloudwf", "openAPI")
	return
}

// CreateShopDeleteResponse creates a response to parse from ShopDelete response
func CreateShopDeleteResponse() (response *ShopDeleteResponse) {
	response = &ShopDeleteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
