package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAggregateRemediations invokes the config.ListAggregateRemediations API synchronously
func (client *Client) ListAggregateRemediations(request *ListAggregateRemediationsRequest) (response *ListAggregateRemediationsResponse, err error) {
	response = CreateListAggregateRemediationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAggregateRemediationsWithChan invokes the config.ListAggregateRemediations API asynchronously
func (client *Client) ListAggregateRemediationsWithChan(request *ListAggregateRemediationsRequest) (<-chan *ListAggregateRemediationsResponse, <-chan error) {
	responseChan := make(chan *ListAggregateRemediationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAggregateRemediations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAggregateRemediationsWithCallback invokes the config.ListAggregateRemediations API asynchronously
func (client *Client) ListAggregateRemediationsWithCallback(request *ListAggregateRemediationsRequest, callback func(response *ListAggregateRemediationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAggregateRemediationsResponse
		var err error
		defer close(result)
		response, err = client.ListAggregateRemediations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAggregateRemediationsRequest is the request struct for api ListAggregateRemediations
type ListAggregateRemediationsRequest struct {
	*requests.RpcRequest
	ConfigRuleIds string `position:"Query" name:"ConfigRuleIds"`
	AggregatorId  string `position:"Query" name:"AggregatorId"`
}

// ListAggregateRemediationsResponse is the response struct for api ListAggregateRemediations
type ListAggregateRemediationsResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	Remediations []Remediation `json:"Remediations" xml:"Remediations"`
}

// CreateListAggregateRemediationsRequest creates a request to invoke ListAggregateRemediations API
func CreateListAggregateRemediationsRequest() (request *ListAggregateRemediationsRequest) {
	request = &ListAggregateRemediationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListAggregateRemediations", "", "")
	request.Method = requests.POST
	return
}

// CreateListAggregateRemediationsResponse creates a response to parse from ListAggregateRemediations response
func CreateListAggregateRemediationsResponse() (response *ListAggregateRemediationsResponse) {
	response = &ListAggregateRemediationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
