package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetDeviceInstance invokes the ens.ResetDeviceInstance API synchronously
func (client *Client) ResetDeviceInstance(request *ResetDeviceInstanceRequest) (response *ResetDeviceInstanceResponse, err error) {
	response = CreateResetDeviceInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ResetDeviceInstanceWithChan invokes the ens.ResetDeviceInstance API asynchronously
func (client *Client) ResetDeviceInstanceWithChan(request *ResetDeviceInstanceRequest) (<-chan *ResetDeviceInstanceResponse, <-chan error) {
	responseChan := make(chan *ResetDeviceInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetDeviceInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetDeviceInstanceWithCallback invokes the ens.ResetDeviceInstance API asynchronously
func (client *Client) ResetDeviceInstanceWithCallback(request *ResetDeviceInstanceRequest, callback func(response *ResetDeviceInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetDeviceInstanceResponse
		var err error
		defer close(result)
		response, err = client.ResetDeviceInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetDeviceInstanceRequest is the request struct for api ResetDeviceInstance
type ResetDeviceInstanceRequest struct {
	*requests.RpcRequest
	ImageId    string `position:"Query" name:"ImageId"`
	InstanceId string `position:"Query" name:"InstanceId"`
	AppId      string `position:"Query" name:"AppId"`
}

// ResetDeviceInstanceResponse is the response struct for api ResetDeviceInstance
type ResetDeviceInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateResetDeviceInstanceRequest creates a request to invoke ResetDeviceInstance API
func CreateResetDeviceInstanceRequest() (request *ResetDeviceInstanceRequest) {
	request = &ResetDeviceInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "ResetDeviceInstance", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateResetDeviceInstanceResponse creates a response to parse from ResetDeviceInstance response
func CreateResetDeviceInstanceResponse() (response *ResetDeviceInstanceResponse) {
	response = &ResetDeviceInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
