package ros

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetStackPolicy invokes the ros.GetStackPolicy API synchronously
// api document: https://help.aliyun.com/api/ros/getstackpolicy.html
func (client *Client) GetStackPolicy(request *GetStackPolicyRequest) (response *GetStackPolicyResponse, err error) {
	response = CreateGetStackPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// GetStackPolicyWithChan invokes the ros.GetStackPolicy API asynchronously
// api document: https://help.aliyun.com/api/ros/getstackpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetStackPolicyWithChan(request *GetStackPolicyRequest) (<-chan *GetStackPolicyResponse, <-chan error) {
	responseChan := make(chan *GetStackPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetStackPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetStackPolicyWithCallback invokes the ros.GetStackPolicy API asynchronously
// api document: https://help.aliyun.com/api/ros/getstackpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetStackPolicyWithCallback(request *GetStackPolicyRequest, callback func(response *GetStackPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetStackPolicyResponse
		var err error
		defer close(result)
		response, err = client.GetStackPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetStackPolicyRequest is the request struct for api GetStackPolicy
type GetStackPolicyRequest struct {
	*requests.RoaRequest
	StackId   string `position:"Path" name:"StackId"`
	StackName string `position:"Path" name:"StackName"`
}

// GetStackPolicyResponse is the response struct for api GetStackPolicy
type GetStackPolicyResponse struct {
	*responses.BaseResponse
}

// CreateGetStackPolicyRequest creates a request to invoke GetStackPolicy API
func CreateGetStackPolicyRequest() (request *GetStackPolicyRequest) {
	request = &GetStackPolicyRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ROS", "2015-09-01", "GetStackPolicy", "/stacks/[StackName]/[StackId]/policy", "ROS", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetStackPolicyResponse creates a response to parse from GetStackPolicy response
func CreateGetStackPolicyResponse() (response *GetStackPolicyResponse) {
	response = &GetStackPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
