package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAgent invokes the scsp.GetAgent API synchronously
func (client *Client) GetAgent(request *GetAgentRequest) (response *GetAgentResponse, err error) {
	response = CreateGetAgentResponse()
	err = client.DoAction(request, response)
	return
}

// GetAgentWithChan invokes the scsp.GetAgent API asynchronously
func (client *Client) GetAgentWithChan(request *GetAgentRequest) (<-chan *GetAgentResponse, <-chan error) {
	responseChan := make(chan *GetAgentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAgent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAgentWithCallback invokes the scsp.GetAgent API asynchronously
func (client *Client) GetAgentWithCallback(request *GetAgentRequest, callback func(response *GetAgentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAgentResponse
		var err error
		defer close(result)
		response, err = client.GetAgent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAgentRequest is the request struct for api GetAgent
type GetAgentRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query"`
	InstanceId  string `position:"Query"`
	AccountName string `position:"Query"`
}

// GetAgentResponse is the response struct for api GetAgent
type GetAgentResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetAgentRequest creates a request to invoke GetAgent API
func CreateGetAgentRequest() (request *GetAgentRequest) {
	request = &GetAgentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "GetAgent", "", "")
	request.Method = requests.GET
	return
}

// CreateGetAgentResponse creates a response to parse from GetAgent response
func CreateGetAgentResponse() (response *GetAgentResponse) {
	response = &GetAgentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
