package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryUnionContentInfo invokes the unimkt.QueryUnionContentInfo API synchronously
func (client *Client) QueryUnionContentInfo(request *QueryUnionContentInfoRequest) (response *QueryUnionContentInfoResponse, err error) {
	response = CreateQueryUnionContentInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryUnionContentInfoWithChan invokes the unimkt.QueryUnionContentInfo API asynchronously
func (client *Client) QueryUnionContentInfoWithChan(request *QueryUnionContentInfoRequest) (<-chan *QueryUnionContentInfoResponse, <-chan error) {
	responseChan := make(chan *QueryUnionContentInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryUnionContentInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryUnionContentInfoWithCallback invokes the unimkt.QueryUnionContentInfo API asynchronously
func (client *Client) QueryUnionContentInfoWithCallback(request *QueryUnionContentInfoRequest, callback func(response *QueryUnionContentInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryUnionContentInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryUnionContentInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryUnionContentInfoRequest is the request struct for api QueryUnionContentInfo
type QueryUnionContentInfoRequest struct {
	*requests.RpcRequest
	ContentId   string           `position:"Query" name:"ContentId"`
	ProxyUserId requests.Integer `position:"Query" name:"ProxyUserId"`
	ChannelId   string           `position:"Query" name:"ChannelId"`
}

// QueryUnionContentInfoResponse is the response struct for api QueryUnionContentInfo
type QueryUnionContentInfoResponse struct {
	*responses.BaseResponse
	Code      int                      `json:"Code" xml:"Code"`
	Success   bool                     `json:"Success" xml:"Success"`
	ErrorMsg  string                   `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Data      []map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateQueryUnionContentInfoRequest creates a request to invoke QueryUnionContentInfo API
func CreateQueryUnionContentInfoRequest() (request *QueryUnionContentInfoRequest) {
	request = &QueryUnionContentInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryUnionContentInfo", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryUnionContentInfoResponse creates a response to parse from QueryUnionContentInfo response
func CreateQueryUnionContentInfoResponse() (response *QueryUnionContentInfoResponse) {
	response = &QueryUnionContentInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
