package datamigration

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// SQLMigrationServicesClient is the data Migration Client
type SQLMigrationServicesClient struct {
	BaseClient
}

// NewSQLMigrationServicesClient creates an instance of the SQLMigrationServicesClient client.
func NewSQLMigrationServicesClient(subscriptionID string) SQLMigrationServicesClient {
	return NewSQLMigrationServicesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewSQLMigrationServicesClientWithBaseURI creates an instance of the SQLMigrationServicesClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewSQLMigrationServicesClientWithBaseURI(baseURI string, subscriptionID string) SQLMigrationServicesClient {
	return SQLMigrationServicesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate create or Update SQL Migration Service.
// Parameters:
// resourceGroupName - name of the resource group that contains the resource. You can obtain this value from
// the Azure Resource Manager API or the portal.
// SQLMigrationServiceName - name of the SQL Migration Service.
// parameters - details of SqlMigrationService resource.
func (client SQLMigrationServicesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string, parameters SQLMigrationService) (result SQLMigrationServicesCreateOrUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLMigrationServicesClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, SQLMigrationServiceName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "CreateOrUpdate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client SQLMigrationServicesClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string, parameters SQLMigrationService) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"sqlMigrationServiceName": autorest.Encode("path", SQLMigrationServiceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-30-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client SQLMigrationServicesClient) CreateOrUpdateSender(req *http.Request) (future SQLMigrationServicesCreateOrUpdateFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client SQLMigrationServicesClient) CreateOrUpdateResponder(resp *http.Response) (result SQLMigrationService, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete SQL Migration Service.
// Parameters:
// resourceGroupName - name of the resource group that contains the resource. You can obtain this value from
// the Azure Resource Manager API or the portal.
// SQLMigrationServiceName - name of the SQL Migration Service.
func (client SQLMigrationServicesClient) Delete(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (result SQLMigrationServicesDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLMigrationServicesClient.Delete")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, resourceGroupName, SQLMigrationServiceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client SQLMigrationServicesClient) DeletePreparer(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"sqlMigrationServiceName": autorest.Encode("path", SQLMigrationServiceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-30-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client SQLMigrationServicesClient) DeleteSender(req *http.Request) (future SQLMigrationServicesDeleteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client SQLMigrationServicesClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteNodeMethod delete the integration runtime node.
// Parameters:
// resourceGroupName - name of the resource group that contains the resource. You can obtain this value from
// the Azure Resource Manager API or the portal.
// SQLMigrationServiceName - name of the SQL Migration Service.
// parameters - details of SqlMigrationService resource.
func (client SQLMigrationServicesClient) DeleteNodeMethod(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string, parameters DeleteNode) (result DeleteNode, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLMigrationServicesClient.DeleteNodeMethod")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteNodeMethodPreparer(ctx, resourceGroupName, SQLMigrationServiceName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "DeleteNodeMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteNodeMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "DeleteNodeMethod", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteNodeMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "DeleteNodeMethod", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteNodeMethodPreparer prepares the DeleteNodeMethod request.
func (client SQLMigrationServicesClient) DeleteNodeMethodPreparer(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string, parameters DeleteNode) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"sqlMigrationServiceName": autorest.Encode("path", SQLMigrationServiceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-30-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/deleteNode", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteNodeMethodSender sends the DeleteNodeMethod request. The method will close the
// http.Response Body if it receives an error.
func (client SQLMigrationServicesClient) DeleteNodeMethodSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteNodeMethodResponder handles the response to the DeleteNodeMethod request. The method always
// closes the http.Response Body.
func (client SQLMigrationServicesClient) DeleteNodeMethodResponder(resp *http.Response) (result DeleteNode, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get retrieve the Migration Service.
// Parameters:
// resourceGroupName - name of the resource group that contains the resource. You can obtain this value from
// the Azure Resource Manager API or the portal.
// SQLMigrationServiceName - name of the SQL Migration Service.
func (client SQLMigrationServicesClient) Get(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (result SQLMigrationService, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLMigrationServicesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, SQLMigrationServiceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client SQLMigrationServicesClient) GetPreparer(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"sqlMigrationServiceName": autorest.Encode("path", SQLMigrationServiceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-30-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client SQLMigrationServicesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client SQLMigrationServicesClient) GetResponder(resp *http.Response) (result SQLMigrationService, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAuthKeys retrieve the List of Authentication Keys for Self Hosted Integration Runtime.
// Parameters:
// resourceGroupName - name of the resource group that contains the resource. You can obtain this value from
// the Azure Resource Manager API or the portal.
// SQLMigrationServiceName - name of the SQL Migration Service.
func (client SQLMigrationServicesClient) ListAuthKeys(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (result AuthenticationKeys, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLMigrationServicesClient.ListAuthKeys")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListAuthKeysPreparer(ctx, resourceGroupName, SQLMigrationServiceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListAuthKeys", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAuthKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListAuthKeys", resp, "Failure sending request")
		return
	}

	result, err = client.ListAuthKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListAuthKeys", resp, "Failure responding to request")
		return
	}

	return
}

// ListAuthKeysPreparer prepares the ListAuthKeys request.
func (client SQLMigrationServicesClient) ListAuthKeysPreparer(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"sqlMigrationServiceName": autorest.Encode("path", SQLMigrationServiceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-30-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/listAuthKeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAuthKeysSender sends the ListAuthKeys request. The method will close the
// http.Response Body if it receives an error.
func (client SQLMigrationServicesClient) ListAuthKeysSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListAuthKeysResponder handles the response to the ListAuthKeys request. The method always
// closes the http.Response Body.
func (client SQLMigrationServicesClient) ListAuthKeysResponder(resp *http.Response) (result AuthenticationKeys, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup retrieve all SQL migration services in the resource group.
// Parameters:
// resourceGroupName - name of the resource group that contains the resource. You can obtain this value from
// the Azure Resource Manager API or the portal.
func (client SQLMigrationServicesClient) ListByResourceGroup(ctx context.Context, resourceGroupName string) (result SQLMigrationListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLMigrationServicesClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.smlr.Response.Response != nil {
				sc = result.smlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.smlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.smlr, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListByResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.smlr.hasNextLink() && result.smlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client SQLMigrationServicesClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-30-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client SQLMigrationServicesClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client SQLMigrationServicesClient) ListByResourceGroupResponder(resp *http.Response) (result SQLMigrationListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client SQLMigrationServicesClient) listByResourceGroupNextResults(ctx context.Context, lastResults SQLMigrationListResult) (result SQLMigrationListResult, err error) {
	req, err := lastResults.sQLMigrationListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client SQLMigrationServicesClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result SQLMigrationListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLMigrationServicesClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName)
	return
}

// ListBySubscription retrieve all SQL migration services in the subscriptions.
func (client SQLMigrationServicesClient) ListBySubscription(ctx context.Context) (result SQLMigrationListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLMigrationServicesClient.ListBySubscription")
		defer func() {
			sc := -1
			if result.smlr.Response.Response != nil {
				sc = result.smlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listBySubscriptionNextResults
	req, err := client.ListBySubscriptionPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListBySubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.smlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListBySubscription", resp, "Failure sending request")
		return
	}

	result.smlr, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListBySubscription", resp, "Failure responding to request")
		return
	}
	if result.smlr.hasNextLink() && result.smlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListBySubscriptionPreparer prepares the ListBySubscription request.
func (client SQLMigrationServicesClient) ListBySubscriptionPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-30-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DataMigration/sqlMigrationServices", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBySubscriptionSender sends the ListBySubscription request. The method will close the
// http.Response Body if it receives an error.
func (client SQLMigrationServicesClient) ListBySubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBySubscriptionResponder handles the response to the ListBySubscription request. The method always
// closes the http.Response Body.
func (client SQLMigrationServicesClient) ListBySubscriptionResponder(resp *http.Response) (result SQLMigrationListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBySubscriptionNextResults retrieves the next set of results, if any.
func (client SQLMigrationServicesClient) listBySubscriptionNextResults(ctx context.Context, lastResults SQLMigrationListResult) (result SQLMigrationListResult, err error) {
	req, err := lastResults.sQLMigrationListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "listBySubscriptionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "listBySubscriptionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "listBySubscriptionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBySubscriptionComplete enumerates all values, automatically crossing page boundaries as required.
func (client SQLMigrationServicesClient) ListBySubscriptionComplete(ctx context.Context) (result SQLMigrationListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLMigrationServicesClient.ListBySubscription")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBySubscription(ctx)
	return
}

// ListMigrations retrieve the List of database migrations attached to the service.
// Parameters:
// resourceGroupName - name of the resource group that contains the resource. You can obtain this value from
// the Azure Resource Manager API or the portal.
// SQLMigrationServiceName - name of the SQL Migration Service.
func (client SQLMigrationServicesClient) ListMigrations(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (result DatabaseMigrationListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLMigrationServicesClient.ListMigrations")
		defer func() {
			sc := -1
			if result.dmlr.Response.Response != nil {
				sc = result.dmlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listMigrationsNextResults
	req, err := client.ListMigrationsPreparer(ctx, resourceGroupName, SQLMigrationServiceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListMigrations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMigrationsSender(req)
	if err != nil {
		result.dmlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListMigrations", resp, "Failure sending request")
		return
	}

	result.dmlr, err = client.ListMigrationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListMigrations", resp, "Failure responding to request")
		return
	}
	if result.dmlr.hasNextLink() && result.dmlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListMigrationsPreparer prepares the ListMigrations request.
func (client SQLMigrationServicesClient) ListMigrationsPreparer(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"sqlMigrationServiceName": autorest.Encode("path", SQLMigrationServiceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-30-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/listMigrations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMigrationsSender sends the ListMigrations request. The method will close the
// http.Response Body if it receives an error.
func (client SQLMigrationServicesClient) ListMigrationsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMigrationsResponder handles the response to the ListMigrations request. The method always
// closes the http.Response Body.
func (client SQLMigrationServicesClient) ListMigrationsResponder(resp *http.Response) (result DatabaseMigrationListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMigrationsNextResults retrieves the next set of results, if any.
func (client SQLMigrationServicesClient) listMigrationsNextResults(ctx context.Context, lastResults DatabaseMigrationListResult) (result DatabaseMigrationListResult, err error) {
	req, err := lastResults.databaseMigrationListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "listMigrationsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMigrationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "listMigrationsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMigrationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "listMigrationsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMigrationsComplete enumerates all values, automatically crossing page boundaries as required.
func (client SQLMigrationServicesClient) ListMigrationsComplete(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (result DatabaseMigrationListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLMigrationServicesClient.ListMigrations")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMigrations(ctx, resourceGroupName, SQLMigrationServiceName)
	return
}

// ListMonitoringData retrieve the Monitoring Data.
// Parameters:
// resourceGroupName - name of the resource group that contains the resource. You can obtain this value from
// the Azure Resource Manager API or the portal.
// SQLMigrationServiceName - name of the SQL Migration Service.
func (client SQLMigrationServicesClient) ListMonitoringData(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (result IntegrationRuntimeMonitoringData, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLMigrationServicesClient.ListMonitoringData")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListMonitoringDataPreparer(ctx, resourceGroupName, SQLMigrationServiceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListMonitoringData", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMonitoringDataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListMonitoringData", resp, "Failure sending request")
		return
	}

	result, err = client.ListMonitoringDataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "ListMonitoringData", resp, "Failure responding to request")
		return
	}

	return
}

// ListMonitoringDataPreparer prepares the ListMonitoringData request.
func (client SQLMigrationServicesClient) ListMonitoringDataPreparer(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"sqlMigrationServiceName": autorest.Encode("path", SQLMigrationServiceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-30-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/listMonitoringData", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMonitoringDataSender sends the ListMonitoringData request. The method will close the
// http.Response Body if it receives an error.
func (client SQLMigrationServicesClient) ListMonitoringDataSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMonitoringDataResponder handles the response to the ListMonitoringData request. The method always
// closes the http.Response Body.
func (client SQLMigrationServicesClient) ListMonitoringDataResponder(resp *http.Response) (result IntegrationRuntimeMonitoringData, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RegenerateAuthKeys regenerate a new set of Authentication Keys for Self Hosted Integration Runtime.
// Parameters:
// resourceGroupName - name of the resource group that contains the resource. You can obtain this value from
// the Azure Resource Manager API or the portal.
// SQLMigrationServiceName - name of the SQL Migration Service.
// parameters - details of SqlMigrationService resource.
func (client SQLMigrationServicesClient) RegenerateAuthKeys(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string, parameters RegenAuthKeys) (result RegenAuthKeys, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLMigrationServicesClient.RegenerateAuthKeys")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RegenerateAuthKeysPreparer(ctx, resourceGroupName, SQLMigrationServiceName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "RegenerateAuthKeys", nil, "Failure preparing request")
		return
	}

	resp, err := client.RegenerateAuthKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "RegenerateAuthKeys", resp, "Failure sending request")
		return
	}

	result, err = client.RegenerateAuthKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "RegenerateAuthKeys", resp, "Failure responding to request")
		return
	}

	return
}

// RegenerateAuthKeysPreparer prepares the RegenerateAuthKeys request.
func (client SQLMigrationServicesClient) RegenerateAuthKeysPreparer(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string, parameters RegenAuthKeys) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"sqlMigrationServiceName": autorest.Encode("path", SQLMigrationServiceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-30-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/regenerateAuthKeys", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RegenerateAuthKeysSender sends the RegenerateAuthKeys request. The method will close the
// http.Response Body if it receives an error.
func (client SQLMigrationServicesClient) RegenerateAuthKeysSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// RegenerateAuthKeysResponder handles the response to the RegenerateAuthKeys request. The method always
// closes the http.Response Body.
func (client SQLMigrationServicesClient) RegenerateAuthKeysResponder(resp *http.Response) (result RegenAuthKeys, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update update SQL Migration Service.
// Parameters:
// resourceGroupName - name of the resource group that contains the resource. You can obtain this value from
// the Azure Resource Manager API or the portal.
// SQLMigrationServiceName - name of the SQL Migration Service.
// parameters - details of SqlMigrationService resource.
func (client SQLMigrationServicesClient) Update(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string, parameters SQLMigrationServiceUpdate) (result SQLMigrationServicesUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLMigrationServicesClient.Update")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePreparer(ctx, resourceGroupName, SQLMigrationServiceName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "Update", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.SQLMigrationServicesClient", "Update", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client SQLMigrationServicesClient) UpdatePreparer(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string, parameters SQLMigrationServiceUpdate) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"sqlMigrationServiceName": autorest.Encode("path", SQLMigrationServiceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-30-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client SQLMigrationServicesClient) UpdateSender(req *http.Request) (future SQLMigrationServicesUpdateFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client SQLMigrationServicesClient) UpdateResponder(resp *http.Response) (result SQLMigrationService, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
