// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package launchwizardiface provides an interface to enable mocking the AWS Launch Wizard service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package launchwizardiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/launchwizard"
)

// LaunchWizardAPI provides an interface to enable mocking the
// launchwizard.LaunchWizard service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Launch Wizard.
//	func myFunc(svc launchwizardiface.LaunchWizardAPI) bool {
//	    // Make svc.CreateDeployment request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := launchwizard.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockLaunchWizardClient struct {
//	    launchwizardiface.LaunchWizardAPI
//	}
//	func (m *mockLaunchWizardClient) CreateDeployment(input *launchwizard.CreateDeploymentInput) (*launchwizard.CreateDeploymentOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockLaunchWizardClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type LaunchWizardAPI interface {
	CreateDeployment(*launchwizard.CreateDeploymentInput) (*launchwizard.CreateDeploymentOutput, error)
	CreateDeploymentWithContext(aws.Context, *launchwizard.CreateDeploymentInput, ...request.Option) (*launchwizard.CreateDeploymentOutput, error)
	CreateDeploymentRequest(*launchwizard.CreateDeploymentInput) (*request.Request, *launchwizard.CreateDeploymentOutput)

	DeleteDeployment(*launchwizard.DeleteDeploymentInput) (*launchwizard.DeleteDeploymentOutput, error)
	DeleteDeploymentWithContext(aws.Context, *launchwizard.DeleteDeploymentInput, ...request.Option) (*launchwizard.DeleteDeploymentOutput, error)
	DeleteDeploymentRequest(*launchwizard.DeleteDeploymentInput) (*request.Request, *launchwizard.DeleteDeploymentOutput)

	GetDeployment(*launchwizard.GetDeploymentInput) (*launchwizard.GetDeploymentOutput, error)
	GetDeploymentWithContext(aws.Context, *launchwizard.GetDeploymentInput, ...request.Option) (*launchwizard.GetDeploymentOutput, error)
	GetDeploymentRequest(*launchwizard.GetDeploymentInput) (*request.Request, *launchwizard.GetDeploymentOutput)

	GetWorkload(*launchwizard.GetWorkloadInput) (*launchwizard.GetWorkloadOutput, error)
	GetWorkloadWithContext(aws.Context, *launchwizard.GetWorkloadInput, ...request.Option) (*launchwizard.GetWorkloadOutput, error)
	GetWorkloadRequest(*launchwizard.GetWorkloadInput) (*request.Request, *launchwizard.GetWorkloadOutput)

	GetWorkloadDeploymentPattern(*launchwizard.GetWorkloadDeploymentPatternInput) (*launchwizard.GetWorkloadDeploymentPatternOutput, error)
	GetWorkloadDeploymentPatternWithContext(aws.Context, *launchwizard.GetWorkloadDeploymentPatternInput, ...request.Option) (*launchwizard.GetWorkloadDeploymentPatternOutput, error)
	GetWorkloadDeploymentPatternRequest(*launchwizard.GetWorkloadDeploymentPatternInput) (*request.Request, *launchwizard.GetWorkloadDeploymentPatternOutput)

	ListDeploymentEvents(*launchwizard.ListDeploymentEventsInput) (*launchwizard.ListDeploymentEventsOutput, error)
	ListDeploymentEventsWithContext(aws.Context, *launchwizard.ListDeploymentEventsInput, ...request.Option) (*launchwizard.ListDeploymentEventsOutput, error)
	ListDeploymentEventsRequest(*launchwizard.ListDeploymentEventsInput) (*request.Request, *launchwizard.ListDeploymentEventsOutput)

	ListDeploymentEventsPages(*launchwizard.ListDeploymentEventsInput, func(*launchwizard.ListDeploymentEventsOutput, bool) bool) error
	ListDeploymentEventsPagesWithContext(aws.Context, *launchwizard.ListDeploymentEventsInput, func(*launchwizard.ListDeploymentEventsOutput, bool) bool, ...request.Option) error

	ListDeployments(*launchwizard.ListDeploymentsInput) (*launchwizard.ListDeploymentsOutput, error)
	ListDeploymentsWithContext(aws.Context, *launchwizard.ListDeploymentsInput, ...request.Option) (*launchwizard.ListDeploymentsOutput, error)
	ListDeploymentsRequest(*launchwizard.ListDeploymentsInput) (*request.Request, *launchwizard.ListDeploymentsOutput)

	ListDeploymentsPages(*launchwizard.ListDeploymentsInput, func(*launchwizard.ListDeploymentsOutput, bool) bool) error
	ListDeploymentsPagesWithContext(aws.Context, *launchwizard.ListDeploymentsInput, func(*launchwizard.ListDeploymentsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*launchwizard.ListTagsForResourceInput) (*launchwizard.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *launchwizard.ListTagsForResourceInput, ...request.Option) (*launchwizard.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*launchwizard.ListTagsForResourceInput) (*request.Request, *launchwizard.ListTagsForResourceOutput)

	ListWorkloadDeploymentPatterns(*launchwizard.ListWorkloadDeploymentPatternsInput) (*launchwizard.ListWorkloadDeploymentPatternsOutput, error)
	ListWorkloadDeploymentPatternsWithContext(aws.Context, *launchwizard.ListWorkloadDeploymentPatternsInput, ...request.Option) (*launchwizard.ListWorkloadDeploymentPatternsOutput, error)
	ListWorkloadDeploymentPatternsRequest(*launchwizard.ListWorkloadDeploymentPatternsInput) (*request.Request, *launchwizard.ListWorkloadDeploymentPatternsOutput)

	ListWorkloadDeploymentPatternsPages(*launchwizard.ListWorkloadDeploymentPatternsInput, func(*launchwizard.ListWorkloadDeploymentPatternsOutput, bool) bool) error
	ListWorkloadDeploymentPatternsPagesWithContext(aws.Context, *launchwizard.ListWorkloadDeploymentPatternsInput, func(*launchwizard.ListWorkloadDeploymentPatternsOutput, bool) bool, ...request.Option) error

	ListWorkloads(*launchwizard.ListWorkloadsInput) (*launchwizard.ListWorkloadsOutput, error)
	ListWorkloadsWithContext(aws.Context, *launchwizard.ListWorkloadsInput, ...request.Option) (*launchwizard.ListWorkloadsOutput, error)
	ListWorkloadsRequest(*launchwizard.ListWorkloadsInput) (*request.Request, *launchwizard.ListWorkloadsOutput)

	ListWorkloadsPages(*launchwizard.ListWorkloadsInput, func(*launchwizard.ListWorkloadsOutput, bool) bool) error
	ListWorkloadsPagesWithContext(aws.Context, *launchwizard.ListWorkloadsInput, func(*launchwizard.ListWorkloadsOutput, bool) bool, ...request.Option) error

	TagResource(*launchwizard.TagResourceInput) (*launchwizard.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *launchwizard.TagResourceInput, ...request.Option) (*launchwizard.TagResourceOutput, error)
	TagResourceRequest(*launchwizard.TagResourceInput) (*request.Request, *launchwizard.TagResourceOutput)

	UntagResource(*launchwizard.UntagResourceInput) (*launchwizard.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *launchwizard.UntagResourceInput, ...request.Option) (*launchwizard.UntagResourceOutput, error)
	UntagResourceRequest(*launchwizard.UntagResourceInput) (*request.Request, *launchwizard.UntagResourceOutput)
}

var _ LaunchWizardAPI = (*launchwizard.LaunchWizard)(nil)
