/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.layout;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.deprecation.DeprecationLogger;

public class BuildLayoutConfiguration {
    private final File currentDir;
    private final boolean searchUpwards;
    private final File settingsFile;
    private final File buildFile;
    private final boolean useEmptySettings;

    public BuildLayoutConfiguration(StartParameter startParameter) {
        File customBuildFile;
        File customSettingsFile;
        this.currentDir = startParameter.getCurrentDir();
        this.searchUpwards = ((StartParameterInternal)startParameter).isSearchUpwards();
        this.settingsFile = customSettingsFile = (File)DeprecationLogger.whileDisabled(() -> ((StartParameter)startParameter).getSettingsFile());
        this.buildFile = customBuildFile = (File)DeprecationLogger.whileDisabled(() -> ((StartParameter)startParameter).getBuildFile());
        this.useEmptySettings = ((StartParameterInternal)startParameter).isUseEmptySettings();
    }

    public BuildLayoutConfiguration(BuildLayoutParameters parameters) {
        this.currentDir = parameters.getCurrentDir();
        this.searchUpwards = true;
        this.settingsFile = parameters.getSettingsFile();
        this.buildFile = parameters.getBuildFile();
        this.useEmptySettings = false;
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    public boolean isSearchUpwards() {
        return this.searchUpwards;
    }

    @Nullable
    public File getSettingsFile() {
        return this.settingsFile;
    }

    @Nullable
    public File getBuildFile() {
        return this.buildFile;
    }

    public boolean isUseEmptySettings() {
        return this.useEmptySettings;
    }
}

