/*
    SPDX-FileCopyrightText: 2008-2009 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KPIECETABLE_ABSTRACTPIECETABLECHANGE_HPP
#define KPIECETABLE_ABSTRACTPIECETABLECHANGE_HPP

// lib
#include "piece.hpp"
//
#include <arraychangemetrics.hpp>

class QString;

namespace KPieceTable {

class PieceTable;

using ArrayChangeMetrics = Okteta::ArrayChangeMetrics;

/** class
 * @author Friedrich W. H. Kossebau
 */

class AbstractPieceTableChange
{
public:
    enum TypeId
    {
        InsertId,
        RemoveId,
        ReplaceId,
        SwapRangesId,
        FillId,
        ReplaceOneId,
        GroupId
    };

public:
    virtual ~AbstractPieceTableChange();

public: // API to be implemented
    [[nodiscard]]
    virtual int type() const = 0;

    [[nodiscard]]
    virtual QString description() const = 0;

    /// returns the storageOffset. Default returns -1.
    [[nodiscard]]
    virtual Address storageOffset() const;

    /// returns true if successful, false otherwise. Default returns false.
    [[nodiscard]]
    virtual bool merge(const AbstractPieceTableChange* other);

    [[nodiscard]]
    virtual AddressRange apply(PieceTable* pieceTable) const = 0;
    [[nodiscard]]
    virtual AddressRange revert(PieceTable* pieceTable) const = 0;

    [[nodiscard]]
    virtual ArrayChangeMetrics metrics() const = 0;
    /// returns the size of the added data. Default returns 0.
    [[nodiscard]]
    virtual Size dataSize() const;
};

inline AbstractPieceTableChange::~AbstractPieceTableChange() = default;

}

#endif
