/****************************************************************************
**
** This file is part of the LibreCAD project, a 2D CAD program
**
** Copyright (C) 2010 R. van Twisk (librecad@rvt.dds.nl)
** Copyright (C) 2001-2003 RibbonSoft. All rights reserved.
**
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software 
** Foundation and appearing in the file gpl-2.0.txt included in the
** packaging of this file.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** This copyright notice MUST APPEAR in all copies of the script!  
**
**********************************************************************/

#ifndef RS_ACTIONDRAWARCTANGENTIAL_H
#define RS_ACTIONDRAWARCTANGENTIAL_H

#include "rs_previewactioninterface.h"

class RS_AtomicEntity;
struct RS_ArcData;

/**
 * This action class can handle user events to draw 
 * arcs with three points given.
 *
 * @author Andrew Mustun
 */
class RS_ActionDrawArcTangential:public RS_PreviewActionInterface {
    Q_OBJECT
public:
    RS_ActionDrawArcTangential(LC_ActionContext *actionContext);
    ~RS_ActionDrawArcTangential() override;
    void reset();
    void preparePreview();
    void setRadius(double r);
    double getRadius() const;
    void setAngle(double r);
    double getAngle() const;
    void setByRadius(bool status = true);
    bool getByRadius() const;
protected:
    /**
 * Action States.
 */
    enum Status {
        SetBaseEntity = InitialActionStatus,   /**< Setting base entity. */
        SetEndAngle                            /**< Setting end angle. */
    };

    /**
     * Base entity.
     */
    RS_AtomicEntity *m_baseEntity = nullptr;
    /**
  * Start point of base entity clicked?
  */
    bool m_isStartPoint = false;
    /**
     * Point that determines end angle.
     */
    RS_Vector m_point;

    RS_Vector m_arcStartPoint;
    /**
  * Arc data calculated.
  */
    std::unique_ptr<RS_ArcData> m_arcData;

    double m_angleLength = 0.;
    bool m_byRadius = false;
    bool m_alternateArc = false;
    void doInitWithContextEntity(RS_Entity* contextEntity, const RS_Vector& clickPosition) override;
    RS_Vector forecastArcCenter() const;
    void setBaseEntity(RS_Entity* entity, RS_Vector coord);
    void updateOptionsRadius(double radius);
    void updateOptionsAngle(double angle);
    RS2::CursorType doGetMouseCursor(int status) override;
    void onMouseLeftButtonRelease(int status, LC_MouseEvent *e) override;
    void onMouseRightButtonRelease(int status, LC_MouseEvent *e) override;
    void onMouseMoveEvent(int status, LC_MouseEvent *event) override;
    void onCoordinateEvent(int status, bool isZero, const RS_Vector &pos) override;
    LC_ActionOptionsWidget* createOptionsWidget() override;
    void updateMouseButtonHints() override;
    void doTrigger() override;
    bool doUpdateAngleByInteractiveInput(const QString& tag, double angle) override;
    bool doUpdateDistanceByInteractiveInput(const QString& tag, double distance) override;
};
#endif
