/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	"encoding/json"
)

// OnboardingRequest struct for OnboardingRequest
type OnboardingRequest struct {
	Username               string  `json:"username" yaml:"username"`
	Password               *string `json:"password,omitempty" yaml:"password,omitempty"`
	Org                    string  `json:"org" yaml:"org"`
	Bucket                 string  `json:"bucket" yaml:"bucket"`
	RetentionPeriodSeconds *int64  `json:"retentionPeriodSeconds,omitempty" yaml:"retentionPeriodSeconds,omitempty"`
	// Retention period *in nanoseconds* for the new bucket. This key's name has been misleading since OSS 2.0 GA, please transition to use `retentionPeriodSeconds`
	RetentionPeriodHrs *int32 `json:"retentionPeriodHrs,omitempty" yaml:"retentionPeriodHrs,omitempty"`
	// Authentication token to set on the initial user. If not specified, the server will generate a token.
	Token *string `json:"token,omitempty" yaml:"token,omitempty"`
}

// NewOnboardingRequest instantiates a new OnboardingRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewOnboardingRequest(username string, org string, bucket string) *OnboardingRequest {
	this := OnboardingRequest{}
	this.Username = username
	this.Org = org
	this.Bucket = bucket
	return &this
}

// NewOnboardingRequestWithDefaults instantiates a new OnboardingRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewOnboardingRequestWithDefaults() *OnboardingRequest {
	this := OnboardingRequest{}
	return &this
}

// GetUsername returns the Username field value
func (o *OnboardingRequest) GetUsername() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Username
}

// GetUsernameOk returns a tuple with the Username field value
// and a boolean to check if the value has been set.
func (o *OnboardingRequest) GetUsernameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Username, true
}

// SetUsername sets field value
func (o *OnboardingRequest) SetUsername(v string) {
	o.Username = v
}

// GetPassword returns the Password field value if set, zero value otherwise.
func (o *OnboardingRequest) GetPassword() string {
	if o == nil || o.Password == nil {
		var ret string
		return ret
	}
	return *o.Password
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OnboardingRequest) GetPasswordOk() (*string, bool) {
	if o == nil || o.Password == nil {
		return nil, false
	}
	return o.Password, true
}

// HasPassword returns a boolean if a field has been set.
func (o *OnboardingRequest) HasPassword() bool {
	if o != nil && o.Password != nil {
		return true
	}

	return false
}

// SetPassword gets a reference to the given string and assigns it to the Password field.
func (o *OnboardingRequest) SetPassword(v string) {
	o.Password = &v
}

// GetOrg returns the Org field value
func (o *OnboardingRequest) GetOrg() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Org
}

// GetOrgOk returns a tuple with the Org field value
// and a boolean to check if the value has been set.
func (o *OnboardingRequest) GetOrgOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Org, true
}

// SetOrg sets field value
func (o *OnboardingRequest) SetOrg(v string) {
	o.Org = v
}

// GetBucket returns the Bucket field value
func (o *OnboardingRequest) GetBucket() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Bucket
}

// GetBucketOk returns a tuple with the Bucket field value
// and a boolean to check if the value has been set.
func (o *OnboardingRequest) GetBucketOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Bucket, true
}

// SetBucket sets field value
func (o *OnboardingRequest) SetBucket(v string) {
	o.Bucket = v
}

// GetRetentionPeriodSeconds returns the RetentionPeriodSeconds field value if set, zero value otherwise.
func (o *OnboardingRequest) GetRetentionPeriodSeconds() int64 {
	if o == nil || o.RetentionPeriodSeconds == nil {
		var ret int64
		return ret
	}
	return *o.RetentionPeriodSeconds
}

// GetRetentionPeriodSecondsOk returns a tuple with the RetentionPeriodSeconds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OnboardingRequest) GetRetentionPeriodSecondsOk() (*int64, bool) {
	if o == nil || o.RetentionPeriodSeconds == nil {
		return nil, false
	}
	return o.RetentionPeriodSeconds, true
}

// HasRetentionPeriodSeconds returns a boolean if a field has been set.
func (o *OnboardingRequest) HasRetentionPeriodSeconds() bool {
	if o != nil && o.RetentionPeriodSeconds != nil {
		return true
	}

	return false
}

// SetRetentionPeriodSeconds gets a reference to the given int64 and assigns it to the RetentionPeriodSeconds field.
func (o *OnboardingRequest) SetRetentionPeriodSeconds(v int64) {
	o.RetentionPeriodSeconds = &v
}

// GetRetentionPeriodHrs returns the RetentionPeriodHrs field value if set, zero value otherwise.
func (o *OnboardingRequest) GetRetentionPeriodHrs() int32 {
	if o == nil || o.RetentionPeriodHrs == nil {
		var ret int32
		return ret
	}
	return *o.RetentionPeriodHrs
}

// GetRetentionPeriodHrsOk returns a tuple with the RetentionPeriodHrs field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OnboardingRequest) GetRetentionPeriodHrsOk() (*int32, bool) {
	if o == nil || o.RetentionPeriodHrs == nil {
		return nil, false
	}
	return o.RetentionPeriodHrs, true
}

// HasRetentionPeriodHrs returns a boolean if a field has been set.
func (o *OnboardingRequest) HasRetentionPeriodHrs() bool {
	if o != nil && o.RetentionPeriodHrs != nil {
		return true
	}

	return false
}

// SetRetentionPeriodHrs gets a reference to the given int32 and assigns it to the RetentionPeriodHrs field.
func (o *OnboardingRequest) SetRetentionPeriodHrs(v int32) {
	o.RetentionPeriodHrs = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *OnboardingRequest) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OnboardingRequest) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *OnboardingRequest) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *OnboardingRequest) SetToken(v string) {
	o.Token = &v
}

func (o OnboardingRequest) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["username"] = o.Username
	}
	if o.Password != nil {
		toSerialize["password"] = o.Password
	}
	if true {
		toSerialize["org"] = o.Org
	}
	if true {
		toSerialize["bucket"] = o.Bucket
	}
	if o.RetentionPeriodSeconds != nil {
		toSerialize["retentionPeriodSeconds"] = o.RetentionPeriodSeconds
	}
	if o.RetentionPeriodHrs != nil {
		toSerialize["retentionPeriodHrs"] = o.RetentionPeriodHrs
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	return json.Marshal(toSerialize)
}

type NullableOnboardingRequest struct {
	value *OnboardingRequest
	isSet bool
}

func (v NullableOnboardingRequest) Get() *OnboardingRequest {
	return v.value
}

func (v *NullableOnboardingRequest) Set(val *OnboardingRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableOnboardingRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableOnboardingRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableOnboardingRequest(val *OnboardingRequest) *NullableOnboardingRequest {
	return &NullableOnboardingRequest{value: val, isSet: true}
}

func (v NullableOnboardingRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableOnboardingRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
