// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum Error {
    /// <p>Specifies that you do not have the permissions required to perform this operation.</p>
    AccessDeniedException(crate::types::error::AccessDeniedException),
    /// <p>The provided iterator exceeds the maximum age allowed.</p>
    ExpiredIteratorException(crate::types::error::ExpiredIteratorException),
    /// <p>The pagination token passed to the operation is expired.</p>
    ExpiredNextTokenException(crate::types::error::ExpiredNextTokenException),
    /// <p>The processing of the request failed because of an unknown error, exception, or failure.</p>
    InternalFailureException(crate::types::error::InternalFailureException),
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information, see the returned message.</p>
    InvalidArgumentException(crate::types::error::InvalidArgumentException),
    /// <p>The ciphertext references a key that doesn't exist or that you don't have access to.</p>
    KmsAccessDeniedException(crate::types::error::KmsAccessDeniedException),
    /// <p>The request was rejected because the specified customer master key (CMK) isn't enabled.</p>
    KmsDisabledException(crate::types::error::KmsDisabledException),
    /// <p>The request was rejected because the state of the specified resource isn't valid for this request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects Use of a Customer Master Key</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    KmsInvalidStateException(crate::types::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource can't be found.</p>
    KmsNotFoundException(crate::types::error::KmsNotFoundException),
    /// <p>The Amazon Web Services access key ID needs a subscription for the service.</p>
    KmsOptInRequired(crate::types::error::KmsOptInRequired),
    /// <p>The request was denied due to request throttling. For more information about throttling, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    KmsThrottlingException(crate::types::error::KmsThrottlingException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds the maximum number allowed.</p>
    LimitExceededException(crate::types::error::LimitExceededException),
    /// <p>The request rate for the stream is too high, or the requested data is too large for the available throughput. Reduce the frequency or size of your requests. For more information, see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and Exponential Backoff in Amazon Web Services</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ProvisionedThroughputExceededException(crate::types::error::ProvisionedThroughputExceededException),
    /// <p>The resource is not available for this operation. For successful operation, the resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::types::error::ResourceInUseException),
    /// <p>The requested resource could not be found. The stream might not be specified correctly.</p>
    ResourceNotFoundException(crate::types::error::ResourceNotFoundException),
    /// <p>Specifies that you tried to invoke this API for a data stream with the on-demand capacity mode. This API is only supported for data streams with the provisioned capacity mode.</p>
    ValidationException(crate::types::error::ValidationException),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-Error) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl ::std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::ExpiredIteratorException(inner) => inner.fmt(f),
            Error::ExpiredNextTokenException(inner) => inner.fmt(f),
            Error::InternalFailureException(inner) => inner.fmt(f),
            Error::InvalidArgumentException(inner) => inner.fmt(f),
            Error::KmsAccessDeniedException(inner) => inner.fmt(f),
            Error::KmsDisabledException(inner) => inner.fmt(f),
            Error::KmsInvalidStateException(inner) => inner.fmt(f),
            Error::KmsNotFoundException(inner) => inner.fmt(f),
            Error::KmsOptInRequired(inner) => inner.fmt(f),
            Error::KmsThrottlingException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::ProvisionedThroughputExceededException(inner) => inner.fmt(f),
            Error::ResourceInUseException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ValidationException(inner) => inner.fmt(f),
            Error::Unhandled(_) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl From<::aws_smithy_types::error::operation::BuildError> for Error {
    fn from(value: ::aws_smithy_types::error::operation::BuildError) -> Self {
        Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: value.into(),
            meta: ::std::default::Default::default(),
        })
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for Error {
    fn meta(&self) -> &::aws_smithy_types::error::metadata::ErrorMetadata {
        match self {
            Self::AccessDeniedException(inner) => inner.meta(),
            Self::ExpiredIteratorException(inner) => inner.meta(),
            Self::ExpiredNextTokenException(inner) => inner.meta(),
            Self::InternalFailureException(inner) => inner.meta(),
            Self::InvalidArgumentException(inner) => inner.meta(),
            Self::KmsAccessDeniedException(inner) => inner.meta(),
            Self::KmsDisabledException(inner) => inner.meta(),
            Self::KmsInvalidStateException(inner) => inner.meta(),
            Self::KmsNotFoundException(inner) => inner.meta(),
            Self::KmsOptInRequired(inner) => inner.meta(),
            Self::KmsThrottlingException(inner) => inner.meta(),
            Self::LimitExceededException(inner) => inner.meta(),
            Self::ProvisionedThroughputExceededException(inner) => inner.meta(),
            Self::ResourceInUseException(inner) => inner.meta(),
            Self::ResourceNotFoundException(inner) => inner.meta(),
            Self::ValidationException(inner) => inner.meta(),
            Self::Unhandled(inner) => &inner.meta,
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::add_tags_to_stream::AddTagsToStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::add_tags_to_stream::AddTagsToStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::add_tags_to_stream::AddTagsToStreamError> for Error {
    fn from(err: crate::operation::add_tags_to_stream::AddTagsToStreamError) -> Self {
        match err {
            crate::operation::add_tags_to_stream::AddTagsToStreamError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::add_tags_to_stream::AddTagsToStreamError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::add_tags_to_stream::AddTagsToStreamError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::add_tags_to_stream::AddTagsToStreamError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::add_tags_to_stream::AddTagsToStreamError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::add_tags_to_stream::AddTagsToStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_stream::CreateStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_stream::CreateStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::create_stream::CreateStreamError> for Error {
    fn from(err: crate::operation::create_stream::CreateStreamError) -> Self {
        match err {
            crate::operation::create_stream::CreateStreamError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::create_stream::CreateStreamError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::create_stream::CreateStreamError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::create_stream::CreateStreamError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::create_stream::CreateStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::decrease_stream_retention_period::DecreaseStreamRetentionPeriodError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::decrease_stream_retention_period::DecreaseStreamRetentionPeriodError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::decrease_stream_retention_period::DecreaseStreamRetentionPeriodError> for Error {
    fn from(err: crate::operation::decrease_stream_retention_period::DecreaseStreamRetentionPeriodError) -> Self {
        match err {
            crate::operation::decrease_stream_retention_period::DecreaseStreamRetentionPeriodError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::decrease_stream_retention_period::DecreaseStreamRetentionPeriodError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::decrease_stream_retention_period::DecreaseStreamRetentionPeriodError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::decrease_stream_retention_period::DecreaseStreamRetentionPeriodError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::decrease_stream_retention_period::DecreaseStreamRetentionPeriodError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::decrease_stream_retention_period::DecreaseStreamRetentionPeriodError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_resource_policy::DeleteResourcePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_resource_policy::DeleteResourcePolicyError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_resource_policy::DeleteResourcePolicyError> for Error {
    fn from(err: crate::operation::delete_resource_policy::DeleteResourcePolicyError) -> Self {
        match err {
            crate::operation::delete_resource_policy::DeleteResourcePolicyError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::delete_resource_policy::DeleteResourcePolicyError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::delete_resource_policy::DeleteResourcePolicyError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::delete_resource_policy::DeleteResourcePolicyError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::delete_resource_policy::DeleteResourcePolicyError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::delete_resource_policy::DeleteResourcePolicyError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_stream::DeleteStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_stream::DeleteStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_stream::DeleteStreamError> for Error {
    fn from(err: crate::operation::delete_stream::DeleteStreamError) -> Self {
        match err {
            crate::operation::delete_stream::DeleteStreamError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::delete_stream::DeleteStreamError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::delete_stream::DeleteStreamError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::delete_stream::DeleteStreamError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::delete_stream::DeleteStreamError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::delete_stream::DeleteStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::deregister_stream_consumer::DeregisterStreamConsumerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::deregister_stream_consumer::DeregisterStreamConsumerError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::deregister_stream_consumer::DeregisterStreamConsumerError> for Error {
    fn from(err: crate::operation::deregister_stream_consumer::DeregisterStreamConsumerError) -> Self {
        match err {
            crate::operation::deregister_stream_consumer::DeregisterStreamConsumerError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::deregister_stream_consumer::DeregisterStreamConsumerError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::deregister_stream_consumer::DeregisterStreamConsumerError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::deregister_stream_consumer::DeregisterStreamConsumerError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_account_settings::DescribeAccountSettingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_account_settings::DescribeAccountSettingsError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_account_settings::DescribeAccountSettingsError> for Error {
    fn from(err: crate::operation::describe_account_settings::DescribeAccountSettingsError) -> Self {
        match err {
            crate::operation::describe_account_settings::DescribeAccountSettingsError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::describe_account_settings::DescribeAccountSettingsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_limits::DescribeLimitsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_limits::DescribeLimitsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_limits::DescribeLimitsError> for Error {
    fn from(err: crate::operation::describe_limits::DescribeLimitsError) -> Self {
        match err {
            crate::operation::describe_limits::DescribeLimitsError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::describe_limits::DescribeLimitsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_stream::DescribeStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_stream::DescribeStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_stream::DescribeStreamError> for Error {
    fn from(err: crate::operation::describe_stream::DescribeStreamError) -> Self {
        match err {
            crate::operation::describe_stream::DescribeStreamError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::describe_stream::DescribeStreamError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::describe_stream::DescribeStreamError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::describe_stream::DescribeStreamError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::describe_stream::DescribeStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_stream_consumer::DescribeStreamConsumerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_stream_consumer::DescribeStreamConsumerError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_stream_consumer::DescribeStreamConsumerError> for Error {
    fn from(err: crate::operation::describe_stream_consumer::DescribeStreamConsumerError) -> Self {
        match err {
            crate::operation::describe_stream_consumer::DescribeStreamConsumerError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::describe_stream_consumer::DescribeStreamConsumerError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::describe_stream_consumer::DescribeStreamConsumerError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::describe_stream_consumer::DescribeStreamConsumerError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_stream_summary::DescribeStreamSummaryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_stream_summary::DescribeStreamSummaryError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_stream_summary::DescribeStreamSummaryError> for Error {
    fn from(err: crate::operation::describe_stream_summary::DescribeStreamSummaryError) -> Self {
        match err {
            crate::operation::describe_stream_summary::DescribeStreamSummaryError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::describe_stream_summary::DescribeStreamSummaryError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::describe_stream_summary::DescribeStreamSummaryError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::describe_stream_summary::DescribeStreamSummaryError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::describe_stream_summary::DescribeStreamSummaryError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringError> for Error {
    fn from(err: crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringError) -> Self {
        match err {
            crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringError> for Error {
    fn from(err: crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringError) -> Self {
        match err {
            crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_records::GetRecordsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_records::GetRecordsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_records::GetRecordsError> for Error {
    fn from(err: crate::operation::get_records::GetRecordsError) -> Self {
        match err {
            crate::operation::get_records::GetRecordsError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::get_records::GetRecordsError::ExpiredIteratorException(inner) => Error::ExpiredIteratorException(inner),
            crate::operation::get_records::GetRecordsError::InternalFailureException(inner) => Error::InternalFailureException(inner),
            crate::operation::get_records::GetRecordsError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::get_records::GetRecordsError::KmsAccessDeniedException(inner) => Error::KmsAccessDeniedException(inner),
            crate::operation::get_records::GetRecordsError::KmsDisabledException(inner) => Error::KmsDisabledException(inner),
            crate::operation::get_records::GetRecordsError::KmsInvalidStateException(inner) => Error::KmsInvalidStateException(inner),
            crate::operation::get_records::GetRecordsError::KmsNotFoundException(inner) => Error::KmsNotFoundException(inner),
            crate::operation::get_records::GetRecordsError::KmsOptInRequired(inner) => Error::KmsOptInRequired(inner),
            crate::operation::get_records::GetRecordsError::KmsThrottlingException(inner) => Error::KmsThrottlingException(inner),
            crate::operation::get_records::GetRecordsError::ProvisionedThroughputExceededException(inner) => {
                Error::ProvisionedThroughputExceededException(inner)
            }
            crate::operation::get_records::GetRecordsError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::get_records::GetRecordsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_resource_policy::GetResourcePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_resource_policy::GetResourcePolicyError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_resource_policy::GetResourcePolicyError> for Error {
    fn from(err: crate::operation::get_resource_policy::GetResourcePolicyError) -> Self {
        match err {
            crate::operation::get_resource_policy::GetResourcePolicyError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::get_resource_policy::GetResourcePolicyError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::get_resource_policy::GetResourcePolicyError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::get_resource_policy::GetResourcePolicyError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::get_resource_policy::GetResourcePolicyError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::get_resource_policy::GetResourcePolicyError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_shard_iterator::GetShardIteratorError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_shard_iterator::GetShardIteratorError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_shard_iterator::GetShardIteratorError> for Error {
    fn from(err: crate::operation::get_shard_iterator::GetShardIteratorError) -> Self {
        match err {
            crate::operation::get_shard_iterator::GetShardIteratorError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::get_shard_iterator::GetShardIteratorError::InternalFailureException(inner) => Error::InternalFailureException(inner),
            crate::operation::get_shard_iterator::GetShardIteratorError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::get_shard_iterator::GetShardIteratorError::ProvisionedThroughputExceededException(inner) => {
                Error::ProvisionedThroughputExceededException(inner)
            }
            crate::operation::get_shard_iterator::GetShardIteratorError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::get_shard_iterator::GetShardIteratorError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::increase_stream_retention_period::IncreaseStreamRetentionPeriodError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::increase_stream_retention_period::IncreaseStreamRetentionPeriodError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::increase_stream_retention_period::IncreaseStreamRetentionPeriodError> for Error {
    fn from(err: crate::operation::increase_stream_retention_period::IncreaseStreamRetentionPeriodError) -> Self {
        match err {
            crate::operation::increase_stream_retention_period::IncreaseStreamRetentionPeriodError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::increase_stream_retention_period::IncreaseStreamRetentionPeriodError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::increase_stream_retention_period::IncreaseStreamRetentionPeriodError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::increase_stream_retention_period::IncreaseStreamRetentionPeriodError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::increase_stream_retention_period::IncreaseStreamRetentionPeriodError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::increase_stream_retention_period::IncreaseStreamRetentionPeriodError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_shards::ListShardsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_shards::ListShardsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_shards::ListShardsError> for Error {
    fn from(err: crate::operation::list_shards::ListShardsError) -> Self {
        match err {
            crate::operation::list_shards::ListShardsError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::list_shards::ListShardsError::ExpiredNextTokenException(inner) => Error::ExpiredNextTokenException(inner),
            crate::operation::list_shards::ListShardsError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::list_shards::ListShardsError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::list_shards::ListShardsError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::list_shards::ListShardsError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::list_shards::ListShardsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_stream_consumers::ListStreamConsumersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_stream_consumers::ListStreamConsumersError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_stream_consumers::ListStreamConsumersError> for Error {
    fn from(err: crate::operation::list_stream_consumers::ListStreamConsumersError) -> Self {
        match err {
            crate::operation::list_stream_consumers::ListStreamConsumersError::ExpiredNextTokenException(inner) => {
                Error::ExpiredNextTokenException(inner)
            }
            crate::operation::list_stream_consumers::ListStreamConsumersError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::list_stream_consumers::ListStreamConsumersError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::list_stream_consumers::ListStreamConsumersError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::list_stream_consumers::ListStreamConsumersError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::list_stream_consumers::ListStreamConsumersError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_streams::ListStreamsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_streams::ListStreamsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_streams::ListStreamsError> for Error {
    fn from(err: crate::operation::list_streams::ListStreamsError) -> Self {
        match err {
            crate::operation::list_streams::ListStreamsError::ExpiredNextTokenException(inner) => Error::ExpiredNextTokenException(inner),
            crate::operation::list_streams::ListStreamsError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::list_streams::ListStreamsError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::list_streams::ListStreamsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_tags_for_resource::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_tags_for_resource::ListTagsForResourceError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_tags_for_resource::ListTagsForResourceError> for Error {
    fn from(err: crate::operation::list_tags_for_resource::ListTagsForResourceError) -> Self {
        match err {
            crate::operation::list_tags_for_resource::ListTagsForResourceError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::list_tags_for_resource::ListTagsForResourceError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::list_tags_for_resource::ListTagsForResourceError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::list_tags_for_resource::ListTagsForResourceError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::list_tags_for_resource::ListTagsForResourceError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::list_tags_for_resource::ListTagsForResourceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_tags_for_stream::ListTagsForStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_tags_for_stream::ListTagsForStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_tags_for_stream::ListTagsForStreamError> for Error {
    fn from(err: crate::operation::list_tags_for_stream::ListTagsForStreamError) -> Self {
        match err {
            crate::operation::list_tags_for_stream::ListTagsForStreamError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::list_tags_for_stream::ListTagsForStreamError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::list_tags_for_stream::ListTagsForStreamError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::list_tags_for_stream::ListTagsForStreamError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::list_tags_for_stream::ListTagsForStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::merge_shards::MergeShardsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::merge_shards::MergeShardsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::merge_shards::MergeShardsError> for Error {
    fn from(err: crate::operation::merge_shards::MergeShardsError) -> Self {
        match err {
            crate::operation::merge_shards::MergeShardsError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::merge_shards::MergeShardsError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::merge_shards::MergeShardsError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::merge_shards::MergeShardsError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::merge_shards::MergeShardsError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::merge_shards::MergeShardsError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::merge_shards::MergeShardsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_record::PutRecordError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_record::PutRecordError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_record::PutRecordError> for Error {
    fn from(err: crate::operation::put_record::PutRecordError) -> Self {
        match err {
            crate::operation::put_record::PutRecordError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::put_record::PutRecordError::InternalFailureException(inner) => Error::InternalFailureException(inner),
            crate::operation::put_record::PutRecordError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::put_record::PutRecordError::KmsAccessDeniedException(inner) => Error::KmsAccessDeniedException(inner),
            crate::operation::put_record::PutRecordError::KmsDisabledException(inner) => Error::KmsDisabledException(inner),
            crate::operation::put_record::PutRecordError::KmsInvalidStateException(inner) => Error::KmsInvalidStateException(inner),
            crate::operation::put_record::PutRecordError::KmsNotFoundException(inner) => Error::KmsNotFoundException(inner),
            crate::operation::put_record::PutRecordError::KmsOptInRequired(inner) => Error::KmsOptInRequired(inner),
            crate::operation::put_record::PutRecordError::KmsThrottlingException(inner) => Error::KmsThrottlingException(inner),
            crate::operation::put_record::PutRecordError::ProvisionedThroughputExceededException(inner) => {
                Error::ProvisionedThroughputExceededException(inner)
            }
            crate::operation::put_record::PutRecordError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::put_record::PutRecordError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_records::PutRecordsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_records::PutRecordsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_records::PutRecordsError> for Error {
    fn from(err: crate::operation::put_records::PutRecordsError) -> Self {
        match err {
            crate::operation::put_records::PutRecordsError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::put_records::PutRecordsError::InternalFailureException(inner) => Error::InternalFailureException(inner),
            crate::operation::put_records::PutRecordsError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::put_records::PutRecordsError::KmsAccessDeniedException(inner) => Error::KmsAccessDeniedException(inner),
            crate::operation::put_records::PutRecordsError::KmsDisabledException(inner) => Error::KmsDisabledException(inner),
            crate::operation::put_records::PutRecordsError::KmsInvalidStateException(inner) => Error::KmsInvalidStateException(inner),
            crate::operation::put_records::PutRecordsError::KmsNotFoundException(inner) => Error::KmsNotFoundException(inner),
            crate::operation::put_records::PutRecordsError::KmsOptInRequired(inner) => Error::KmsOptInRequired(inner),
            crate::operation::put_records::PutRecordsError::KmsThrottlingException(inner) => Error::KmsThrottlingException(inner),
            crate::operation::put_records::PutRecordsError::ProvisionedThroughputExceededException(inner) => {
                Error::ProvisionedThroughputExceededException(inner)
            }
            crate::operation::put_records::PutRecordsError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::put_records::PutRecordsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_resource_policy::PutResourcePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::put_resource_policy::PutResourcePolicyError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::put_resource_policy::PutResourcePolicyError> for Error {
    fn from(err: crate::operation::put_resource_policy::PutResourcePolicyError) -> Self {
        match err {
            crate::operation::put_resource_policy::PutResourcePolicyError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::put_resource_policy::PutResourcePolicyError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::put_resource_policy::PutResourcePolicyError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::put_resource_policy::PutResourcePolicyError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::put_resource_policy::PutResourcePolicyError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::put_resource_policy::PutResourcePolicyError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::register_stream_consumer::RegisterStreamConsumerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::register_stream_consumer::RegisterStreamConsumerError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::register_stream_consumer::RegisterStreamConsumerError> for Error {
    fn from(err: crate::operation::register_stream_consumer::RegisterStreamConsumerError) -> Self {
        match err {
            crate::operation::register_stream_consumer::RegisterStreamConsumerError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::register_stream_consumer::RegisterStreamConsumerError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::register_stream_consumer::RegisterStreamConsumerError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::register_stream_consumer::RegisterStreamConsumerError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::register_stream_consumer::RegisterStreamConsumerError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::remove_tags_from_stream::RemoveTagsFromStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::remove_tags_from_stream::RemoveTagsFromStreamError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::remove_tags_from_stream::RemoveTagsFromStreamError> for Error {
    fn from(err: crate::operation::remove_tags_from_stream::RemoveTagsFromStreamError) -> Self {
        match err {
            crate::operation::remove_tags_from_stream::RemoveTagsFromStreamError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::remove_tags_from_stream::RemoveTagsFromStreamError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::remove_tags_from_stream::RemoveTagsFromStreamError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::remove_tags_from_stream::RemoveTagsFromStreamError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::remove_tags_from_stream::RemoveTagsFromStreamError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::remove_tags_from_stream::RemoveTagsFromStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::split_shard::SplitShardError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::split_shard::SplitShardError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::split_shard::SplitShardError> for Error {
    fn from(err: crate::operation::split_shard::SplitShardError) -> Self {
        match err {
            crate::operation::split_shard::SplitShardError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::split_shard::SplitShardError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::split_shard::SplitShardError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::split_shard::SplitShardError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::split_shard::SplitShardError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::split_shard::SplitShardError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::split_shard::SplitShardError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_stream_encryption::StartStreamEncryptionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_stream_encryption::StartStreamEncryptionError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::start_stream_encryption::StartStreamEncryptionError> for Error {
    fn from(err: crate::operation::start_stream_encryption::StartStreamEncryptionError) -> Self {
        match err {
            crate::operation::start_stream_encryption::StartStreamEncryptionError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::start_stream_encryption::StartStreamEncryptionError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::start_stream_encryption::StartStreamEncryptionError::KmsAccessDeniedException(inner) => {
                Error::KmsAccessDeniedException(inner)
            }
            crate::operation::start_stream_encryption::StartStreamEncryptionError::KmsDisabledException(inner) => Error::KmsDisabledException(inner),
            crate::operation::start_stream_encryption::StartStreamEncryptionError::KmsInvalidStateException(inner) => {
                Error::KmsInvalidStateException(inner)
            }
            crate::operation::start_stream_encryption::StartStreamEncryptionError::KmsNotFoundException(inner) => Error::KmsNotFoundException(inner),
            crate::operation::start_stream_encryption::StartStreamEncryptionError::KmsOptInRequired(inner) => Error::KmsOptInRequired(inner),
            crate::operation::start_stream_encryption::StartStreamEncryptionError::KmsThrottlingException(inner) => {
                Error::KmsThrottlingException(inner)
            }
            crate::operation::start_stream_encryption::StartStreamEncryptionError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::start_stream_encryption::StartStreamEncryptionError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::start_stream_encryption::StartStreamEncryptionError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::start_stream_encryption::StartStreamEncryptionError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::stop_stream_encryption::StopStreamEncryptionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::stop_stream_encryption::StopStreamEncryptionError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::stop_stream_encryption::StopStreamEncryptionError> for Error {
    fn from(err: crate::operation::stop_stream_encryption::StopStreamEncryptionError) -> Self {
        match err {
            crate::operation::stop_stream_encryption::StopStreamEncryptionError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::stop_stream_encryption::StopStreamEncryptionError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::stop_stream_encryption::StopStreamEncryptionError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::stop_stream_encryption::StopStreamEncryptionError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::stop_stream_encryption::StopStreamEncryptionError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::stop_stream_encryption::StopStreamEncryptionError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::subscribe_to_shard::SubscribeToShardError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::subscribe_to_shard::SubscribeToShardError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::subscribe_to_shard::SubscribeToShardError> for Error {
    fn from(err: crate::operation::subscribe_to_shard::SubscribeToShardError) -> Self {
        match err {
            crate::operation::subscribe_to_shard::SubscribeToShardError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::subscribe_to_shard::SubscribeToShardError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::subscribe_to_shard::SubscribeToShardError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::subscribe_to_shard::SubscribeToShardError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::subscribe_to_shard::SubscribeToShardError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::subscribe_to_shard::SubscribeToShardError::KmsDisabledException(inner) => Error::KmsDisabledException(inner),
            crate::operation::subscribe_to_shard::SubscribeToShardError::KmsInvalidStateException(inner) => Error::KmsInvalidStateException(inner),
            crate::operation::subscribe_to_shard::SubscribeToShardError::KmsAccessDeniedException(inner) => Error::KmsAccessDeniedException(inner),
            crate::operation::subscribe_to_shard::SubscribeToShardError::KmsNotFoundException(inner) => Error::KmsNotFoundException(inner),
            crate::operation::subscribe_to_shard::SubscribeToShardError::KmsOptInRequired(inner) => Error::KmsOptInRequired(inner),
            crate::operation::subscribe_to_shard::SubscribeToShardError::KmsThrottlingException(inner) => Error::KmsThrottlingException(inner),
            crate::operation::subscribe_to_shard::SubscribeToShardError::InternalFailureException(inner) => Error::InternalFailureException(inner),
            crate::operation::subscribe_to_shard::SubscribeToShardError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::tag_resource::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::tag_resource::TagResourceError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::tag_resource::TagResourceError> for Error {
    fn from(err: crate::operation::tag_resource::TagResourceError) -> Self {
        match err {
            crate::operation::tag_resource::TagResourceError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::tag_resource::TagResourceError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::tag_resource::TagResourceError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::tag_resource::TagResourceError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::tag_resource::TagResourceError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::tag_resource::TagResourceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::untag_resource::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::untag_resource::UntagResourceError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::untag_resource::UntagResourceError> for Error {
    fn from(err: crate::operation::untag_resource::UntagResourceError) -> Self {
        match err {
            crate::operation::untag_resource::UntagResourceError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::untag_resource::UntagResourceError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::untag_resource::UntagResourceError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::untag_resource::UntagResourceError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::untag_resource::UntagResourceError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::untag_resource::UntagResourceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_account_settings::UpdateAccountSettingsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_account_settings::UpdateAccountSettingsError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::update_account_settings::UpdateAccountSettingsError> for Error {
    fn from(err: crate::operation::update_account_settings::UpdateAccountSettingsError) -> Self {
        match err {
            crate::operation::update_account_settings::UpdateAccountSettingsError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::update_account_settings::UpdateAccountSettingsError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::update_account_settings::UpdateAccountSettingsError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::update_account_settings::UpdateAccountSettingsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_max_record_size::UpdateMaxRecordSizeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_max_record_size::UpdateMaxRecordSizeError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::update_max_record_size::UpdateMaxRecordSizeError> for Error {
    fn from(err: crate::operation::update_max_record_size::UpdateMaxRecordSizeError) -> Self {
        match err {
            crate::operation::update_max_record_size::UpdateMaxRecordSizeError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::update_max_record_size::UpdateMaxRecordSizeError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::update_max_record_size::UpdateMaxRecordSizeError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::update_max_record_size::UpdateMaxRecordSizeError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::update_max_record_size::UpdateMaxRecordSizeError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::update_max_record_size::UpdateMaxRecordSizeError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::update_max_record_size::UpdateMaxRecordSizeError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_shard_count::UpdateShardCountError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_shard_count::UpdateShardCountError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::update_shard_count::UpdateShardCountError> for Error {
    fn from(err: crate::operation::update_shard_count::UpdateShardCountError) -> Self {
        match err {
            crate::operation::update_shard_count::UpdateShardCountError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::update_shard_count::UpdateShardCountError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::update_shard_count::UpdateShardCountError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::update_shard_count::UpdateShardCountError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::update_shard_count::UpdateShardCountError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::update_shard_count::UpdateShardCountError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::update_shard_count::UpdateShardCountError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_stream_mode::UpdateStreamModeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_stream_mode::UpdateStreamModeError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::update_stream_mode::UpdateStreamModeError> for Error {
    fn from(err: crate::operation::update_stream_mode::UpdateStreamModeError) -> Self {
        match err {
            crate::operation::update_stream_mode::UpdateStreamModeError::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
            crate::operation::update_stream_mode::UpdateStreamModeError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::update_stream_mode::UpdateStreamModeError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::operation::update_stream_mode::UpdateStreamModeError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::update_stream_mode::UpdateStreamModeError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::update_stream_mode::UpdateStreamModeError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_stream_warm_throughput::UpdateStreamWarmThroughputError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_stream_warm_throughput::UpdateStreamWarmThroughputError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::update_stream_warm_throughput::UpdateStreamWarmThroughputError> for Error {
    fn from(err: crate::operation::update_stream_warm_throughput::UpdateStreamWarmThroughputError) -> Self {
        match err {
            crate::operation::update_stream_warm_throughput::UpdateStreamWarmThroughputError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::update_stream_warm_throughput::UpdateStreamWarmThroughputError::InvalidArgumentException(inner) => {
                Error::InvalidArgumentException(inner)
            }
            crate::operation::update_stream_warm_throughput::UpdateStreamWarmThroughputError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::update_stream_warm_throughput::UpdateStreamWarmThroughputError::ResourceInUseException(inner) => {
                Error::ResourceInUseException(inner)
            }
            crate::operation::update_stream_warm_throughput::UpdateStreamWarmThroughputError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::update_stream_warm_throughput::UpdateStreamWarmThroughputError::ValidationException(inner) => {
                Error::ValidationException(inner)
            }
            crate::operation::update_stream_warm_throughput::UpdateStreamWarmThroughputError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<O, E> ::std::convert::From<::aws_smithy_runtime_api::client::waiters::error::WaiterError<O, E>> for Error
where
    O: ::std::fmt::Debug + ::std::marker::Send + ::std::marker::Sync + 'static,
    E: ::std::error::Error + ::std::marker::Send + ::std::marker::Sync + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::waiters::error::WaiterError<O, E>) -> Self {
        Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
            meta: ::std::default::Default::default(),
            source: err.into(),
        })
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::SubscribeToShardEventStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::SubscribeToShardEventStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::types::error::SubscribeToShardEventStreamError> for Error {
    fn from(err: crate::types::error::SubscribeToShardEventStreamError) -> Self {
        match err {
            crate::types::error::SubscribeToShardEventStreamError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::types::error::SubscribeToShardEventStreamError::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
            crate::types::error::SubscribeToShardEventStreamError::KmsDisabledException(inner) => Error::KmsDisabledException(inner),
            crate::types::error::SubscribeToShardEventStreamError::KmsInvalidStateException(inner) => Error::KmsInvalidStateException(inner),
            crate::types::error::SubscribeToShardEventStreamError::KmsAccessDeniedException(inner) => Error::KmsAccessDeniedException(inner),
            crate::types::error::SubscribeToShardEventStreamError::KmsNotFoundException(inner) => Error::KmsNotFoundException(inner),
            crate::types::error::SubscribeToShardEventStreamError::KmsOptInRequired(inner) => Error::KmsOptInRequired(inner),
            crate::types::error::SubscribeToShardEventStreamError::KmsThrottlingException(inner) => Error::KmsThrottlingException(inner),
            crate::types::error::SubscribeToShardEventStreamError::InternalFailureException(inner) => Error::InternalFailureException(inner),
            crate::types::error::SubscribeToShardEventStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl ::std::error::Error for Error {
    fn source(&self) -> std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Error::AccessDeniedException(inner) => inner.source(),
            Error::ExpiredIteratorException(inner) => inner.source(),
            Error::ExpiredNextTokenException(inner) => inner.source(),
            Error::InternalFailureException(inner) => inner.source(),
            Error::InvalidArgumentException(inner) => inner.source(),
            Error::KmsAccessDeniedException(inner) => inner.source(),
            Error::KmsDisabledException(inner) => inner.source(),
            Error::KmsInvalidStateException(inner) => inner.source(),
            Error::KmsNotFoundException(inner) => inner.source(),
            Error::KmsOptInRequired(inner) => inner.source(),
            Error::KmsThrottlingException(inner) => inner.source(),
            Error::LimitExceededException(inner) => inner.source(),
            Error::ProvisionedThroughputExceededException(inner) => inner.source(),
            Error::ResourceInUseException(inner) => inner.source(),
            Error::ResourceNotFoundException(inner) => inner.source(),
            Error::ValidationException(inner) => inner.source(),
            Error::Unhandled(inner) => ::std::option::Option::Some(&*inner.source),
        }
    }
}
impl ::aws_types::request_id::RequestId for Error {
    fn request_id(&self) -> Option<&str> {
        match self {
            Self::AccessDeniedException(e) => e.request_id(),
            Self::ExpiredIteratorException(e) => e.request_id(),
            Self::ExpiredNextTokenException(e) => e.request_id(),
            Self::InternalFailureException(e) => e.request_id(),
            Self::InvalidArgumentException(e) => e.request_id(),
            Self::KmsAccessDeniedException(e) => e.request_id(),
            Self::KmsDisabledException(e) => e.request_id(),
            Self::KmsInvalidStateException(e) => e.request_id(),
            Self::KmsNotFoundException(e) => e.request_id(),
            Self::KmsOptInRequired(e) => e.request_id(),
            Self::KmsThrottlingException(e) => e.request_id(),
            Self::LimitExceededException(e) => e.request_id(),
            Self::ProvisionedThroughputExceededException(e) => e.request_id(),
            Self::ResourceInUseException(e) => e.request_id(),
            Self::ResourceNotFoundException(e) => e.request_id(),
            Self::ValidationException(e) => e.request_id(),
            Self::Unhandled(e) => e.meta.request_id(),
        }
    }
}
