// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::update_account_settings::_update_account_settings_output::UpdateAccountSettingsOutputBuilder;

pub use crate::operation::update_account_settings::_update_account_settings_input::UpdateAccountSettingsInputBuilder;

impl crate::operation::update_account_settings::builders::UpdateAccountSettingsInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::update_account_settings::UpdateAccountSettingsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_account_settings::UpdateAccountSettingsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.update_account_settings();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `UpdateAccountSettings`.
///
/// <p>Updates the account-level settings for Amazon Kinesis Data Streams.</p>
/// <p>Updating account settings is a synchronous operation. Upon receiving the request, Kinesis Data Streams will return immediately with your account’s updated settings.</p>
/// <p><b>API limits</b></p>
/// <ul>
/// <li>
/// <p>Certain account configurations have minimum commitment windows. Attempting to update your settings prior to the end of the minimum commitment window might have certain restrictions.</p></li>
/// <li>
/// <p>This API has a call limit of 5 transactions per second (TPS) for each Amazon Web Services account. TPS over 5 will initiate the <code>LimitExceededException</code>.</p></li>
/// </ul>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct UpdateAccountSettingsFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::update_account_settings::builders::UpdateAccountSettingsInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::update_account_settings::UpdateAccountSettingsOutput,
        crate::operation::update_account_settings::UpdateAccountSettingsError,
    > for UpdateAccountSettingsFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::update_account_settings::UpdateAccountSettingsOutput,
            crate::operation::update_account_settings::UpdateAccountSettingsError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl UpdateAccountSettingsFluentBuilder {
    /// Creates a new `UpdateAccountSettingsFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the UpdateAccountSettings as a reference.
    pub fn as_input(&self) -> &crate::operation::update_account_settings::builders::UpdateAccountSettingsInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::update_account_settings::UpdateAccountSettingsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_account_settings::UpdateAccountSettingsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::update_account_settings::UpdateAccountSettings::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::update_account_settings::UpdateAccountSettings::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::update_account_settings::UpdateAccountSettingsOutput,
        crate::operation::update_account_settings::UpdateAccountSettingsError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>Specifies the minimum throughput billing commitment configuration for your account.</p>
    pub fn minimum_throughput_billing_commitment(mut self, input: crate::types::MinimumThroughputBillingCommitmentInput) -> Self {
        self.inner = self.inner.minimum_throughput_billing_commitment(input);
        self
    }
    /// <p>Specifies the minimum throughput billing commitment configuration for your account.</p>
    pub fn set_minimum_throughput_billing_commitment(
        mut self,
        input: ::std::option::Option<crate::types::MinimumThroughputBillingCommitmentInput>,
    ) -> Self {
        self.inner = self.inner.set_minimum_throughput_billing_commitment(input);
        self
    }
    /// <p>Specifies the minimum throughput billing commitment configuration for your account.</p>
    pub fn get_minimum_throughput_billing_commitment(&self) -> &::std::option::Option<crate::types::MinimumThroughputBillingCommitmentInput> {
        self.inner.get_minimum_throughput_billing_commitment()
    }
}
