// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct UpdateMaxRecordSizeInput {
    /// <p>The Amazon Resource Name (ARN) of the stream for the <code>MaxRecordSize</code> update.</p>
    pub stream_arn: ::std::option::Option<::std::string::String>,
    /// <p>The maximum record size of a single record in KiB that you can write to, and read from a stream. Specify a value between 1024 and 10240 KiB (1 to 10 MiB). If you specify a value that is out of this range, <code>UpdateMaxRecordSize</code> sends back an <code>ValidationException</code> message.</p>
    pub max_record_size_in_kib: ::std::option::Option<i32>,
}
impl UpdateMaxRecordSizeInput {
    /// <p>The Amazon Resource Name (ARN) of the stream for the <code>MaxRecordSize</code> update.</p>
    pub fn stream_arn(&self) -> ::std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The maximum record size of a single record in KiB that you can write to, and read from a stream. Specify a value between 1024 and 10240 KiB (1 to 10 MiB). If you specify a value that is out of this range, <code>UpdateMaxRecordSize</code> sends back an <code>ValidationException</code> message.</p>
    pub fn max_record_size_in_kib(&self) -> ::std::option::Option<i32> {
        self.max_record_size_in_kib
    }
}
impl UpdateMaxRecordSizeInput {
    /// Creates a new builder-style object to manufacture [`UpdateMaxRecordSizeInput`](crate::operation::update_max_record_size::UpdateMaxRecordSizeInput).
    pub fn builder() -> crate::operation::update_max_record_size::builders::UpdateMaxRecordSizeInputBuilder {
        crate::operation::update_max_record_size::builders::UpdateMaxRecordSizeInputBuilder::default()
    }
}

/// A builder for [`UpdateMaxRecordSizeInput`](crate::operation::update_max_record_size::UpdateMaxRecordSizeInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct UpdateMaxRecordSizeInputBuilder {
    pub(crate) stream_arn: ::std::option::Option<::std::string::String>,
    pub(crate) max_record_size_in_kib: ::std::option::Option<i32>,
}
impl UpdateMaxRecordSizeInputBuilder {
    /// <p>The Amazon Resource Name (ARN) of the stream for the <code>MaxRecordSize</code> update.</p>
    pub fn stream_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream for the <code>MaxRecordSize</code> update.</p>
    pub fn set_stream_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream for the <code>MaxRecordSize</code> update.</p>
    pub fn get_stream_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_arn
    }
    /// <p>The maximum record size of a single record in KiB that you can write to, and read from a stream. Specify a value between 1024 and 10240 KiB (1 to 10 MiB). If you specify a value that is out of this range, <code>UpdateMaxRecordSize</code> sends back an <code>ValidationException</code> message.</p>
    /// This field is required.
    pub fn max_record_size_in_kib(mut self, input: i32) -> Self {
        self.max_record_size_in_kib = ::std::option::Option::Some(input);
        self
    }
    /// <p>The maximum record size of a single record in KiB that you can write to, and read from a stream. Specify a value between 1024 and 10240 KiB (1 to 10 MiB). If you specify a value that is out of this range, <code>UpdateMaxRecordSize</code> sends back an <code>ValidationException</code> message.</p>
    pub fn set_max_record_size_in_kib(mut self, input: ::std::option::Option<i32>) -> Self {
        self.max_record_size_in_kib = input;
        self
    }
    /// <p>The maximum record size of a single record in KiB that you can write to, and read from a stream. Specify a value between 1024 and 10240 KiB (1 to 10 MiB). If you specify a value that is out of this range, <code>UpdateMaxRecordSize</code> sends back an <code>ValidationException</code> message.</p>
    pub fn get_max_record_size_in_kib(&self) -> &::std::option::Option<i32> {
        &self.max_record_size_in_kib
    }
    /// Consumes the builder and constructs a [`UpdateMaxRecordSizeInput`](crate::operation::update_max_record_size::UpdateMaxRecordSizeInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::update_max_record_size::UpdateMaxRecordSizeInput, ::aws_smithy_types::error::operation::BuildError>
    {
        ::std::result::Result::Ok(crate::operation::update_max_record_size::UpdateMaxRecordSizeInput {
            stream_arn: self.stream_arn,
            max_record_size_in_kib: self.max_record_size_in_kib,
        })
    }
}
