// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub(crate) fn de_stream_description<'a, I>(
    tokens: &mut ::std::iter::Peekable<I>,
) -> ::std::result::Result<Option<crate::types::StreamDescription>, ::aws_smithy_json::deserialize::error::DeserializeError>
where
    I: Iterator<Item = Result<::aws_smithy_json::deserialize::Token<'a>, ::aws_smithy_json::deserialize::error::DeserializeError>>,
{
    match tokens.next().transpose()? {
        Some(::aws_smithy_json::deserialize::Token::ValueNull { .. }) => Ok(None),
        Some(::aws_smithy_json::deserialize::Token::StartObject { .. }) => {
            #[allow(unused_mut)]
            let mut builder = crate::types::builders::StreamDescriptionBuilder::default();
            loop {
                match tokens.next().transpose()? {
                    Some(::aws_smithy_json::deserialize::Token::EndObject { .. }) => break,
                    Some(::aws_smithy_json::deserialize::Token::ObjectKey { key, .. }) => match key.to_unescaped()?.as_ref() {
                        "StreamName" => {
                            builder = builder.set_stream_name(
                                ::aws_smithy_json::deserialize::token::expect_string_or_null(tokens.next())?
                                    .map(|s| s.to_unescaped().map(|u| u.into_owned()))
                                    .transpose()?,
                            );
                        }
                        "StreamARN" => {
                            builder = builder.set_stream_arn(
                                ::aws_smithy_json::deserialize::token::expect_string_or_null(tokens.next())?
                                    .map(|s| s.to_unescaped().map(|u| u.into_owned()))
                                    .transpose()?,
                            );
                        }
                        "StreamStatus" => {
                            builder = builder.set_stream_status(
                                ::aws_smithy_json::deserialize::token::expect_string_or_null(tokens.next())?
                                    .map(|s| s.to_unescaped().map(|u| crate::types::StreamStatus::from(u.as_ref())))
                                    .transpose()?,
                            );
                        }
                        "StreamModeDetails" => {
                            builder =
                                builder.set_stream_mode_details(crate::protocol_serde::shape_stream_mode_details::de_stream_mode_details(tokens)?);
                        }
                        "Shards" => {
                            builder = builder.set_shards(crate::protocol_serde::shape_shard_list::de_shard_list(tokens)?);
                        }
                        "HasMoreShards" => {
                            builder = builder.set_has_more_shards(::aws_smithy_json::deserialize::token::expect_bool_or_null(tokens.next())?);
                        }
                        "RetentionPeriodHours" => {
                            builder = builder.set_retention_period_hours(
                                ::aws_smithy_json::deserialize::token::expect_number_or_null(tokens.next())?
                                    .map(i32::try_from)
                                    .transpose()?,
                            );
                        }
                        "StreamCreationTimestamp" => {
                            builder = builder.set_stream_creation_timestamp(::aws_smithy_json::deserialize::token::expect_timestamp_or_null(
                                tokens.next(),
                                ::aws_smithy_types::date_time::Format::EpochSeconds,
                            )?);
                        }
                        "EnhancedMonitoring" => {
                            builder = builder.set_enhanced_monitoring(
                                crate::protocol_serde::shape_enhanced_monitoring_list::de_enhanced_monitoring_list(tokens)?,
                            );
                        }
                        "EncryptionType" => {
                            builder = builder.set_encryption_type(
                                ::aws_smithy_json::deserialize::token::expect_string_or_null(tokens.next())?
                                    .map(|s| s.to_unescaped().map(|u| crate::types::EncryptionType::from(u.as_ref())))
                                    .transpose()?,
                            );
                        }
                        "KeyId" => {
                            builder = builder.set_key_id(
                                ::aws_smithy_json::deserialize::token::expect_string_or_null(tokens.next())?
                                    .map(|s| s.to_unescaped().map(|u| u.into_owned()))
                                    .transpose()?,
                            );
                        }
                        _ => ::aws_smithy_json::deserialize::token::skip_value(tokens)?,
                    },
                    other => {
                        return Err(::aws_smithy_json::deserialize::error::DeserializeError::custom(format!(
                            "expected object key or end object, found: {other:?}"
                        )))
                    }
                }
            }
            Ok(Some(crate::serde_util::stream_description_correct_errors(builder).build().map_err(
                |err| ::aws_smithy_json::deserialize::error::DeserializeError::custom_source("Response was invalid", err),
            )?))
        }
        _ => Err(::aws_smithy_json::deserialize::error::DeserializeError::custom(
            "expected start object or null",
        )),
    }
}
