// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Represents the current status of minimum throughput billing commitment for an account.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MinimumThroughputBillingCommitmentOutput {
    /// <p>The current status of the minimum throughput billing commitment.</p>
    pub status: crate::types::MinimumThroughputBillingCommitmentOutputStatus,
    /// <p>The timestamp when the commitment was started.</p>
    pub started_at: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The timestamp when the commitment was ended.</p>
    pub ended_at: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The earliest timestamp when the commitment can be ended.</p>
    pub earliest_allowed_end_at: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl MinimumThroughputBillingCommitmentOutput {
    /// <p>The current status of the minimum throughput billing commitment.</p>
    pub fn status(&self) -> &crate::types::MinimumThroughputBillingCommitmentOutputStatus {
        &self.status
    }
    /// <p>The timestamp when the commitment was started.</p>
    pub fn started_at(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.started_at.as_ref()
    }
    /// <p>The timestamp when the commitment was ended.</p>
    pub fn ended_at(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.ended_at.as_ref()
    }
    /// <p>The earliest timestamp when the commitment can be ended.</p>
    pub fn earliest_allowed_end_at(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.earliest_allowed_end_at.as_ref()
    }
}
impl MinimumThroughputBillingCommitmentOutput {
    /// Creates a new builder-style object to manufacture [`MinimumThroughputBillingCommitmentOutput`](crate::types::MinimumThroughputBillingCommitmentOutput).
    pub fn builder() -> crate::types::builders::MinimumThroughputBillingCommitmentOutputBuilder {
        crate::types::builders::MinimumThroughputBillingCommitmentOutputBuilder::default()
    }
}

/// A builder for [`MinimumThroughputBillingCommitmentOutput`](crate::types::MinimumThroughputBillingCommitmentOutput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MinimumThroughputBillingCommitmentOutputBuilder {
    pub(crate) status: ::std::option::Option<crate::types::MinimumThroughputBillingCommitmentOutputStatus>,
    pub(crate) started_at: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) ended_at: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) earliest_allowed_end_at: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl MinimumThroughputBillingCommitmentOutputBuilder {
    /// <p>The current status of the minimum throughput billing commitment.</p>
    /// This field is required.
    pub fn status(mut self, input: crate::types::MinimumThroughputBillingCommitmentOutputStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The current status of the minimum throughput billing commitment.</p>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::MinimumThroughputBillingCommitmentOutputStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>The current status of the minimum throughput billing commitment.</p>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::MinimumThroughputBillingCommitmentOutputStatus> {
        &self.status
    }
    /// <p>The timestamp when the commitment was started.</p>
    pub fn started_at(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.started_at = ::std::option::Option::Some(input);
        self
    }
    /// <p>The timestamp when the commitment was started.</p>
    pub fn set_started_at(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.started_at = input;
        self
    }
    /// <p>The timestamp when the commitment was started.</p>
    pub fn get_started_at(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.started_at
    }
    /// <p>The timestamp when the commitment was ended.</p>
    pub fn ended_at(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.ended_at = ::std::option::Option::Some(input);
        self
    }
    /// <p>The timestamp when the commitment was ended.</p>
    pub fn set_ended_at(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.ended_at = input;
        self
    }
    /// <p>The timestamp when the commitment was ended.</p>
    pub fn get_ended_at(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.ended_at
    }
    /// <p>The earliest timestamp when the commitment can be ended.</p>
    pub fn earliest_allowed_end_at(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.earliest_allowed_end_at = ::std::option::Option::Some(input);
        self
    }
    /// <p>The earliest timestamp when the commitment can be ended.</p>
    pub fn set_earliest_allowed_end_at(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.earliest_allowed_end_at = input;
        self
    }
    /// <p>The earliest timestamp when the commitment can be ended.</p>
    pub fn get_earliest_allowed_end_at(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.earliest_allowed_end_at
    }
    /// Consumes the builder and constructs a [`MinimumThroughputBillingCommitmentOutput`](crate::types::MinimumThroughputBillingCommitmentOutput).
    /// This method will fail if any of the following fields are not set:
    /// - [`status`](crate::types::builders::MinimumThroughputBillingCommitmentOutputBuilder::status)
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::types::MinimumThroughputBillingCommitmentOutput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::MinimumThroughputBillingCommitmentOutput {
            status: self.status.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "status",
                    "status was not specified but it is required when building MinimumThroughputBillingCommitmentOutput",
                )
            })?,
            started_at: self.started_at,
            ended_at: self.ended_at,
            earliest_allowed_end_at: self.earliest_allowed_end_at,
        })
    }
}
