//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// Defines a unique identifier for an audio session.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiosessionid?language=objc)
pub type AudioSessionID = u32;

/// Error codes returned from the AVAudioSession API.
///
/// Operation succeeded.
///
/// The app attempted to use the audio session during or after a Media Services failure.  App
/// should wait for a AVAudioSessionMediaServicesWereResetNotification and then rebuild all
/// its state.
///
/// The app attempted to set its audio session inactive or change its AVAudioSessionIOType,
/// but it is still actively playing and/or recording.
///
/// The app tried to perform an operation on a session but its category does not support it.
/// For instance, if the app calls setPreferredInputNumberOfChannels: while in a playback-only
/// category.
///
/// The app's audio session is non-mixable and trying to go active while in the background.
/// This is allowed only when the app is the NowPlaying app.
///
/// The app does not have the required entitlements to perform an operation.
///
/// The app tried to do something with the audio session that is not allowed while Siri is
/// recording.
///
/// The app is not allowed to start recording and/or playing, usually because of a lack of audio
/// key in its Info.plist.  This could also happen if the app has this key but uses a category
/// that can't record and/or play in the background (AVAudioSessionCategoryAmbient,
/// AVAudioSessionCategorySoloAmbient, etc.).
///
/// The app is not allowed to start recording, usually because it is starting a mixable
/// recording from the background and is not an Inter-App Audio app.
///
/// An illegal value was used for a property.
///
/// The app was not allowed to set the audio category because another app (Phone, etc.) is
/// controlling it.
///
/// The operation failed because the device does not have sufficient hardware resources to
/// complete the action. For example, the operation requires audio input hardware, but the
/// device has no audio input available.
///
/// The operation failed because the associated session has been destroyed.
///
/// An unspecified error has occurred.
///
/// The operation failed because the session is not active.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/avaudiosessionerrorcode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AVAudioSessionErrorCode(pub AVAudioInteger);
impl AVAudioSessionErrorCode {
    #[doc(alias = "AVAudioSessionErrorCodeNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "AVAudioSessionErrorCodeMediaServicesFailed")]
    pub const MediaServicesFailed: Self = Self(0x6d737276);
    #[doc(alias = "AVAudioSessionErrorCodeIsBusy")]
    pub const IsBusy: Self = Self(0x21616374);
    #[doc(alias = "AVAudioSessionErrorCodeIncompatibleCategory")]
    pub const IncompatibleCategory: Self = Self(0x21636174);
    #[doc(alias = "AVAudioSessionErrorCodeCannotInterruptOthers")]
    pub const CannotInterruptOthers: Self = Self(0x21696e74);
    #[doc(alias = "AVAudioSessionErrorCodeMissingEntitlement")]
    pub const MissingEntitlement: Self = Self(0x656e743f);
    #[doc(alias = "AVAudioSessionErrorCodeSiriIsRecording")]
    pub const SiriIsRecording: Self = Self(0x73697269);
    #[doc(alias = "AVAudioSessionErrorCodeCannotStartPlaying")]
    pub const CannotStartPlaying: Self = Self(0x21706c61);
    #[doc(alias = "AVAudioSessionErrorCodeCannotStartRecording")]
    pub const CannotStartRecording: Self = Self(0x21726563);
    #[doc(alias = "AVAudioSessionErrorCodeBadParam")]
    pub const BadParam: Self = Self(-50);
    #[doc(alias = "AVAudioSessionErrorCodeInsufficientPriority")]
    pub const InsufficientPriority: Self = Self(0x21707269);
    #[doc(alias = "AVAudioSessionErrorCodeResourceNotAvailable")]
    pub const ResourceNotAvailable: Self = Self(0x21726573);
    #[doc(alias = "AVAudioSessionErrorCodeUnspecified")]
    pub const Unspecified: Self = Self(0x77686174);
    #[doc(alias = "AVAudioSessionErrorCodeExpiredSession")]
    pub const ExpiredSession: Self = Self(0x21736573);
    #[doc(alias = "AVAudioSessionErrorCodeSessionNotActive")]
    pub const SessionNotActive: Self = Self(0x696e6163);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AVAudioSessionErrorCode {
    const ENCODING: Encoding = AVAudioInteger::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AVAudioSessionErrorCode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/avaudiosessionerrorinsufficientpriority?language=objc)
#[deprecated]
pub const AVAudioSessionErrorInsufficientPriority: AVAudioInteger =
    AVAudioSessionErrorCode::InsufficientPriority.0;
