# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Build and Test Commands

- **Build the library**: `cargo build`
- **Run tests**: `cargo test`
  - Note: The test `test_privdrop` requires root privileges to run properly as it needs to change root directory and user. Otherwise, it will be skipped.
  - Run a specific test: `cargo test test_privdrop`
- **Build documentation**: `cargo doc`
- **Build for release**: `cargo build --release`

## Architecture Overview

This crate provides a simple API for dropping privileges in Unix systems. It follows a builder pattern to configure and execute privilege dropping operations.

### Core Components

1. **PrivDrop (src/privdrop.rs)**: 
   - Main struct for handling privilege dropping operations
   - Provides methods for configuring chroot directory, user/group settings
   - Uses a builder pattern for configuration
   - Final `apply()` method performs all privilege dropping operations atomically

2. **Error Handling (src/errors.rs)**:
   - Custom error types specific to privilege dropping operations
   - Wraps system errors from nix and libc

### Key Operations

The library allows:
- Changing the root directory (chroot)
- Switching to a non-root user
- Setting group memberships
- Managing supplementary groups

### Dependencies

- **libc**: Low-level bindings to the C standard library
- **nix**: Rust friendly bindings to *nix APIs with the "user" and "fs" features enabled

### Usage Considerations

- All operations require root privileges to execute successfully
- The privilege dropping is atomic - it happens all at once during the `apply()` call
- The library preloads necessary system resources before dropping privileges to prevent potential deadlocks