#nullable enable
using System;
using System.Collections;
using System.Text;
using Microsoft.Boogie;
using VCGeneration;

namespace Microsoft.Dafny;

[method: SyntaxConstructor]
[SyntaxBaseType(typeof(IOrigin))]
public class SourceOrigin(TokenRange entireRange, TokenRange? reportingRange = null)
  : IOrigin, IComparable<SourceOrigin> {
  public Uri Uri => ReportingRange.StartToken.Uri;

  public TokenRange EntireRange { get; } = entireRange;
  public Token StartToken => EntireRange.StartToken;
  public Token EndToken => EntireRange.EndToken;
  public TokenRange ReportingRange { get; } = reportingRange ?? entireRange;
  public bool IncludesRange => true;

  public SourceOrigin(Token start, Token end) : this(new TokenRange(start, end)) {
  }

  public SourceOrigin(Token start, Token end, TokenRange? reportingRange) : this(
    new TokenRange(start, end), reportingRange) {
  }

  public SourceOrigin(Token start, Token end, Token? center) : this(
    new TokenRange(start, end),
    center == null ? null : new TokenRange(center, center)) {
  }

  public int CompareTo(IToken? other) {
    if (other is IOrigin otherOrigin) {
      return EntireRange.CompareTo(otherOrigin.EntireRange);
    }

    return 1;
  }

  public override bool Equals(object? obj) {
    // TODO remove equality members 
    if (obj is SourceOrigin other) {
      return ReportingRange.StartToken.Equals(other.ReportingRange.StartToken) && ReportingRange.EndToken.Equals(other.ReportingRange.EndToken);
    }
    return false;
  }

  public override int GetHashCode() {
    return HashCode.Combine(ReportingRange.StartToken.GetHashCode(), ReportingRange.EndToken.GetHashCode());
  }

  public bool IsInherited(ModuleDefinition m) {
    return false;
  }

  // TODO rename to Generated, and Token.NoToken to Token.Generated, and remove AutoGeneratedToken.
  public static IOrigin NoToken => Token.NoToken;

  public IOrigin WithVal(string newVal) {
    throw new NotImplementedException();
  }

  public bool IsCopy => false;

  public bool IsSourceToken => !ReferenceEquals(this, NoToken);
  public int kind {
    get => ReportingRange.StartToken.kind;
    set => throw new NotImplementedException();
  }

  public int pos {
    get => ReportingRange.StartToken.pos;
    set => throw new NotImplementedException();
  }

  public int col {
    get => ReportingRange.StartToken.col;
    set => throw new NotImplementedException();
  }

  public int line {
    get => ReportingRange.StartToken.line;
    set => throw new NotImplementedException();
  }

  public string val {
    get => ReportingRange.StartToken.val;
    set => throw new InvalidOperationException();
  }

  public bool IsValid => true;

  public int CompareTo(SourceOrigin? other) {
    throw new NotImplementedException();
  }
}