// Copyright (c) 2024 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_REDUCE_BY_KEY_HPP_
#define ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_REDUCE_BY_KEY_HPP_

#include "../../../type_traits.hpp"
#include "../device_config_helper.hpp"

#include <type_traits>

/* DO NOT EDIT THIS FILE
 * This file is automatically generated by `/scripts/autotune/create_optimization.py`.
 * so most likely you want to edit rocprim/device/device_(algo)_config.hpp
 */

/// \addtogroup primitivesmodule_deviceconfigs
/// @{

BEGIN_ROCPRIM_NAMESPACE

namespace detail
{

template<unsigned int arch, class key_type, class value_type, class enable = void>
struct default_reduce_by_key_config : default_reduce_by_key_config_base<key_type, value_type>::type
{};

// Based on key_type = int64_t, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<512,
                           8,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<512,
                           8,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<512,
                           8,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           2>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<512,
                           8,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<512,
                           8,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<384,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<512,
                           8,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<512,
                           8,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<384,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<512,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<384,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<384,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<384,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<384,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<384,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<384,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<384,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<384,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<384,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<384,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<384,
                           13,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<384,
                           12,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<512,
                           12,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<512,
                           8,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           2>
{};

// Based on key_type = int64_t, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<512,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           2>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<512,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           2>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<512,
                           8,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           2>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<512,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           2>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<384,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           2>
{};

// Based on key_type = int, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<512,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<512,
                           12,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           2>
{};

// Based on key_type = int, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<512,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<512,
                           12,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           2>
{};

// Based on key_type = int, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<512,
                           12,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           2>
{};

// Based on key_type = int, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<512,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<512,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<384,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<512,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<384,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<512,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           2>
{};

// Based on key_type = short, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<512,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<384,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<512,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<384,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           2>
{};

// Based on key_type = int8_t, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<384,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<384,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<384,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           2>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<384,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<384,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<384,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<128,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<128,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<512,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<512,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           14,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<512,
                           10,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = double
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = float
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = rocprim::half
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : reduce_by_key_config<256,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, class value_type>
struct default_reduce_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<((sizeof(key_type) <= 1)
                      && !bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1))>>
    : reduce_by_key_config<192,
                           15,
                           block_load_method::block_load_transpose,
                           block_load_method::block_load_transpose,
                           block_scan_algorithm::using_warp_scan,
                           1>
{};

} // end namespace detail

END_ROCPRIM_NAMESPACE

/// @}
// end of group primitivesmodule_deviceconfigs

#endif // ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_REDUCE_BY_KEY_HPP_
