#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 3347
#define LARGE_STATE_COUNT 302
#define SYMBOL_COUNT 279
#define ALIAS_COUNT 4
#define TOKEN_COUNT 116
#define EXTERNAL_TOKEN_COUNT 12
#define FIELD_COUNT 32
#define MAX_ALIAS_SEQUENCE_LENGTH 16
#define PRODUCTION_ID_COUNT 197

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_SEMI = 2,
  anon_sym_import = 3,
  anon_sym_DOT = 4,
  anon_sym_from = 5,
  anon_sym___future__ = 6,
  anon_sym_LPAREN = 7,
  anon_sym_RPAREN = 8,
  anon_sym_COMMA = 9,
  anon_sym_as = 10,
  anon_sym_STAR = 11,
  anon_sym_print = 12,
  anon_sym_GT_GT = 13,
  anon_sym_assert = 14,
  anon_sym_COLON_EQ = 15,
  anon_sym_return = 16,
  anon_sym_del = 17,
  anon_sym_raise = 18,
  anon_sym_pass = 19,
  anon_sym_break = 20,
  anon_sym_continue = 21,
  anon_sym_if = 22,
  anon_sym_COLON = 23,
  anon_sym_elif = 24,
  anon_sym_else = 25,
  anon_sym_match = 26,
  anon_sym_case = 27,
  anon_sym_async = 28,
  anon_sym_for = 29,
  anon_sym_in = 30,
  anon_sym_while = 31,
  anon_sym_try = 32,
  anon_sym_except = 33,
  anon_sym_except_STAR = 34,
  anon_sym_finally = 35,
  anon_sym_with = 36,
  anon_sym_def = 37,
  anon_sym_fn = 38,
  anon_sym_LBRACK = 39,
  anon_sym_RBRACK = 40,
  anon_sym_raises = 41,
  anon_sym_DASH_GT = 42,
  anon_sym_STAR_STAR = 43,
  anon_sym_global = 44,
  anon_sym_nonlocal = 45,
  anon_sym_exec = 46,
  anon_sym_type = 47,
  anon_sym_EQ = 48,
  anon_sym_class = 49,
  anon_sym_struct = 50,
  anon_sym_AT = 51,
  anon_sym_DASH = 52,
  anon_sym__ = 53,
  anon_sym_PIPE = 54,
  anon_sym_LBRACE = 55,
  anon_sym_RBRACE = 56,
  anon_sym_PLUS = 57,
  anon_sym_not = 58,
  anon_sym_and = 59,
  anon_sym_or = 60,
  anon_sym_SLASH = 61,
  anon_sym_PERCENT = 62,
  anon_sym_SLASH_SLASH = 63,
  anon_sym_AMP = 64,
  anon_sym_CARET = 65,
  anon_sym_LT_LT = 66,
  anon_sym_TILDE = 67,
  anon_sym_LT = 68,
  anon_sym_LT_EQ = 69,
  anon_sym_EQ_EQ = 70,
  anon_sym_BANG_EQ = 71,
  anon_sym_GT_EQ = 72,
  anon_sym_GT = 73,
  anon_sym_LT_GT = 74,
  anon_sym_is = 75,
  anon_sym_lambda = 76,
  anon_sym_var = 77,
  anon_sym_alias = 78,
  anon_sym_PLUS_EQ = 79,
  anon_sym_DASH_EQ = 80,
  anon_sym_STAR_EQ = 81,
  anon_sym_SLASH_EQ = 82,
  anon_sym_AT_EQ = 83,
  anon_sym_SLASH_SLASH_EQ = 84,
  anon_sym_PERCENT_EQ = 85,
  anon_sym_STAR_STAR_EQ = 86,
  anon_sym_GT_GT_EQ = 87,
  anon_sym_LT_LT_EQ = 88,
  anon_sym_AMP_EQ = 89,
  anon_sym_CARET_EQ = 90,
  anon_sym_PIPE_EQ = 91,
  anon_sym_yield = 92,
  sym_ellipsis = 93,
  anon_sym_inout = 94,
  anon_sym_owned = 95,
  anon_sym_borrowed = 96,
  sym_escape_sequence = 97,
  sym__not_escape_sequence = 98,
  aux_sym_format_specifier_token1 = 99,
  sym_type_conversion = 100,
  sym_integer = 101,
  sym_float = 102,
  anon_sym_await = 103,
  sym_true = 104,
  sym_false = 105,
  sym_none = 106,
  sym_comment = 107,
  sym_line_continuation = 108,
  sym__newline = 109,
  sym__indent = 110,
  sym__dedent = 111,
  sym_string_start = 112,
  sym__string_content = 113,
  sym_escape_interpolation = 114,
  sym_string_end = 115,
  sym_module = 116,
  sym__statement = 117,
  sym__simple_statements = 118,
  sym_import_statement = 119,
  sym_import_prefix = 120,
  sym_relative_import = 121,
  sym_future_import_statement = 122,
  sym_import_from_statement = 123,
  sym__import_list = 124,
  sym_aliased_import = 125,
  sym_wildcard_import = 126,
  sym_print_statement = 127,
  sym_chevron = 128,
  sym_assert_statement = 129,
  sym_expression_statement = 130,
  sym_named_expression = 131,
  sym__named_expression_lhs = 132,
  sym_return_statement = 133,
  sym_delete_statement = 134,
  sym_raise_statement = 135,
  sym_pass_statement = 136,
  sym_break_statement = 137,
  sym_continue_statement = 138,
  sym_if_statement = 139,
  sym_elif_clause = 140,
  sym_else_clause = 141,
  sym_match_statement = 142,
  sym__match_block = 143,
  sym_case_clause = 144,
  sym_for_statement = 145,
  sym_while_statement = 146,
  sym_try_statement = 147,
  sym_except_clause = 148,
  sym_except_group_clause = 149,
  sym_finally_clause = 150,
  sym_with_statement = 151,
  sym_with_clause = 152,
  sym_with_item = 153,
  sym_function_definition = 154,
  sym_parameters = 155,
  sym_lambda_parameters = 156,
  sym_list_splat = 157,
  sym_dictionary_splat = 158,
  sym_global_statement = 159,
  sym_nonlocal_statement = 160,
  sym_exec_statement = 161,
  sym_type_alias_statement = 162,
  sym_class_definition = 163,
  sym_type_parameter = 164,
  sym_parenthesized_list_splat = 165,
  sym_argument_list = 166,
  sym_parameter_list = 167,
  sym_decorated_definition = 168,
  sym_decorator = 169,
  sym_block = 170,
  sym_expression_list = 171,
  sym_dotted_name = 172,
  sym_case_pattern = 173,
  sym__simple_pattern = 174,
  sym__as_pattern = 175,
  sym_union_pattern = 176,
  sym__list_pattern = 177,
  sym__tuple_pattern = 178,
  sym_dict_pattern = 179,
  sym__key_value_pattern = 180,
  sym_keyword_pattern = 181,
  sym_splat_pattern = 182,
  sym_class_pattern = 183,
  sym_complex_pattern = 184,
  sym__parameters = 185,
  sym__patterns = 186,
  sym_parameter = 187,
  sym_pattern = 188,
  sym_tuple_pattern = 189,
  sym_list_pattern = 190,
  sym_default_parameter = 191,
  sym_typed_default_parameter = 192,
  sym_list_splat_pattern = 193,
  sym_dictionary_splat_pattern = 194,
  sym_as_pattern = 195,
  sym__expression_within_for_in_clause = 196,
  sym_expression = 197,
  sym_primary_expression = 198,
  sym_not_operator = 199,
  sym_boolean_operator = 200,
  sym_binary_operator = 201,
  sym_unary_operator = 202,
  sym_comparison_operator = 203,
  sym_lambda = 204,
  sym_lambda_within_for_in_clause = 205,
  sym_assignment = 206,
  sym_augmented_assignment = 207,
  sym_pattern_list = 208,
  sym__right_hand_side = 209,
  sym_yield = 210,
  sym_attribute = 211,
  sym_subscript = 212,
  sym_slice = 213,
  sym_call = 214,
  sym_typed_parameter = 215,
  sym_type = 216,
  sym_splat_type = 217,
  sym_generic_type = 218,
  sym_union_type = 219,
  sym_constrained_type = 220,
  sym_member_type = 221,
  sym_keyword_argument = 222,
  sym_list = 223,
  sym_set = 224,
  sym_tuple = 225,
  sym_dictionary = 226,
  sym_pair = 227,
  sym_list_comprehension = 228,
  sym_dictionary_comprehension = 229,
  sym_set_comprehension = 230,
  sym_generator_expression = 231,
  sym__comprehension_clauses = 232,
  sym_parenthesized_expression = 233,
  sym__collection_elements = 234,
  sym_for_in_clause = 235,
  sym_if_clause = 236,
  sym_conditional_expression = 237,
  sym_concatenated_string = 238,
  sym_string = 239,
  sym_string_content = 240,
  sym_interpolation = 241,
  sym__f_expression = 242,
  sym_format_specifier = 243,
  sym_await = 244,
  sym_positional_separator = 245,
  sym_keyword_separator = 246,
  aux_sym_module_repeat1 = 247,
  aux_sym__simple_statements_repeat1 = 248,
  aux_sym_import_prefix_repeat1 = 249,
  aux_sym__import_list_repeat1 = 250,
  aux_sym_print_statement_repeat1 = 251,
  aux_sym_assert_statement_repeat1 = 252,
  aux_sym_if_statement_repeat1 = 253,
  aux_sym_match_statement_repeat1 = 254,
  aux_sym__match_block_repeat1 = 255,
  aux_sym_case_clause_repeat1 = 256,
  aux_sym_try_statement_repeat1 = 257,
  aux_sym_try_statement_repeat2 = 258,
  aux_sym_with_clause_repeat1 = 259,
  aux_sym_global_statement_repeat1 = 260,
  aux_sym_type_parameter_repeat1 = 261,
  aux_sym_argument_list_repeat1 = 262,
  aux_sym_decorated_definition_repeat1 = 263,
  aux_sym_dotted_name_repeat1 = 264,
  aux_sym_union_pattern_repeat1 = 265,
  aux_sym_dict_pattern_repeat1 = 266,
  aux_sym__parameters_repeat1 = 267,
  aux_sym__patterns_repeat1 = 268,
  aux_sym_comparison_operator_repeat1 = 269,
  aux_sym_subscript_repeat1 = 270,
  aux_sym_dictionary_repeat1 = 271,
  aux_sym__comprehension_clauses_repeat1 = 272,
  aux_sym__collection_elements_repeat1 = 273,
  aux_sym_for_in_clause_repeat1 = 274,
  aux_sym_concatenated_string_repeat1 = 275,
  aux_sym_string_repeat1 = 276,
  aux_sym_string_content_repeat1 = 277,
  aux_sym_format_specifier_repeat1 = 278,
  alias_sym_as_pattern_target = 279,
  alias_sym_format_expression = 280,
  anon_alias_sym_isnot = 281,
  anon_alias_sym_notin = 282,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_SEMI] = ";",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_from] = "from",
  [anon_sym___future__] = "__future__",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [anon_sym_as] = "as",
  [anon_sym_STAR] = "*",
  [anon_sym_print] = "print",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_assert] = "assert",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_return] = "return",
  [anon_sym_del] = "del",
  [anon_sym_raise] = "raise",
  [anon_sym_pass] = "pass",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_if] = "if",
  [anon_sym_COLON] = ":",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_match] = "match",
  [anon_sym_case] = "case",
  [anon_sym_async] = "async",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_try] = "try",
  [anon_sym_except] = "except",
  [anon_sym_except_STAR] = "except*",
  [anon_sym_finally] = "finally",
  [anon_sym_with] = "with",
  [anon_sym_def] = "def",
  [anon_sym_fn] = "fn",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_raises] = "raises",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_global] = "global",
  [anon_sym_nonlocal] = "nonlocal",
  [anon_sym_exec] = "exec",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_class] = "class",
  [anon_sym_struct] = "struct",
  [anon_sym_AT] = "@",
  [anon_sym_DASH] = "-",
  [anon_sym__] = "_",
  [anon_sym_PIPE] = "|",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_PLUS] = "+",
  [anon_sym_not] = "not",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_TILDE] = "~",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_is] = "is",
  [anon_sym_lambda] = "lambda",
  [anon_sym_var] = "var",
  [anon_sym_alias] = "alias",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AT_EQ] = "@=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_yield] = "yield",
  [sym_ellipsis] = "ellipsis",
  [anon_sym_inout] = "inout",
  [anon_sym_owned] = "owned",
  [anon_sym_borrowed] = "borrowed",
  [sym_escape_sequence] = "escape_sequence",
  [sym__not_escape_sequence] = "_not_escape_sequence",
  [aux_sym_format_specifier_token1] = "format_specifier_token1",
  [sym_type_conversion] = "type_conversion",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_await] = "await",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_none] = "none",
  [sym_comment] = "comment",
  [sym_line_continuation] = "line_continuation",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym_string_start] = "string_start",
  [sym__string_content] = "_string_content",
  [sym_escape_interpolation] = "escape_interpolation",
  [sym_string_end] = "string_end",
  [sym_module] = "module",
  [sym__statement] = "_statement",
  [sym__simple_statements] = "_simple_statements",
  [sym_import_statement] = "import_statement",
  [sym_import_prefix] = "import_prefix",
  [sym_relative_import] = "relative_import",
  [sym_future_import_statement] = "future_import_statement",
  [sym_import_from_statement] = "import_from_statement",
  [sym__import_list] = "_import_list",
  [sym_aliased_import] = "aliased_import",
  [sym_wildcard_import] = "wildcard_import",
  [sym_print_statement] = "print_statement",
  [sym_chevron] = "chevron",
  [sym_assert_statement] = "assert_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_named_expression] = "named_expression",
  [sym__named_expression_lhs] = "_named_expression_lhs",
  [sym_return_statement] = "return_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_raise_statement] = "raise_statement",
  [sym_pass_statement] = "pass_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_match_statement] = "match_statement",
  [sym__match_block] = "block",
  [sym_case_clause] = "case_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_try_statement] = "try_statement",
  [sym_except_clause] = "except_clause",
  [sym_except_group_clause] = "except_group_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_with_statement] = "with_statement",
  [sym_with_clause] = "with_clause",
  [sym_with_item] = "with_item",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_lambda_parameters] = "lambda_parameters",
  [sym_list_splat] = "list_splat",
  [sym_dictionary_splat] = "dictionary_splat",
  [sym_global_statement] = "global_statement",
  [sym_nonlocal_statement] = "nonlocal_statement",
  [sym_exec_statement] = "exec_statement",
  [sym_type_alias_statement] = "type_alias_statement",
  [sym_class_definition] = "class_definition",
  [sym_type_parameter] = "type_parameter",
  [sym_parenthesized_list_splat] = "parenthesized_list_splat",
  [sym_argument_list] = "argument_list",
  [sym_parameter_list] = "parameter_list",
  [sym_decorated_definition] = "decorated_definition",
  [sym_decorator] = "decorator",
  [sym_block] = "block",
  [sym_expression_list] = "expression_list",
  [sym_dotted_name] = "dotted_name",
  [sym_case_pattern] = "case_pattern",
  [sym__simple_pattern] = "_simple_pattern",
  [sym__as_pattern] = "as_pattern",
  [sym_union_pattern] = "union_pattern",
  [sym__list_pattern] = "list_pattern",
  [sym__tuple_pattern] = "tuple_pattern",
  [sym_dict_pattern] = "dict_pattern",
  [sym__key_value_pattern] = "_key_value_pattern",
  [sym_keyword_pattern] = "keyword_pattern",
  [sym_splat_pattern] = "splat_pattern",
  [sym_class_pattern] = "class_pattern",
  [sym_complex_pattern] = "complex_pattern",
  [sym__parameters] = "_parameters",
  [sym__patterns] = "_patterns",
  [sym_parameter] = "parameter",
  [sym_pattern] = "pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_default_parameter] = "default_parameter",
  [sym_typed_default_parameter] = "typed_default_parameter",
  [sym_list_splat_pattern] = "list_splat_pattern",
  [sym_dictionary_splat_pattern] = "dictionary_splat_pattern",
  [sym_as_pattern] = "as_pattern",
  [sym__expression_within_for_in_clause] = "_expression_within_for_in_clause",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_not_operator] = "not_operator",
  [sym_boolean_operator] = "boolean_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_lambda] = "lambda",
  [sym_lambda_within_for_in_clause] = "lambda",
  [sym_assignment] = "assignment",
  [sym_augmented_assignment] = "augmented_assignment",
  [sym_pattern_list] = "pattern_list",
  [sym__right_hand_side] = "_right_hand_side",
  [sym_yield] = "yield",
  [sym_attribute] = "attribute",
  [sym_subscript] = "subscript",
  [sym_slice] = "slice",
  [sym_call] = "call",
  [sym_typed_parameter] = "typed_parameter",
  [sym_type] = "type",
  [sym_splat_type] = "splat_type",
  [sym_generic_type] = "generic_type",
  [sym_union_type] = "union_type",
  [sym_constrained_type] = "constrained_type",
  [sym_member_type] = "member_type",
  [sym_keyword_argument] = "keyword_argument",
  [sym_list] = "list",
  [sym_set] = "set",
  [sym_tuple] = "tuple",
  [sym_dictionary] = "dictionary",
  [sym_pair] = "pair",
  [sym_list_comprehension] = "list_comprehension",
  [sym_dictionary_comprehension] = "dictionary_comprehension",
  [sym_set_comprehension] = "set_comprehension",
  [sym_generator_expression] = "generator_expression",
  [sym__comprehension_clauses] = "_comprehension_clauses",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__collection_elements] = "_collection_elements",
  [sym_for_in_clause] = "for_in_clause",
  [sym_if_clause] = "if_clause",
  [sym_conditional_expression] = "conditional_expression",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string] = "string",
  [sym_string_content] = "string_content",
  [sym_interpolation] = "interpolation",
  [sym__f_expression] = "_f_expression",
  [sym_format_specifier] = "format_specifier",
  [sym_await] = "await",
  [sym_positional_separator] = "positional_separator",
  [sym_keyword_separator] = "keyword_separator",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym__simple_statements_repeat1] = "_simple_statements_repeat1",
  [aux_sym_import_prefix_repeat1] = "import_prefix_repeat1",
  [aux_sym__import_list_repeat1] = "_import_list_repeat1",
  [aux_sym_print_statement_repeat1] = "print_statement_repeat1",
  [aux_sym_assert_statement_repeat1] = "assert_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_match_statement_repeat1] = "match_statement_repeat1",
  [aux_sym__match_block_repeat1] = "_match_block_repeat1",
  [aux_sym_case_clause_repeat1] = "case_clause_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_try_statement_repeat2] = "try_statement_repeat2",
  [aux_sym_with_clause_repeat1] = "with_clause_repeat1",
  [aux_sym_global_statement_repeat1] = "global_statement_repeat1",
  [aux_sym_type_parameter_repeat1] = "type_parameter_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_decorated_definition_repeat1] = "decorated_definition_repeat1",
  [aux_sym_dotted_name_repeat1] = "dotted_name_repeat1",
  [aux_sym_union_pattern_repeat1] = "union_pattern_repeat1",
  [aux_sym_dict_pattern_repeat1] = "dict_pattern_repeat1",
  [aux_sym__parameters_repeat1] = "_parameters_repeat1",
  [aux_sym__patterns_repeat1] = "_patterns_repeat1",
  [aux_sym_comparison_operator_repeat1] = "comparison_operator_repeat1",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
  [aux_sym_dictionary_repeat1] = "dictionary_repeat1",
  [aux_sym__comprehension_clauses_repeat1] = "_comprehension_clauses_repeat1",
  [aux_sym__collection_elements_repeat1] = "_collection_elements_repeat1",
  [aux_sym_for_in_clause_repeat1] = "for_in_clause_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_content_repeat1] = "string_content_repeat1",
  [aux_sym_format_specifier_repeat1] = "format_specifier_repeat1",
  [alias_sym_as_pattern_target] = "as_pattern_target",
  [alias_sym_format_expression] = "format_expression",
  [anon_alias_sym_isnot] = "is not",
  [anon_alias_sym_notin] = "not in",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_from] = anon_sym_from,
  [anon_sym___future__] = anon_sym___future__,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_del] = anon_sym_del,
  [anon_sym_raise] = anon_sym_raise,
  [anon_sym_pass] = anon_sym_pass,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_except] = anon_sym_except,
  [anon_sym_except_STAR] = anon_sym_except_STAR,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_raises] = anon_sym_raises,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_nonlocal] = anon_sym_nonlocal,
  [anon_sym_exec] = anon_sym_exec,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym__] = anon_sym__,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_lambda] = anon_sym_lambda,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_alias] = anon_sym_alias,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AT_EQ] = anon_sym_AT_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_yield] = anon_sym_yield,
  [sym_ellipsis] = sym_ellipsis,
  [anon_sym_inout] = anon_sym_inout,
  [anon_sym_owned] = anon_sym_owned,
  [anon_sym_borrowed] = anon_sym_borrowed,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__not_escape_sequence] = sym__not_escape_sequence,
  [aux_sym_format_specifier_token1] = aux_sym_format_specifier_token1,
  [sym_type_conversion] = sym_type_conversion,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_await] = anon_sym_await,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_none] = sym_none,
  [sym_comment] = sym_comment,
  [sym_line_continuation] = sym_line_continuation,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym_string_start] = sym_string_start,
  [sym__string_content] = sym__string_content,
  [sym_escape_interpolation] = sym_escape_interpolation,
  [sym_string_end] = sym_string_end,
  [sym_module] = sym_module,
  [sym__statement] = sym__statement,
  [sym__simple_statements] = sym__simple_statements,
  [sym_import_statement] = sym_import_statement,
  [sym_import_prefix] = sym_import_prefix,
  [sym_relative_import] = sym_relative_import,
  [sym_future_import_statement] = sym_future_import_statement,
  [sym_import_from_statement] = sym_import_from_statement,
  [sym__import_list] = sym__import_list,
  [sym_aliased_import] = sym_aliased_import,
  [sym_wildcard_import] = sym_wildcard_import,
  [sym_print_statement] = sym_print_statement,
  [sym_chevron] = sym_chevron,
  [sym_assert_statement] = sym_assert_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_named_expression] = sym_named_expression,
  [sym__named_expression_lhs] = sym__named_expression_lhs,
  [sym_return_statement] = sym_return_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_raise_statement] = sym_raise_statement,
  [sym_pass_statement] = sym_pass_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_match_statement] = sym_match_statement,
  [sym__match_block] = sym_block,
  [sym_case_clause] = sym_case_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_except_clause] = sym_except_clause,
  [sym_except_group_clause] = sym_except_group_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_with_statement] = sym_with_statement,
  [sym_with_clause] = sym_with_clause,
  [sym_with_item] = sym_with_item,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_lambda_parameters] = sym_lambda_parameters,
  [sym_list_splat] = sym_list_splat,
  [sym_dictionary_splat] = sym_dictionary_splat,
  [sym_global_statement] = sym_global_statement,
  [sym_nonlocal_statement] = sym_nonlocal_statement,
  [sym_exec_statement] = sym_exec_statement,
  [sym_type_alias_statement] = sym_type_alias_statement,
  [sym_class_definition] = sym_class_definition,
  [sym_type_parameter] = sym_type_parameter,
  [sym_parenthesized_list_splat] = sym_parenthesized_list_splat,
  [sym_argument_list] = sym_argument_list,
  [sym_parameter_list] = sym_parameter_list,
  [sym_decorated_definition] = sym_decorated_definition,
  [sym_decorator] = sym_decorator,
  [sym_block] = sym_block,
  [sym_expression_list] = sym_expression_list,
  [sym_dotted_name] = sym_dotted_name,
  [sym_case_pattern] = sym_case_pattern,
  [sym__simple_pattern] = sym__simple_pattern,
  [sym__as_pattern] = sym_as_pattern,
  [sym_union_pattern] = sym_union_pattern,
  [sym__list_pattern] = sym_list_pattern,
  [sym__tuple_pattern] = sym_tuple_pattern,
  [sym_dict_pattern] = sym_dict_pattern,
  [sym__key_value_pattern] = sym__key_value_pattern,
  [sym_keyword_pattern] = sym_keyword_pattern,
  [sym_splat_pattern] = sym_splat_pattern,
  [sym_class_pattern] = sym_class_pattern,
  [sym_complex_pattern] = sym_complex_pattern,
  [sym__parameters] = sym__parameters,
  [sym__patterns] = sym__patterns,
  [sym_parameter] = sym_parameter,
  [sym_pattern] = sym_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_default_parameter] = sym_default_parameter,
  [sym_typed_default_parameter] = sym_typed_default_parameter,
  [sym_list_splat_pattern] = sym_list_splat_pattern,
  [sym_dictionary_splat_pattern] = sym_dictionary_splat_pattern,
  [sym_as_pattern] = sym_as_pattern,
  [sym__expression_within_for_in_clause] = sym__expression_within_for_in_clause,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_not_operator] = sym_not_operator,
  [sym_boolean_operator] = sym_boolean_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_lambda] = sym_lambda,
  [sym_lambda_within_for_in_clause] = sym_lambda,
  [sym_assignment] = sym_assignment,
  [sym_augmented_assignment] = sym_augmented_assignment,
  [sym_pattern_list] = sym_pattern_list,
  [sym__right_hand_side] = sym__right_hand_side,
  [sym_yield] = sym_yield,
  [sym_attribute] = sym_attribute,
  [sym_subscript] = sym_subscript,
  [sym_slice] = sym_slice,
  [sym_call] = sym_call,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_type] = sym_type,
  [sym_splat_type] = sym_splat_type,
  [sym_generic_type] = sym_generic_type,
  [sym_union_type] = sym_union_type,
  [sym_constrained_type] = sym_constrained_type,
  [sym_member_type] = sym_member_type,
  [sym_keyword_argument] = sym_keyword_argument,
  [sym_list] = sym_list,
  [sym_set] = sym_set,
  [sym_tuple] = sym_tuple,
  [sym_dictionary] = sym_dictionary,
  [sym_pair] = sym_pair,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_dictionary_comprehension] = sym_dictionary_comprehension,
  [sym_set_comprehension] = sym_set_comprehension,
  [sym_generator_expression] = sym_generator_expression,
  [sym__comprehension_clauses] = sym__comprehension_clauses,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__collection_elements] = sym__collection_elements,
  [sym_for_in_clause] = sym_for_in_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string] = sym_string,
  [sym_string_content] = sym_string_content,
  [sym_interpolation] = sym_interpolation,
  [sym__f_expression] = sym__f_expression,
  [sym_format_specifier] = sym_format_specifier,
  [sym_await] = sym_await,
  [sym_positional_separator] = sym_positional_separator,
  [sym_keyword_separator] = sym_keyword_separator,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym__simple_statements_repeat1] = aux_sym__simple_statements_repeat1,
  [aux_sym_import_prefix_repeat1] = aux_sym_import_prefix_repeat1,
  [aux_sym__import_list_repeat1] = aux_sym__import_list_repeat1,
  [aux_sym_print_statement_repeat1] = aux_sym_print_statement_repeat1,
  [aux_sym_assert_statement_repeat1] = aux_sym_assert_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_match_statement_repeat1] = aux_sym_match_statement_repeat1,
  [aux_sym__match_block_repeat1] = aux_sym__match_block_repeat1,
  [aux_sym_case_clause_repeat1] = aux_sym_case_clause_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_try_statement_repeat2] = aux_sym_try_statement_repeat2,
  [aux_sym_with_clause_repeat1] = aux_sym_with_clause_repeat1,
  [aux_sym_global_statement_repeat1] = aux_sym_global_statement_repeat1,
  [aux_sym_type_parameter_repeat1] = aux_sym_type_parameter_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_decorated_definition_repeat1] = aux_sym_decorated_definition_repeat1,
  [aux_sym_dotted_name_repeat1] = aux_sym_dotted_name_repeat1,
  [aux_sym_union_pattern_repeat1] = aux_sym_union_pattern_repeat1,
  [aux_sym_dict_pattern_repeat1] = aux_sym_dict_pattern_repeat1,
  [aux_sym__parameters_repeat1] = aux_sym__parameters_repeat1,
  [aux_sym__patterns_repeat1] = aux_sym__patterns_repeat1,
  [aux_sym_comparison_operator_repeat1] = aux_sym_comparison_operator_repeat1,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
  [aux_sym_dictionary_repeat1] = aux_sym_dictionary_repeat1,
  [aux_sym__comprehension_clauses_repeat1] = aux_sym__comprehension_clauses_repeat1,
  [aux_sym__collection_elements_repeat1] = aux_sym__collection_elements_repeat1,
  [aux_sym_for_in_clause_repeat1] = aux_sym_for_in_clause_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_content_repeat1] = aux_sym_string_content_repeat1,
  [aux_sym_format_specifier_repeat1] = aux_sym_format_specifier_repeat1,
  [alias_sym_as_pattern_target] = alias_sym_as_pattern_target,
  [alias_sym_format_expression] = alias_sym_format_expression,
  [anon_alias_sym_isnot] = anon_alias_sym_isnot,
  [anon_alias_sym_notin] = anon_alias_sym_notin,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___future__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_del] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raises] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lambda] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alias] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipsis] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_inout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_owned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_borrowed] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__not_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_format_specifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_type_conversion] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_continuation] = {
    .visible = true,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym_string_start] = {
    .visible = true,
    .named = true,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_string_end] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_relative_import] = {
    .visible = true,
    .named = true,
  },
  [sym_future_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_from_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__import_list] = {
    .visible = false,
    .named = true,
  },
  [sym_aliased_import] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard_import] = {
    .visible = true,
    .named = true,
  },
  [sym_print_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_chevron] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_named_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__named_expression_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raise_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_match_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__match_block] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_except_group_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_global_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_nonlocal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_decorated_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_name] = {
    .visible = true,
    .named = true,
  },
  [sym_case_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_union_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dict_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__key_value_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_class_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_complex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__patterns] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_within_for_in_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_not_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_within_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_list] = {
    .visible = true,
    .named = true,
  },
  [sym__right_hand_side] = {
    .visible = false,
    .named = true,
  },
  [sym_yield] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_slice] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_splat_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constrained_type] = {
    .visible = true,
    .named = true,
  },
  [sym_member_type] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_set_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__comprehension_clauses] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__collection_elements] = {
    .visible = false,
    .named = true,
  },
  [sym_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__f_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_await] = {
    .visible = true,
    .named = true,
  },
  [sym_positional_separator] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_separator] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__import_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_print_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assert_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__match_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decorated_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dict_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comparison_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comprehension_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__collection_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_in_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_as_pattern_target] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_format_expression] = {
    .visible = true,
    .named = true,
  },
  [anon_alias_sym_isnot] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_notin] = {
    .visible = true,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_cause = 7,
  field_code = 8,
  field_condition = 9,
  field_consequence = 10,
  field_definition = 11,
  field_expression = 12,
  field_format_specifier = 13,
  field_function = 14,
  field_guard = 15,
  field_key = 16,
  field_left = 17,
  field_module_name = 18,
  field_name = 19,
  field_object = 20,
  field_operator = 21,
  field_operators = 22,
  field_parameters = 23,
  field_return_type = 24,
  field_right = 25,
  field_subject = 26,
  field_subscript = 27,
  field_superclasses = 28,
  field_type = 29,
  field_type_conversion = 30,
  field_type_parameters = 31,
  field_value = 32,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_cause] = "cause",
  [field_code] = "code",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_definition] = "definition",
  [field_expression] = "expression",
  [field_format_specifier] = "format_specifier",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_key] = "key",
  [field_left] = "left",
  [field_module_name] = "module_name",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_operators] = "operators",
  [field_parameters] = "parameters",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_subject] = "subject",
  [field_subscript] = "subscript",
  [field_superclasses] = "superclasses",
  [field_type] = "type",
  [field_type_conversion] = "type_conversion",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 1},
  [7] = {.index = 3, .length = 1},
  [8] = {.index = 4, .length = 1},
  [9] = {.index = 5, .length = 2},
  [10] = {.index = 7, .length = 2},
  [11] = {.index = 9, .length = 1},
  [12] = {.index = 10, .length = 1},
  [13] = {.index = 11, .length = 2},
  [14] = {.index = 13, .length = 1},
  [15] = {.index = 14, .length = 2},
  [16] = {.index = 16, .length = 1},
  [17] = {.index = 17, .length = 1},
  [18] = {.index = 18, .length = 2},
  [19] = {.index = 20, .length = 3},
  [20] = {.index = 23, .length = 1},
  [21] = {.index = 24, .length = 2},
  [22] = {.index = 26, .length = 1},
  [23] = {.index = 27, .length = 2},
  [24] = {.index = 29, .length = 2},
  [25] = {.index = 31, .length = 1},
  [26] = {.index = 32, .length = 1},
  [27] = {.index = 33, .length = 2},
  [28] = {.index = 35, .length = 2},
  [29] = {.index = 37, .length = 1},
  [30] = {.index = 38, .length = 2},
  [31] = {.index = 40, .length = 1},
  [33] = {.index = 41, .length = 1},
  [34] = {.index = 42, .length = 2},
  [35] = {.index = 44, .length = 1},
  [36] = {.index = 45, .length = 2},
  [37] = {.index = 47, .length = 1},
  [38] = {.index = 48, .length = 3},
  [39] = {.index = 51, .length = 2},
  [40] = {.index = 53, .length = 2},
  [41] = {.index = 17, .length = 1},
  [42] = {.index = 55, .length = 1},
  [43] = {.index = 56, .length = 2},
  [44] = {.index = 58, .length = 2},
  [45] = {.index = 60, .length = 1},
  [46] = {.index = 61, .length = 2},
  [47] = {.index = 63, .length = 2},
  [48] = {.index = 65, .length = 2},
  [49] = {.index = 67, .length = 2},
  [50] = {.index = 69, .length = 2},
  [51] = {.index = 69, .length = 2},
  [53] = {.index = 71, .length = 2},
  [54] = {.index = 73, .length = 2},
  [55] = {.index = 75, .length = 1},
  [56] = {.index = 76, .length = 3},
  [57] = {.index = 79, .length = 3},
  [58] = {.index = 82, .length = 3},
  [59] = {.index = 85, .length = 3},
  [60] = {.index = 88, .length = 4},
  [61] = {.index = 92, .length = 1},
  [62] = {.index = 93, .length = 3},
  [63] = {.index = 96, .length = 3},
  [64] = {.index = 99, .length = 2},
  [65] = {.index = 101, .length = 2},
  [66] = {.index = 103, .length = 3},
  [67] = {.index = 106, .length = 3},
  [68] = {.index = 109, .length = 3},
  [69] = {.index = 112, .length = 3},
  [70] = {.index = 115, .length = 1},
  [71] = {.index = 18, .length = 2},
  [72] = {.index = 116, .length = 1},
  [73] = {.index = 117, .length = 3},
  [74] = {.index = 120, .length = 2},
  [75] = {.index = 122, .length = 2},
  [76] = {.index = 124, .length = 2},
  [77] = {.index = 126, .length = 3},
  [78] = {.index = 129, .length = 1},
  [79] = {.index = 130, .length = 2},
  [80] = {.index = 132, .length = 4},
  [81] = {.index = 136, .length = 2},
  [82] = {.index = 138, .length = 4},
  [83] = {.index = 142, .length = 4},
  [84] = {.index = 146, .length = 1},
  [85] = {.index = 147, .length = 4},
  [86] = {.index = 151, .length = 2},
  [87] = {.index = 153, .length = 3},
  [88] = {.index = 156, .length = 3},
  [89] = {.index = 159, .length = 4},
  [91] = {.index = 163, .length = 4},
  [92] = {.index = 167, .length = 4},
  [93] = {.index = 171, .length = 4},
  [94] = {.index = 175, .length = 4},
  [95] = {.index = 179, .length = 4},
  [96] = {.index = 183, .length = 3},
  [97] = {.index = 186, .length = 3},
  [98] = {.index = 189, .length = 3},
  [99] = {.index = 192, .length = 2},
  [100] = {.index = 194, .length = 3},
  [101] = {.index = 197, .length = 5},
  [102] = {.index = 202, .length = 3},
  [103] = {.index = 205, .length = 4},
  [104] = {.index = 209, .length = 4},
  [105] = {.index = 213, .length = 4},
  [106] = {.index = 217, .length = 4},
  [108] = {.index = 221, .length = 4},
  [109] = {.index = 225, .length = 5},
  [110] = {.index = 230, .length = 5},
  [111] = {.index = 235, .length = 3},
  [112] = {.index = 238, .length = 2},
  [113] = {.index = 240, .length = 1},
  [114] = {.index = 241, .length = 4},
  [115] = {.index = 245, .length = 4},
  [116] = {.index = 249, .length = 4},
  [117] = {.index = 253, .length = 5},
  [118] = {.index = 258, .length = 5},
  [119] = {.index = 263, .length = 4},
  [120] = {.index = 267, .length = 5},
  [121] = {.index = 272, .length = 5},
  [122] = {.index = 277, .length = 4},
  [123] = {.index = 281, .length = 4},
  [124] = {.index = 285, .length = 2},
  [125] = {.index = 287, .length = 1},
  [126] = {.index = 288, .length = 2},
  [127] = {.index = 290, .length = 2},
  [128] = {.index = 292, .length = 5},
  [129] = {.index = 297, .length = 4},
  [130] = {.index = 301, .length = 5},
  [131] = {.index = 306, .length = 5},
  [133] = {.index = 311, .length = 5},
  [134] = {.index = 316, .length = 5},
  [135] = {.index = 321, .length = 5},
  [136] = {.index = 326, .length = 6},
  [137] = {.index = 332, .length = 2},
  [138] = {.index = 334, .length = 2},
  [139] = {.index = 336, .length = 3},
  [140] = {.index = 339, .length = 1},
  [141] = {.index = 340, .length = 5},
  [142] = {.index = 345, .length = 5},
  [143] = {.index = 350, .length = 5},
  [144] = {.index = 355, .length = 6},
  [145] = {.index = 361, .length = 6},
  [146] = {.index = 367, .length = 6},
  [147] = {.index = 373, .length = 6},
  [148] = {.index = 379, .length = 6},
  [149] = {.index = 385, .length = 3},
  [150] = {.index = 388, .length = 2},
  [151] = {.index = 390, .length = 2},
  [152] = {.index = 392, .length = 6},
  [153] = {.index = 398, .length = 6},
  [154] = {.index = 404, .length = 6},
  [155] = {.index = 410, .length = 6},
  [156] = {.index = 416, .length = 6},
  [157] = {.index = 422, .length = 7},
  [158] = {.index = 429, .length = 7},
  [159] = {.index = 436, .length = 7},
  [160] = {.index = 443, .length = 3},
  [161] = {.index = 446, .length = 6},
  [162] = {.index = 452, .length = 7},
  [163] = {.index = 459, .length = 7},
  [164] = {.index = 466, .length = 7},
  [165] = {.index = 473, .length = 6},
  [166] = {.index = 479, .length = 7},
  [167] = {.index = 486, .length = 7},
  [168] = {.index = 493, .length = 7},
  [169] = {.index = 500, .length = 8},
  [170] = {.index = 508, .length = 6},
  [171] = {.index = 514, .length = 7},
  [172] = {.index = 521, .length = 7},
  [173] = {.index = 528, .length = 7},
  [174] = {.index = 535, .length = 8},
  [175] = {.index = 543, .length = 7},
  [176] = {.index = 550, .length = 7},
  [177] = {.index = 557, .length = 8},
  [178] = {.index = 565, .length = 7},
  [179] = {.index = 572, .length = 8},
  [180] = {.index = 580, .length = 8},
  [181] = {.index = 588, .length = 7},
  [182] = {.index = 595, .length = 7},
  [183] = {.index = 602, .length = 8},
  [184] = {.index = 610, .length = 7},
  [185] = {.index = 617, .length = 8},
  [186] = {.index = 625, .length = 8},
  [187] = {.index = 633, .length = 8},
  [188] = {.index = 641, .length = 8},
  [189] = {.index = 649, .length = 8},
  [190] = {.index = 657, .length = 9},
  [191] = {.index = 666, .length = 8},
  [192] = {.index = 674, .length = 8},
  [193] = {.index = 682, .length = 8},
  [194] = {.index = 690, .length = 9},
  [195] = {.index = 699, .length = 9},
  [196] = {.index = 708, .length = 9},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1, .inherited = true},
  [1] =
    {field_name, 0},
  [2] =
    {field_argument, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_code, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_operators, 1, .inherited = true},
  [10] =
    {field_definition, 1},
  [11] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [13] =
    {field_argument, 2, .inherited = true},
  [14] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
  [16] =
    {field_cause, 2},
  [17] =
    {field_body, 2},
  [18] =
    {field_name, 0},
    {field_value, 2},
  [20] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [23] =
    {field_alias, 2},
  [24] =
    {field_attribute, 2},
    {field_object, 0},
  [26] =
    {field_operators, 0},
  [27] =
    {field_arguments, 2},
    {field_function, 0},
  [29] =
    {field_operators, 0, .inherited = true},
    {field_operators, 1, .inherited = true},
  [31] =
    {field_expression, 1},
  [32] =
    {field_name, 1},
  [33] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [35] =
    {field_alias, 2},
    {field_name, 0},
  [37] =
    {field_name, 3, .inherited = true},
  [38] =
    {field_module_name, 1},
    {field_name, 3, .inherited = true},
  [40] =
    {field_module_name, 1},
  [41] =
    {field_body, 1},
  [42] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [44] =
    {field_cause, 3},
  [45] =
    {field_condition, 1},
    {field_consequence, 3},
  [47] =
    {field_subject, 1},
  [48] =
    {field_alternative, 3, .inherited = true},
    {field_body, 3},
    {field_subject, 1},
  [51] =
    {field_subject, 0, .inherited = true},
    {field_subject, 1, .inherited = true},
  [53] =
    {field_body, 3},
    {field_condition, 1},
  [55] =
    {field_body, 3},
  [56] =
    {field_body, 3},
    {field_name, 1},
  [58] =
    {field_key, 0},
    {field_value, 2},
  [60] =
    {field_type, 2},
  [61] =
    {field_body, 3},
    {field_parameters, 1},
  [63] =
    {field_left, 1},
    {field_type, 3},
  [65] =
    {field_left, 1},
    {field_right, 3},
  [67] =
    {field_subscript, 2},
    {field_value, 0},
  [69] =
    {field_operators, 0},
    {field_operators, 1},
  [71] =
    {field_expression, 1},
    {field_type_conversion, 2},
  [73] =
    {field_expression, 1},
    {field_format_specifier, 2},
  [75] =
    {field_alternative, 0},
  [76] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [79] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [82] =
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [85] =
    {field_alternative, 4, .inherited = true},
    {field_body, 4},
    {field_subject, 1},
  [88] =
    {field_alternative, 4, .inherited = true},
    {field_body, 4},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [92] =
    {field_body, 4},
  [93] =
    {field_alternative, 4},
    {field_body, 3},
    {field_condition, 1},
  [96] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [99] =
    {field_body, 2},
    {field_body, 3},
  [101] =
    {field_body, 3},
    {field_body, 4},
  [103] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [106] =
    {field_body, 3},
    {field_body, 4},
    {field_name, 1},
  [109] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [112] =
    {field_body, 4},
    {field_name, 1},
    {field_superclasses, 2},
  [115] =
    {field_type, 3},
  [116] =
    {field_subscript, 1},
  [117] =
    {field_subscript, 2},
    {field_subscript, 3, .inherited = true},
    {field_value, 0},
  [120] =
    {field_subscript, 0, .inherited = true},
    {field_subscript, 1, .inherited = true},
  [122] =
    {field_expression, 1},
    {field_type_conversion, 3},
  [124] =
    {field_expression, 1},
    {field_format_specifier, 3},
  [126] =
    {field_expression, 1},
    {field_format_specifier, 3},
    {field_type_conversion, 2},
  [129] =
    {field_name, 4, .inherited = true},
  [130] =
    {field_module_name, 1},
    {field_name, 4, .inherited = true},
  [132] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [136] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [138] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [142] =
    {field_alternative, 5, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [146] =
    {field_alternative, 1, .inherited = true},
  [147] =
    {field_alternative, 5, .inherited = true},
    {field_body, 5},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [151] =
    {field_body, 4},
    {field_body, 5},
  [153] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [156] =
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [159] =
    {field_alternative, 5},
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [163] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
  [167] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [171] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_type_parameters, 2},
  [175] =
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 3},
    {field_type_parameters, 2},
  [179] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 2},
  [183] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 4},
  [186] =
    {field_left, 1},
    {field_right, 5},
    {field_type, 3},
  [189] =
    {field_expression, 1},
    {field_format_specifier, 4},
    {field_type_conversion, 3},
  [192] =
    {field_left, 2},
    {field_right, 4},
  [194] =
    {field_left, 1},
    {field_right, 3},
    {field_right, 4},
  [197] =
    {field_alternative, 5, .inherited = true},
    {field_alternative, 6},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [202] =
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [205] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
  [209] =
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [213] =
    {field_alternative, 6},
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [217] =
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [221] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [225] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [230] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 1},
    {field_superclasses, 3},
    {field_type_parameters, 2},
  [235] =
    {field_left, 2},
    {field_right, 4},
    {field_right, 5},
  [238] =
    {field_key, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [240] =
    {field_consequence, 3},
  [241] =
    {field_alternative, 7},
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [245] =
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [249] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [253] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [258] =
    {field_alternative, 7},
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [263] =
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 5},
  [267] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [272] =
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [277] =
    {field_key, 1, .inherited = true},
    {field_key, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [281] =
    {field_key, 0, .inherited = true},
    {field_key, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [285] =
    {field_key, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [287] =
    {field_consequence, 4},
  [288] =
    {field_consequence, 3},
    {field_consequence, 4},
  [290] =
    {field_consequence, 4},
    {field_guard, 2},
  [292] =
    {field_alternative, 8},
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [297] =
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 6},
  [301] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [306] =
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [311] =
    {field_body, 8},
    {field_name, 2},
    {field_name, 5},
    {field_parameters, 3},
    {field_parameters, 6},
  [316] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 5},
  [321] =
    {field_body, 8},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 6},
    {field_type_parameters, 2},
  [326] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [332] =
    {field_consequence, 4},
    {field_consequence, 5},
  [334] =
    {field_consequence, 5},
    {field_guard, 3},
  [336] =
    {field_consequence, 4},
    {field_consequence, 5},
    {field_guard, 2},
  [339] =
    {field_consequence, 5},
  [340] =
    {field_body, 9},
    {field_name, 3},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 7},
  [345] =
    {field_body, 8},
    {field_body, 9},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 6},
  [350] =
    {field_body, 9},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 7},
    {field_type_parameters, 3},
  [355] =
    {field_body, 8},
    {field_body, 9},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [361] =
    {field_body, 8},
    {field_body, 9},
    {field_name, 2},
    {field_name, 5},
    {field_parameters, 3},
    {field_parameters, 6},
  [367] =
    {field_body, 9},
    {field_name, 2},
    {field_name, 5},
    {field_parameters, 3},
    {field_parameters, 7},
    {field_type_parameters, 6},
  [373] =
    {field_body, 9},
    {field_name, 2},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 7},
    {field_type_parameters, 3},
  [379] =
    {field_body, 8},
    {field_body, 9},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 6},
    {field_type_parameters, 2},
  [385] =
    {field_consequence, 5},
    {field_consequence, 6},
    {field_guard, 3},
  [388] =
    {field_consequence, 5},
    {field_consequence, 6},
  [390] =
    {field_consequence, 6},
    {field_guard, 4},
  [392] =
    {field_body, 9},
    {field_body, 10},
    {field_name, 3},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 7},
  [398] =
    {field_body, 10},
    {field_name, 3},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 8},
    {field_type_parameters, 7},
  [404] =
    {field_body, 10},
    {field_name, 3},
    {field_name, 7},
    {field_parameters, 5},
    {field_parameters, 8},
    {field_type_parameters, 4},
  [410] =
    {field_body, 9},
    {field_body, 10},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 7},
    {field_type_parameters, 3},
  [416] =
    {field_body, 10},
    {field_name, 2},
    {field_name, 5},
    {field_parameters, 3},
    {field_parameters, 6},
    {field_return_type, 8},
  [422] =
    {field_body, 9},
    {field_body, 10},
    {field_name, 2},
    {field_name, 5},
    {field_parameters, 3},
    {field_parameters, 7},
    {field_type_parameters, 6},
  [429] =
    {field_body, 9},
    {field_body, 10},
    {field_name, 2},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 7},
    {field_type_parameters, 3},
  [436] =
    {field_body, 10},
    {field_name, 2},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 8},
    {field_type_parameters, 3},
    {field_type_parameters, 7},
  [443] =
    {field_consequence, 6},
    {field_consequence, 7},
    {field_guard, 4},
  [446] =
    {field_body, 11},
    {field_name, 3},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 7},
    {field_return_type, 9},
  [452] =
    {field_body, 10},
    {field_body, 11},
    {field_name, 3},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 8},
    {field_type_parameters, 7},
  [459] =
    {field_body, 10},
    {field_body, 11},
    {field_name, 3},
    {field_name, 7},
    {field_parameters, 5},
    {field_parameters, 8},
    {field_type_parameters, 4},
  [466] =
    {field_body, 11},
    {field_name, 3},
    {field_name, 7},
    {field_parameters, 5},
    {field_parameters, 9},
    {field_type_parameters, 4},
    {field_type_parameters, 8},
  [473] =
    {field_body, 11},
    {field_name, 2},
    {field_name, 5},
    {field_parameters, 3},
    {field_parameters, 6},
    {field_return_type, 9},
  [479] =
    {field_body, 10},
    {field_body, 11},
    {field_name, 2},
    {field_name, 5},
    {field_parameters, 3},
    {field_parameters, 6},
    {field_return_type, 8},
  [486] =
    {field_body, 11},
    {field_name, 2},
    {field_name, 5},
    {field_parameters, 3},
    {field_parameters, 7},
    {field_return_type, 9},
    {field_type_parameters, 6},
  [493] =
    {field_body, 11},
    {field_name, 2},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 7},
    {field_return_type, 9},
    {field_type_parameters, 3},
  [500] =
    {field_body, 10},
    {field_body, 11},
    {field_name, 2},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 8},
    {field_type_parameters, 3},
    {field_type_parameters, 7},
  [508] =
    {field_body, 12},
    {field_name, 3},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 7},
    {field_return_type, 10},
  [514] =
    {field_body, 11},
    {field_body, 12},
    {field_name, 3},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 7},
    {field_return_type, 9},
  [521] =
    {field_body, 12},
    {field_name, 3},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 8},
    {field_return_type, 10},
    {field_type_parameters, 7},
  [528] =
    {field_body, 12},
    {field_name, 3},
    {field_name, 7},
    {field_parameters, 5},
    {field_parameters, 8},
    {field_return_type, 10},
    {field_type_parameters, 4},
  [535] =
    {field_body, 11},
    {field_body, 12},
    {field_name, 3},
    {field_name, 7},
    {field_parameters, 5},
    {field_parameters, 9},
    {field_type_parameters, 4},
    {field_type_parameters, 8},
  [543] =
    {field_body, 11},
    {field_body, 12},
    {field_name, 2},
    {field_name, 5},
    {field_parameters, 3},
    {field_parameters, 6},
    {field_return_type, 9},
  [550] =
    {field_body, 12},
    {field_name, 2},
    {field_name, 5},
    {field_parameters, 3},
    {field_parameters, 7},
    {field_return_type, 10},
    {field_type_parameters, 6},
  [557] =
    {field_body, 11},
    {field_body, 12},
    {field_name, 2},
    {field_name, 5},
    {field_parameters, 3},
    {field_parameters, 7},
    {field_return_type, 9},
    {field_type_parameters, 6},
  [565] =
    {field_body, 12},
    {field_name, 2},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 7},
    {field_return_type, 10},
    {field_type_parameters, 3},
  [572] =
    {field_body, 11},
    {field_body, 12},
    {field_name, 2},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 7},
    {field_return_type, 9},
    {field_type_parameters, 3},
  [580] =
    {field_body, 12},
    {field_name, 2},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 8},
    {field_return_type, 10},
    {field_type_parameters, 3},
    {field_type_parameters, 7},
  [588] =
    {field_body, 12},
    {field_body, 13},
    {field_name, 3},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 7},
    {field_return_type, 10},
  [595] =
    {field_body, 13},
    {field_name, 3},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 8},
    {field_return_type, 11},
    {field_type_parameters, 7},
  [602] =
    {field_body, 12},
    {field_body, 13},
    {field_name, 3},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 8},
    {field_return_type, 10},
    {field_type_parameters, 7},
  [610] =
    {field_body, 13},
    {field_name, 3},
    {field_name, 7},
    {field_parameters, 5},
    {field_parameters, 8},
    {field_return_type, 11},
    {field_type_parameters, 4},
  [617] =
    {field_body, 12},
    {field_body, 13},
    {field_name, 3},
    {field_name, 7},
    {field_parameters, 5},
    {field_parameters, 8},
    {field_return_type, 10},
    {field_type_parameters, 4},
  [625] =
    {field_body, 13},
    {field_name, 3},
    {field_name, 7},
    {field_parameters, 5},
    {field_parameters, 9},
    {field_return_type, 11},
    {field_type_parameters, 4},
    {field_type_parameters, 8},
  [633] =
    {field_body, 12},
    {field_body, 13},
    {field_name, 2},
    {field_name, 5},
    {field_parameters, 3},
    {field_parameters, 7},
    {field_return_type, 10},
    {field_type_parameters, 6},
  [641] =
    {field_body, 12},
    {field_body, 13},
    {field_name, 2},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 7},
    {field_return_type, 10},
    {field_type_parameters, 3},
  [649] =
    {field_body, 13},
    {field_name, 2},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 8},
    {field_return_type, 11},
    {field_type_parameters, 3},
    {field_type_parameters, 7},
  [657] =
    {field_body, 12},
    {field_body, 13},
    {field_name, 2},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 8},
    {field_return_type, 10},
    {field_type_parameters, 3},
    {field_type_parameters, 7},
  [666] =
    {field_body, 13},
    {field_body, 14},
    {field_name, 3},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 8},
    {field_return_type, 11},
    {field_type_parameters, 7},
  [674] =
    {field_body, 13},
    {field_body, 14},
    {field_name, 3},
    {field_name, 7},
    {field_parameters, 5},
    {field_parameters, 8},
    {field_return_type, 11},
    {field_type_parameters, 4},
  [682] =
    {field_body, 14},
    {field_name, 3},
    {field_name, 7},
    {field_parameters, 5},
    {field_parameters, 9},
    {field_return_type, 12},
    {field_type_parameters, 4},
    {field_type_parameters, 8},
  [690] =
    {field_body, 13},
    {field_body, 14},
    {field_name, 3},
    {field_name, 7},
    {field_parameters, 5},
    {field_parameters, 9},
    {field_return_type, 11},
    {field_type_parameters, 4},
    {field_type_parameters, 8},
  [699] =
    {field_body, 13},
    {field_body, 14},
    {field_name, 2},
    {field_name, 6},
    {field_parameters, 4},
    {field_parameters, 8},
    {field_return_type, 11},
    {field_type_parameters, 3},
    {field_type_parameters, 7},
  [708] =
    {field_body, 14},
    {field_body, 15},
    {field_name, 3},
    {field_name, 7},
    {field_parameters, 5},
    {field_parameters, 9},
    {field_return_type, 12},
    {field_type_parameters, 4},
    {field_type_parameters, 8},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = sym_list_splat,
  },
  [5] = {
    [1] = sym_identifier,
  },
  [20] = {
    [2] = alias_sym_as_pattern_target,
  },
  [32] = {
    [1] = sym_parenthesized_expression,
  },
  [36] = {
    [3] = sym_block,
  },
  [40] = {
    [3] = sym_block,
  },
  [41] = {
    [2] = sym_block,
  },
  [42] = {
    [3] = sym_block,
  },
  [43] = {
    [3] = sym_block,
  },
  [50] = {
    [0] = anon_alias_sym_notin,
    [1] = anon_alias_sym_notin,
  },
  [51] = {
    [0] = anon_alias_sym_isnot,
    [1] = anon_alias_sym_isnot,
  },
  [52] = {
    [0] = alias_sym_format_expression,
  },
  [56] = {
    [3] = sym_block,
  },
  [57] = {
    [3] = sym_block,
  },
  [61] = {
    [4] = sym_block,
  },
  [62] = {
    [3] = sym_block,
  },
  [66] = {
    [4] = sym_block,
  },
  [68] = {
    [4] = sym_block,
  },
  [69] = {
    [4] = sym_block,
  },
  [71] = {
    [0] = sym_identifier,
  },
  [80] = {
    [3] = sym_block,
  },
  [87] = {
    [5] = sym_block,
  },
  [88] = {
    [5] = sym_block,
  },
  [90] = {
    [2] = sym_block,
  },
  [92] = {
    [5] = sym_block,
  },
  [94] = {
    [5] = sym_block,
  },
  [102] = {
    [6] = sym_block,
  },
  [104] = {
    [6] = sym_block,
  },
  [105] = {
    [5] = sym_block,
  },
  [107] = {
    [3] = sym_block,
  },
  [108] = {
    [6] = sym_block,
  },
  [113] = {
    [3] = sym_block,
  },
  [114] = {
    [6] = sym_block,
  },
  [116] = {
    [7] = sym_block,
  },
  [119] = {
    [7] = sym_block,
  },
  [121] = {
    [7] = sym_block,
  },
  [125] = {
    [4] = sym_block,
  },
  [127] = {
    [4] = sym_block,
  },
  [129] = {
    [8] = sym_block,
  },
  [131] = {
    [8] = sym_block,
  },
  [132] = {
    [5] = sym_block,
  },
  [133] = {
    [8] = sym_block,
  },
  [135] = {
    [8] = sym_block,
  },
  [138] = {
    [5] = sym_block,
  },
  [140] = {
    [5] = sym_block,
  },
  [141] = {
    [9] = sym_block,
  },
  [143] = {
    [9] = sym_block,
  },
  [146] = {
    [9] = sym_block,
  },
  [147] = {
    [9] = sym_block,
  },
  [151] = {
    [6] = sym_block,
  },
  [153] = {
    [10] = sym_block,
  },
  [154] = {
    [10] = sym_block,
  },
  [156] = {
    [10] = sym_block,
  },
  [159] = {
    [10] = sym_block,
  },
  [161] = {
    [11] = sym_block,
  },
  [164] = {
    [11] = sym_block,
  },
  [165] = {
    [11] = sym_block,
  },
  [167] = {
    [11] = sym_block,
  },
  [168] = {
    [11] = sym_block,
  },
  [170] = {
    [12] = sym_block,
  },
  [172] = {
    [12] = sym_block,
  },
  [173] = {
    [12] = sym_block,
  },
  [176] = {
    [12] = sym_block,
  },
  [178] = {
    [12] = sym_block,
  },
  [180] = {
    [12] = sym_block,
  },
  [182] = {
    [13] = sym_block,
  },
  [184] = {
    [13] = sym_block,
  },
  [186] = {
    [13] = sym_block,
  },
  [189] = {
    [13] = sym_block,
  },
  [193] = {
    [14] = sym_block,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__simple_statements, 2,
    sym__simple_statements,
    sym_block,
  sym_parenthesized_list_splat, 2,
    sym_parenthesized_list_splat,
    sym_parenthesized_expression,
  sym_list_splat_pattern, 2,
    sym_list_splat_pattern,
    sym_list_splat,
  sym_expression, 2,
    sym_expression,
    alias_sym_as_pattern_target,
  sym_interpolation, 2,
    sym_interpolation,
    alias_sym_format_expression,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 21,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 2,
  [62] = 62,
  [63] = 62,
  [64] = 60,
  [65] = 28,
  [66] = 66,
  [67] = 67,
  [68] = 50,
  [69] = 19,
  [70] = 46,
  [71] = 59,
  [72] = 58,
  [73] = 43,
  [74] = 66,
  [75] = 42,
  [76] = 41,
  [77] = 54,
  [78] = 40,
  [79] = 27,
  [80] = 55,
  [81] = 16,
  [82] = 39,
  [83] = 51,
  [84] = 29,
  [85] = 25,
  [86] = 57,
  [87] = 22,
  [88] = 37,
  [89] = 47,
  [90] = 36,
  [91] = 20,
  [92] = 52,
  [93] = 26,
  [94] = 15,
  [95] = 56,
  [96] = 35,
  [97] = 34,
  [98] = 33,
  [99] = 14,
  [100] = 32,
  [101] = 10,
  [102] = 9,
  [103] = 24,
  [104] = 53,
  [105] = 3,
  [106] = 4,
  [107] = 5,
  [108] = 17,
  [109] = 6,
  [110] = 7,
  [111] = 8,
  [112] = 30,
  [113] = 13,
  [114] = 11,
  [115] = 12,
  [116] = 44,
  [117] = 45,
  [118] = 118,
  [119] = 119,
  [120] = 118,
  [121] = 118,
  [122] = 118,
  [123] = 123,
  [124] = 118,
  [125] = 119,
  [126] = 118,
  [127] = 118,
  [128] = 118,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 131,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 144,
  [150] = 150,
  [151] = 151,
  [152] = 143,
  [153] = 153,
  [154] = 150,
  [155] = 155,
  [156] = 142,
  [157] = 133,
  [158] = 158,
  [159] = 158,
  [160] = 130,
  [161] = 155,
  [162] = 141,
  [163] = 147,
  [164] = 153,
  [165] = 136,
  [166] = 139,
  [167] = 167,
  [168] = 140,
  [169] = 151,
  [170] = 148,
  [171] = 145,
  [172] = 167,
  [173] = 132,
  [174] = 137,
  [175] = 134,
  [176] = 135,
  [177] = 146,
  [178] = 178,
  [179] = 179,
  [180] = 179,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 183,
  [191] = 188,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 206,
  [208] = 186,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 204,
  [213] = 200,
  [214] = 211,
  [215] = 215,
  [216] = 184,
  [217] = 217,
  [218] = 210,
  [219] = 194,
  [220] = 203,
  [221] = 221,
  [222] = 222,
  [223] = 193,
  [224] = 224,
  [225] = 217,
  [226] = 226,
  [227] = 189,
  [228] = 226,
  [229] = 222,
  [230] = 209,
  [231] = 181,
  [232] = 192,
  [233] = 187,
  [234] = 196,
  [235] = 235,
  [236] = 201,
  [237] = 205,
  [238] = 198,
  [239] = 221,
  [240] = 195,
  [241] = 241,
  [242] = 235,
  [243] = 243,
  [244] = 182,
  [245] = 202,
  [246] = 185,
  [247] = 247,
  [248] = 247,
  [249] = 249,
  [250] = 249,
  [251] = 247,
  [252] = 247,
  [253] = 247,
  [254] = 247,
  [255] = 249,
  [256] = 249,
  [257] = 249,
  [258] = 247,
  [259] = 249,
  [260] = 249,
  [261] = 249,
  [262] = 247,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 265,
  [268] = 264,
  [269] = 266,
  [270] = 270,
  [271] = 265,
  [272] = 272,
  [273] = 273,
  [274] = 266,
  [275] = 270,
  [276] = 272,
  [277] = 266,
  [278] = 266,
  [279] = 273,
  [280] = 265,
  [281] = 270,
  [282] = 264,
  [283] = 266,
  [284] = 265,
  [285] = 270,
  [286] = 266,
  [287] = 264,
  [288] = 270,
  [289] = 272,
  [290] = 265,
  [291] = 273,
  [292] = 266,
  [293] = 270,
  [294] = 270,
  [295] = 270,
  [296] = 296,
  [297] = 296,
  [298] = 265,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 303,
  [305] = 305,
  [306] = 306,
  [307] = 303,
  [308] = 305,
  [309] = 303,
  [310] = 302,
  [311] = 303,
  [312] = 305,
  [313] = 302,
  [314] = 306,
  [315] = 303,
  [316] = 305,
  [317] = 303,
  [318] = 305,
  [319] = 303,
  [320] = 302,
  [321] = 302,
  [322] = 302,
  [323] = 302,
  [324] = 303,
  [325] = 305,
  [326] = 302,
  [327] = 303,
  [328] = 305,
  [329] = 305,
  [330] = 330,
  [331] = 330,
  [332] = 330,
  [333] = 330,
  [334] = 330,
  [335] = 330,
  [336] = 330,
  [337] = 330,
  [338] = 330,
  [339] = 330,
  [340] = 340,
  [341] = 340,
  [342] = 342,
  [343] = 343,
  [344] = 340,
  [345] = 343,
  [346] = 343,
  [347] = 342,
  [348] = 340,
  [349] = 340,
  [350] = 343,
  [351] = 340,
  [352] = 340,
  [353] = 353,
  [354] = 340,
  [355] = 340,
  [356] = 342,
  [357] = 353,
  [358] = 340,
  [359] = 342,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 363,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 368,
  [375] = 365,
  [376] = 371,
  [377] = 377,
  [378] = 367,
  [379] = 379,
  [380] = 361,
  [381] = 381,
  [382] = 382,
  [383] = 372,
  [384] = 379,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 385,
  [391] = 391,
  [392] = 392,
  [393] = 370,
  [394] = 386,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 362,
  [401] = 401,
  [402] = 402,
  [403] = 370,
  [404] = 404,
  [405] = 377,
  [406] = 389,
  [407] = 407,
  [408] = 404,
  [409] = 409,
  [410] = 369,
  [411] = 397,
  [412] = 412,
  [413] = 387,
  [414] = 389,
  [415] = 370,
  [416] = 395,
  [417] = 370,
  [418] = 396,
  [419] = 370,
  [420] = 407,
  [421] = 381,
  [422] = 399,
  [423] = 423,
  [424] = 423,
  [425] = 370,
  [426] = 370,
  [427] = 412,
  [428] = 428,
  [429] = 391,
  [430] = 412,
  [431] = 431,
  [432] = 388,
  [433] = 433,
  [434] = 401,
  [435] = 389,
  [436] = 412,
  [437] = 398,
  [438] = 404,
  [439] = 404,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 440,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 441,
  [449] = 449,
  [450] = 450,
  [451] = 446,
  [452] = 445,
  [453] = 441,
  [454] = 447,
  [455] = 444,
  [456] = 441,
  [457] = 447,
  [458] = 442,
  [459] = 446,
  [460] = 445,
  [461] = 447,
  [462] = 440,
  [463] = 442,
  [464] = 442,
  [465] = 446,
  [466] = 440,
  [467] = 445,
  [468] = 441,
  [469] = 444,
  [470] = 447,
  [471] = 441,
  [472] = 446,
  [473] = 440,
  [474] = 445,
  [475] = 442,
  [476] = 447,
  [477] = 444,
  [478] = 445,
  [479] = 446,
  [480] = 444,
  [481] = 446,
  [482] = 445,
  [483] = 441,
  [484] = 447,
  [485] = 442,
  [486] = 440,
  [487] = 442,
  [488] = 440,
  [489] = 440,
  [490] = 442,
  [491] = 444,
  [492] = 446,
  [493] = 493,
  [494] = 447,
  [495] = 495,
  [496] = 441,
  [497] = 445,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 409,
  [504] = 499,
  [505] = 373,
  [506] = 501,
  [507] = 502,
  [508] = 508,
  [509] = 500,
  [510] = 501,
  [511] = 511,
  [512] = 508,
  [513] = 513,
  [514] = 514,
  [515] = 296,
  [516] = 500,
  [517] = 508,
  [518] = 514,
  [519] = 499,
  [520] = 502,
  [521] = 498,
  [522] = 514,
  [523] = 523,
  [524] = 523,
  [525] = 525,
  [526] = 523,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 530,
  [532] = 527,
  [533] = 533,
  [534] = 528,
  [535] = 535,
  [536] = 528,
  [537] = 296,
  [538] = 533,
  [539] = 392,
  [540] = 527,
  [541] = 392,
  [542] = 527,
  [543] = 523,
  [544] = 523,
  [545] = 527,
  [546] = 523,
  [547] = 523,
  [548] = 527,
  [549] = 523,
  [550] = 527,
  [551] = 392,
  [552] = 527,
  [553] = 529,
  [554] = 535,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 558,
  [561] = 558,
  [562] = 559,
  [563] = 555,
  [564] = 558,
  [565] = 265,
  [566] = 559,
  [567] = 555,
  [568] = 558,
  [569] = 569,
  [570] = 555,
  [571] = 559,
  [572] = 555,
  [573] = 558,
  [574] = 513,
  [575] = 559,
  [576] = 555,
  [577] = 558,
  [578] = 559,
  [579] = 559,
  [580] = 555,
  [581] = 559,
  [582] = 582,
  [583] = 558,
  [584] = 558,
  [585] = 555,
  [586] = 555,
  [587] = 511,
  [588] = 559,
  [589] = 589,
  [590] = 559,
  [591] = 558,
  [592] = 555,
  [593] = 593,
  [594] = 594,
  [595] = 513,
  [596] = 556,
  [597] = 511,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 593,
  [609] = 609,
  [610] = 603,
  [611] = 611,
  [612] = 612,
  [613] = 594,
  [614] = 602,
  [615] = 601,
  [616] = 607,
  [617] = 598,
  [618] = 605,
  [619] = 619,
  [620] = 296,
  [621] = 621,
  [622] = 622,
  [623] = 600,
  [624] = 624,
  [625] = 611,
  [626] = 612,
  [627] = 594,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 265,
  [632] = 632,
  [633] = 513,
  [634] = 598,
  [635] = 622,
  [636] = 636,
  [637] = 603,
  [638] = 630,
  [639] = 511,
  [640] = 602,
  [641] = 641,
  [642] = 622,
  [643] = 643,
  [644] = 644,
  [645] = 296,
  [646] = 646,
  [647] = 647,
  [648] = 646,
  [649] = 649,
  [650] = 650,
  [651] = 647,
  [652] = 649,
  [653] = 653,
  [654] = 650,
  [655] = 655,
  [656] = 656,
  [657] = 511,
  [658] = 653,
  [659] = 659,
  [660] = 513,
  [661] = 656,
  [662] = 655,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 672,
  [678] = 678,
  [679] = 665,
  [680] = 678,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 681,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 686,
  [690] = 690,
  [691] = 691,
  [692] = 687,
  [693] = 686,
  [694] = 686,
  [695] = 695,
  [696] = 696,
  [697] = 686,
  [698] = 698,
  [699] = 699,
  [700] = 687,
  [701] = 687,
  [702] = 663,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 663,
  [707] = 682,
  [708] = 705,
  [709] = 705,
  [710] = 682,
  [711] = 663,
  [712] = 682,
  [713] = 713,
  [714] = 687,
  [715] = 691,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 668,
  [720] = 686,
  [721] = 691,
  [722] = 713,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 705,
  [727] = 695,
  [728] = 728,
  [729] = 725,
  [730] = 690,
  [731] = 724,
  [732] = 675,
  [733] = 723,
  [734] = 695,
  [735] = 695,
  [736] = 691,
  [737] = 691,
  [738] = 683,
  [739] = 739,
  [740] = 740,
  [741] = 672,
  [742] = 665,
  [743] = 713,
  [744] = 678,
  [745] = 705,
  [746] = 669,
  [747] = 683,
  [748] = 674,
  [749] = 688,
  [750] = 683,
  [751] = 678,
  [752] = 676,
  [753] = 753,
  [754] = 665,
  [755] = 682,
  [756] = 664,
  [757] = 682,
  [758] = 663,
  [759] = 759,
  [760] = 672,
  [761] = 753,
  [762] = 717,
  [763] = 687,
  [764] = 728,
  [765] = 759,
  [766] = 675,
  [767] = 663,
  [768] = 728,
  [769] = 691,
  [770] = 670,
  [771] = 675,
  [772] = 772,
  [773] = 773,
  [774] = 675,
  [775] = 686,
  [776] = 683,
  [777] = 678,
  [778] = 665,
  [779] = 695,
  [780] = 683,
  [781] = 678,
  [782] = 665,
  [783] = 783,
  [784] = 717,
  [785] = 672,
  [786] = 688,
  [787] = 713,
  [788] = 691,
  [789] = 695,
  [790] = 691,
  [791] = 676,
  [792] = 682,
  [793] = 675,
  [794] = 667,
  [795] = 795,
  [796] = 672,
  [797] = 676,
  [798] = 682,
  [799] = 688,
  [800] = 675,
  [801] = 717,
  [802] = 676,
  [803] = 672,
  [804] = 683,
  [805] = 678,
  [806] = 665,
  [807] = 665,
  [808] = 672,
  [809] = 676,
  [810] = 705,
  [811] = 675,
  [812] = 686,
  [813] = 678,
  [814] = 698,
  [815] = 683,
  [816] = 690,
  [817] = 666,
  [818] = 740,
  [819] = 699,
  [820] = 718,
  [821] = 690,
  [822] = 822,
  [823] = 772,
  [824] = 713,
  [825] = 690,
  [826] = 826,
  [827] = 827,
  [828] = 690,
  [829] = 773,
  [830] = 728,
  [831] = 783,
  [832] = 795,
  [833] = 690,
  [834] = 834,
  [835] = 723,
  [836] = 703,
  [837] = 690,
  [838] = 728,
  [839] = 728,
  [840] = 840,
  [841] = 840,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 844,
  [848] = 848,
  [849] = 849,
  [850] = 845,
  [851] = 851,
  [852] = 842,
  [853] = 849,
  [854] = 848,
  [855] = 851,
  [856] = 843,
  [857] = 857,
  [858] = 858,
  [859] = 858,
  [860] = 857,
  [861] = 846,
  [862] = 862,
  [863] = 863,
  [864] = 863,
  [865] = 862,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 897,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 908,
  [920] = 920,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 868,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 932,
  [939] = 939,
  [940] = 940,
  [941] = 936,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 958,
  [959] = 959,
  [960] = 957,
  [961] = 954,
  [962] = 962,
  [963] = 956,
  [964] = 947,
  [965] = 965,
  [966] = 943,
  [967] = 955,
  [968] = 965,
  [969] = 969,
  [970] = 940,
  [971] = 971,
  [972] = 944,
  [973] = 973,
  [974] = 953,
  [975] = 975,
  [976] = 952,
  [977] = 959,
  [978] = 978,
  [979] = 979,
  [980] = 937,
  [981] = 930,
  [982] = 935,
  [983] = 915,
  [984] = 929,
  [985] = 978,
  [986] = 934,
  [987] = 923,
  [988] = 988,
  [989] = 914,
  [990] = 928,
  [991] = 911,
  [992] = 927,
  [993] = 890,
  [994] = 912,
  [995] = 925,
  [996] = 910,
  [997] = 909,
  [998] = 922,
  [999] = 898,
  [1000] = 888,
  [1001] = 1001,
  [1002] = 921,
  [1003] = 924,
  [1004] = 920,
  [1005] = 951,
  [1006] = 907,
  [1007] = 945,
  [1008] = 1008,
  [1009] = 905,
  [1010] = 895,
  [1011] = 904,
  [1012] = 893,
  [1013] = 892,
  [1014] = 903,
  [1015] = 913,
  [1016] = 901,
  [1017] = 969,
  [1018] = 900,
  [1019] = 949,
  [1020] = 1020,
  [1021] = 896,
  [1022] = 881,
  [1023] = 894,
  [1024] = 887,
  [1025] = 916,
  [1026] = 891,
  [1027] = 889,
  [1028] = 886,
  [1029] = 885,
  [1030] = 884,
  [1031] = 1031,
  [1032] = 883,
  [1033] = 882,
  [1034] = 880,
  [1035] = 1035,
  [1036] = 878,
  [1037] = 877,
  [1038] = 1001,
  [1039] = 875,
  [1040] = 1040,
  [1041] = 874,
  [1042] = 971,
  [1043] = 873,
  [1044] = 872,
  [1045] = 871,
  [1046] = 1046,
  [1047] = 870,
  [1048] = 869,
  [1049] = 1049,
  [1050] = 926,
  [1051] = 931,
  [1052] = 939,
  [1053] = 942,
  [1054] = 1054,
  [1055] = 1049,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1056,
  [1059] = 1054,
  [1060] = 1035,
  [1061] = 946,
  [1062] = 948,
  [1063] = 950,
  [1064] = 1031,
  [1065] = 973,
  [1066] = 975,
  [1067] = 979,
  [1068] = 1020,
  [1069] = 1008,
  [1070] = 962,
  [1071] = 1057,
  [1072] = 918,
  [1073] = 1073,
  [1074] = 917,
  [1075] = 1046,
  [1076] = 1040,
  [1077] = 958,
  [1078] = 876,
  [1079] = 1079,
  [1080] = 879,
  [1081] = 899,
  [1082] = 1082,
  [1083] = 1073,
  [1084] = 1079,
  [1085] = 1082,
  [1086] = 988,
  [1087] = 902,
  [1088] = 373,
  [1089] = 1089,
  [1090] = 1090,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 409,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 373,
  [1112] = 409,
  [1113] = 1113,
  [1114] = 1113,
  [1115] = 1115,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1115,
  [1119] = 1119,
  [1120] = 1116,
  [1121] = 1121,
  [1122] = 1117,
  [1123] = 1123,
  [1124] = 1119,
  [1125] = 1119,
  [1126] = 1123,
  [1127] = 1116,
  [1128] = 1128,
  [1129] = 1121,
  [1130] = 1130,
  [1131] = 1130,
  [1132] = 1130,
  [1133] = 1130,
  [1134] = 1130,
  [1135] = 1130,
  [1136] = 1136,
  [1137] = 1136,
  [1138] = 1138,
  [1139] = 1138,
  [1140] = 1138,
  [1141] = 1138,
  [1142] = 1138,
  [1143] = 1138,
  [1144] = 1138,
  [1145] = 1138,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 1148,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1148,
  [1159] = 1159,
  [1160] = 1148,
  [1161] = 1161,
  [1162] = 1152,
  [1163] = 1146,
  [1164] = 1151,
  [1165] = 1153,
  [1166] = 1146,
  [1167] = 1167,
  [1168] = 1155,
  [1169] = 1150,
  [1170] = 1157,
  [1171] = 1159,
  [1172] = 1149,
  [1173] = 1147,
  [1174] = 1149,
  [1175] = 1156,
  [1176] = 1147,
  [1177] = 1159,
  [1178] = 1157,
  [1179] = 1150,
  [1180] = 1155,
  [1181] = 1154,
  [1182] = 1149,
  [1183] = 1147,
  [1184] = 1146,
  [1185] = 1159,
  [1186] = 1157,
  [1187] = 1150,
  [1188] = 1146,
  [1189] = 1151,
  [1190] = 1153,
  [1191] = 1151,
  [1192] = 1154,
  [1193] = 1153,
  [1194] = 1156,
  [1195] = 1148,
  [1196] = 1149,
  [1197] = 1147,
  [1198] = 1159,
  [1199] = 1157,
  [1200] = 1150,
  [1201] = 1148,
  [1202] = 1151,
  [1203] = 1153,
  [1204] = 1148,
  [1205] = 1154,
  [1206] = 1154,
  [1207] = 1156,
  [1208] = 1152,
  [1209] = 1153,
  [1210] = 1156,
  [1211] = 1154,
  [1212] = 1156,
  [1213] = 1151,
  [1214] = 1146,
  [1215] = 1150,
  [1216] = 1157,
  [1217] = 1159,
  [1218] = 1147,
  [1219] = 1149,
  [1220] = 1156,
  [1221] = 1148,
  [1222] = 1148,
  [1223] = 1152,
  [1224] = 1148,
  [1225] = 1155,
  [1226] = 1167,
  [1227] = 1152,
  [1228] = 1148,
  [1229] = 1152,
  [1230] = 1149,
  [1231] = 1152,
  [1232] = 1147,
  [1233] = 1159,
  [1234] = 1157,
  [1235] = 1150,
  [1236] = 1146,
  [1237] = 1151,
  [1238] = 1153,
  [1239] = 1148,
  [1240] = 1148,
  [1241] = 1153,
  [1242] = 1151,
  [1243] = 1146,
  [1244] = 1150,
  [1245] = 1157,
  [1246] = 1159,
  [1247] = 1147,
  [1248] = 1155,
  [1249] = 1149,
  [1250] = 1154,
  [1251] = 1156,
  [1252] = 1152,
  [1253] = 1148,
  [1254] = 1154,
  [1255] = 1255,
  [1256] = 1256,
  [1257] = 1257,
  [1258] = 1258,
  [1259] = 1259,
  [1260] = 1260,
  [1261] = 1261,
  [1262] = 1262,
  [1263] = 1263,
  [1264] = 1264,
  [1265] = 1161,
  [1266] = 1266,
  [1267] = 1267,
  [1268] = 1268,
  [1269] = 1161,
  [1270] = 1270,
  [1271] = 1271,
  [1272] = 1260,
  [1273] = 1161,
  [1274] = 1268,
  [1275] = 1260,
  [1276] = 1259,
  [1277] = 1263,
  [1278] = 1270,
  [1279] = 1262,
  [1280] = 1266,
  [1281] = 1264,
  [1282] = 1255,
  [1283] = 1267,
  [1284] = 1271,
  [1285] = 1267,
  [1286] = 1255,
  [1287] = 1258,
  [1288] = 1161,
  [1289] = 1257,
  [1290] = 1256,
  [1291] = 1261,
  [1292] = 1270,
  [1293] = 1264,
  [1294] = 1161,
  [1295] = 1161,
  [1296] = 1161,
  [1297] = 1256,
  [1298] = 1258,
  [1299] = 1257,
  [1300] = 1268,
  [1301] = 1263,
  [1302] = 1271,
  [1303] = 1261,
  [1304] = 1262,
  [1305] = 1259,
  [1306] = 1266,
  [1307] = 1263,
  [1308] = 1268,
  [1309] = 1259,
  [1310] = 1092,
  [1311] = 1161,
  [1312] = 1089,
  [1313] = 1105,
  [1314] = 1102,
  [1315] = 1264,
  [1316] = 1316,
  [1317] = 1097,
  [1318] = 1099,
  [1319] = 1264,
  [1320] = 1255,
  [1321] = 1258,
  [1322] = 1322,
  [1323] = 1270,
  [1324] = 1260,
  [1325] = 1257,
  [1326] = 1260,
  [1327] = 1268,
  [1328] = 1328,
  [1329] = 1256,
  [1330] = 1261,
  [1331] = 1259,
  [1332] = 1332,
  [1333] = 1261,
  [1334] = 1270,
  [1335] = 1258,
  [1336] = 1258,
  [1337] = 1256,
  [1338] = 1257,
  [1339] = 1262,
  [1340] = 1268,
  [1341] = 1257,
  [1342] = 1271,
  [1343] = 1263,
  [1344] = 1259,
  [1345] = 1262,
  [1346] = 1266,
  [1347] = 1263,
  [1348] = 1262,
  [1349] = 1260,
  [1350] = 1266,
  [1351] = 1267,
  [1352] = 1266,
  [1353] = 1255,
  [1354] = 1255,
  [1355] = 1255,
  [1356] = 1267,
  [1357] = 1266,
  [1358] = 1261,
  [1359] = 1093,
  [1360] = 1262,
  [1361] = 1267,
  [1362] = 1256,
  [1363] = 1263,
  [1364] = 1268,
  [1365] = 1257,
  [1366] = 1258,
  [1367] = 1259,
  [1368] = 1261,
  [1369] = 1264,
  [1370] = 1260,
  [1371] = 1271,
  [1372] = 1267,
  [1373] = 1106,
  [1374] = 1270,
  [1375] = 1271,
  [1376] = 1271,
  [1377] = 1264,
  [1378] = 1378,
  [1379] = 1094,
  [1380] = 1256,
  [1381] = 1270,
  [1382] = 1382,
  [1383] = 1104,
  [1384] = 1110,
  [1385] = 1385,
  [1386] = 867,
  [1387] = 1106,
  [1388] = 1388,
  [1389] = 1322,
  [1390] = 1390,
  [1391] = 1161,
  [1392] = 1100,
  [1393] = 1316,
  [1394] = 1271,
  [1395] = 1108,
  [1396] = 1396,
  [1397] = 1093,
  [1398] = 1322,
  [1399] = 1328,
  [1400] = 1332,
  [1401] = 1401,
  [1402] = 1402,
  [1403] = 1403,
  [1404] = 1404,
  [1405] = 1405,
  [1406] = 1406,
  [1407] = 1378,
  [1408] = 1332,
  [1409] = 1092,
  [1410] = 1089,
  [1411] = 1411,
  [1412] = 1412,
  [1413] = 1105,
  [1414] = 1378,
  [1415] = 1102,
  [1416] = 1416,
  [1417] = 1270,
  [1418] = 1161,
  [1419] = 1260,
  [1420] = 1097,
  [1421] = 1264,
  [1422] = 1099,
  [1423] = 1423,
  [1424] = 1412,
  [1425] = 1259,
  [1426] = 1258,
  [1427] = 1316,
  [1428] = 1428,
  [1429] = 1257,
  [1430] = 1268,
  [1431] = 1431,
  [1432] = 1263,
  [1433] = 1262,
  [1434] = 1434,
  [1435] = 1266,
  [1436] = 1436,
  [1437] = 1437,
  [1438] = 1255,
  [1439] = 1267,
  [1440] = 1091,
  [1441] = 1441,
  [1442] = 1090,
  [1443] = 1328,
  [1444] = 1444,
  [1445] = 1445,
  [1446] = 1446,
  [1447] = 1261,
  [1448] = 1448,
  [1449] = 1256,
  [1450] = 1450,
  [1451] = 1451,
  [1452] = 1452,
  [1453] = 1453,
  [1454] = 1094,
  [1455] = 1455,
  [1456] = 1456,
  [1457] = 1161,
  [1458] = 1458,
  [1459] = 1459,
  [1460] = 1460,
  [1461] = 1461,
  [1462] = 1462,
  [1463] = 1388,
  [1464] = 1462,
  [1465] = 1456,
  [1466] = 1458,
  [1467] = 1406,
  [1468] = 1396,
  [1469] = 1461,
  [1470] = 1444,
  [1471] = 1322,
  [1472] = 1382,
  [1473] = 1441,
  [1474] = 1328,
  [1475] = 1332,
  [1476] = 1451,
  [1477] = 1108,
  [1478] = 1094,
  [1479] = 1450,
  [1480] = 1437,
  [1481] = 1436,
  [1482] = 1434,
  [1483] = 1428,
  [1484] = 1378,
  [1485] = 1385,
  [1486] = 1423,
  [1487] = 867,
  [1488] = 1322,
  [1489] = 1099,
  [1490] = 1097,
  [1491] = 1328,
  [1492] = 1332,
  [1493] = 1102,
  [1494] = 1105,
  [1495] = 1089,
  [1496] = 1092,
  [1497] = 1093,
  [1498] = 1106,
  [1499] = 1411,
  [1500] = 1378,
  [1501] = 1108,
  [1502] = 1412,
  [1503] = 1316,
  [1504] = 1411,
  [1505] = 1459,
  [1506] = 1453,
  [1507] = 1448,
  [1508] = 1446,
  [1509] = 1378,
  [1510] = 867,
  [1511] = 1378,
  [1512] = 1090,
  [1513] = 1401,
  [1514] = 1431,
  [1515] = 1316,
  [1516] = 1091,
  [1517] = 1441,
  [1518] = 1382,
  [1519] = 1444,
  [1520] = 1390,
  [1521] = 1401,
  [1522] = 1110,
  [1523] = 1404,
  [1524] = 1405,
  [1525] = 1106,
  [1526] = 1093,
  [1527] = 1455,
  [1528] = 1332,
  [1529] = 1328,
  [1530] = 1455,
  [1531] = 1322,
  [1532] = 1091,
  [1533] = 1412,
  [1534] = 1090,
  [1535] = 1416,
  [1536] = 1428,
  [1537] = 1456,
  [1538] = 1110,
  [1539] = 1406,
  [1540] = 1396,
  [1541] = 1461,
  [1542] = 1451,
  [1543] = 1316,
  [1544] = 1450,
  [1545] = 1402,
  [1546] = 1403,
  [1547] = 1437,
  [1548] = 1388,
  [1549] = 1101,
  [1550] = 1107,
  [1551] = 1109,
  [1552] = 1092,
  [1553] = 1089,
  [1554] = 1105,
  [1555] = 1102,
  [1556] = 1416,
  [1557] = 1098,
  [1558] = 1104,
  [1559] = 1100,
  [1560] = 1436,
  [1561] = 1316,
  [1562] = 1322,
  [1563] = 1328,
  [1564] = 1332,
  [1565] = 1094,
  [1566] = 1434,
  [1567] = 1402,
  [1568] = 1403,
  [1569] = 1096,
  [1570] = 1460,
  [1571] = 1104,
  [1572] = 1100,
  [1573] = 1090,
  [1574] = 1091,
  [1575] = 1452,
  [1576] = 1445,
  [1577] = 1405,
  [1578] = 1404,
  [1579] = 1458,
  [1580] = 1423,
  [1581] = 1385,
  [1582] = 1462,
  [1583] = 1431,
  [1584] = 1446,
  [1585] = 1448,
  [1586] = 1390,
  [1587] = 1453,
  [1588] = 1097,
  [1589] = 1099,
  [1590] = 1459,
  [1591] = 1456,
  [1592] = 1104,
  [1593] = 1091,
  [1594] = 1090,
  [1595] = 1446,
  [1596] = 1091,
  [1597] = 1090,
  [1598] = 1316,
  [1599] = 1091,
  [1600] = 1090,
  [1601] = 1100,
  [1602] = 1104,
  [1603] = 1378,
  [1604] = 1106,
  [1605] = 1448,
  [1606] = 1462,
  [1607] = 1460,
  [1608] = 1452,
  [1609] = 1445,
  [1610] = 1093,
  [1611] = 1431,
  [1612] = 1092,
  [1613] = 1089,
  [1614] = 1105,
  [1615] = 1102,
  [1616] = 1453,
  [1617] = 1103,
  [1618] = 1097,
  [1619] = 1099,
  [1620] = 1423,
  [1621] = 1094,
  [1622] = 1456,
  [1623] = 1458,
  [1624] = 1406,
  [1625] = 1396,
  [1626] = 1461,
  [1627] = 1451,
  [1628] = 1450,
  [1629] = 1437,
  [1630] = 1436,
  [1631] = 1385,
  [1632] = 1434,
  [1633] = 1459,
  [1634] = 1428,
  [1635] = 1428,
  [1636] = 1385,
  [1637] = 1423,
  [1638] = 1403,
  [1639] = 1434,
  [1640] = 1436,
  [1641] = 1437,
  [1642] = 1402,
  [1643] = 1411,
  [1644] = 1390,
  [1645] = 1450,
  [1646] = 1451,
  [1647] = 1462,
  [1648] = 1411,
  [1649] = 1459,
  [1650] = 1453,
  [1651] = 1448,
  [1652] = 1446,
  [1653] = 1404,
  [1654] = 1431,
  [1655] = 1461,
  [1656] = 1390,
  [1657] = 1396,
  [1658] = 1406,
  [1659] = 1405,
  [1660] = 1404,
  [1661] = 1405,
  [1662] = 1332,
  [1663] = 1328,
  [1664] = 1322,
  [1665] = 1100,
  [1666] = 1104,
  [1667] = 1416,
  [1668] = 1388,
  [1669] = 1101,
  [1670] = 1107,
  [1671] = 1109,
  [1672] = 1458,
  [1673] = 1416,
  [1674] = 1098,
  [1675] = 1091,
  [1676] = 1100,
  [1677] = 1090,
  [1678] = 1090,
  [1679] = 1091,
  [1680] = 1455,
  [1681] = 1096,
  [1682] = 1405,
  [1683] = 1404,
  [1684] = 1390,
  [1685] = 1403,
  [1686] = 1402,
  [1687] = 1431,
  [1688] = 1446,
  [1689] = 1388,
  [1690] = 1448,
  [1691] = 1455,
  [1692] = 1453,
  [1693] = 1459,
  [1694] = 1401,
  [1695] = 1411,
  [1696] = 1100,
  [1697] = 1104,
  [1698] = 1106,
  [1699] = 1093,
  [1700] = 1092,
  [1701] = 1089,
  [1702] = 1105,
  [1703] = 1102,
  [1704] = 1097,
  [1705] = 1099,
  [1706] = 1462,
  [1707] = 1423,
  [1708] = 1385,
  [1709] = 1094,
  [1710] = 1428,
  [1711] = 1403,
  [1712] = 1402,
  [1713] = 1434,
  [1714] = 1436,
  [1715] = 1437,
  [1716] = 1450,
  [1717] = 1451,
  [1718] = 1461,
  [1719] = 1455,
  [1720] = 1091,
  [1721] = 1401,
  [1722] = 1090,
  [1723] = 1406,
  [1724] = 1106,
  [1725] = 1416,
  [1726] = 1388,
  [1727] = 1093,
  [1728] = 1456,
  [1729] = 1458,
  [1730] = 1092,
  [1731] = 1101,
  [1732] = 1089,
  [1733] = 1107,
  [1734] = 1109,
  [1735] = 1416,
  [1736] = 1105,
  [1737] = 1102,
  [1738] = 1406,
  [1739] = 1098,
  [1740] = 1388,
  [1741] = 1396,
  [1742] = 1461,
  [1743] = 1097,
  [1744] = 1099,
  [1745] = 1451,
  [1746] = 1401,
  [1747] = 1450,
  [1748] = 1437,
  [1749] = 1436,
  [1750] = 1434,
  [1751] = 1428,
  [1752] = 1455,
  [1753] = 1385,
  [1754] = 1458,
  [1755] = 1423,
  [1756] = 1096,
  [1757] = 1456,
  [1758] = 1462,
  [1759] = 1094,
  [1760] = 1405,
  [1761] = 1404,
  [1762] = 1401,
  [1763] = 1411,
  [1764] = 1390,
  [1765] = 1459,
  [1766] = 1396,
  [1767] = 1103,
  [1768] = 1453,
  [1769] = 1403,
  [1770] = 1402,
  [1771] = 1448,
  [1772] = 1446,
  [1773] = 1444,
  [1774] = 1382,
  [1775] = 1441,
  [1776] = 1431,
  [1777] = 1450,
  [1778] = 1451,
  [1779] = 1382,
  [1780] = 1441,
  [1781] = 1090,
  [1782] = 1091,
  [1783] = 1090,
  [1784] = 1091,
  [1785] = 1103,
  [1786] = 1106,
  [1787] = 1093,
  [1788] = 1401,
  [1789] = 1455,
  [1790] = 1092,
  [1791] = 1402,
  [1792] = 1403,
  [1793] = 1089,
  [1794] = 1388,
  [1795] = 1416,
  [1796] = 1104,
  [1797] = 1100,
  [1798] = 1405,
  [1799] = 1404,
  [1800] = 1390,
  [1801] = 1105,
  [1802] = 1431,
  [1803] = 1446,
  [1804] = 1448,
  [1805] = 1444,
  [1806] = 1382,
  [1807] = 1441,
  [1808] = 1453,
  [1809] = 1459,
  [1810] = 1461,
  [1811] = 1462,
  [1812] = 1423,
  [1813] = 1385,
  [1814] = 1428,
  [1815] = 1434,
  [1816] = 1436,
  [1817] = 1103,
  [1818] = 1437,
  [1819] = 1444,
  [1820] = 1102,
  [1821] = 1411,
  [1822] = 1396,
  [1823] = 1406,
  [1824] = 1458,
  [1825] = 1456,
  [1826] = 1094,
  [1827] = 1099,
  [1828] = 1097,
  [1829] = 1096,
  [1830] = 1830,
  [1831] = 1090,
  [1832] = 1091,
  [1833] = 1090,
  [1834] = 1101,
  [1835] = 1107,
  [1836] = 1109,
  [1837] = 1091,
  [1838] = 1098,
  [1839] = 1839,
  [1840] = 1840,
  [1841] = 1841,
  [1842] = 1093,
  [1843] = 1104,
  [1844] = 1830,
  [1845] = 1106,
  [1846] = 1107,
  [1847] = 1100,
  [1848] = 1101,
  [1849] = 1092,
  [1850] = 1089,
  [1851] = 1105,
  [1852] = 1102,
  [1853] = 1097,
  [1854] = 1109,
  [1855] = 1098,
  [1856] = 1096,
  [1857] = 1839,
  [1858] = 1091,
  [1859] = 1090,
  [1860] = 1099,
  [1861] = 1094,
  [1862] = 1862,
  [1863] = 1863,
  [1864] = 1862,
  [1865] = 1865,
  [1866] = 1866,
  [1867] = 1867,
  [1868] = 1868,
  [1869] = 1869,
  [1870] = 1867,
  [1871] = 1867,
  [1872] = 1868,
  [1873] = 1869,
  [1874] = 1866,
  [1875] = 1865,
  [1876] = 1876,
  [1877] = 1863,
  [1878] = 1865,
  [1879] = 1866,
  [1880] = 1876,
  [1881] = 1876,
  [1882] = 1882,
  [1883] = 1869,
  [1884] = 1868,
  [1885] = 1882,
  [1886] = 1862,
  [1887] = 1876,
  [1888] = 1882,
  [1889] = 1868,
  [1890] = 1867,
  [1891] = 1866,
  [1892] = 1863,
  [1893] = 1863,
  [1894] = 1882,
  [1895] = 1862,
  [1896] = 1865,
  [1897] = 1869,
  [1898] = 1898,
  [1899] = 1898,
  [1900] = 1898,
  [1901] = 1901,
  [1902] = 1902,
  [1903] = 1903,
  [1904] = 1904,
  [1905] = 1905,
  [1906] = 1905,
  [1907] = 1904,
  [1908] = 1904,
  [1909] = 1909,
  [1910] = 1910,
  [1911] = 1905,
  [1912] = 1910,
  [1913] = 1905,
  [1914] = 1909,
  [1915] = 1903,
  [1916] = 1903,
  [1917] = 1910,
  [1918] = 1903,
  [1919] = 1910,
  [1920] = 1909,
  [1921] = 1909,
  [1922] = 1904,
  [1923] = 1923,
  [1924] = 1924,
  [1925] = 1924,
  [1926] = 1926,
  [1927] = 1926,
  [1928] = 1924,
  [1929] = 1926,
  [1930] = 1926,
  [1931] = 1924,
  [1932] = 1932,
  [1933] = 1933,
  [1934] = 1098,
  [1935] = 1109,
  [1936] = 1096,
  [1937] = 1107,
  [1938] = 1101,
  [1939] = 1932,
  [1940] = 1839,
  [1941] = 1830,
  [1942] = 1933,
  [1943] = 1932,
  [1944] = 1933,
  [1945] = 1945,
  [1946] = 1830,
  [1947] = 1932,
  [1948] = 1945,
  [1949] = 1933,
  [1950] = 1945,
  [1951] = 1945,
  [1952] = 1945,
  [1953] = 1098,
  [1954] = 1954,
  [1955] = 1954,
  [1956] = 1096,
  [1957] = 1101,
  [1958] = 1945,
  [1959] = 1932,
  [1960] = 1945,
  [1961] = 1107,
  [1962] = 1945,
  [1963] = 1109,
  [1964] = 1933,
  [1965] = 1839,
  [1966] = 1954,
  [1967] = 1933,
  [1968] = 1932,
  [1969] = 1932,
  [1970] = 1970,
  [1971] = 1970,
  [1972] = 1933,
  [1973] = 1973,
  [1974] = 1974,
  [1975] = 1970,
  [1976] = 1091,
  [1977] = 1970,
  [1978] = 1978,
  [1979] = 1090,
  [1980] = 1978,
  [1981] = 1970,
  [1982] = 1982,
  [1983] = 1970,
  [1984] = 1100,
  [1985] = 1970,
  [1986] = 1104,
  [1987] = 1970,
  [1988] = 1988,
  [1989] = 1932,
  [1990] = 1970,
  [1991] = 1970,
  [1992] = 1933,
  [1993] = 1830,
  [1994] = 1101,
  [1995] = 1988,
  [1996] = 1996,
  [1997] = 1973,
  [1998] = 1096,
  [1999] = 1090,
  [2000] = 1974,
  [2001] = 1098,
  [2002] = 1839,
  [2003] = 1091,
  [2004] = 1098,
  [2005] = 1996,
  [2006] = 2006,
  [2007] = 1109,
  [2008] = 1109,
  [2009] = 1107,
  [2010] = 1982,
  [2011] = 1830,
  [2012] = 2006,
  [2013] = 1107,
  [2014] = 1100,
  [2015] = 1096,
  [2016] = 1104,
  [2017] = 1101,
  [2018] = 1839,
  [2019] = 2019,
  [2020] = 2020,
  [2021] = 2021,
  [2022] = 2022,
  [2023] = 2023,
  [2024] = 2024,
  [2025] = 2025,
  [2026] = 2021,
  [2027] = 2023,
  [2028] = 2020,
  [2029] = 2019,
  [2030] = 2025,
  [2031] = 2031,
  [2032] = 2032,
  [2033] = 2022,
  [2034] = 2024,
  [2035] = 2031,
  [2036] = 2036,
  [2037] = 2037,
  [2038] = 2038,
  [2039] = 2039,
  [2040] = 2040,
  [2041] = 2040,
  [2042] = 2042,
  [2043] = 2040,
  [2044] = 2040,
  [2045] = 2045,
  [2046] = 2040,
  [2047] = 2040,
  [2048] = 2048,
  [2049] = 2040,
  [2050] = 2040,
  [2051] = 2051,
  [2052] = 2052,
  [2053] = 2053,
  [2054] = 2054,
  [2055] = 2055,
  [2056] = 2054,
  [2057] = 2054,
  [2058] = 2058,
  [2059] = 2055,
  [2060] = 2054,
  [2061] = 2054,
  [2062] = 2055,
  [2063] = 2055,
  [2064] = 2064,
  [2065] = 2054,
  [2066] = 2064,
  [2067] = 2064,
  [2068] = 2064,
  [2069] = 2064,
  [2070] = 2055,
  [2071] = 2064,
  [2072] = 2072,
  [2073] = 2055,
  [2074] = 2055,
  [2075] = 2064,
  [2076] = 2064,
  [2077] = 2054,
  [2078] = 2054,
  [2079] = 2055,
  [2080] = 2052,
  [2081] = 2081,
  [2082] = 2082,
  [2083] = 2083,
  [2084] = 2084,
  [2085] = 2084,
  [2086] = 2037,
  [2087] = 2087,
  [2088] = 2045,
  [2089] = 2053,
  [2090] = 2084,
  [2091] = 2038,
  [2092] = 2081,
  [2093] = 2081,
  [2094] = 2094,
  [2095] = 2084,
  [2096] = 2051,
  [2097] = 2038,
  [2098] = 2081,
  [2099] = 2037,
  [2100] = 2052,
  [2101] = 2045,
  [2102] = 2084,
  [2103] = 2042,
  [2104] = 2082,
  [2105] = 2094,
  [2106] = 2081,
  [2107] = 2081,
  [2108] = 2108,
  [2109] = 2084,
  [2110] = 2081,
  [2111] = 2053,
  [2112] = 2048,
  [2113] = 2039,
  [2114] = 2051,
  [2115] = 2084,
  [2116] = 2048,
  [2117] = 2039,
  [2118] = 2081,
  [2119] = 2042,
  [2120] = 2081,
  [2121] = 2084,
  [2122] = 2084,
  [2123] = 2037,
  [2124] = 2039,
  [2125] = 2125,
  [2126] = 2052,
  [2127] = 2051,
  [2128] = 2128,
  [2129] = 2042,
  [2130] = 2037,
  [2131] = 2131,
  [2132] = 2042,
  [2133] = 2082,
  [2134] = 2039,
  [2135] = 2131,
  [2136] = 2048,
  [2137] = 2052,
  [2138] = 2051,
  [2139] = 2037,
  [2140] = 2045,
  [2141] = 2141,
  [2142] = 2131,
  [2143] = 2053,
  [2144] = 2131,
  [2145] = 2145,
  [2146] = 2146,
  [2147] = 2038,
  [2148] = 2131,
  [2149] = 2131,
  [2150] = 2131,
  [2151] = 2048,
  [2152] = 2052,
  [2153] = 2153,
  [2154] = 2042,
  [2155] = 2131,
  [2156] = 2082,
  [2157] = 2051,
  [2158] = 2131,
  [2159] = 2159,
  [2160] = 2053,
  [2161] = 2053,
  [2162] = 2038,
  [2163] = 2131,
  [2164] = 2045,
  [2165] = 2039,
  [2166] = 2038,
  [2167] = 2045,
  [2168] = 2048,
  [2169] = 2039,
  [2170] = 2048,
  [2171] = 2171,
  [2172] = 2053,
  [2173] = 2173,
  [2174] = 2141,
  [2175] = 2175,
  [2176] = 2176,
  [2177] = 2176,
  [2178] = 2042,
  [2179] = 2037,
  [2180] = 2180,
  [2181] = 2181,
  [2182] = 2141,
  [2183] = 2173,
  [2184] = 2039,
  [2185] = 2185,
  [2186] = 2186,
  [2187] = 2141,
  [2188] = 2188,
  [2189] = 2145,
  [2190] = 2045,
  [2191] = 2038,
  [2192] = 2171,
  [2193] = 2193,
  [2194] = 2052,
  [2195] = 2185,
  [2196] = 2196,
  [2197] = 2197,
  [2198] = 2042,
  [2199] = 2199,
  [2200] = 2176,
  [2201] = 2201,
  [2202] = 2193,
  [2203] = 2193,
  [2204] = 2204,
  [2205] = 2108,
  [2206] = 2045,
  [2207] = 2053,
  [2208] = 2038,
  [2209] = 2051,
  [2210] = 2037,
  [2211] = 2052,
  [2212] = 2185,
  [2213] = 2051,
  [2214] = 2048,
  [2215] = 2215,
  [2216] = 2204,
  [2217] = 2217,
  [2218] = 2204,
  [2219] = 2219,
  [2220] = 2220,
  [2221] = 2221,
  [2222] = 2222,
  [2223] = 2159,
  [2224] = 2224,
  [2225] = 2125,
  [2226] = 2226,
  [2227] = 2227,
  [2228] = 2228,
  [2229] = 2229,
  [2230] = 2230,
  [2231] = 2226,
  [2232] = 2219,
  [2233] = 2230,
  [2234] = 2234,
  [2235] = 2235,
  [2236] = 2236,
  [2237] = 2236,
  [2238] = 2228,
  [2239] = 2226,
  [2240] = 2219,
  [2241] = 2241,
  [2242] = 2226,
  [2243] = 2108,
  [2244] = 2234,
  [2245] = 2245,
  [2246] = 2153,
  [2247] = 2247,
  [2248] = 2159,
  [2249] = 2226,
  [2250] = 2108,
  [2251] = 2228,
  [2252] = 2234,
  [2253] = 2159,
  [2254] = 2254,
  [2255] = 2125,
  [2256] = 2125,
  [2257] = 2226,
  [2258] = 2204,
  [2259] = 2153,
  [2260] = 2260,
  [2261] = 2230,
  [2262] = 2262,
  [2263] = 2153,
  [2264] = 2262,
  [2265] = 2265,
  [2266] = 2226,
  [2267] = 2247,
  [2268] = 2226,
  [2269] = 2269,
  [2270] = 2128,
  [2271] = 2125,
  [2272] = 2272,
  [2273] = 2273,
  [2274] = 2274,
  [2275] = 2275,
  [2276] = 2276,
  [2277] = 2180,
  [2278] = 2278,
  [2279] = 2279,
  [2280] = 2280,
  [2281] = 2281,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2284,
  [2285] = 2022,
  [2286] = 2286,
  [2287] = 2287,
  [2288] = 2288,
  [2289] = 2289,
  [2290] = 2275,
  [2291] = 2265,
  [2292] = 2272,
  [2293] = 2273,
  [2294] = 2294,
  [2295] = 2295,
  [2296] = 2145,
  [2297] = 2297,
  [2298] = 2298,
  [2299] = 2299,
  [2300] = 2300,
  [2301] = 2301,
  [2302] = 2302,
  [2303] = 2303,
  [2304] = 2283,
  [2305] = 2305,
  [2306] = 2306,
  [2307] = 2307,
  [2308] = 2181,
  [2309] = 2024,
  [2310] = 2310,
  [2311] = 2311,
  [2312] = 2180,
  [2313] = 2145,
  [2314] = 2314,
  [2315] = 2315,
  [2316] = 2153,
  [2317] = 2317,
  [2318] = 2279,
  [2319] = 2286,
  [2320] = 2320,
  [2321] = 2321,
  [2322] = 2322,
  [2323] = 2302,
  [2324] = 2324,
  [2325] = 2325,
  [2326] = 2326,
  [2327] = 2281,
  [2328] = 2328,
  [2329] = 2329,
  [2330] = 2302,
  [2331] = 2331,
  [2332] = 2265,
  [2333] = 2275,
  [2334] = 2272,
  [2335] = 2275,
  [2336] = 2336,
  [2337] = 2321,
  [2338] = 2306,
  [2339] = 2286,
  [2340] = 2307,
  [2341] = 2341,
  [2342] = 2299,
  [2343] = 2298,
  [2344] = 2344,
  [2345] = 2180,
  [2346] = 2346,
  [2347] = 2347,
  [2348] = 2336,
  [2349] = 2341,
  [2350] = 2300,
  [2351] = 2301,
  [2352] = 2352,
  [2353] = 2276,
  [2354] = 2354,
  [2355] = 2346,
  [2356] = 2354,
  [2357] = 2307,
  [2358] = 2229,
  [2359] = 2303,
  [2360] = 2269,
  [2361] = 2294,
  [2362] = 2306,
  [2363] = 2320,
  [2364] = 2276,
  [2365] = 2128,
  [2366] = 2145,
  [2367] = 2325,
  [2368] = 2159,
  [2369] = 2128,
  [2370] = 2294,
  [2371] = 2229,
  [2372] = 2336,
  [2373] = 2320,
  [2374] = 2374,
  [2375] = 2321,
  [2376] = 2229,
  [2377] = 2265,
  [2378] = 2281,
  [2379] = 2379,
  [2380] = 2325,
  [2381] = 2331,
  [2382] = 2289,
  [2383] = 2383,
  [2384] = 2384,
  [2385] = 2385,
  [2386] = 2346,
  [2387] = 2354,
  [2388] = 2388,
  [2389] = 2269,
  [2390] = 2390,
  [2391] = 2317,
  [2392] = 2385,
  [2393] = 2393,
  [2394] = 2274,
  [2395] = 2278,
  [2396] = 2396,
  [2397] = 2397,
  [2398] = 2289,
  [2399] = 2399,
  [2400] = 2384,
  [2401] = 2401,
  [2402] = 2402,
  [2403] = 2383,
  [2404] = 2404,
  [2405] = 2278,
  [2406] = 2379,
  [2407] = 2274,
  [2408] = 2379,
  [2409] = 2409,
  [2410] = 2025,
  [2411] = 2326,
  [2412] = 2412,
  [2413] = 2413,
  [2414] = 2325,
  [2415] = 2415,
  [2416] = 2416,
  [2417] = 2417,
  [2418] = 2418,
  [2419] = 2419,
  [2420] = 2298,
  [2421] = 2299,
  [2422] = 2422,
  [2423] = 2331,
  [2424] = 2328,
  [2425] = 2425,
  [2426] = 2426,
  [2427] = 2427,
  [2428] = 2428,
  [2429] = 2429,
  [2430] = 2430,
  [2431] = 2020,
  [2432] = 2430,
  [2433] = 2019,
  [2434] = 2430,
  [2435] = 2383,
  [2436] = 2436,
  [2437] = 2437,
  [2438] = 2438,
  [2439] = 2346,
  [2440] = 2440,
  [2441] = 2354,
  [2442] = 2442,
  [2443] = 2443,
  [2444] = 2269,
  [2445] = 2445,
  [2446] = 2234,
  [2447] = 2447,
  [2448] = 2328,
  [2449] = 2449,
  [2450] = 2412,
  [2451] = 2281,
  [2452] = 2452,
  [2453] = 2331,
  [2454] = 2022,
  [2455] = 2383,
  [2456] = 2456,
  [2457] = 2379,
  [2458] = 2274,
  [2459] = 2447,
  [2460] = 2023,
  [2461] = 2461,
  [2462] = 2462,
  [2463] = 2463,
  [2464] = 2396,
  [2465] = 2465,
  [2466] = 2399,
  [2467] = 2467,
  [2468] = 2385,
  [2469] = 2413,
  [2470] = 2442,
  [2471] = 2413,
  [2472] = 2472,
  [2473] = 2180,
  [2474] = 2289,
  [2475] = 2321,
  [2476] = 2430,
  [2477] = 2477,
  [2478] = 2478,
  [2479] = 2479,
  [2480] = 2416,
  [2481] = 2481,
  [2482] = 2383,
  [2483] = 2024,
  [2484] = 2383,
  [2485] = 2399,
  [2486] = 2438,
  [2487] = 2487,
  [2488] = 2422,
  [2489] = 2383,
  [2490] = 2328,
  [2491] = 2491,
  [2492] = 2298,
  [2493] = 2294,
  [2494] = 2494,
  [2495] = 2383,
  [2496] = 2496,
  [2497] = 2278,
  [2498] = 2299,
  [2499] = 2310,
  [2500] = 2500,
  [2501] = 2501,
  [2502] = 2502,
  [2503] = 2412,
  [2504] = 2504,
  [2505] = 2505,
  [2506] = 2456,
  [2507] = 2507,
  [2508] = 2449,
  [2509] = 2509,
  [2510] = 2496,
  [2511] = 2417,
  [2512] = 2512,
  [2513] = 2481,
  [2514] = 2514,
  [2515] = 2515,
  [2516] = 2472,
  [2517] = 2502,
  [2518] = 2401,
  [2519] = 2481,
  [2520] = 2415,
  [2521] = 2521,
  [2522] = 2417,
  [2523] = 2523,
  [2524] = 2501,
  [2525] = 2507,
  [2526] = 2526,
  [2527] = 2404,
  [2528] = 2528,
  [2529] = 2529,
  [2530] = 2418,
  [2531] = 2472,
  [2532] = 2425,
  [2533] = 2533,
  [2534] = 2534,
  [2535] = 2428,
  [2536] = 2415,
  [2537] = 2429,
  [2538] = 2538,
  [2539] = 2539,
  [2540] = 2496,
  [2541] = 2541,
  [2542] = 2417,
  [2543] = 2443,
  [2544] = 2427,
  [2545] = 2397,
  [2546] = 2404,
  [2547] = 2418,
  [2548] = 2472,
  [2549] = 2425,
  [2550] = 2429,
  [2551] = 2523,
  [2552] = 2552,
  [2553] = 2456,
  [2554] = 2467,
  [2555] = 2412,
  [2556] = 2501,
  [2557] = 2538,
  [2558] = 2467,
  [2559] = 2409,
  [2560] = 2560,
  [2561] = 2463,
  [2562] = 2463,
  [2563] = 2462,
  [2564] = 2564,
  [2565] = 2565,
  [2566] = 2452,
  [2567] = 2491,
  [2568] = 2568,
  [2569] = 2569,
  [2570] = 2523,
  [2571] = 2487,
  [2572] = 2572,
  [2573] = 2573,
  [2574] = 2574,
  [2575] = 2449,
  [2576] = 2576,
  [2577] = 2402,
  [2578] = 2501,
  [2579] = 2515,
  [2580] = 2523,
  [2581] = 2401,
  [2582] = 2533,
  [2583] = 2462,
  [2584] = 2452,
  [2585] = 2487,
  [2586] = 2509,
  [2587] = 2487,
  [2588] = 2588,
  [2589] = 2456,
  [2590] = 2590,
  [2591] = 2449,
  [2592] = 2429,
  [2593] = 2477,
  [2594] = 2425,
  [2595] = 2595,
  [2596] = 2538,
  [2597] = 2477,
  [2598] = 2598,
  [2599] = 2418,
  [2600] = 2600,
  [2601] = 2601,
  [2602] = 2428,
  [2603] = 2443,
  [2604] = 2528,
  [2605] = 2427,
  [2606] = 2504,
  [2607] = 2409,
  [2608] = 2402,
  [2609] = 2538,
  [2610] = 2401,
  [2611] = 2611,
  [2612] = 2428,
  [2613] = 2600,
  [2614] = 2614,
  [2615] = 2615,
  [2616] = 2443,
  [2617] = 2572,
  [2618] = 2427,
  [2619] = 2426,
  [2620] = 2620,
  [2621] = 2452,
  [2622] = 2445,
  [2623] = 2623,
  [2624] = 2478,
  [2625] = 2409,
  [2626] = 2402,
  [2627] = 2462,
  [2628] = 2463,
  [2629] = 2440,
  [2630] = 2467,
  [2631] = 2631,
  [2632] = 2404,
  [2633] = 2477,
  [2634] = 2634,
  [2635] = 2505,
  [2636] = 2636,
  [2637] = 2637,
  [2638] = 2521,
  [2639] = 2639,
  [2640] = 2481,
  [2641] = 2496,
  [2642] = 2415,
  [2643] = 2643,
  [2644] = 2644,
  [2645] = 2645,
  [2646] = 2646,
  [2647] = 2647,
  [2648] = 2648,
  [2649] = 2649,
  [2650] = 2650,
  [2651] = 2024,
  [2652] = 2310,
  [2653] = 2653,
  [2654] = 2654,
  [2655] = 2326,
  [2656] = 2656,
  [2657] = 2657,
  [2658] = 2658,
  [2659] = 2659,
  [2660] = 2660,
  [2661] = 2661,
  [2662] = 2662,
  [2663] = 2663,
  [2664] = 2664,
  [2665] = 2665,
  [2666] = 2666,
  [2667] = 2514,
  [2668] = 2668,
  [2669] = 2669,
  [2670] = 2615,
  [2671] = 2671,
  [2672] = 2620,
  [2673] = 2636,
  [2674] = 687,
  [2675] = 2636,
  [2676] = 2620,
  [2677] = 2677,
  [2678] = 2662,
  [2679] = 2615,
  [2680] = 2680,
  [2681] = 2326,
  [2682] = 2669,
  [2683] = 2683,
  [2684] = 2684,
  [2685] = 2310,
  [2686] = 2684,
  [2687] = 2687,
  [2688] = 2352,
  [2689] = 2514,
  [2690] = 2620,
  [2691] = 2315,
  [2692] = 2692,
  [2693] = 2314,
  [2694] = 2694,
  [2695] = 2695,
  [2696] = 2311,
  [2697] = 1378,
  [2698] = 2698,
  [2699] = 2666,
  [2700] = 2700,
  [2701] = 2701,
  [2702] = 2702,
  [2703] = 2703,
  [2704] = 2704,
  [2705] = 2646,
  [2706] = 2706,
  [2707] = 2707,
  [2708] = 2295,
  [2709] = 2284,
  [2710] = 2282,
  [2711] = 2711,
  [2712] = 2712,
  [2713] = 663,
  [2714] = 2677,
  [2715] = 1316,
  [2716] = 2703,
  [2717] = 2326,
  [2718] = 2718,
  [2719] = 2719,
  [2720] = 2514,
  [2721] = 2668,
  [2722] = 2722,
  [2723] = 2658,
  [2724] = 2694,
  [2725] = 2644,
  [2726] = 2726,
  [2727] = 2310,
  [2728] = 2728,
  [2729] = 2663,
  [2730] = 2719,
  [2731] = 2659,
  [2732] = 2732,
  [2733] = 2653,
  [2734] = 2666,
  [2735] = 2650,
  [2736] = 2574,
  [2737] = 2647,
  [2738] = 2728,
  [2739] = 2739,
  [2740] = 2740,
  [2741] = 2322,
  [2742] = 2024,
  [2743] = 695,
  [2744] = 2744,
  [2745] = 2745,
  [2746] = 2746,
  [2747] = 705,
  [2748] = 2748,
  [2749] = 2749,
  [2750] = 2750,
  [2751] = 2751,
  [2752] = 2752,
  [2753] = 2753,
  [2754] = 2754,
  [2755] = 2739,
  [2756] = 2756,
  [2757] = 2757,
  [2758] = 2758,
  [2759] = 2759,
  [2760] = 2760,
  [2761] = 2745,
  [2762] = 2754,
  [2763] = 2744,
  [2764] = 2764,
  [2765] = 2765,
  [2766] = 2732,
  [2767] = 2767,
  [2768] = 2726,
  [2769] = 2698,
  [2770] = 2770,
  [2771] = 2771,
  [2772] = 2772,
  [2773] = 2773,
  [2774] = 2774,
  [2775] = 2775,
  [2776] = 2702,
  [2777] = 2777,
  [2778] = 2778,
  [2779] = 2779,
  [2780] = 2780,
  [2781] = 2781,
  [2782] = 2739,
  [2783] = 2783,
  [2784] = 2784,
  [2785] = 2785,
  [2786] = 2786,
  [2787] = 2787,
  [2788] = 2662,
  [2789] = 2789,
  [2790] = 2790,
  [2791] = 2645,
  [2792] = 2792,
  [2793] = 2650,
  [2794] = 2684,
  [2795] = 2795,
  [2796] = 2653,
  [2797] = 2722,
  [2798] = 2798,
  [2799] = 2799,
  [2800] = 2659,
  [2801] = 2801,
  [2802] = 2802,
  [2803] = 2803,
  [2804] = 2695,
  [2805] = 2663,
  [2806] = 2757,
  [2807] = 2807,
  [2808] = 2808,
  [2809] = 2700,
  [2810] = 2025,
  [2811] = 2664,
  [2812] = 2647,
  [2813] = 2704,
  [2814] = 2661,
  [2815] = 2687,
  [2816] = 2728,
  [2817] = 2817,
  [2818] = 2818,
  [2819] = 2712,
  [2820] = 2564,
  [2821] = 2569,
  [2822] = 2822,
  [2823] = 676,
  [2824] = 2824,
  [2825] = 2718,
  [2826] = 2719,
  [2827] = 2801,
  [2828] = 2828,
  [2829] = 2722,
  [2830] = 2830,
  [2831] = 2718,
  [2832] = 2722,
  [2833] = 2539,
  [2834] = 2669,
  [2835] = 2835,
  [2836] = 2663,
  [2837] = 2711,
  [2838] = 2659,
  [2839] = 2799,
  [2840] = 2653,
  [2841] = 2798,
  [2842] = 2650,
  [2843] = 2565,
  [2844] = 2739,
  [2845] = 2784,
  [2846] = 2650,
  [2847] = 2795,
  [2848] = 2719,
  [2849] = 2718,
  [2850] = 2695,
  [2851] = 2653,
  [2852] = 2722,
  [2853] = 2746,
  [2854] = 2748,
  [2855] = 2650,
  [2856] = 2653,
  [2857] = 2754,
  [2858] = 2601,
  [2859] = 2722,
  [2860] = 2712,
  [2861] = 2749,
  [2862] = 2750,
  [2863] = 2745,
  [2864] = 2830,
  [2865] = 2744,
  [2866] = 2828,
  [2867] = 2650,
  [2868] = 2732,
  [2869] = 2752,
  [2870] = 2726,
  [2871] = 2871,
  [2872] = 2653,
  [2873] = 2707,
  [2874] = 2706,
  [2875] = 2659,
  [2876] = 2663,
  [2877] = 2702,
  [2878] = 2704,
  [2879] = 2700,
  [2880] = 2756,
  [2881] = 2881,
  [2882] = 2722,
  [2883] = 2700,
  [2884] = 2790,
  [2885] = 2758,
  [2886] = 2759,
  [2887] = 2662,
  [2888] = 2719,
  [2889] = 2695,
  [2890] = 2718,
  [2891] = 2683,
  [2892] = 2712,
  [2893] = 2684,
  [2894] = 2704,
  [2895] = 2700,
  [2896] = 2704,
  [2897] = 2764,
  [2898] = 2695,
  [2899] = 2765,
  [2900] = 2684,
  [2901] = 2695,
  [2902] = 2662,
  [2903] = 2767,
  [2904] = 2770,
  [2905] = 2905,
  [2906] = 2700,
  [2907] = 2771,
  [2908] = 2754,
  [2909] = 2772,
  [2910] = 2704,
  [2911] = 2773,
  [2912] = 2650,
  [2913] = 2653,
  [2914] = 2803,
  [2915] = 2712,
  [2916] = 2659,
  [2917] = 2663,
  [2918] = 2774,
  [2919] = 2722,
  [2920] = 2775,
  [2921] = 2718,
  [2922] = 2719,
  [2923] = 2684,
  [2924] = 2719,
  [2925] = 2722,
  [2926] = 2718,
  [2927] = 2712,
  [2928] = 2706,
  [2929] = 2712,
  [2930] = 2663,
  [2931] = 2707,
  [2932] = 2659,
  [2933] = 2817,
  [2934] = 2653,
  [2935] = 2704,
  [2936] = 2650,
  [2937] = 2662,
  [2938] = 2778,
  [2939] = 2700,
  [2940] = 2664,
  [2941] = 2732,
  [2942] = 2792,
  [2943] = 2780,
  [2944] = 2695,
  [2945] = 2789,
  [2946] = 2807,
  [2947] = 2818,
  [2948] = 2684,
  [2949] = 2662,
  [2950] = 2662,
  [2951] = 2787,
  [2952] = 2745,
  [2953] = 2744,
  [2954] = 2684,
  [2955] = 2702,
  [2956] = 2760,
  [2957] = 2957,
  [2958] = 2958,
  [2959] = 2959,
  [2960] = 2781,
  [2961] = 2695,
  [2962] = 2726,
  [2963] = 2783,
  [2964] = 2650,
  [2965] = 2965,
  [2966] = 2700,
  [2967] = 2785,
  [2968] = 2653,
  [2969] = 2871,
  [2970] = 2704,
  [2971] = 2659,
  [2972] = 2643,
  [2973] = 2663,
  [2974] = 2712,
  [2975] = 2657,
  [2976] = 2722,
  [2977] = 2786,
  [2978] = 2719,
  [2979] = 2718,
  [2980] = 2980,
  [2981] = 2981,
  [2982] = 2982,
  [2983] = 2983,
  [2984] = 2984,
  [2985] = 2023,
  [2986] = 2986,
  [2987] = 2987,
  [2988] = 2988,
  [2989] = 2989,
  [2990] = 2990,
  [2991] = 2991,
  [2992] = 2992,
  [2993] = 2989,
  [2994] = 2020,
  [2995] = 2995,
  [2996] = 2996,
  [2997] = 2997,
  [2998] = 2998,
  [2999] = 2999,
  [3000] = 3000,
  [3001] = 3001,
  [3002] = 2984,
  [3003] = 3003,
  [3004] = 2437,
  [3005] = 3005,
  [3006] = 3006,
  [3007] = 3007,
  [3008] = 2998,
  [3009] = 3009,
  [3010] = 3010,
  [3011] = 3011,
  [3012] = 2983,
  [3013] = 3013,
  [3014] = 3011,
  [3015] = 3015,
  [3016] = 2025,
  [3017] = 3017,
  [3018] = 3018,
  [3019] = 3018,
  [3020] = 3013,
  [3021] = 2019,
  [3022] = 3022,
  [3023] = 3023,
  [3024] = 3024,
  [3025] = 3025,
  [3026] = 3026,
  [3027] = 2988,
  [3028] = 3007,
  [3029] = 2982,
  [3030] = 2997,
  [3031] = 2997,
  [3032] = 2996,
  [3033] = 3033,
  [3034] = 3005,
  [3035] = 2995,
  [3036] = 2751,
  [3037] = 2996,
  [3038] = 2995,
  [3039] = 3039,
  [3040] = 3040,
  [3041] = 2779,
  [3042] = 3042,
  [3043] = 3001,
  [3044] = 2023,
  [3045] = 3045,
  [3046] = 3046,
  [3047] = 3047,
  [3048] = 3048,
  [3049] = 3049,
  [3050] = 3033,
  [3051] = 3051,
  [3052] = 3033,
  [3053] = 3001,
  [3054] = 3025,
  [3055] = 3024,
  [3056] = 3049,
  [3057] = 3048,
  [3058] = 3058,
  [3059] = 3059,
  [3060] = 3060,
  [3061] = 3061,
  [3062] = 3062,
  [3063] = 3048,
  [3064] = 2020,
  [3065] = 3065,
  [3066] = 3066,
  [3067] = 3026,
  [3068] = 676,
  [3069] = 2987,
  [3070] = 2437,
  [3071] = 3071,
  [3072] = 3072,
  [3073] = 695,
  [3074] = 687,
  [3075] = 663,
  [3076] = 3076,
  [3077] = 3049,
  [3078] = 3048,
  [3079] = 2019,
  [3080] = 3049,
  [3081] = 3081,
  [3082] = 3082,
  [3083] = 3072,
  [3084] = 3033,
  [3085] = 705,
  [3086] = 3071,
  [3087] = 2437,
  [3088] = 3001,
  [3089] = 3089,
  [3090] = 3090,
  [3091] = 2824,
  [3092] = 3092,
  [3093] = 3093,
  [3094] = 3094,
  [3095] = 3095,
  [3096] = 3096,
  [3097] = 3097,
  [3098] = 3098,
  [3099] = 3099,
  [3100] = 3100,
  [3101] = 3101,
  [3102] = 3102,
  [3103] = 3103,
  [3104] = 3104,
  [3105] = 3105,
  [3106] = 3106,
  [3107] = 3107,
  [3108] = 3108,
  [3109] = 3109,
  [3110] = 3110,
  [3111] = 3111,
  [3112] = 3112,
  [3113] = 3102,
  [3114] = 3095,
  [3115] = 3103,
  [3116] = 3116,
  [3117] = 3117,
  [3118] = 3118,
  [3119] = 3094,
  [3120] = 3120,
  [3121] = 3095,
  [3122] = 3109,
  [3123] = 3099,
  [3124] = 3101,
  [3125] = 3107,
  [3126] = 3103,
  [3127] = 3127,
  [3128] = 3104,
  [3129] = 3104,
  [3130] = 3098,
  [3131] = 3103,
  [3132] = 3117,
  [3133] = 3133,
  [3134] = 3102,
  [3135] = 3101,
  [3136] = 3136,
  [3137] = 3137,
  [3138] = 3098,
  [3139] = 3139,
  [3140] = 3140,
  [3141] = 3141,
  [3142] = 3142,
  [3143] = 3143,
  [3144] = 3133,
  [3145] = 3098,
  [3146] = 3120,
  [3147] = 3140,
  [3148] = 3148,
  [3149] = 3149,
  [3150] = 3150,
  [3151] = 3095,
  [3152] = 3094,
  [3153] = 3153,
  [3154] = 3110,
  [3155] = 3155,
  [3156] = 3109,
  [3157] = 3093,
  [3158] = 3107,
  [3159] = 3159,
  [3160] = 3140,
  [3161] = 3140,
  [3162] = 3098,
  [3163] = 3105,
  [3164] = 3164,
  [3165] = 3104,
  [3166] = 3166,
  [3167] = 3167,
  [3168] = 3168,
  [3169] = 3169,
  [3170] = 3127,
  [3171] = 3103,
  [3172] = 3102,
  [3173] = 3101,
  [3174] = 3133,
  [3175] = 3133,
  [3176] = 3117,
  [3177] = 3140,
  [3178] = 3139,
  [3179] = 3108,
  [3180] = 3127,
  [3181] = 3096,
  [3182] = 3182,
  [3183] = 3100,
  [3184] = 3184,
  [3185] = 3185,
  [3186] = 3100,
  [3187] = 3136,
  [3188] = 3139,
  [3189] = 3189,
  [3190] = 3190,
  [3191] = 3190,
  [3192] = 3101,
  [3193] = 3102,
  [3194] = 3103,
  [3195] = 3195,
  [3196] = 3196,
  [3197] = 3104,
  [3198] = 3198,
  [3199] = 3105,
  [3200] = 3200,
  [3201] = 3116,
  [3202] = 3116,
  [3203] = 3105,
  [3204] = 3204,
  [3205] = 3205,
  [3206] = 3206,
  [3207] = 3107,
  [3208] = 3106,
  [3209] = 3109,
  [3210] = 3139,
  [3211] = 3094,
  [3212] = 3095,
  [3213] = 3213,
  [3214] = 3214,
  [3215] = 3215,
  [3216] = 2665,
  [3217] = 3217,
  [3218] = 3127,
  [3219] = 3133,
  [3220] = 3220,
  [3221] = 3166,
  [3222] = 3098,
  [3223] = 3108,
  [3224] = 3096,
  [3225] = 3094,
  [3226] = 3098,
  [3227] = 3142,
  [3228] = 3095,
  [3229] = 3229,
  [3230] = 3094,
  [3231] = 3093,
  [3232] = 3232,
  [3233] = 3100,
  [3234] = 3155,
  [3235] = 3235,
  [3236] = 3168,
  [3237] = 3098,
  [3238] = 3238,
  [3239] = 3109,
  [3240] = 3107,
  [3241] = 3095,
  [3242] = 3094,
  [3243] = 3110,
  [3244] = 3109,
  [3245] = 3107,
  [3246] = 3105,
  [3247] = 2753,
  [3248] = 3104,
  [3249] = 3103,
  [3250] = 3110,
  [3251] = 3104,
  [3252] = 3102,
  [3253] = 3116,
  [3254] = 3101,
  [3255] = 3103,
  [3256] = 3167,
  [3257] = 3257,
  [3258] = 3133,
  [3259] = 3259,
  [3260] = 3117,
  [3261] = 3166,
  [3262] = 3140,
  [3263] = 3263,
  [3264] = 3139,
  [3265] = 3265,
  [3266] = 3127,
  [3267] = 3102,
  [3268] = 3101,
  [3269] = 3127,
  [3270] = 3270,
  [3271] = 3096,
  [3272] = 3096,
  [3273] = 3159,
  [3274] = 3274,
  [3275] = 3182,
  [3276] = 3276,
  [3277] = 3100,
  [3278] = 3278,
  [3279] = 3092,
  [3280] = 3109,
  [3281] = 3133,
  [3282] = 3140,
  [3283] = 3184,
  [3284] = 3284,
  [3285] = 3285,
  [3286] = 3127,
  [3287] = 3287,
  [3288] = 3100,
  [3289] = 3100,
  [3290] = 3290,
  [3291] = 3291,
  [3292] = 3107,
  [3293] = 3127,
  [3294] = 3238,
  [3295] = 3140,
  [3296] = 3133,
  [3297] = 3100,
  [3298] = 3101,
  [3299] = 3299,
  [3300] = 3300,
  [3301] = 3301,
  [3302] = 3259,
  [3303] = 3303,
  [3304] = 3304,
  [3305] = 3102,
  [3306] = 3257,
  [3307] = 3103,
  [3308] = 3308,
  [3309] = 3104,
  [3310] = 3107,
  [3311] = 3109,
  [3312] = 3312,
  [3313] = 3229,
  [3314] = 3103,
  [3315] = 3291,
  [3316] = 3316,
  [3317] = 3317,
  [3318] = 3299,
  [3319] = 3232,
  [3320] = 3205,
  [3321] = 3185,
  [3322] = 3149,
  [3323] = 3143,
  [3324] = 3137,
  [3325] = 3265,
  [3326] = 3301,
  [3327] = 3284,
  [3328] = 3214,
  [3329] = 3220,
  [3330] = 3200,
  [3331] = 3198,
  [3332] = 3189,
  [3333] = 3097,
  [3334] = 3291,
  [3335] = 3335,
  [3336] = 3164,
  [3337] = 3290,
  [3338] = 3235,
  [3339] = 3204,
  [3340] = 3148,
  [3341] = 3094,
  [3342] = 3317,
  [3343] = 3150,
  [3344] = 3095,
  [3345] = 3215,
  [3346] = 3217,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6},
  {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f}, {0x671, 0x6d3},
  {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5},
  {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828},
  {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950},
  {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10},
  {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa72, 0xa74},
  {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0},
  {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xc05, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61}, {0xc80, 0xc80},
  {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1},
  {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd5f, 0xd61},
  {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30}, {0xe32, 0xe32},
  {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb2},
  {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c}, {0xf88, 0xf8c},
  {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081},
  {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd},
  {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751},
  {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18aa, 0x18aa},
  {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54},
  {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f},
  {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa},
  {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e},
  {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9},
  {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb},
  {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef},
  {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1},
  {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06},
  {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3},
  {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28},
  {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d},
  {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf},
  {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d},
  {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d},
  {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
  {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808},
  {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5},
  {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27},
  {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11075, 0x11075}, {0x11083, 0x110af},
  {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176}, {0x11183, 0x111b2}, {0x111c1, 0x111c4},
  {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d},
  {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339},
  {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461}, {0x11480, 0x114af}, {0x114c4, 0x114c5},
  {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa}, {0x116b8, 0x116b8}, {0x11700, 0x1171a},
  {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x1192f},
  {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3}, {0x11a00, 0x11a00}, {0x11a0b, 0x11a32},
  {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e}, {0x11c40, 0x11c40},
  {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d89},
  {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342e},
  {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77},
  {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7},
  {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b150, 0x1b152}, {0x1b164, 0x1b167},
  {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f},
  {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a},
  {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5},
  {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788},
  {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ad},
  {0x1e2c0, 0x1e2eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b},
  {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39},
  {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54},
  {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a},
  {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9},
  {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b738}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xb7, 0xb7}, {0xba, 0xba},
  {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x300, 0x374},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481},
  {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd}, {0x5bf, 0x5bf}, {0x5c1, 0x5c2},
  {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669}, {0x66e, 0x6d3}, {0x6d5, 0x6dc},
  {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5}, {0x7fa, 0x7fa}, {0x7fd, 0x7fd},
  {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1}, {0x8e3, 0x963}, {0x966, 0x96f},
  {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bc, 0x9c4},
  {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1}, {0x9fc, 0x9fc}, {0x9fe, 0x9fe},
  {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39},
  {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa66, 0xa75},
  {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabc, 0xac5},
  {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff}, {0xb01, 0xb03}, {0xb05, 0xb0c},
  {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44}, {0xb47, 0xb48}, {0xb4b, 0xb4d},
  {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90},
  {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbbe, 0xbc2},
  {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28},
  {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc63},
  {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbc, 0xcc4},
  {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef}, {0xcf1, 0xcf2}, {0xd00, 0xd0c},
  {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63}, {0xd66, 0xd6f}, {0xd7a, 0xd7f},
  {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xdca, 0xdca}, {0xdcf, 0xdd4},
  {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e}, {0xe50, 0xe59}, {0xe81, 0xe82},
  {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xec8, 0xecd},
  {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35}, {0xf37, 0xf37}, {0xf39, 0xf39},
  {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6}, {0x1000, 0x1049}, {0x1050, 0x109d},
  {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258},
  {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5},
  {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f}, {0x13a0, 0x13f5},
  {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715}, {0x171f, 0x1734},
  {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dd}, {0x17e0, 0x17e9},
  {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b},
  {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c},
  {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73},
  {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2},
  {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x203f, 0x2040}, {0x2054, 0x2054}, {0x2071, 0x2071}, {0x207f, 0x207f},
  {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115},
  {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e},
  {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f},
  {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6},
  {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096}, {0x3099, 0x309a},
  {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf},
  {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1}, {0xa717, 0xa71f},
  {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c}, {0xa840, 0xa873},
  {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c}, {0xa980, 0xa9c0},
  {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, {0xaadb, 0xaadd},
  {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a},
  {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d},
  {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41},
  {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f},
  {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff66, 0xffbe}, {0xffc2, 0xffc7},
  {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d},
  {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0}, {0x10300, 0x1031f},
  {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9},
  {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595},
  {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785},
  {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855},
  {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf},
  {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f}, {0x10a60, 0x10a7c},
  {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48},
  {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c},
  {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075}, {0x1107f, 0x110ba},
  {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173}, {0x11176, 0x11176},
  {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x1123e}, {0x11280, 0x11286},
  {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c},
  {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d},
  {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459}, {0x1145e, 0x11461},
  {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640}, {0x11644, 0x11644},
  {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746}, {0x11800, 0x1183a},
  {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938}, {0x1193b, 0x11943},
  {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47}, {0x11a50, 0x11a99},
  {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7},
  {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, {0x11d50, 0x11d59},
  {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6}, {0x11fb0, 0x11fb0},
  {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342e}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e},
  {0x16a60, 0x16a69}, {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9}, {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59},
  {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4},
  {0x16ff0, 0x16ff1}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122},
  {0x1b150, 0x1b152}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e},
  {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244},
  {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb},
  {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544},
  {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734},
  {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36},
  {0x1da3b, 0x1da6c}, {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018},
  {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149}, {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae},
  {0x1e2c0, 0x1e2f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b},
  {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37},
  {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52},
  {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64},
  {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3},
  {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df}, {0x2a700, 0x2b738}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0},
  {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(59);
      if (lookahead == '\r') SKIP(55);
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '%') ADVANCE(98);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(63);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(94);
      if (lookahead == ',') ADVANCE(65);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(60);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(85);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == ']') ADVANCE(79);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == 'e') ADVANCE(164);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(90);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(107);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(55);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(141);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(169);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(133);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(3);
      if (lookahead == '\r') ADVANCE(136);
      if (lookahead == '#') ADVANCE(137);
      if (lookahead == '\\') ADVANCE(135);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '}') ADVANCE(92);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(136);
      if (lookahead != 0) ADVANCE(137);
      END_STATE();
    case 4:
      if (lookahead == '\r') SKIP(4);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '%') ADVANCE(98);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(63);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(94);
      if (lookahead == ',') ADVANCE(65);
      if (lookahead == '-') ADVANCE(87);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(60);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(24);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(85);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(90);
      if (lookahead == '~') ADVANCE(107);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(141);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 5:
      if (lookahead == '\r') SKIP(5);
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '%') ADVANCE(97);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(63);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == ',') ADVANCE(65);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '/') ADVANCE(96);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(60);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == ']') ADVANCE(79);
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(107);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(141);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 6:
      if (lookahead == '\r') SKIP(6);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '%') ADVANCE(22);
      if (lookahead == '&') ADVANCE(23);
      if (lookahead == '(') ADVANCE(63);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(94);
      if (lookahead == '-') ADVANCE(87);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ';') ADVANCE(60);
      if (lookahead == '<') ADVANCE(19);
      if (lookahead == '>') ADVANCE(33);
      if (lookahead == '@') ADVANCE(25);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '^') ADVANCE(26);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(27);
      if (lookahead == '~') ADVANCE(107);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(6);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(141);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 7:
      if (lookahead == '\r') SKIP(7);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '%') ADVANCE(98);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(63);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(94);
      if (lookahead == ',') ADVANCE(65);
      if (lookahead == '-') ADVANCE(87);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(60);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(85);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == ']') ADVANCE(79);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == '|') ADVANCE(90);
      if (lookahead == '}') ADVANCE(92);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(7);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 8:
      if (lookahead == '\r') SKIP(8);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '%') ADVANCE(98);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(63);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(94);
      if (lookahead == ',') ADVANCE(65);
      if (lookahead == '-') ADVANCE(87);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == ';') ADVANCE(60);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(85);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == ']') ADVANCE(79);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == '|') ADVANCE(90);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(8);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 9:
      if (lookahead == '\r') SKIP(9);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '-') ADVANCE(32);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == 'e') ADVANCE(164);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(9);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 10:
      if (lookahead == '\r') SKIP(10);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '-') ADVANCE(32);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(11);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(10);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 11:
      if (lookahead == '\r') ADVANCE(1);
      if ((!eof && lookahead == 00) ||
          lookahead == '\n') ADVANCE(169);
      END_STATE();
    case 12:
      if (lookahead == '\r') SKIP(12);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '%') ADVANCE(98);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(63);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(94);
      if (lookahead == ',') ADVANCE(65);
      if (lookahead == '-') ADVANCE(87);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == ';') ADVANCE(60);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(85);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(90);
      if (lookahead == '~') ADVANCE(107);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(12);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(141);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 13:
      if (lookahead == '\r') SKIP(13);
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '%') ADVANCE(97);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(63);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == ',') ADVANCE(65);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '/') ADVANCE(96);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == ';') ADVANCE(60);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == ']') ADVANCE(79);
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(107);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(13);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(141);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 14:
      if (lookahead == '\r') SKIP(14);
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '%') ADVANCE(97);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(63);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == ',') ADVANCE(65);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == '/') ADVANCE(96);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == ';') ADVANCE(60);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == ']') ADVANCE(79);
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '}') ADVANCE(92);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(14);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 15:
      if (lookahead == '\r') SKIP(15);
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '%') ADVANCE(97);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(63);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == ',') ADVANCE(65);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == '/') ADVANCE(96);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(60);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == ']') ADVANCE(79);
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '}') ADVANCE(92);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(15);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 17:
      if (lookahead == '.') ADVANCE(132);
      END_STATE();
    case 18:
      if (lookahead == '/') ADVANCE(29);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 19:
      if (lookahead == '<') ADVANCE(30);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 21:
      if (lookahead == '=') ADVANCE(113);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 25:
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 26:
      if (lookahead == '=') ADVANCE(130);
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 28:
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 29:
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 30:
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 31:
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 32:
      if (lookahead == '>') ADVANCE(80);
      END_STATE();
    case 33:
      if (lookahead == '>') ADVANCE(31);
      END_STATE();
    case 34:
      if (lookahead == '_') ADVANCE(40);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(143);
      END_STATE();
    case 35:
      if (lookahead == '_') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(144);
      END_STATE();
    case 36:
      if (lookahead == '_') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(145);
      END_STATE();
    case 37:
      if (lookahead == '{') ADVANCE(54);
      END_STATE();
    case 38:
      if (lookahead == '}') ADVANCE(133);
      if (lookahead != 0) ADVANCE(38);
      END_STATE();
    case 39:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 40:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(143);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(144);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(133);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(133);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(145);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 54:
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(38);
      END_STATE();
    case 55:
      if (eof) ADVANCE(59);
      if (lookahead == '\r') SKIP(55);
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '%') ADVANCE(98);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(63);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(94);
      if (lookahead == ',') ADVANCE(65);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(60);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(85);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == ']') ADVANCE(79);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == 'e') ADVANCE(164);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(90);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(107);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(55);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(141);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 56:
      if (eof) ADVANCE(59);
      if (lookahead == '\r') SKIP(56);
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '(') ADVANCE(63);
      if (lookahead == ')') ADVANCE(64);
      if (lookahead == '*') ADVANCE(66);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == ',') ADVANCE(65);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(73);
      if (lookahead == ';') ADVANCE(60);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == ']') ADVANCE(79);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(107);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(56);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(141);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 57:
      if (eof) ADVANCE(59);
      if (lookahead == '\r') SKIP(57);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '(') ADVANCE(63);
      if (lookahead == '*') ADVANCE(66);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '~') ADVANCE(107);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(57);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(141);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 58:
      if (eof) ADVANCE(59);
      if (lookahead == '\r') SKIP(58);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '(') ADVANCE(63);
      if (lookahead == '*') ADVANCE(66);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == 'e') ADVANCE(166);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '~') ADVANCE(107);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(58);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(141);
      if (set_contains(sym_identifier_character_set_1, 656, lookahead)) ADVANCE(167);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(82);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(81);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(28);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(72);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_except);
      if (lookahead == '*') ADVANCE(77);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_except);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_except_STAR);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(120);
      if (lookahead == '>') ADVANCE(80);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(100);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(99);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(130);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(106);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(114);
      if (lookahead == '>') ADVANCE(71);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(114);
      if (lookahead == '>') ADVANCE(70);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_AT_EQ);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_ellipsis);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym__not_escape_sequence);
      ADVANCE_MAP(
        0, 169,
        '\n', 133,
        '\r', 2,
        'N', 37,
        'U', 53,
        'u', 49,
        'x', 47,
        '"', 133,
        '\'', 133,
        '\\', 133,
        'a', 133,
        'b', 133,
        'f', 133,
        'n', 133,
        'r', 133,
        't', 133,
        'v', 133,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(44);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if ((!eof && lookahead == 00)) ADVANCE(137);
      if (lookahead == '\r') ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(137);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      ADVANCE_MAP(
        '\r', 136,
        '#', 137,
        '\\', 135,
        '\t', 136,
        0x0b, 136,
        '\f', 136,
        ' ', 136,
        0x200b, 136,
        0x2060, 136,
        0xfeff, 136,
      );
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(137);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(137);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_type_conversion);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_integer);
      ADVANCE_MAP(
        '.', 149,
        '_', 142,
        'B', 34,
        'b', 34,
        'E', 39,
        'e', 39,
        'O', 35,
        'o', 35,
        'X', 36,
        'x', 36,
        'J', 139,
        'L', 139,
        'j', 139,
        'l', 139,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(141);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_integer);
      ADVANCE_MAP(
        '.', 149,
        '_', 142,
        'E', 39,
        'e', 39,
        'J', 139,
        'L', 139,
        'j', 139,
        'l', 139,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(141);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(149);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(39);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(141);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(40);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(139);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(46);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(145);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_float);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(149);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(39);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(146);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(150);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(146);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(39);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(146);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(146);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '*') ADVANCE(77);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(155);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(156);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(157);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(158);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(159);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(160);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(161);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(162);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(163);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(75);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(76);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(151);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(152);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(153);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(154);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_identifier);
      if (set_contains(sym_identifier_character_set_2, 763, lookahead)) ADVANCE(167);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(168);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_line_continuation);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\r') SKIP(0);
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '_') ADVANCE(4);
      if (lookahead == 'a') ADVANCE(5);
      if (lookahead == 'b') ADVANCE(6);
      if (lookahead == 'c') ADVANCE(7);
      if (lookahead == 'd') ADVANCE(8);
      if (lookahead == 'e') ADVANCE(9);
      if (lookahead == 'f') ADVANCE(10);
      if (lookahead == 'g') ADVANCE(11);
      if (lookahead == 'i') ADVANCE(12);
      if (lookahead == 'l') ADVANCE(13);
      if (lookahead == 'm') ADVANCE(14);
      if (lookahead == 'n') ADVANCE(15);
      if (lookahead == 'o') ADVANCE(16);
      if (lookahead == 'p') ADVANCE(17);
      if (lookahead == 'r') ADVANCE(18);
      if (lookahead == 's') ADVANCE(19);
      if (lookahead == 't') ADVANCE(20);
      if (lookahead == 'v') ADVANCE(21);
      if (lookahead == 'w') ADVANCE(22);
      if (lookahead == 'y') ADVANCE(23);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'a') ADVANCE(24);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(26);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '_') ADVANCE(27);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(28);
      if (lookahead == 'n') ADVANCE(29);
      if (lookahead == 's') ADVANCE(30);
      if (lookahead == 'w') ADVANCE(31);
      END_STATE();
    case 6:
      if (lookahead == 'o') ADVANCE(32);
      if (lookahead == 'r') ADVANCE(33);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'l') ADVANCE(35);
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 9:
      if (lookahead == 'l') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(39);
      END_STATE();
    case 10:
      if (lookahead == 'i') ADVANCE(40);
      if (lookahead == 'n') ADVANCE(41);
      if (lookahead == 'o') ADVANCE(42);
      if (lookahead == 'r') ADVANCE(43);
      END_STATE();
    case 11:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 12:
      if (lookahead == 'f') ADVANCE(45);
      if (lookahead == 'm') ADVANCE(46);
      if (lookahead == 'n') ADVANCE(47);
      if (lookahead == 's') ADVANCE(48);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(49);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(50);
      END_STATE();
    case 15:
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 16:
      if (lookahead == 'r') ADVANCE(52);
      if (lookahead == 'w') ADVANCE(53);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(54);
      if (lookahead == 'r') ADVANCE(55);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(57);
      END_STATE();
    case 19:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 20:
      if (lookahead == 'r') ADVANCE(59);
      if (lookahead == 'y') ADVANCE(60);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(61);
      END_STATE();
    case 22:
      if (lookahead == 'h') ADVANCE(62);
      if (lookahead == 'i') ADVANCE(63);
      END_STATE();
    case 23:
      if (lookahead == 'i') ADVANCE(64);
      END_STATE();
    case 24:
      if (lookahead == 'l') ADVANCE(65);
      END_STATE();
    case 25:
      if (lookahead == 'n') ADVANCE(66);
      END_STATE();
    case 26:
      if (lookahead == 'u') ADVANCE(67);
      END_STATE();
    case 27:
      if (lookahead == 'f') ADVANCE(68);
      END_STATE();
    case 28:
      if (lookahead == 'i') ADVANCE(69);
      END_STATE();
    case 29:
      if (lookahead == 'd') ADVANCE(70);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(71);
      if (lookahead == 'y') ADVANCE(72);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(73);
      END_STATE();
    case 32:
      if (lookahead == 'r') ADVANCE(74);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 34:
      if (lookahead == 's') ADVANCE(76);
      END_STATE();
    case 35:
      if (lookahead == 'a') ADVANCE(77);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(78);
      END_STATE();
    case 37:
      if (lookahead == 'f') ADVANCE(79);
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 38:
      if (lookahead == 'i') ADVANCE(81);
      if (lookahead == 's') ADVANCE(82);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(84);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 42:
      if (lookahead == 'r') ADVANCE(85);
      END_STATE();
    case 43:
      if (lookahead == 'o') ADVANCE(86);
      END_STATE();
    case 44:
      if (lookahead == 'o') ADVANCE(87);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 46:
      if (lookahead == 'p') ADVANCE(88);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'o') ADVANCE(89);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 49:
      if (lookahead == 'm') ADVANCE(90);
      END_STATE();
    case 50:
      if (lookahead == 't') ADVANCE(91);
      END_STATE();
    case 51:
      if (lookahead == 'n') ADVANCE(92);
      if (lookahead == 't') ADVANCE(93);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 53:
      if (lookahead == 'n') ADVANCE(94);
      END_STATE();
    case 54:
      if (lookahead == 's') ADVANCE(95);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(96);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(98);
      END_STATE();
    case 58:
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 59:
      if (lookahead == 'y') ADVANCE(100);
      END_STATE();
    case 60:
      if (lookahead == 'p') ADVANCE(101);
      END_STATE();
    case 61:
      if (lookahead == 'r') ADVANCE(102);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(103);
      END_STATE();
    case 63:
      if (lookahead == 't') ADVANCE(104);
      END_STATE();
    case 64:
      if (lookahead == 'e') ADVANCE(105);
      END_STATE();
    case 65:
      if (lookahead == 's') ADVANCE(106);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(107);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 68:
      if (lookahead == 'u') ADVANCE(109);
      END_STATE();
    case 69:
      if (lookahead == 'a') ADVANCE(110);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(112);
      END_STATE();
    case 73:
      if (lookahead == 'i') ADVANCE(113);
      END_STATE();
    case 74:
      if (lookahead == 'r') ADVANCE(114);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(115);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 77:
      if (lookahead == 's') ADVANCE(117);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(118);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_del);
      END_STATE();
    case 81:
      if (lookahead == 'f') ADVANCE(119);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 83:
      if (lookahead == 'c') ADVANCE(121);
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(122);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 86:
      if (lookahead == 'm') ADVANCE(123);
      END_STATE();
    case 87:
      if (lookahead == 'b') ADVANCE(124);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(125);
      END_STATE();
    case 89:
      if (lookahead == 'u') ADVANCE(126);
      END_STATE();
    case 90:
      if (lookahead == 'b') ADVANCE(127);
      END_STATE();
    case 91:
      if (lookahead == 'c') ADVANCE(128);
      END_STATE();
    case 92:
      if (lookahead == 'l') ADVANCE(129);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 95:
      if (lookahead == 's') ADVANCE(131);
      END_STATE();
    case 96:
      if (lookahead == 'n') ADVANCE(132);
      END_STATE();
    case 97:
      if (lookahead == 's') ADVANCE(133);
      END_STATE();
    case 98:
      if (lookahead == 'u') ADVANCE(134);
      END_STATE();
    case 99:
      if (lookahead == 'u') ADVANCE(135);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(136);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 103:
      if (lookahead == 'l') ADVANCE(137);
      END_STATE();
    case 104:
      if (lookahead == 'h') ADVANCE(138);
      END_STATE();
    case 105:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(140);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(141);
      END_STATE();
    case 110:
      if (lookahead == 's') ADVANCE(142);
      END_STATE();
    case 111:
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 112:
      if (lookahead == 'c') ADVANCE(144);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 114:
      if (lookahead == 'o') ADVANCE(146);
      END_STATE();
    case 115:
      if (lookahead == 'k') ADVANCE(147);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 117:
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 118:
      if (lookahead == 'i') ADVANCE(149);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_exec);
      END_STATE();
    case 122:
      if (lookahead == 'l') ADVANCE(150);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 124:
      if (lookahead == 'a') ADVANCE(151);
      END_STATE();
    case 125:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(153);
      END_STATE();
    case 127:
      if (lookahead == 'd') ADVANCE(154);
      END_STATE();
    case 128:
      if (lookahead == 'h') ADVANCE(155);
      END_STATE();
    case 129:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 130:
      if (lookahead == 'd') ADVANCE(157);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_pass);
      END_STATE();
    case 132:
      if (lookahead == 't') ADVANCE(158);
      END_STATE();
    case 133:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 134:
      if (lookahead == 'r') ADVANCE(160);
      END_STATE();
    case 135:
      if (lookahead == 'c') ADVANCE(161);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 139:
      if (lookahead == 'd') ADVANCE(163);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 141:
      if (lookahead == 'u') ADVANCE(164);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_alias);
      END_STATE();
    case 143:
      if (lookahead == 't') ADVANCE(165);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 146:
      if (lookahead == 'w') ADVANCE(166);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(167);
      END_STATE();
    case 150:
      if (lookahead == 'l') ADVANCE(168);
      END_STATE();
    case 151:
      if (lookahead == 'l') ADVANCE(169);
      END_STATE();
    case 152:
      if (lookahead == 't') ADVANCE(170);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_inout);
      END_STATE();
    case 154:
      if (lookahead == 'a') ADVANCE(171);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 156:
      if (lookahead == 'c') ADVANCE(172);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_owned);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_raise);
      if (lookahead == 's') ADVANCE(173);
      END_STATE();
    case 160:
      if (lookahead == 'n') ADVANCE(174);
      END_STATE();
    case 161:
      if (lookahead == 't') ADVANCE(175);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(176);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 167:
      if (lookahead == 'u') ADVANCE(178);
      END_STATE();
    case 168:
      if (lookahead == 'y') ADVANCE(179);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_lambda);
      END_STATE();
    case 172:
      if (lookahead == 'a') ADVANCE(180);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_raises);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 176:
      if (lookahead == 'e') ADVANCE(181);
      END_STATE();
    case 177:
      if (lookahead == 'd') ADVANCE(182);
      END_STATE();
    case 178:
      if (lookahead == 'e') ADVANCE(183);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 180:
      if (lookahead == 'l') ADVANCE(184);
      END_STATE();
    case 181:
      if (lookahead == '_') ADVANCE(185);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_borrowed);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_nonlocal);
      END_STATE();
    case 185:
      if (lookahead == '_') ADVANCE(186);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym___future__);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 56, .external_lex_state = 2},
  [2] = {.lex_state = 56, .external_lex_state = 3},
  [3] = {.lex_state = 56, .external_lex_state = 3},
  [4] = {.lex_state = 56, .external_lex_state = 3},
  [5] = {.lex_state = 56, .external_lex_state = 3},
  [6] = {.lex_state = 56, .external_lex_state = 3},
  [7] = {.lex_state = 56, .external_lex_state = 3},
  [8] = {.lex_state = 56, .external_lex_state = 3},
  [9] = {.lex_state = 56, .external_lex_state = 3},
  [10] = {.lex_state = 56, .external_lex_state = 3},
  [11] = {.lex_state = 56, .external_lex_state = 3},
  [12] = {.lex_state = 56, .external_lex_state = 3},
  [13] = {.lex_state = 56, .external_lex_state = 3},
  [14] = {.lex_state = 56, .external_lex_state = 3},
  [15] = {.lex_state = 56, .external_lex_state = 3},
  [16] = {.lex_state = 56, .external_lex_state = 3},
  [17] = {.lex_state = 56, .external_lex_state = 3},
  [18] = {.lex_state = 56, .external_lex_state = 3},
  [19] = {.lex_state = 56, .external_lex_state = 3},
  [20] = {.lex_state = 56, .external_lex_state = 3},
  [21] = {.lex_state = 56, .external_lex_state = 3},
  [22] = {.lex_state = 56, .external_lex_state = 3},
  [23] = {.lex_state = 56, .external_lex_state = 3},
  [24] = {.lex_state = 56, .external_lex_state = 3},
  [25] = {.lex_state = 56, .external_lex_state = 3},
  [26] = {.lex_state = 56, .external_lex_state = 3},
  [27] = {.lex_state = 56, .external_lex_state = 3},
  [28] = {.lex_state = 56, .external_lex_state = 3},
  [29] = {.lex_state = 56, .external_lex_state = 3},
  [30] = {.lex_state = 56, .external_lex_state = 3},
  [31] = {.lex_state = 56, .external_lex_state = 3},
  [32] = {.lex_state = 56, .external_lex_state = 3},
  [33] = {.lex_state = 56, .external_lex_state = 3},
  [34] = {.lex_state = 56, .external_lex_state = 3},
  [35] = {.lex_state = 56, .external_lex_state = 3},
  [36] = {.lex_state = 56, .external_lex_state = 3},
  [37] = {.lex_state = 56, .external_lex_state = 3},
  [38] = {.lex_state = 56, .external_lex_state = 3},
  [39] = {.lex_state = 56, .external_lex_state = 3},
  [40] = {.lex_state = 56, .external_lex_state = 3},
  [41] = {.lex_state = 56, .external_lex_state = 3},
  [42] = {.lex_state = 56, .external_lex_state = 3},
  [43] = {.lex_state = 56, .external_lex_state = 3},
  [44] = {.lex_state = 56, .external_lex_state = 3},
  [45] = {.lex_state = 56, .external_lex_state = 3},
  [46] = {.lex_state = 56, .external_lex_state = 3},
  [47] = {.lex_state = 56, .external_lex_state = 3},
  [48] = {.lex_state = 56, .external_lex_state = 3},
  [49] = {.lex_state = 56, .external_lex_state = 3},
  [50] = {.lex_state = 56, .external_lex_state = 3},
  [51] = {.lex_state = 56, .external_lex_state = 3},
  [52] = {.lex_state = 56, .external_lex_state = 3},
  [53] = {.lex_state = 56, .external_lex_state = 3},
  [54] = {.lex_state = 56, .external_lex_state = 3},
  [55] = {.lex_state = 56, .external_lex_state = 3},
  [56] = {.lex_state = 56, .external_lex_state = 3},
  [57] = {.lex_state = 56, .external_lex_state = 3},
  [58] = {.lex_state = 56, .external_lex_state = 3},
  [59] = {.lex_state = 56, .external_lex_state = 3},
  [60] = {.lex_state = 56, .external_lex_state = 3},
  [61] = {.lex_state = 56, .external_lex_state = 3},
  [62] = {.lex_state = 56, .external_lex_state = 3},
  [63] = {.lex_state = 56, .external_lex_state = 3},
  [64] = {.lex_state = 56, .external_lex_state = 3},
  [65] = {.lex_state = 56, .external_lex_state = 3},
  [66] = {.lex_state = 56, .external_lex_state = 3},
  [67] = {.lex_state = 56, .external_lex_state = 3},
  [68] = {.lex_state = 56, .external_lex_state = 3},
  [69] = {.lex_state = 56, .external_lex_state = 3},
  [70] = {.lex_state = 56, .external_lex_state = 3},
  [71] = {.lex_state = 56, .external_lex_state = 3},
  [72] = {.lex_state = 56, .external_lex_state = 3},
  [73] = {.lex_state = 56, .external_lex_state = 3},
  [74] = {.lex_state = 56, .external_lex_state = 3},
  [75] = {.lex_state = 56, .external_lex_state = 3},
  [76] = {.lex_state = 56, .external_lex_state = 3},
  [77] = {.lex_state = 56, .external_lex_state = 3},
  [78] = {.lex_state = 56, .external_lex_state = 3},
  [79] = {.lex_state = 56, .external_lex_state = 3},
  [80] = {.lex_state = 56, .external_lex_state = 3},
  [81] = {.lex_state = 56, .external_lex_state = 3},
  [82] = {.lex_state = 56, .external_lex_state = 3},
  [83] = {.lex_state = 56, .external_lex_state = 3},
  [84] = {.lex_state = 56, .external_lex_state = 3},
  [85] = {.lex_state = 56, .external_lex_state = 3},
  [86] = {.lex_state = 56, .external_lex_state = 3},
  [87] = {.lex_state = 56, .external_lex_state = 3},
  [88] = {.lex_state = 56, .external_lex_state = 3},
  [89] = {.lex_state = 56, .external_lex_state = 3},
  [90] = {.lex_state = 56, .external_lex_state = 3},
  [91] = {.lex_state = 56, .external_lex_state = 3},
  [92] = {.lex_state = 56, .external_lex_state = 3},
  [93] = {.lex_state = 56, .external_lex_state = 3},
  [94] = {.lex_state = 56, .external_lex_state = 3},
  [95] = {.lex_state = 56, .external_lex_state = 3},
  [96] = {.lex_state = 56, .external_lex_state = 3},
  [97] = {.lex_state = 56, .external_lex_state = 3},
  [98] = {.lex_state = 56, .external_lex_state = 3},
  [99] = {.lex_state = 56, .external_lex_state = 3},
  [100] = {.lex_state = 56, .external_lex_state = 3},
  [101] = {.lex_state = 56, .external_lex_state = 3},
  [102] = {.lex_state = 56, .external_lex_state = 3},
  [103] = {.lex_state = 56, .external_lex_state = 3},
  [104] = {.lex_state = 56, .external_lex_state = 3},
  [105] = {.lex_state = 56, .external_lex_state = 3},
  [106] = {.lex_state = 56, .external_lex_state = 3},
  [107] = {.lex_state = 56, .external_lex_state = 3},
  [108] = {.lex_state = 56, .external_lex_state = 3},
  [109] = {.lex_state = 56, .external_lex_state = 3},
  [110] = {.lex_state = 56, .external_lex_state = 3},
  [111] = {.lex_state = 56, .external_lex_state = 3},
  [112] = {.lex_state = 56, .external_lex_state = 3},
  [113] = {.lex_state = 56, .external_lex_state = 3},
  [114] = {.lex_state = 56, .external_lex_state = 3},
  [115] = {.lex_state = 56, .external_lex_state = 3},
  [116] = {.lex_state = 56, .external_lex_state = 3},
  [117] = {.lex_state = 56, .external_lex_state = 3},
  [118] = {.lex_state = 56, .external_lex_state = 3},
  [119] = {.lex_state = 56, .external_lex_state = 2},
  [120] = {.lex_state = 56, .external_lex_state = 3},
  [121] = {.lex_state = 56, .external_lex_state = 3},
  [122] = {.lex_state = 56, .external_lex_state = 3},
  [123] = {.lex_state = 56, .external_lex_state = 2},
  [124] = {.lex_state = 56, .external_lex_state = 3},
  [125] = {.lex_state = 56, .external_lex_state = 3},
  [126] = {.lex_state = 56, .external_lex_state = 3},
  [127] = {.lex_state = 56, .external_lex_state = 3},
  [128] = {.lex_state = 56, .external_lex_state = 3},
  [129] = {.lex_state = 4, .external_lex_state = 4},
  [130] = {.lex_state = 5, .external_lex_state = 5},
  [131] = {.lex_state = 5, .external_lex_state = 5},
  [132] = {.lex_state = 5, .external_lex_state = 5},
  [133] = {.lex_state = 5, .external_lex_state = 5},
  [134] = {.lex_state = 5, .external_lex_state = 5},
  [135] = {.lex_state = 5, .external_lex_state = 5},
  [136] = {.lex_state = 5, .external_lex_state = 5},
  [137] = {.lex_state = 5, .external_lex_state = 5},
  [138] = {.lex_state = 5, .external_lex_state = 5},
  [139] = {.lex_state = 5, .external_lex_state = 5},
  [140] = {.lex_state = 5, .external_lex_state = 5},
  [141] = {.lex_state = 5, .external_lex_state = 5},
  [142] = {.lex_state = 5, .external_lex_state = 5},
  [143] = {.lex_state = 5, .external_lex_state = 5},
  [144] = {.lex_state = 5, .external_lex_state = 5},
  [145] = {.lex_state = 5, .external_lex_state = 5},
  [146] = {.lex_state = 5, .external_lex_state = 5},
  [147] = {.lex_state = 5, .external_lex_state = 5},
  [148] = {.lex_state = 5, .external_lex_state = 5},
  [149] = {.lex_state = 5, .external_lex_state = 5},
  [150] = {.lex_state = 5, .external_lex_state = 5},
  [151] = {.lex_state = 5, .external_lex_state = 5},
  [152] = {.lex_state = 5, .external_lex_state = 5},
  [153] = {.lex_state = 5, .external_lex_state = 5},
  [154] = {.lex_state = 5, .external_lex_state = 5},
  [155] = {.lex_state = 5, .external_lex_state = 5},
  [156] = {.lex_state = 5, .external_lex_state = 5},
  [157] = {.lex_state = 5, .external_lex_state = 5},
  [158] = {.lex_state = 5, .external_lex_state = 5},
  [159] = {.lex_state = 5, .external_lex_state = 5},
  [160] = {.lex_state = 5, .external_lex_state = 5},
  [161] = {.lex_state = 5, .external_lex_state = 5},
  [162] = {.lex_state = 5, .external_lex_state = 5},
  [163] = {.lex_state = 5, .external_lex_state = 5},
  [164] = {.lex_state = 5, .external_lex_state = 5},
  [165] = {.lex_state = 5, .external_lex_state = 5},
  [166] = {.lex_state = 5, .external_lex_state = 5},
  [167] = {.lex_state = 5, .external_lex_state = 5},
  [168] = {.lex_state = 5, .external_lex_state = 5},
  [169] = {.lex_state = 5, .external_lex_state = 5},
  [170] = {.lex_state = 5, .external_lex_state = 5},
  [171] = {.lex_state = 5, .external_lex_state = 5},
  [172] = {.lex_state = 5, .external_lex_state = 5},
  [173] = {.lex_state = 5, .external_lex_state = 5},
  [174] = {.lex_state = 5, .external_lex_state = 5},
  [175] = {.lex_state = 5, .external_lex_state = 5},
  [176] = {.lex_state = 5, .external_lex_state = 5},
  [177] = {.lex_state = 5, .external_lex_state = 5},
  [178] = {.lex_state = 4, .external_lex_state = 4},
  [179] = {.lex_state = 4, .external_lex_state = 4},
  [180] = {.lex_state = 4, .external_lex_state = 4},
  [181] = {.lex_state = 56, .external_lex_state = 5},
  [182] = {.lex_state = 56, .external_lex_state = 5},
  [183] = {.lex_state = 56, .external_lex_state = 5},
  [184] = {.lex_state = 56, .external_lex_state = 5},
  [185] = {.lex_state = 56, .external_lex_state = 5},
  [186] = {.lex_state = 56, .external_lex_state = 5},
  [187] = {.lex_state = 56, .external_lex_state = 5},
  [188] = {.lex_state = 56, .external_lex_state = 5},
  [189] = {.lex_state = 56, .external_lex_state = 5},
  [190] = {.lex_state = 56, .external_lex_state = 5},
  [191] = {.lex_state = 56, .external_lex_state = 5},
  [192] = {.lex_state = 56, .external_lex_state = 5},
  [193] = {.lex_state = 56, .external_lex_state = 5},
  [194] = {.lex_state = 56, .external_lex_state = 5},
  [195] = {.lex_state = 56, .external_lex_state = 5},
  [196] = {.lex_state = 56, .external_lex_state = 5},
  [197] = {.lex_state = 56, .external_lex_state = 5},
  [198] = {.lex_state = 56, .external_lex_state = 5},
  [199] = {.lex_state = 56, .external_lex_state = 5},
  [200] = {.lex_state = 56, .external_lex_state = 5},
  [201] = {.lex_state = 56, .external_lex_state = 5},
  [202] = {.lex_state = 56, .external_lex_state = 5},
  [203] = {.lex_state = 56, .external_lex_state = 5},
  [204] = {.lex_state = 56, .external_lex_state = 5},
  [205] = {.lex_state = 56, .external_lex_state = 5},
  [206] = {.lex_state = 56, .external_lex_state = 5},
  [207] = {.lex_state = 56, .external_lex_state = 5},
  [208] = {.lex_state = 56, .external_lex_state = 5},
  [209] = {.lex_state = 56, .external_lex_state = 5},
  [210] = {.lex_state = 56, .external_lex_state = 5},
  [211] = {.lex_state = 56, .external_lex_state = 5},
  [212] = {.lex_state = 56, .external_lex_state = 5},
  [213] = {.lex_state = 56, .external_lex_state = 5},
  [214] = {.lex_state = 56, .external_lex_state = 5},
  [215] = {.lex_state = 56, .external_lex_state = 5},
  [216] = {.lex_state = 56, .external_lex_state = 5},
  [217] = {.lex_state = 56, .external_lex_state = 5},
  [218] = {.lex_state = 56, .external_lex_state = 5},
  [219] = {.lex_state = 56, .external_lex_state = 5},
  [220] = {.lex_state = 56, .external_lex_state = 5},
  [221] = {.lex_state = 56, .external_lex_state = 5},
  [222] = {.lex_state = 56, .external_lex_state = 5},
  [223] = {.lex_state = 56, .external_lex_state = 5},
  [224] = {.lex_state = 56, .external_lex_state = 5},
  [225] = {.lex_state = 56, .external_lex_state = 5},
  [226] = {.lex_state = 56, .external_lex_state = 5},
  [227] = {.lex_state = 56, .external_lex_state = 5},
  [228] = {.lex_state = 56, .external_lex_state = 5},
  [229] = {.lex_state = 56, .external_lex_state = 5},
  [230] = {.lex_state = 56, .external_lex_state = 5},
  [231] = {.lex_state = 56, .external_lex_state = 5},
  [232] = {.lex_state = 56, .external_lex_state = 5},
  [233] = {.lex_state = 56, .external_lex_state = 5},
  [234] = {.lex_state = 56, .external_lex_state = 5},
  [235] = {.lex_state = 56, .external_lex_state = 5},
  [236] = {.lex_state = 56, .external_lex_state = 5},
  [237] = {.lex_state = 56, .external_lex_state = 5},
  [238] = {.lex_state = 56, .external_lex_state = 5},
  [239] = {.lex_state = 56, .external_lex_state = 5},
  [240] = {.lex_state = 56, .external_lex_state = 5},
  [241] = {.lex_state = 56, .external_lex_state = 5},
  [242] = {.lex_state = 56, .external_lex_state = 5},
  [243] = {.lex_state = 56, .external_lex_state = 5},
  [244] = {.lex_state = 56, .external_lex_state = 5},
  [245] = {.lex_state = 56, .external_lex_state = 5},
  [246] = {.lex_state = 56, .external_lex_state = 5},
  [247] = {.lex_state = 56, .external_lex_state = 4},
  [248] = {.lex_state = 56, .external_lex_state = 4},
  [249] = {.lex_state = 56, .external_lex_state = 4},
  [250] = {.lex_state = 56, .external_lex_state = 4},
  [251] = {.lex_state = 56, .external_lex_state = 4},
  [252] = {.lex_state = 56, .external_lex_state = 4},
  [253] = {.lex_state = 56, .external_lex_state = 4},
  [254] = {.lex_state = 56, .external_lex_state = 4},
  [255] = {.lex_state = 56, .external_lex_state = 4},
  [256] = {.lex_state = 56, .external_lex_state = 4},
  [257] = {.lex_state = 56, .external_lex_state = 4},
  [258] = {.lex_state = 56, .external_lex_state = 4},
  [259] = {.lex_state = 56, .external_lex_state = 4},
  [260] = {.lex_state = 56, .external_lex_state = 4},
  [261] = {.lex_state = 56, .external_lex_state = 4},
  [262] = {.lex_state = 56, .external_lex_state = 4},
  [263] = {.lex_state = 56, .external_lex_state = 2},
  [264] = {.lex_state = 4, .external_lex_state = 4},
  [265] = {.lex_state = 12, .external_lex_state = 4},
  [266] = {.lex_state = 5, .external_lex_state = 4},
  [267] = {.lex_state = 13, .external_lex_state = 6},
  [268] = {.lex_state = 5, .external_lex_state = 6},
  [269] = {.lex_state = 5, .external_lex_state = 6},
  [270] = {.lex_state = 13, .external_lex_state = 4},
  [271] = {.lex_state = 13, .external_lex_state = 4},
  [272] = {.lex_state = 5, .external_lex_state = 6},
  [273] = {.lex_state = 5, .external_lex_state = 7},
  [274] = {.lex_state = 5, .external_lex_state = 6},
  [275] = {.lex_state = 13, .external_lex_state = 6},
  [276] = {.lex_state = 5, .external_lex_state = 8},
  [277] = {.lex_state = 5, .external_lex_state = 7},
  [278] = {.lex_state = 5, .external_lex_state = 2},
  [279] = {.lex_state = 5, .external_lex_state = 8},
  [280] = {.lex_state = 13, .external_lex_state = 7},
  [281] = {.lex_state = 13, .external_lex_state = 7},
  [282] = {.lex_state = 5, .external_lex_state = 8},
  [283] = {.lex_state = 5, .external_lex_state = 8},
  [284] = {.lex_state = 13, .external_lex_state = 2},
  [285] = {.lex_state = 13, .external_lex_state = 2},
  [286] = {.lex_state = 5, .external_lex_state = 7},
  [287] = {.lex_state = 5, .external_lex_state = 7},
  [288] = {.lex_state = 13, .external_lex_state = 6},
  [289] = {.lex_state = 5, .external_lex_state = 7},
  [290] = {.lex_state = 13, .external_lex_state = 8},
  [291] = {.lex_state = 5, .external_lex_state = 7},
  [292] = {.lex_state = 5, .external_lex_state = 8},
  [293] = {.lex_state = 13, .external_lex_state = 8},
  [294] = {.lex_state = 5, .external_lex_state = 8},
  [295] = {.lex_state = 5, .external_lex_state = 7},
  [296] = {.lex_state = 4, .external_lex_state = 4},
  [297] = {.lex_state = 4, .external_lex_state = 2},
  [298] = {.lex_state = 4, .external_lex_state = 2},
  [299] = {.lex_state = 56, .external_lex_state = 2},
  [300] = {.lex_state = 56, .external_lex_state = 2},
  [301] = {.lex_state = 56, .external_lex_state = 2},
  [302] = {.lex_state = 5, .external_lex_state = 6},
  [303] = {.lex_state = 56, .external_lex_state = 8},
  [304] = {.lex_state = 56, .external_lex_state = 8},
  [305] = {.lex_state = 56, .external_lex_state = 7},
  [306] = {.lex_state = 56, .external_lex_state = 7},
  [307] = {.lex_state = 56, .external_lex_state = 8},
  [308] = {.lex_state = 56, .external_lex_state = 7},
  [309] = {.lex_state = 56, .external_lex_state = 8},
  [310] = {.lex_state = 5, .external_lex_state = 6},
  [311] = {.lex_state = 56, .external_lex_state = 8},
  [312] = {.lex_state = 56, .external_lex_state = 7},
  [313] = {.lex_state = 5, .external_lex_state = 6},
  [314] = {.lex_state = 56, .external_lex_state = 7},
  [315] = {.lex_state = 56, .external_lex_state = 8},
  [316] = {.lex_state = 56, .external_lex_state = 7},
  [317] = {.lex_state = 56, .external_lex_state = 8},
  [318] = {.lex_state = 56, .external_lex_state = 7},
  [319] = {.lex_state = 56, .external_lex_state = 8},
  [320] = {.lex_state = 5, .external_lex_state = 6},
  [321] = {.lex_state = 5, .external_lex_state = 6},
  [322] = {.lex_state = 5, .external_lex_state = 6},
  [323] = {.lex_state = 5, .external_lex_state = 6},
  [324] = {.lex_state = 56, .external_lex_state = 8},
  [325] = {.lex_state = 56, .external_lex_state = 7},
  [326] = {.lex_state = 5, .external_lex_state = 6},
  [327] = {.lex_state = 56, .external_lex_state = 8},
  [328] = {.lex_state = 56, .external_lex_state = 7},
  [329] = {.lex_state = 56, .external_lex_state = 7},
  [330] = {.lex_state = 13, .external_lex_state = 8},
  [331] = {.lex_state = 13, .external_lex_state = 8},
  [332] = {.lex_state = 13, .external_lex_state = 8},
  [333] = {.lex_state = 13, .external_lex_state = 8},
  [334] = {.lex_state = 13, .external_lex_state = 8},
  [335] = {.lex_state = 13, .external_lex_state = 8},
  [336] = {.lex_state = 13, .external_lex_state = 8},
  [337] = {.lex_state = 13, .external_lex_state = 8},
  [338] = {.lex_state = 13, .external_lex_state = 8},
  [339] = {.lex_state = 13, .external_lex_state = 8},
  [340] = {.lex_state = 13, .external_lex_state = 8},
  [341] = {.lex_state = 13, .external_lex_state = 8},
  [342] = {.lex_state = 5, .external_lex_state = 8},
  [343] = {.lex_state = 5, .external_lex_state = 8},
  [344] = {.lex_state = 13, .external_lex_state = 8},
  [345] = {.lex_state = 5, .external_lex_state = 8},
  [346] = {.lex_state = 5, .external_lex_state = 8},
  [347] = {.lex_state = 5, .external_lex_state = 8},
  [348] = {.lex_state = 13, .external_lex_state = 8},
  [349] = {.lex_state = 13, .external_lex_state = 8},
  [350] = {.lex_state = 5, .external_lex_state = 8},
  [351] = {.lex_state = 13, .external_lex_state = 8},
  [352] = {.lex_state = 13, .external_lex_state = 8},
  [353] = {.lex_state = 56, .external_lex_state = 2},
  [354] = {.lex_state = 13, .external_lex_state = 8},
  [355] = {.lex_state = 13, .external_lex_state = 8},
  [356] = {.lex_state = 5, .external_lex_state = 8},
  [357] = {.lex_state = 56, .external_lex_state = 2},
  [358] = {.lex_state = 13, .external_lex_state = 8},
  [359] = {.lex_state = 5, .external_lex_state = 8},
  [360] = {.lex_state = 5, .external_lex_state = 2},
  [361] = {.lex_state = 5, .external_lex_state = 2},
  [362] = {.lex_state = 5, .external_lex_state = 2},
  [363] = {.lex_state = 5, .external_lex_state = 2},
  [364] = {.lex_state = 5, .external_lex_state = 2},
  [365] = {.lex_state = 5, .external_lex_state = 2},
  [366] = {.lex_state = 5, .external_lex_state = 2},
  [367] = {.lex_state = 5, .external_lex_state = 2},
  [368] = {.lex_state = 5, .external_lex_state = 2},
  [369] = {.lex_state = 5, .external_lex_state = 2},
  [370] = {.lex_state = 5, .external_lex_state = 7},
  [371] = {.lex_state = 5, .external_lex_state = 2},
  [372] = {.lex_state = 5, .external_lex_state = 2},
  [373] = {.lex_state = 6, .external_lex_state = 4},
  [374] = {.lex_state = 5, .external_lex_state = 2},
  [375] = {.lex_state = 5, .external_lex_state = 2},
  [376] = {.lex_state = 5, .external_lex_state = 2},
  [377] = {.lex_state = 5, .external_lex_state = 2},
  [378] = {.lex_state = 5, .external_lex_state = 2},
  [379] = {.lex_state = 5, .external_lex_state = 2},
  [380] = {.lex_state = 5, .external_lex_state = 2},
  [381] = {.lex_state = 5, .external_lex_state = 2},
  [382] = {.lex_state = 5, .external_lex_state = 2},
  [383] = {.lex_state = 5, .external_lex_state = 2},
  [384] = {.lex_state = 5, .external_lex_state = 2},
  [385] = {.lex_state = 5, .external_lex_state = 2},
  [386] = {.lex_state = 5, .external_lex_state = 2},
  [387] = {.lex_state = 5, .external_lex_state = 2},
  [388] = {.lex_state = 5, .external_lex_state = 2},
  [389] = {.lex_state = 5, .external_lex_state = 2},
  [390] = {.lex_state = 5, .external_lex_state = 2},
  [391] = {.lex_state = 5, .external_lex_state = 2},
  [392] = {.lex_state = 56, .external_lex_state = 6},
  [393] = {.lex_state = 5, .external_lex_state = 7},
  [394] = {.lex_state = 5, .external_lex_state = 2},
  [395] = {.lex_state = 5, .external_lex_state = 2},
  [396] = {.lex_state = 5, .external_lex_state = 2},
  [397] = {.lex_state = 5, .external_lex_state = 2},
  [398] = {.lex_state = 5, .external_lex_state = 2},
  [399] = {.lex_state = 5, .external_lex_state = 2},
  [400] = {.lex_state = 5, .external_lex_state = 2},
  [401] = {.lex_state = 5, .external_lex_state = 2},
  [402] = {.lex_state = 5, .external_lex_state = 7},
  [403] = {.lex_state = 5, .external_lex_state = 7},
  [404] = {.lex_state = 5, .external_lex_state = 2},
  [405] = {.lex_state = 5, .external_lex_state = 2},
  [406] = {.lex_state = 5, .external_lex_state = 2},
  [407] = {.lex_state = 5, .external_lex_state = 2},
  [408] = {.lex_state = 5, .external_lex_state = 2},
  [409] = {.lex_state = 6, .external_lex_state = 4},
  [410] = {.lex_state = 5, .external_lex_state = 2},
  [411] = {.lex_state = 5, .external_lex_state = 2},
  [412] = {.lex_state = 5, .external_lex_state = 2},
  [413] = {.lex_state = 5, .external_lex_state = 2},
  [414] = {.lex_state = 5, .external_lex_state = 2},
  [415] = {.lex_state = 5, .external_lex_state = 7},
  [416] = {.lex_state = 5, .external_lex_state = 2},
  [417] = {.lex_state = 5, .external_lex_state = 7},
  [418] = {.lex_state = 5, .external_lex_state = 2},
  [419] = {.lex_state = 5, .external_lex_state = 7},
  [420] = {.lex_state = 5, .external_lex_state = 2},
  [421] = {.lex_state = 5, .external_lex_state = 2},
  [422] = {.lex_state = 5, .external_lex_state = 2},
  [423] = {.lex_state = 5, .external_lex_state = 2},
  [424] = {.lex_state = 5, .external_lex_state = 2},
  [425] = {.lex_state = 5, .external_lex_state = 7},
  [426] = {.lex_state = 5, .external_lex_state = 7},
  [427] = {.lex_state = 5, .external_lex_state = 2},
  [428] = {.lex_state = 56, .external_lex_state = 7},
  [429] = {.lex_state = 5, .external_lex_state = 2},
  [430] = {.lex_state = 5, .external_lex_state = 2},
  [431] = {.lex_state = 5, .external_lex_state = 2},
  [432] = {.lex_state = 5, .external_lex_state = 2},
  [433] = {.lex_state = 5, .external_lex_state = 2},
  [434] = {.lex_state = 5, .external_lex_state = 2},
  [435] = {.lex_state = 5, .external_lex_state = 2},
  [436] = {.lex_state = 5, .external_lex_state = 2},
  [437] = {.lex_state = 5, .external_lex_state = 2},
  [438] = {.lex_state = 5, .external_lex_state = 2},
  [439] = {.lex_state = 5, .external_lex_state = 2},
  [440] = {.lex_state = 5, .external_lex_state = 7},
  [441] = {.lex_state = 5, .external_lex_state = 7},
  [442] = {.lex_state = 5, .external_lex_state = 7},
  [443] = {.lex_state = 5, .external_lex_state = 7},
  [444] = {.lex_state = 56, .external_lex_state = 7},
  [445] = {.lex_state = 56, .external_lex_state = 7},
  [446] = {.lex_state = 56, .external_lex_state = 8},
  [447] = {.lex_state = 5, .external_lex_state = 7},
  [448] = {.lex_state = 5, .external_lex_state = 7},
  [449] = {.lex_state = 5, .external_lex_state = 8},
  [450] = {.lex_state = 5, .external_lex_state = 8},
  [451] = {.lex_state = 56, .external_lex_state = 8},
  [452] = {.lex_state = 56, .external_lex_state = 7},
  [453] = {.lex_state = 5, .external_lex_state = 7},
  [454] = {.lex_state = 5, .external_lex_state = 7},
  [455] = {.lex_state = 56, .external_lex_state = 7},
  [456] = {.lex_state = 5, .external_lex_state = 7},
  [457] = {.lex_state = 5, .external_lex_state = 7},
  [458] = {.lex_state = 5, .external_lex_state = 7},
  [459] = {.lex_state = 56, .external_lex_state = 8},
  [460] = {.lex_state = 56, .external_lex_state = 7},
  [461] = {.lex_state = 5, .external_lex_state = 7},
  [462] = {.lex_state = 5, .external_lex_state = 7},
  [463] = {.lex_state = 5, .external_lex_state = 7},
  [464] = {.lex_state = 5, .external_lex_state = 7},
  [465] = {.lex_state = 56, .external_lex_state = 8},
  [466] = {.lex_state = 5, .external_lex_state = 7},
  [467] = {.lex_state = 56, .external_lex_state = 7},
  [468] = {.lex_state = 5, .external_lex_state = 7},
  [469] = {.lex_state = 56, .external_lex_state = 7},
  [470] = {.lex_state = 5, .external_lex_state = 7},
  [471] = {.lex_state = 5, .external_lex_state = 7},
  [472] = {.lex_state = 56, .external_lex_state = 8},
  [473] = {.lex_state = 5, .external_lex_state = 7},
  [474] = {.lex_state = 56, .external_lex_state = 7},
  [475] = {.lex_state = 5, .external_lex_state = 7},
  [476] = {.lex_state = 5, .external_lex_state = 7},
  [477] = {.lex_state = 56, .external_lex_state = 7},
  [478] = {.lex_state = 56, .external_lex_state = 7},
  [479] = {.lex_state = 56, .external_lex_state = 8},
  [480] = {.lex_state = 56, .external_lex_state = 7},
  [481] = {.lex_state = 56, .external_lex_state = 8},
  [482] = {.lex_state = 56, .external_lex_state = 7},
  [483] = {.lex_state = 5, .external_lex_state = 7},
  [484] = {.lex_state = 5, .external_lex_state = 7},
  [485] = {.lex_state = 5, .external_lex_state = 7},
  [486] = {.lex_state = 5, .external_lex_state = 7},
  [487] = {.lex_state = 5, .external_lex_state = 7},
  [488] = {.lex_state = 5, .external_lex_state = 7},
  [489] = {.lex_state = 5, .external_lex_state = 7},
  [490] = {.lex_state = 5, .external_lex_state = 7},
  [491] = {.lex_state = 56, .external_lex_state = 7},
  [492] = {.lex_state = 56, .external_lex_state = 8},
  [493] = {.lex_state = 5, .external_lex_state = 8},
  [494] = {.lex_state = 5, .external_lex_state = 7},
  [495] = {.lex_state = 5, .external_lex_state = 8},
  [496] = {.lex_state = 5, .external_lex_state = 7},
  [497] = {.lex_state = 56, .external_lex_state = 7},
  [498] = {.lex_state = 5, .external_lex_state = 2},
  [499] = {.lex_state = 56, .external_lex_state = 7},
  [500] = {.lex_state = 56, .external_lex_state = 7},
  [501] = {.lex_state = 56, .external_lex_state = 6},
  [502] = {.lex_state = 56, .external_lex_state = 6},
  [503] = {.lex_state = 6, .external_lex_state = 2},
  [504] = {.lex_state = 56, .external_lex_state = 6},
  [505] = {.lex_state = 6, .external_lex_state = 2},
  [506] = {.lex_state = 56, .external_lex_state = 7},
  [507] = {.lex_state = 56, .external_lex_state = 7},
  [508] = {.lex_state = 56, .external_lex_state = 6},
  [509] = {.lex_state = 56, .external_lex_state = 6},
  [510] = {.lex_state = 56, .external_lex_state = 8},
  [511] = {.lex_state = 56, .external_lex_state = 6},
  [512] = {.lex_state = 56, .external_lex_state = 7},
  [513] = {.lex_state = 56, .external_lex_state = 6},
  [514] = {.lex_state = 56, .external_lex_state = 7},
  [515] = {.lex_state = 13, .external_lex_state = 6},
  [516] = {.lex_state = 56, .external_lex_state = 8},
  [517] = {.lex_state = 56, .external_lex_state = 8},
  [518] = {.lex_state = 56, .external_lex_state = 8},
  [519] = {.lex_state = 56, .external_lex_state = 8},
  [520] = {.lex_state = 56, .external_lex_state = 8},
  [521] = {.lex_state = 5, .external_lex_state = 2},
  [522] = {.lex_state = 56, .external_lex_state = 6},
  [523] = {.lex_state = 5, .external_lex_state = 6},
  [524] = {.lex_state = 5, .external_lex_state = 6},
  [525] = {.lex_state = 56, .external_lex_state = 4},
  [526] = {.lex_state = 5, .external_lex_state = 6},
  [527] = {.lex_state = 5, .external_lex_state = 6},
  [528] = {.lex_state = 56, .external_lex_state = 2},
  [529] = {.lex_state = 57, .external_lex_state = 9},
  [530] = {.lex_state = 58, .external_lex_state = 2},
  [531] = {.lex_state = 58, .external_lex_state = 3},
  [532] = {.lex_state = 5, .external_lex_state = 6},
  [533] = {.lex_state = 57, .external_lex_state = 9},
  [534] = {.lex_state = 56, .external_lex_state = 2},
  [535] = {.lex_state = 58, .external_lex_state = 3},
  [536] = {.lex_state = 56, .external_lex_state = 2},
  [537] = {.lex_state = 13, .external_lex_state = 2},
  [538] = {.lex_state = 57, .external_lex_state = 10},
  [539] = {.lex_state = 56, .external_lex_state = 8},
  [540] = {.lex_state = 5, .external_lex_state = 6},
  [541] = {.lex_state = 56, .external_lex_state = 4},
  [542] = {.lex_state = 5, .external_lex_state = 6},
  [543] = {.lex_state = 5, .external_lex_state = 6},
  [544] = {.lex_state = 5, .external_lex_state = 6},
  [545] = {.lex_state = 5, .external_lex_state = 6},
  [546] = {.lex_state = 5, .external_lex_state = 6},
  [547] = {.lex_state = 5, .external_lex_state = 6},
  [548] = {.lex_state = 5, .external_lex_state = 6},
  [549] = {.lex_state = 5, .external_lex_state = 6},
  [550] = {.lex_state = 5, .external_lex_state = 6},
  [551] = {.lex_state = 56, .external_lex_state = 7},
  [552] = {.lex_state = 5, .external_lex_state = 6},
  [553] = {.lex_state = 57, .external_lex_state = 10},
  [554] = {.lex_state = 58, .external_lex_state = 2},
  [555] = {.lex_state = 56, .external_lex_state = 8},
  [556] = {.lex_state = 13, .external_lex_state = 7},
  [557] = {.lex_state = 56, .external_lex_state = 4},
  [558] = {.lex_state = 56, .external_lex_state = 8},
  [559] = {.lex_state = 56, .external_lex_state = 8},
  [560] = {.lex_state = 56, .external_lex_state = 8},
  [561] = {.lex_state = 56, .external_lex_state = 8},
  [562] = {.lex_state = 56, .external_lex_state = 8},
  [563] = {.lex_state = 56, .external_lex_state = 8},
  [564] = {.lex_state = 56, .external_lex_state = 8},
  [565] = {.lex_state = 13, .external_lex_state = 7},
  [566] = {.lex_state = 56, .external_lex_state = 8},
  [567] = {.lex_state = 56, .external_lex_state = 8},
  [568] = {.lex_state = 56, .external_lex_state = 8},
  [569] = {.lex_state = 56, .external_lex_state = 8},
  [570] = {.lex_state = 56, .external_lex_state = 8},
  [571] = {.lex_state = 56, .external_lex_state = 8},
  [572] = {.lex_state = 56, .external_lex_state = 8},
  [573] = {.lex_state = 56, .external_lex_state = 8},
  [574] = {.lex_state = 56, .external_lex_state = 4},
  [575] = {.lex_state = 56, .external_lex_state = 8},
  [576] = {.lex_state = 56, .external_lex_state = 8},
  [577] = {.lex_state = 56, .external_lex_state = 8},
  [578] = {.lex_state = 56, .external_lex_state = 8},
  [579] = {.lex_state = 56, .external_lex_state = 8},
  [580] = {.lex_state = 56, .external_lex_state = 8},
  [581] = {.lex_state = 56, .external_lex_state = 8},
  [582] = {.lex_state = 56, .external_lex_state = 8},
  [583] = {.lex_state = 56, .external_lex_state = 8},
  [584] = {.lex_state = 56, .external_lex_state = 8},
  [585] = {.lex_state = 56, .external_lex_state = 8},
  [586] = {.lex_state = 56, .external_lex_state = 8},
  [587] = {.lex_state = 56, .external_lex_state = 4},
  [588] = {.lex_state = 56, .external_lex_state = 8},
  [589] = {.lex_state = 5, .external_lex_state = 2},
  [590] = {.lex_state = 56, .external_lex_state = 8},
  [591] = {.lex_state = 56, .external_lex_state = 8},
  [592] = {.lex_state = 56, .external_lex_state = 8},
  [593] = {.lex_state = 56, .external_lex_state = 2},
  [594] = {.lex_state = 56, .external_lex_state = 2},
  [595] = {.lex_state = 56, .external_lex_state = 7},
  [596] = {.lex_state = 13, .external_lex_state = 2},
  [597] = {.lex_state = 56, .external_lex_state = 7},
  [598] = {.lex_state = 56, .external_lex_state = 2},
  [599] = {.lex_state = 56, .external_lex_state = 4},
  [600] = {.lex_state = 56, .external_lex_state = 2},
  [601] = {.lex_state = 56, .external_lex_state = 3},
  [602] = {.lex_state = 56, .external_lex_state = 2},
  [603] = {.lex_state = 56, .external_lex_state = 2},
  [604] = {.lex_state = 56, .external_lex_state = 8},
  [605] = {.lex_state = 56, .external_lex_state = 3},
  [606] = {.lex_state = 56, .external_lex_state = 8},
  [607] = {.lex_state = 56, .external_lex_state = 3},
  [608] = {.lex_state = 56, .external_lex_state = 2},
  [609] = {.lex_state = 56, .external_lex_state = 4},
  [610] = {.lex_state = 56, .external_lex_state = 2},
  [611] = {.lex_state = 57, .external_lex_state = 9},
  [612] = {.lex_state = 58, .external_lex_state = 3},
  [613] = {.lex_state = 56, .external_lex_state = 2},
  [614] = {.lex_state = 56, .external_lex_state = 2},
  [615] = {.lex_state = 56, .external_lex_state = 2},
  [616] = {.lex_state = 56, .external_lex_state = 2},
  [617] = {.lex_state = 56, .external_lex_state = 2},
  [618] = {.lex_state = 56, .external_lex_state = 2},
  [619] = {.lex_state = 56, .external_lex_state = 2},
  [620] = {.lex_state = 5, .external_lex_state = 7},
  [621] = {.lex_state = 56, .external_lex_state = 4},
  [622] = {.lex_state = 56, .external_lex_state = 2},
  [623] = {.lex_state = 56, .external_lex_state = 2},
  [624] = {.lex_state = 56, .external_lex_state = 4},
  [625] = {.lex_state = 57, .external_lex_state = 10},
  [626] = {.lex_state = 58, .external_lex_state = 2},
  [627] = {.lex_state = 56, .external_lex_state = 2},
  [628] = {.lex_state = 56, .external_lex_state = 2},
  [629] = {.lex_state = 56, .external_lex_state = 4},
  [630] = {.lex_state = 56, .external_lex_state = 3},
  [631] = {.lex_state = 13, .external_lex_state = 2},
  [632] = {.lex_state = 56, .external_lex_state = 4},
  [633] = {.lex_state = 56, .external_lex_state = 8},
  [634] = {.lex_state = 56, .external_lex_state = 2},
  [635] = {.lex_state = 56, .external_lex_state = 2},
  [636] = {.lex_state = 56, .external_lex_state = 7},
  [637] = {.lex_state = 56, .external_lex_state = 2},
  [638] = {.lex_state = 56, .external_lex_state = 2},
  [639] = {.lex_state = 56, .external_lex_state = 8},
  [640] = {.lex_state = 56, .external_lex_state = 2},
  [641] = {.lex_state = 56, .external_lex_state = 8},
  [642] = {.lex_state = 56, .external_lex_state = 2},
  [643] = {.lex_state = 56, .external_lex_state = 2},
  [644] = {.lex_state = 56, .external_lex_state = 7},
  [645] = {.lex_state = 5, .external_lex_state = 8},
  [646] = {.lex_state = 56, .external_lex_state = 2},
  [647] = {.lex_state = 56, .external_lex_state = 2},
  [648] = {.lex_state = 56, .external_lex_state = 2},
  [649] = {.lex_state = 56, .external_lex_state = 2},
  [650] = {.lex_state = 56, .external_lex_state = 2},
  [651] = {.lex_state = 56, .external_lex_state = 3},
  [652] = {.lex_state = 56, .external_lex_state = 2},
  [653] = {.lex_state = 56, .external_lex_state = 2},
  [654] = {.lex_state = 56, .external_lex_state = 2},
  [655] = {.lex_state = 56, .external_lex_state = 2},
  [656] = {.lex_state = 56, .external_lex_state = 2},
  [657] = {.lex_state = 56, .external_lex_state = 2},
  [658] = {.lex_state = 56, .external_lex_state = 2},
  [659] = {.lex_state = 56, .external_lex_state = 2},
  [660] = {.lex_state = 56, .external_lex_state = 2},
  [661] = {.lex_state = 56, .external_lex_state = 2},
  [662] = {.lex_state = 56, .external_lex_state = 2},
  [663] = {.lex_state = 58, .external_lex_state = 2},
  [664] = {.lex_state = 57, .external_lex_state = 9},
  [665] = {.lex_state = 56, .external_lex_state = 2},
  [666] = {.lex_state = 56, .external_lex_state = 2},
  [667] = {.lex_state = 56, .external_lex_state = 2},
  [668] = {.lex_state = 57, .external_lex_state = 10},
  [669] = {.lex_state = 56, .external_lex_state = 2},
  [670] = {.lex_state = 56, .external_lex_state = 2},
  [671] = {.lex_state = 56, .external_lex_state = 2},
  [672] = {.lex_state = 56, .external_lex_state = 2},
  [673] = {.lex_state = 56, .external_lex_state = 2},
  [674] = {.lex_state = 56, .external_lex_state = 2},
  [675] = {.lex_state = 56, .external_lex_state = 2},
  [676] = {.lex_state = 58, .external_lex_state = 2},
  [677] = {.lex_state = 56, .external_lex_state = 2},
  [678] = {.lex_state = 56, .external_lex_state = 2},
  [679] = {.lex_state = 56, .external_lex_state = 2},
  [680] = {.lex_state = 56, .external_lex_state = 2},
  [681] = {.lex_state = 56, .external_lex_state = 2},
  [682] = {.lex_state = 56, .external_lex_state = 2},
  [683] = {.lex_state = 56, .external_lex_state = 2},
  [684] = {.lex_state = 56, .external_lex_state = 2},
  [685] = {.lex_state = 56, .external_lex_state = 2},
  [686] = {.lex_state = 56, .external_lex_state = 2},
  [687] = {.lex_state = 56, .external_lex_state = 2},
  [688] = {.lex_state = 56, .external_lex_state = 2},
  [689] = {.lex_state = 56, .external_lex_state = 2},
  [690] = {.lex_state = 56, .external_lex_state = 2},
  [691] = {.lex_state = 56, .external_lex_state = 2},
  [692] = {.lex_state = 57, .external_lex_state = 10},
  [693] = {.lex_state = 56, .external_lex_state = 2},
  [694] = {.lex_state = 56, .external_lex_state = 2},
  [695] = {.lex_state = 58, .external_lex_state = 2},
  [696] = {.lex_state = 56, .external_lex_state = 2},
  [697] = {.lex_state = 56, .external_lex_state = 2},
  [698] = {.lex_state = 7, .external_lex_state = 11},
  [699] = {.lex_state = 56, .external_lex_state = 2},
  [700] = {.lex_state = 56, .external_lex_state = 3},
  [701] = {.lex_state = 57, .external_lex_state = 9},
  [702] = {.lex_state = 57, .external_lex_state = 9},
  [703] = {.lex_state = 56, .external_lex_state = 2},
  [704] = {.lex_state = 56, .external_lex_state = 2},
  [705] = {.lex_state = 56, .external_lex_state = 2},
  [706] = {.lex_state = 56, .external_lex_state = 3},
  [707] = {.lex_state = 56, .external_lex_state = 2},
  [708] = {.lex_state = 56, .external_lex_state = 3},
  [709] = {.lex_state = 58, .external_lex_state = 2},
  [710] = {.lex_state = 56, .external_lex_state = 2},
  [711] = {.lex_state = 57, .external_lex_state = 10},
  [712] = {.lex_state = 56, .external_lex_state = 2},
  [713] = {.lex_state = 56, .external_lex_state = 2},
  [714] = {.lex_state = 58, .external_lex_state = 2},
  [715] = {.lex_state = 56, .external_lex_state = 2},
  [716] = {.lex_state = 56, .external_lex_state = 2},
  [717] = {.lex_state = 56, .external_lex_state = 2},
  [718] = {.lex_state = 58, .external_lex_state = 2},
  [719] = {.lex_state = 57, .external_lex_state = 9},
  [720] = {.lex_state = 56, .external_lex_state = 2},
  [721] = {.lex_state = 56, .external_lex_state = 2},
  [722] = {.lex_state = 56, .external_lex_state = 2},
  [723] = {.lex_state = 56, .external_lex_state = 2},
  [724] = {.lex_state = 56, .external_lex_state = 2},
  [725] = {.lex_state = 56, .external_lex_state = 2},
  [726] = {.lex_state = 57, .external_lex_state = 9},
  [727] = {.lex_state = 57, .external_lex_state = 9},
  [728] = {.lex_state = 56, .external_lex_state = 2},
  [729] = {.lex_state = 56, .external_lex_state = 2},
  [730] = {.lex_state = 56, .external_lex_state = 2},
  [731] = {.lex_state = 56, .external_lex_state = 2},
  [732] = {.lex_state = 56, .external_lex_state = 2},
  [733] = {.lex_state = 56, .external_lex_state = 2},
  [734] = {.lex_state = 57, .external_lex_state = 10},
  [735] = {.lex_state = 56, .external_lex_state = 3},
  [736] = {.lex_state = 56, .external_lex_state = 2},
  [737] = {.lex_state = 56, .external_lex_state = 2},
  [738] = {.lex_state = 56, .external_lex_state = 2},
  [739] = {.lex_state = 56, .external_lex_state = 2},
  [740] = {.lex_state = 57, .external_lex_state = 10},
  [741] = {.lex_state = 56, .external_lex_state = 2},
  [742] = {.lex_state = 56, .external_lex_state = 2},
  [743] = {.lex_state = 56, .external_lex_state = 2},
  [744] = {.lex_state = 56, .external_lex_state = 2},
  [745] = {.lex_state = 58, .external_lex_state = 3},
  [746] = {.lex_state = 56, .external_lex_state = 2},
  [747] = {.lex_state = 56, .external_lex_state = 2},
  [748] = {.lex_state = 56, .external_lex_state = 2},
  [749] = {.lex_state = 56, .external_lex_state = 2},
  [750] = {.lex_state = 56, .external_lex_state = 2},
  [751] = {.lex_state = 56, .external_lex_state = 2},
  [752] = {.lex_state = 57, .external_lex_state = 9},
  [753] = {.lex_state = 57, .external_lex_state = 10},
  [754] = {.lex_state = 56, .external_lex_state = 2},
  [755] = {.lex_state = 56, .external_lex_state = 2},
  [756] = {.lex_state = 57, .external_lex_state = 10},
  [757] = {.lex_state = 56, .external_lex_state = 2},
  [758] = {.lex_state = 58, .external_lex_state = 3},
  [759] = {.lex_state = 58, .external_lex_state = 2},
  [760] = {.lex_state = 56, .external_lex_state = 2},
  [761] = {.lex_state = 57, .external_lex_state = 9},
  [762] = {.lex_state = 56, .external_lex_state = 2},
  [763] = {.lex_state = 58, .external_lex_state = 3},
  [764] = {.lex_state = 56, .external_lex_state = 2},
  [765] = {.lex_state = 58, .external_lex_state = 3},
  [766] = {.lex_state = 56, .external_lex_state = 2},
  [767] = {.lex_state = 56, .external_lex_state = 2},
  [768] = {.lex_state = 56, .external_lex_state = 2},
  [769] = {.lex_state = 56, .external_lex_state = 2},
  [770] = {.lex_state = 56, .external_lex_state = 2},
  [771] = {.lex_state = 56, .external_lex_state = 2},
  [772] = {.lex_state = 57, .external_lex_state = 10},
  [773] = {.lex_state = 58, .external_lex_state = 2},
  [774] = {.lex_state = 56, .external_lex_state = 2},
  [775] = {.lex_state = 56, .external_lex_state = 2},
  [776] = {.lex_state = 56, .external_lex_state = 2},
  [777] = {.lex_state = 56, .external_lex_state = 2},
  [778] = {.lex_state = 56, .external_lex_state = 2},
  [779] = {.lex_state = 56, .external_lex_state = 2},
  [780] = {.lex_state = 56, .external_lex_state = 2},
  [781] = {.lex_state = 56, .external_lex_state = 2},
  [782] = {.lex_state = 56, .external_lex_state = 2},
  [783] = {.lex_state = 57, .external_lex_state = 9},
  [784] = {.lex_state = 56, .external_lex_state = 2},
  [785] = {.lex_state = 56, .external_lex_state = 2},
  [786] = {.lex_state = 56, .external_lex_state = 2},
  [787] = {.lex_state = 56, .external_lex_state = 2},
  [788] = {.lex_state = 56, .external_lex_state = 2},
  [789] = {.lex_state = 58, .external_lex_state = 3},
  [790] = {.lex_state = 56, .external_lex_state = 2},
  [791] = {.lex_state = 56, .external_lex_state = 3},
  [792] = {.lex_state = 56, .external_lex_state = 2},
  [793] = {.lex_state = 56, .external_lex_state = 2},
  [794] = {.lex_state = 56, .external_lex_state = 2},
  [795] = {.lex_state = 58, .external_lex_state = 3},
  [796] = {.lex_state = 56, .external_lex_state = 2},
  [797] = {.lex_state = 57, .external_lex_state = 10},
  [798] = {.lex_state = 56, .external_lex_state = 2},
  [799] = {.lex_state = 56, .external_lex_state = 2},
  [800] = {.lex_state = 56, .external_lex_state = 2},
  [801] = {.lex_state = 56, .external_lex_state = 2},
  [802] = {.lex_state = 56, .external_lex_state = 2},
  [803] = {.lex_state = 56, .external_lex_state = 2},
  [804] = {.lex_state = 56, .external_lex_state = 2},
  [805] = {.lex_state = 56, .external_lex_state = 2},
  [806] = {.lex_state = 56, .external_lex_state = 2},
  [807] = {.lex_state = 56, .external_lex_state = 2},
  [808] = {.lex_state = 56, .external_lex_state = 2},
  [809] = {.lex_state = 58, .external_lex_state = 3},
  [810] = {.lex_state = 57, .external_lex_state = 10},
  [811] = {.lex_state = 56, .external_lex_state = 2},
  [812] = {.lex_state = 56, .external_lex_state = 2},
  [813] = {.lex_state = 56, .external_lex_state = 2},
  [814] = {.lex_state = 7, .external_lex_state = 11},
  [815] = {.lex_state = 56, .external_lex_state = 2},
  [816] = {.lex_state = 56, .external_lex_state = 2},
  [817] = {.lex_state = 56, .external_lex_state = 2},
  [818] = {.lex_state = 57, .external_lex_state = 9},
  [819] = {.lex_state = 56, .external_lex_state = 2},
  [820] = {.lex_state = 58, .external_lex_state = 3},
  [821] = {.lex_state = 56, .external_lex_state = 2},
  [822] = {.lex_state = 7, .external_lex_state = 4},
  [823] = {.lex_state = 57, .external_lex_state = 9},
  [824] = {.lex_state = 56, .external_lex_state = 2},
  [825] = {.lex_state = 56, .external_lex_state = 2},
  [826] = {.lex_state = 56, .external_lex_state = 2},
  [827] = {.lex_state = 56, .external_lex_state = 2},
  [828] = {.lex_state = 56, .external_lex_state = 2},
  [829] = {.lex_state = 58, .external_lex_state = 3},
  [830] = {.lex_state = 56, .external_lex_state = 2},
  [831] = {.lex_state = 57, .external_lex_state = 10},
  [832] = {.lex_state = 58, .external_lex_state = 2},
  [833] = {.lex_state = 56, .external_lex_state = 2},
  [834] = {.lex_state = 56, .external_lex_state = 2},
  [835] = {.lex_state = 56, .external_lex_state = 2},
  [836] = {.lex_state = 56, .external_lex_state = 2},
  [837] = {.lex_state = 56, .external_lex_state = 2},
  [838] = {.lex_state = 56, .external_lex_state = 2},
  [839] = {.lex_state = 56, .external_lex_state = 2},
  [840] = {.lex_state = 56, .external_lex_state = 2},
  [841] = {.lex_state = 56, .external_lex_state = 3},
  [842] = {.lex_state = 56, .external_lex_state = 3},
  [843] = {.lex_state = 56, .external_lex_state = 2},
  [844] = {.lex_state = 56, .external_lex_state = 2},
  [845] = {.lex_state = 56, .external_lex_state = 3},
  [846] = {.lex_state = 56, .external_lex_state = 2},
  [847] = {.lex_state = 56, .external_lex_state = 3},
  [848] = {.lex_state = 56, .external_lex_state = 3},
  [849] = {.lex_state = 56, .external_lex_state = 2},
  [850] = {.lex_state = 56, .external_lex_state = 2},
  [851] = {.lex_state = 56, .external_lex_state = 2},
  [852] = {.lex_state = 56, .external_lex_state = 2},
  [853] = {.lex_state = 56, .external_lex_state = 3},
  [854] = {.lex_state = 56, .external_lex_state = 2},
  [855] = {.lex_state = 56, .external_lex_state = 3},
  [856] = {.lex_state = 56, .external_lex_state = 3},
  [857] = {.lex_state = 56, .external_lex_state = 2},
  [858] = {.lex_state = 56, .external_lex_state = 2},
  [859] = {.lex_state = 56, .external_lex_state = 3},
  [860] = {.lex_state = 56, .external_lex_state = 3},
  [861] = {.lex_state = 56, .external_lex_state = 3},
  [862] = {.lex_state = 56, .external_lex_state = 3},
  [863] = {.lex_state = 56, .external_lex_state = 3},
  [864] = {.lex_state = 56, .external_lex_state = 2},
  [865] = {.lex_state = 56, .external_lex_state = 2},
  [866] = {.lex_state = 7, .external_lex_state = 11},
  [867] = {.lex_state = 7, .external_lex_state = 11},
  [868] = {.lex_state = 56, .external_lex_state = 2},
  [869] = {.lex_state = 56, .external_lex_state = 3},
  [870] = {.lex_state = 56, .external_lex_state = 3},
  [871] = {.lex_state = 56, .external_lex_state = 3},
  [872] = {.lex_state = 56, .external_lex_state = 3},
  [873] = {.lex_state = 56, .external_lex_state = 3},
  [874] = {.lex_state = 56, .external_lex_state = 3},
  [875] = {.lex_state = 56, .external_lex_state = 3},
  [876] = {.lex_state = 56, .external_lex_state = 3},
  [877] = {.lex_state = 56, .external_lex_state = 3},
  [878] = {.lex_state = 56, .external_lex_state = 3},
  [879] = {.lex_state = 56, .external_lex_state = 3},
  [880] = {.lex_state = 56, .external_lex_state = 3},
  [881] = {.lex_state = 56, .external_lex_state = 3},
  [882] = {.lex_state = 56, .external_lex_state = 3},
  [883] = {.lex_state = 56, .external_lex_state = 3},
  [884] = {.lex_state = 56, .external_lex_state = 3},
  [885] = {.lex_state = 56, .external_lex_state = 3},
  [886] = {.lex_state = 56, .external_lex_state = 3},
  [887] = {.lex_state = 56, .external_lex_state = 2},
  [888] = {.lex_state = 56, .external_lex_state = 2},
  [889] = {.lex_state = 56, .external_lex_state = 3},
  [890] = {.lex_state = 56, .external_lex_state = 3},
  [891] = {.lex_state = 56, .external_lex_state = 3},
  [892] = {.lex_state = 56, .external_lex_state = 2},
  [893] = {.lex_state = 56, .external_lex_state = 2},
  [894] = {.lex_state = 56, .external_lex_state = 3},
  [895] = {.lex_state = 56, .external_lex_state = 2},
  [896] = {.lex_state = 56, .external_lex_state = 3},
  [897] = {.lex_state = 56, .external_lex_state = 3},
  [898] = {.lex_state = 56, .external_lex_state = 2},
  [899] = {.lex_state = 56, .external_lex_state = 2},
  [900] = {.lex_state = 56, .external_lex_state = 3},
  [901] = {.lex_state = 56, .external_lex_state = 3},
  [902] = {.lex_state = 56, .external_lex_state = 2},
  [903] = {.lex_state = 56, .external_lex_state = 3},
  [904] = {.lex_state = 56, .external_lex_state = 3},
  [905] = {.lex_state = 56, .external_lex_state = 3},
  [906] = {.lex_state = 56, .external_lex_state = 2},
  [907] = {.lex_state = 56, .external_lex_state = 3},
  [908] = {.lex_state = 56, .external_lex_state = 3},
  [909] = {.lex_state = 56, .external_lex_state = 2},
  [910] = {.lex_state = 56, .external_lex_state = 2},
  [911] = {.lex_state = 56, .external_lex_state = 2},
  [912] = {.lex_state = 56, .external_lex_state = 2},
  [913] = {.lex_state = 56, .external_lex_state = 2},
  [914] = {.lex_state = 56, .external_lex_state = 2},
  [915] = {.lex_state = 56, .external_lex_state = 2},
  [916] = {.lex_state = 56, .external_lex_state = 3},
  [917] = {.lex_state = 56, .external_lex_state = 2},
  [918] = {.lex_state = 56, .external_lex_state = 2},
  [919] = {.lex_state = 56, .external_lex_state = 2},
  [920] = {.lex_state = 56, .external_lex_state = 3},
  [921] = {.lex_state = 56, .external_lex_state = 3},
  [922] = {.lex_state = 56, .external_lex_state = 3},
  [923] = {.lex_state = 56, .external_lex_state = 2},
  [924] = {.lex_state = 56, .external_lex_state = 3},
  [925] = {.lex_state = 56, .external_lex_state = 3},
  [926] = {.lex_state = 56, .external_lex_state = 3},
  [927] = {.lex_state = 56, .external_lex_state = 3},
  [928] = {.lex_state = 56, .external_lex_state = 3},
  [929] = {.lex_state = 56, .external_lex_state = 3},
  [930] = {.lex_state = 56, .external_lex_state = 3},
  [931] = {.lex_state = 56, .external_lex_state = 3},
  [932] = {.lex_state = 56, .external_lex_state = 3},
  [933] = {.lex_state = 56, .external_lex_state = 3},
  [934] = {.lex_state = 56, .external_lex_state = 2},
  [935] = {.lex_state = 56, .external_lex_state = 2},
  [936] = {.lex_state = 56, .external_lex_state = 3},
  [937] = {.lex_state = 56, .external_lex_state = 2},
  [938] = {.lex_state = 56, .external_lex_state = 2},
  [939] = {.lex_state = 56, .external_lex_state = 3},
  [940] = {.lex_state = 56, .external_lex_state = 2},
  [941] = {.lex_state = 56, .external_lex_state = 2},
  [942] = {.lex_state = 56, .external_lex_state = 3},
  [943] = {.lex_state = 56, .external_lex_state = 2},
  [944] = {.lex_state = 56, .external_lex_state = 3},
  [945] = {.lex_state = 56, .external_lex_state = 3},
  [946] = {.lex_state = 56, .external_lex_state = 2},
  [947] = {.lex_state = 56, .external_lex_state = 2},
  [948] = {.lex_state = 56, .external_lex_state = 2},
  [949] = {.lex_state = 56, .external_lex_state = 2},
  [950] = {.lex_state = 56, .external_lex_state = 2},
  [951] = {.lex_state = 56, .external_lex_state = 2},
  [952] = {.lex_state = 56, .external_lex_state = 3},
  [953] = {.lex_state = 56, .external_lex_state = 3},
  [954] = {.lex_state = 56, .external_lex_state = 2},
  [955] = {.lex_state = 56, .external_lex_state = 3},
  [956] = {.lex_state = 56, .external_lex_state = 3},
  [957] = {.lex_state = 56, .external_lex_state = 3},
  [958] = {.lex_state = 56, .external_lex_state = 3},
  [959] = {.lex_state = 56, .external_lex_state = 3},
  [960] = {.lex_state = 56, .external_lex_state = 2},
  [961] = {.lex_state = 56, .external_lex_state = 3},
  [962] = {.lex_state = 56, .external_lex_state = 3},
  [963] = {.lex_state = 56, .external_lex_state = 2},
  [964] = {.lex_state = 56, .external_lex_state = 3},
  [965] = {.lex_state = 56, .external_lex_state = 2},
  [966] = {.lex_state = 56, .external_lex_state = 3},
  [967] = {.lex_state = 56, .external_lex_state = 2},
  [968] = {.lex_state = 56, .external_lex_state = 3},
  [969] = {.lex_state = 56, .external_lex_state = 2},
  [970] = {.lex_state = 56, .external_lex_state = 3},
  [971] = {.lex_state = 56, .external_lex_state = 3},
  [972] = {.lex_state = 56, .external_lex_state = 2},
  [973] = {.lex_state = 56, .external_lex_state = 2},
  [974] = {.lex_state = 56, .external_lex_state = 2},
  [975] = {.lex_state = 56, .external_lex_state = 2},
  [976] = {.lex_state = 56, .external_lex_state = 2},
  [977] = {.lex_state = 56, .external_lex_state = 2},
  [978] = {.lex_state = 56, .external_lex_state = 3},
  [979] = {.lex_state = 56, .external_lex_state = 2},
  [980] = {.lex_state = 56, .external_lex_state = 3},
  [981] = {.lex_state = 56, .external_lex_state = 2},
  [982] = {.lex_state = 56, .external_lex_state = 3},
  [983] = {.lex_state = 56, .external_lex_state = 3},
  [984] = {.lex_state = 56, .external_lex_state = 2},
  [985] = {.lex_state = 56, .external_lex_state = 2},
  [986] = {.lex_state = 56, .external_lex_state = 3},
  [987] = {.lex_state = 56, .external_lex_state = 3},
  [988] = {.lex_state = 56, .external_lex_state = 2},
  [989] = {.lex_state = 56, .external_lex_state = 3},
  [990] = {.lex_state = 56, .external_lex_state = 2},
  [991] = {.lex_state = 56, .external_lex_state = 3},
  [992] = {.lex_state = 56, .external_lex_state = 2},
  [993] = {.lex_state = 56, .external_lex_state = 2},
  [994] = {.lex_state = 56, .external_lex_state = 3},
  [995] = {.lex_state = 56, .external_lex_state = 2},
  [996] = {.lex_state = 56, .external_lex_state = 3},
  [997] = {.lex_state = 56, .external_lex_state = 3},
  [998] = {.lex_state = 56, .external_lex_state = 2},
  [999] = {.lex_state = 56, .external_lex_state = 3},
  [1000] = {.lex_state = 56, .external_lex_state = 3},
  [1001] = {.lex_state = 56, .external_lex_state = 3},
  [1002] = {.lex_state = 56, .external_lex_state = 2},
  [1003] = {.lex_state = 56, .external_lex_state = 2},
  [1004] = {.lex_state = 56, .external_lex_state = 2},
  [1005] = {.lex_state = 56, .external_lex_state = 3},
  [1006] = {.lex_state = 56, .external_lex_state = 2},
  [1007] = {.lex_state = 56, .external_lex_state = 2},
  [1008] = {.lex_state = 56, .external_lex_state = 2},
  [1009] = {.lex_state = 56, .external_lex_state = 2},
  [1010] = {.lex_state = 56, .external_lex_state = 3},
  [1011] = {.lex_state = 56, .external_lex_state = 2},
  [1012] = {.lex_state = 56, .external_lex_state = 3},
  [1013] = {.lex_state = 56, .external_lex_state = 3},
  [1014] = {.lex_state = 56, .external_lex_state = 2},
  [1015] = {.lex_state = 56, .external_lex_state = 3},
  [1016] = {.lex_state = 56, .external_lex_state = 2},
  [1017] = {.lex_state = 56, .external_lex_state = 3},
  [1018] = {.lex_state = 56, .external_lex_state = 2},
  [1019] = {.lex_state = 56, .external_lex_state = 3},
  [1020] = {.lex_state = 56, .external_lex_state = 2},
  [1021] = {.lex_state = 56, .external_lex_state = 2},
  [1022] = {.lex_state = 56, .external_lex_state = 2},
  [1023] = {.lex_state = 56, .external_lex_state = 2},
  [1024] = {.lex_state = 56, .external_lex_state = 3},
  [1025] = {.lex_state = 56, .external_lex_state = 2},
  [1026] = {.lex_state = 56, .external_lex_state = 2},
  [1027] = {.lex_state = 56, .external_lex_state = 2},
  [1028] = {.lex_state = 56, .external_lex_state = 2},
  [1029] = {.lex_state = 56, .external_lex_state = 2},
  [1030] = {.lex_state = 56, .external_lex_state = 2},
  [1031] = {.lex_state = 56, .external_lex_state = 2},
  [1032] = {.lex_state = 56, .external_lex_state = 2},
  [1033] = {.lex_state = 56, .external_lex_state = 2},
  [1034] = {.lex_state = 56, .external_lex_state = 2},
  [1035] = {.lex_state = 56, .external_lex_state = 2},
  [1036] = {.lex_state = 56, .external_lex_state = 2},
  [1037] = {.lex_state = 56, .external_lex_state = 2},
  [1038] = {.lex_state = 56, .external_lex_state = 2},
  [1039] = {.lex_state = 56, .external_lex_state = 2},
  [1040] = {.lex_state = 56, .external_lex_state = 3},
  [1041] = {.lex_state = 56, .external_lex_state = 2},
  [1042] = {.lex_state = 56, .external_lex_state = 2},
  [1043] = {.lex_state = 56, .external_lex_state = 2},
  [1044] = {.lex_state = 56, .external_lex_state = 2},
  [1045] = {.lex_state = 56, .external_lex_state = 2},
  [1046] = {.lex_state = 56, .external_lex_state = 3},
  [1047] = {.lex_state = 56, .external_lex_state = 2},
  [1048] = {.lex_state = 56, .external_lex_state = 2},
  [1049] = {.lex_state = 56, .external_lex_state = 2},
  [1050] = {.lex_state = 56, .external_lex_state = 2},
  [1051] = {.lex_state = 56, .external_lex_state = 2},
  [1052] = {.lex_state = 56, .external_lex_state = 2},
  [1053] = {.lex_state = 56, .external_lex_state = 2},
  [1054] = {.lex_state = 56, .external_lex_state = 2},
  [1055] = {.lex_state = 56, .external_lex_state = 3},
  [1056] = {.lex_state = 56, .external_lex_state = 2},
  [1057] = {.lex_state = 56, .external_lex_state = 3},
  [1058] = {.lex_state = 56, .external_lex_state = 3},
  [1059] = {.lex_state = 56, .external_lex_state = 3},
  [1060] = {.lex_state = 56, .external_lex_state = 3},
  [1061] = {.lex_state = 56, .external_lex_state = 3},
  [1062] = {.lex_state = 56, .external_lex_state = 3},
  [1063] = {.lex_state = 56, .external_lex_state = 3},
  [1064] = {.lex_state = 56, .external_lex_state = 3},
  [1065] = {.lex_state = 56, .external_lex_state = 3},
  [1066] = {.lex_state = 56, .external_lex_state = 3},
  [1067] = {.lex_state = 56, .external_lex_state = 3},
  [1068] = {.lex_state = 56, .external_lex_state = 3},
  [1069] = {.lex_state = 56, .external_lex_state = 3},
  [1070] = {.lex_state = 56, .external_lex_state = 2},
  [1071] = {.lex_state = 56, .external_lex_state = 2},
  [1072] = {.lex_state = 56, .external_lex_state = 3},
  [1073] = {.lex_state = 56, .external_lex_state = 2},
  [1074] = {.lex_state = 56, .external_lex_state = 3},
  [1075] = {.lex_state = 56, .external_lex_state = 2},
  [1076] = {.lex_state = 56, .external_lex_state = 2},
  [1077] = {.lex_state = 56, .external_lex_state = 2},
  [1078] = {.lex_state = 56, .external_lex_state = 2},
  [1079] = {.lex_state = 56, .external_lex_state = 2},
  [1080] = {.lex_state = 56, .external_lex_state = 2},
  [1081] = {.lex_state = 56, .external_lex_state = 3},
  [1082] = {.lex_state = 56, .external_lex_state = 2},
  [1083] = {.lex_state = 56, .external_lex_state = 3},
  [1084] = {.lex_state = 56, .external_lex_state = 3},
  [1085] = {.lex_state = 56, .external_lex_state = 3},
  [1086] = {.lex_state = 56, .external_lex_state = 3},
  [1087] = {.lex_state = 56, .external_lex_state = 3},
  [1088] = {.lex_state = 56, .external_lex_state = 6},
  [1089] = {.lex_state = 8, .external_lex_state = 11},
  [1090] = {.lex_state = 8, .external_lex_state = 11},
  [1091] = {.lex_state = 8, .external_lex_state = 11},
  [1092] = {.lex_state = 8, .external_lex_state = 11},
  [1093] = {.lex_state = 8, .external_lex_state = 11},
  [1094] = {.lex_state = 8, .external_lex_state = 11},
  [1095] = {.lex_state = 56, .external_lex_state = 6},
  [1096] = {.lex_state = 8, .external_lex_state = 11},
  [1097] = {.lex_state = 8, .external_lex_state = 11},
  [1098] = {.lex_state = 8, .external_lex_state = 11},
  [1099] = {.lex_state = 8, .external_lex_state = 11},
  [1100] = {.lex_state = 8, .external_lex_state = 11},
  [1101] = {.lex_state = 8, .external_lex_state = 11},
  [1102] = {.lex_state = 8, .external_lex_state = 11},
  [1103] = {.lex_state = 8, .external_lex_state = 11},
  [1104] = {.lex_state = 8, .external_lex_state = 11},
  [1105] = {.lex_state = 8, .external_lex_state = 11},
  [1106] = {.lex_state = 8, .external_lex_state = 11},
  [1107] = {.lex_state = 8, .external_lex_state = 11},
  [1108] = {.lex_state = 7, .external_lex_state = 11},
  [1109] = {.lex_state = 8, .external_lex_state = 11},
  [1110] = {.lex_state = 7, .external_lex_state = 11},
  [1111] = {.lex_state = 56, .external_lex_state = 2},
  [1112] = {.lex_state = 56, .external_lex_state = 2},
  [1113] = {.lex_state = 56, .external_lex_state = 7},
  [1114] = {.lex_state = 56, .external_lex_state = 7},
  [1115] = {.lex_state = 56, .external_lex_state = 2},
  [1116] = {.lex_state = 56, .external_lex_state = 2},
  [1117] = {.lex_state = 56, .external_lex_state = 8},
  [1118] = {.lex_state = 56, .external_lex_state = 2},
  [1119] = {.lex_state = 56, .external_lex_state = 2},
  [1120] = {.lex_state = 56, .external_lex_state = 2},
  [1121] = {.lex_state = 56, .external_lex_state = 8},
  [1122] = {.lex_state = 56, .external_lex_state = 7},
  [1123] = {.lex_state = 56, .external_lex_state = 2},
  [1124] = {.lex_state = 56, .external_lex_state = 2},
  [1125] = {.lex_state = 56, .external_lex_state = 2},
  [1126] = {.lex_state = 56, .external_lex_state = 2},
  [1127] = {.lex_state = 56, .external_lex_state = 2},
  [1128] = {.lex_state = 56, .external_lex_state = 2},
  [1129] = {.lex_state = 56, .external_lex_state = 7},
  [1130] = {.lex_state = 56, .external_lex_state = 2},
  [1131] = {.lex_state = 56, .external_lex_state = 2},
  [1132] = {.lex_state = 56, .external_lex_state = 2},
  [1133] = {.lex_state = 56, .external_lex_state = 2},
  [1134] = {.lex_state = 56, .external_lex_state = 2},
  [1135] = {.lex_state = 56, .external_lex_state = 2},
  [1136] = {.lex_state = 56, .external_lex_state = 7},
  [1137] = {.lex_state = 56, .external_lex_state = 2},
  [1138] = {.lex_state = 56, .external_lex_state = 2},
  [1139] = {.lex_state = 56, .external_lex_state = 2},
  [1140] = {.lex_state = 56, .external_lex_state = 2},
  [1141] = {.lex_state = 56, .external_lex_state = 2},
  [1142] = {.lex_state = 56, .external_lex_state = 2},
  [1143] = {.lex_state = 56, .external_lex_state = 2},
  [1144] = {.lex_state = 56, .external_lex_state = 2},
  [1145] = {.lex_state = 56, .external_lex_state = 2},
  [1146] = {.lex_state = 56, .external_lex_state = 2},
  [1147] = {.lex_state = 56, .external_lex_state = 2},
  [1148] = {.lex_state = 56, .external_lex_state = 2},
  [1149] = {.lex_state = 56, .external_lex_state = 2},
  [1150] = {.lex_state = 56, .external_lex_state = 2},
  [1151] = {.lex_state = 56, .external_lex_state = 2},
  [1152] = {.lex_state = 56, .external_lex_state = 2},
  [1153] = {.lex_state = 56, .external_lex_state = 2},
  [1154] = {.lex_state = 56, .external_lex_state = 2},
  [1155] = {.lex_state = 56, .external_lex_state = 2},
  [1156] = {.lex_state = 56, .external_lex_state = 2},
  [1157] = {.lex_state = 56, .external_lex_state = 2},
  [1158] = {.lex_state = 56, .external_lex_state = 2},
  [1159] = {.lex_state = 56, .external_lex_state = 2},
  [1160] = {.lex_state = 56, .external_lex_state = 2},
  [1161] = {.lex_state = 14, .external_lex_state = 11},
  [1162] = {.lex_state = 56, .external_lex_state = 2},
  [1163] = {.lex_state = 56, .external_lex_state = 2},
  [1164] = {.lex_state = 56, .external_lex_state = 2},
  [1165] = {.lex_state = 56, .external_lex_state = 2},
  [1166] = {.lex_state = 56, .external_lex_state = 2},
  [1167] = {.lex_state = 56, .external_lex_state = 2},
  [1168] = {.lex_state = 56, .external_lex_state = 2},
  [1169] = {.lex_state = 56, .external_lex_state = 2},
  [1170] = {.lex_state = 56, .external_lex_state = 2},
  [1171] = {.lex_state = 56, .external_lex_state = 2},
  [1172] = {.lex_state = 56, .external_lex_state = 2},
  [1173] = {.lex_state = 56, .external_lex_state = 2},
  [1174] = {.lex_state = 56, .external_lex_state = 2},
  [1175] = {.lex_state = 56, .external_lex_state = 2},
  [1176] = {.lex_state = 56, .external_lex_state = 2},
  [1177] = {.lex_state = 56, .external_lex_state = 2},
  [1178] = {.lex_state = 56, .external_lex_state = 2},
  [1179] = {.lex_state = 56, .external_lex_state = 2},
  [1180] = {.lex_state = 56, .external_lex_state = 2},
  [1181] = {.lex_state = 56, .external_lex_state = 2},
  [1182] = {.lex_state = 56, .external_lex_state = 2},
  [1183] = {.lex_state = 56, .external_lex_state = 2},
  [1184] = {.lex_state = 56, .external_lex_state = 2},
  [1185] = {.lex_state = 56, .external_lex_state = 2},
  [1186] = {.lex_state = 56, .external_lex_state = 2},
  [1187] = {.lex_state = 56, .external_lex_state = 2},
  [1188] = {.lex_state = 56, .external_lex_state = 2},
  [1189] = {.lex_state = 56, .external_lex_state = 2},
  [1190] = {.lex_state = 56, .external_lex_state = 2},
  [1191] = {.lex_state = 56, .external_lex_state = 2},
  [1192] = {.lex_state = 56, .external_lex_state = 2},
  [1193] = {.lex_state = 56, .external_lex_state = 2},
  [1194] = {.lex_state = 56, .external_lex_state = 2},
  [1195] = {.lex_state = 56, .external_lex_state = 2},
  [1196] = {.lex_state = 56, .external_lex_state = 2},
  [1197] = {.lex_state = 56, .external_lex_state = 2},
  [1198] = {.lex_state = 56, .external_lex_state = 2},
  [1199] = {.lex_state = 56, .external_lex_state = 2},
  [1200] = {.lex_state = 56, .external_lex_state = 2},
  [1201] = {.lex_state = 56, .external_lex_state = 2},
  [1202] = {.lex_state = 56, .external_lex_state = 2},
  [1203] = {.lex_state = 56, .external_lex_state = 2},
  [1204] = {.lex_state = 56, .external_lex_state = 2},
  [1205] = {.lex_state = 56, .external_lex_state = 2},
  [1206] = {.lex_state = 56, .external_lex_state = 2},
  [1207] = {.lex_state = 56, .external_lex_state = 2},
  [1208] = {.lex_state = 56, .external_lex_state = 2},
  [1209] = {.lex_state = 56, .external_lex_state = 2},
  [1210] = {.lex_state = 56, .external_lex_state = 2},
  [1211] = {.lex_state = 56, .external_lex_state = 2},
  [1212] = {.lex_state = 56, .external_lex_state = 2},
  [1213] = {.lex_state = 56, .external_lex_state = 2},
  [1214] = {.lex_state = 56, .external_lex_state = 2},
  [1215] = {.lex_state = 56, .external_lex_state = 2},
  [1216] = {.lex_state = 56, .external_lex_state = 2},
  [1217] = {.lex_state = 56, .external_lex_state = 2},
  [1218] = {.lex_state = 56, .external_lex_state = 2},
  [1219] = {.lex_state = 56, .external_lex_state = 2},
  [1220] = {.lex_state = 56, .external_lex_state = 2},
  [1221] = {.lex_state = 56, .external_lex_state = 2},
  [1222] = {.lex_state = 56, .external_lex_state = 2},
  [1223] = {.lex_state = 56, .external_lex_state = 2},
  [1224] = {.lex_state = 56, .external_lex_state = 2},
  [1225] = {.lex_state = 56, .external_lex_state = 2},
  [1226] = {.lex_state = 56, .external_lex_state = 2},
  [1227] = {.lex_state = 56, .external_lex_state = 2},
  [1228] = {.lex_state = 56, .external_lex_state = 2},
  [1229] = {.lex_state = 56, .external_lex_state = 2},
  [1230] = {.lex_state = 56, .external_lex_state = 2},
  [1231] = {.lex_state = 56, .external_lex_state = 2},
  [1232] = {.lex_state = 56, .external_lex_state = 2},
  [1233] = {.lex_state = 56, .external_lex_state = 2},
  [1234] = {.lex_state = 56, .external_lex_state = 2},
  [1235] = {.lex_state = 56, .external_lex_state = 2},
  [1236] = {.lex_state = 56, .external_lex_state = 2},
  [1237] = {.lex_state = 56, .external_lex_state = 2},
  [1238] = {.lex_state = 56, .external_lex_state = 2},
  [1239] = {.lex_state = 56, .external_lex_state = 2},
  [1240] = {.lex_state = 56, .external_lex_state = 2},
  [1241] = {.lex_state = 56, .external_lex_state = 2},
  [1242] = {.lex_state = 56, .external_lex_state = 2},
  [1243] = {.lex_state = 56, .external_lex_state = 2},
  [1244] = {.lex_state = 56, .external_lex_state = 2},
  [1245] = {.lex_state = 56, .external_lex_state = 2},
  [1246] = {.lex_state = 56, .external_lex_state = 2},
  [1247] = {.lex_state = 56, .external_lex_state = 2},
  [1248] = {.lex_state = 56, .external_lex_state = 2},
  [1249] = {.lex_state = 56, .external_lex_state = 2},
  [1250] = {.lex_state = 56, .external_lex_state = 2},
  [1251] = {.lex_state = 56, .external_lex_state = 2},
  [1252] = {.lex_state = 56, .external_lex_state = 2},
  [1253] = {.lex_state = 56, .external_lex_state = 2},
  [1254] = {.lex_state = 56, .external_lex_state = 2},
  [1255] = {.lex_state = 14, .external_lex_state = 11},
  [1256] = {.lex_state = 14, .external_lex_state = 11},
  [1257] = {.lex_state = 14, .external_lex_state = 11},
  [1258] = {.lex_state = 14, .external_lex_state = 11},
  [1259] = {.lex_state = 14, .external_lex_state = 11},
  [1260] = {.lex_state = 14, .external_lex_state = 11},
  [1261] = {.lex_state = 14, .external_lex_state = 11},
  [1262] = {.lex_state = 14, .external_lex_state = 11},
  [1263] = {.lex_state = 14, .external_lex_state = 11},
  [1264] = {.lex_state = 14, .external_lex_state = 4},
  [1265] = {.lex_state = 14, .external_lex_state = 12},
  [1266] = {.lex_state = 14, .external_lex_state = 11},
  [1267] = {.lex_state = 14, .external_lex_state = 4},
  [1268] = {.lex_state = 14, .external_lex_state = 11},
  [1269] = {.lex_state = 14, .external_lex_state = 12},
  [1270] = {.lex_state = 14, .external_lex_state = 11},
  [1271] = {.lex_state = 14, .external_lex_state = 4},
  [1272] = {.lex_state = 14, .external_lex_state = 12},
  [1273] = {.lex_state = 14, .external_lex_state = 13},
  [1274] = {.lex_state = 14, .external_lex_state = 12},
  [1275] = {.lex_state = 14, .external_lex_state = 12},
  [1276] = {.lex_state = 14, .external_lex_state = 12},
  [1277] = {.lex_state = 14, .external_lex_state = 12},
  [1278] = {.lex_state = 14, .external_lex_state = 12},
  [1279] = {.lex_state = 14, .external_lex_state = 12},
  [1280] = {.lex_state = 14, .external_lex_state = 12},
  [1281] = {.lex_state = 14, .external_lex_state = 6},
  [1282] = {.lex_state = 14, .external_lex_state = 12},
  [1283] = {.lex_state = 14, .external_lex_state = 6},
  [1284] = {.lex_state = 14, .external_lex_state = 6},
  [1285] = {.lex_state = 14, .external_lex_state = 6},
  [1286] = {.lex_state = 14, .external_lex_state = 12},
  [1287] = {.lex_state = 14, .external_lex_state = 12},
  [1288] = {.lex_state = 14, .external_lex_state = 13},
  [1289] = {.lex_state = 14, .external_lex_state = 12},
  [1290] = {.lex_state = 14, .external_lex_state = 12},
  [1291] = {.lex_state = 14, .external_lex_state = 12},
  [1292] = {.lex_state = 14, .external_lex_state = 12},
  [1293] = {.lex_state = 14, .external_lex_state = 6},
  [1294] = {.lex_state = 14, .external_lex_state = 14},
  [1295] = {.lex_state = 14, .external_lex_state = 11},
  [1296] = {.lex_state = 14, .external_lex_state = 15},
  [1297] = {.lex_state = 14, .external_lex_state = 12},
  [1298] = {.lex_state = 14, .external_lex_state = 12},
  [1299] = {.lex_state = 14, .external_lex_state = 12},
  [1300] = {.lex_state = 14, .external_lex_state = 12},
  [1301] = {.lex_state = 14, .external_lex_state = 12},
  [1302] = {.lex_state = 14, .external_lex_state = 6},
  [1303] = {.lex_state = 14, .external_lex_state = 12},
  [1304] = {.lex_state = 14, .external_lex_state = 12},
  [1305] = {.lex_state = 14, .external_lex_state = 12},
  [1306] = {.lex_state = 14, .external_lex_state = 12},
  [1307] = {.lex_state = 14, .external_lex_state = 13},
  [1308] = {.lex_state = 14, .external_lex_state = 14},
  [1309] = {.lex_state = 14, .external_lex_state = 14},
  [1310] = {.lex_state = 14, .external_lex_state = 12},
  [1311] = {.lex_state = 14, .external_lex_state = 15},
  [1312] = {.lex_state = 14, .external_lex_state = 12},
  [1313] = {.lex_state = 14, .external_lex_state = 12},
  [1314] = {.lex_state = 14, .external_lex_state = 12},
  [1315] = {.lex_state = 14, .external_lex_state = 2},
  [1316] = {.lex_state = 14, .external_lex_state = 4},
  [1317] = {.lex_state = 14, .external_lex_state = 12},
  [1318] = {.lex_state = 14, .external_lex_state = 12},
  [1319] = {.lex_state = 14, .external_lex_state = 7},
  [1320] = {.lex_state = 14, .external_lex_state = 13},
  [1321] = {.lex_state = 14, .external_lex_state = 13},
  [1322] = {.lex_state = 15, .external_lex_state = 11},
  [1323] = {.lex_state = 14, .external_lex_state = 15},
  [1324] = {.lex_state = 14, .external_lex_state = 14},
  [1325] = {.lex_state = 14, .external_lex_state = 13},
  [1326] = {.lex_state = 14, .external_lex_state = 15},
  [1327] = {.lex_state = 14, .external_lex_state = 13},
  [1328] = {.lex_state = 15, .external_lex_state = 11},
  [1329] = {.lex_state = 14, .external_lex_state = 15},
  [1330] = {.lex_state = 14, .external_lex_state = 15},
  [1331] = {.lex_state = 14, .external_lex_state = 13},
  [1332] = {.lex_state = 15, .external_lex_state = 11},
  [1333] = {.lex_state = 14, .external_lex_state = 14},
  [1334] = {.lex_state = 14, .external_lex_state = 14},
  [1335] = {.lex_state = 14, .external_lex_state = 14},
  [1336] = {.lex_state = 14, .external_lex_state = 13},
  [1337] = {.lex_state = 14, .external_lex_state = 14},
  [1338] = {.lex_state = 14, .external_lex_state = 13},
  [1339] = {.lex_state = 14, .external_lex_state = 13},
  [1340] = {.lex_state = 14, .external_lex_state = 13},
  [1341] = {.lex_state = 14, .external_lex_state = 14},
  [1342] = {.lex_state = 14, .external_lex_state = 7},
  [1343] = {.lex_state = 14, .external_lex_state = 13},
  [1344] = {.lex_state = 14, .external_lex_state = 13},
  [1345] = {.lex_state = 14, .external_lex_state = 13},
  [1346] = {.lex_state = 14, .external_lex_state = 13},
  [1347] = {.lex_state = 14, .external_lex_state = 14},
  [1348] = {.lex_state = 14, .external_lex_state = 14},
  [1349] = {.lex_state = 14, .external_lex_state = 13},
  [1350] = {.lex_state = 14, .external_lex_state = 13},
  [1351] = {.lex_state = 14, .external_lex_state = 8},
  [1352] = {.lex_state = 14, .external_lex_state = 14},
  [1353] = {.lex_state = 14, .external_lex_state = 14},
  [1354] = {.lex_state = 14, .external_lex_state = 15},
  [1355] = {.lex_state = 14, .external_lex_state = 13},
  [1356] = {.lex_state = 14, .external_lex_state = 7},
  [1357] = {.lex_state = 14, .external_lex_state = 15},
  [1358] = {.lex_state = 14, .external_lex_state = 13},
  [1359] = {.lex_state = 14, .external_lex_state = 12},
  [1360] = {.lex_state = 14, .external_lex_state = 15},
  [1361] = {.lex_state = 14, .external_lex_state = 7},
  [1362] = {.lex_state = 14, .external_lex_state = 13},
  [1363] = {.lex_state = 14, .external_lex_state = 15},
  [1364] = {.lex_state = 14, .external_lex_state = 15},
  [1365] = {.lex_state = 14, .external_lex_state = 15},
  [1366] = {.lex_state = 14, .external_lex_state = 15},
  [1367] = {.lex_state = 14, .external_lex_state = 15},
  [1368] = {.lex_state = 14, .external_lex_state = 13},
  [1369] = {.lex_state = 14, .external_lex_state = 7},
  [1370] = {.lex_state = 14, .external_lex_state = 13},
  [1371] = {.lex_state = 14, .external_lex_state = 2},
  [1372] = {.lex_state = 14, .external_lex_state = 2},
  [1373] = {.lex_state = 14, .external_lex_state = 12},
  [1374] = {.lex_state = 14, .external_lex_state = 13},
  [1375] = {.lex_state = 14, .external_lex_state = 7},
  [1376] = {.lex_state = 14, .external_lex_state = 8},
  [1377] = {.lex_state = 14, .external_lex_state = 8},
  [1378] = {.lex_state = 14, .external_lex_state = 4},
  [1379] = {.lex_state = 14, .external_lex_state = 12},
  [1380] = {.lex_state = 14, .external_lex_state = 13},
  [1381] = {.lex_state = 14, .external_lex_state = 13},
  [1382] = {.lex_state = 15, .external_lex_state = 12},
  [1383] = {.lex_state = 14, .external_lex_state = 11},
  [1384] = {.lex_state = 15, .external_lex_state = 12},
  [1385] = {.lex_state = 14, .external_lex_state = 11},
  [1386] = {.lex_state = 15, .external_lex_state = 12},
  [1387] = {.lex_state = 14, .external_lex_state = 11},
  [1388] = {.lex_state = 14, .external_lex_state = 11},
  [1389] = {.lex_state = 15, .external_lex_state = 12},
  [1390] = {.lex_state = 14, .external_lex_state = 11},
  [1391] = {.lex_state = 14, .external_lex_state = 15},
  [1392] = {.lex_state = 14, .external_lex_state = 11},
  [1393] = {.lex_state = 14, .external_lex_state = 6},
  [1394] = {.lex_state = 14, .external_lex_state = 8},
  [1395] = {.lex_state = 15, .external_lex_state = 12},
  [1396] = {.lex_state = 14, .external_lex_state = 11},
  [1397] = {.lex_state = 14, .external_lex_state = 11},
  [1398] = {.lex_state = 15, .external_lex_state = 12},
  [1399] = {.lex_state = 15, .external_lex_state = 12},
  [1400] = {.lex_state = 15, .external_lex_state = 12},
  [1401] = {.lex_state = 14, .external_lex_state = 11},
  [1402] = {.lex_state = 14, .external_lex_state = 11},
  [1403] = {.lex_state = 14, .external_lex_state = 11},
  [1404] = {.lex_state = 14, .external_lex_state = 11},
  [1405] = {.lex_state = 14, .external_lex_state = 11},
  [1406] = {.lex_state = 14, .external_lex_state = 11},
  [1407] = {.lex_state = 14, .external_lex_state = 6},
  [1408] = {.lex_state = 15, .external_lex_state = 12},
  [1409] = {.lex_state = 14, .external_lex_state = 11},
  [1410] = {.lex_state = 14, .external_lex_state = 11},
  [1411] = {.lex_state = 14, .external_lex_state = 11},
  [1412] = {.lex_state = 15, .external_lex_state = 11},
  [1413] = {.lex_state = 14, .external_lex_state = 11},
  [1414] = {.lex_state = 14, .external_lex_state = 6},
  [1415] = {.lex_state = 14, .external_lex_state = 11},
  [1416] = {.lex_state = 14, .external_lex_state = 11},
  [1417] = {.lex_state = 14, .external_lex_state = 15},
  [1418] = {.lex_state = 14, .external_lex_state = 12},
  [1419] = {.lex_state = 14, .external_lex_state = 15},
  [1420] = {.lex_state = 14, .external_lex_state = 11},
  [1421] = {.lex_state = 14, .external_lex_state = 8},
  [1422] = {.lex_state = 14, .external_lex_state = 11},
  [1423] = {.lex_state = 14, .external_lex_state = 11},
  [1424] = {.lex_state = 15, .external_lex_state = 13},
  [1425] = {.lex_state = 14, .external_lex_state = 15},
  [1426] = {.lex_state = 14, .external_lex_state = 15},
  [1427] = {.lex_state = 14, .external_lex_state = 6},
  [1428] = {.lex_state = 14, .external_lex_state = 11},
  [1429] = {.lex_state = 14, .external_lex_state = 15},
  [1430] = {.lex_state = 14, .external_lex_state = 15},
  [1431] = {.lex_state = 14, .external_lex_state = 11},
  [1432] = {.lex_state = 14, .external_lex_state = 15},
  [1433] = {.lex_state = 14, .external_lex_state = 15},
  [1434] = {.lex_state = 14, .external_lex_state = 11},
  [1435] = {.lex_state = 14, .external_lex_state = 15},
  [1436] = {.lex_state = 14, .external_lex_state = 11},
  [1437] = {.lex_state = 14, .external_lex_state = 11},
  [1438] = {.lex_state = 14, .external_lex_state = 15},
  [1439] = {.lex_state = 14, .external_lex_state = 8},
  [1440] = {.lex_state = 14, .external_lex_state = 11},
  [1441] = {.lex_state = 15, .external_lex_state = 12},
  [1442] = {.lex_state = 14, .external_lex_state = 11},
  [1443] = {.lex_state = 15, .external_lex_state = 12},
  [1444] = {.lex_state = 15, .external_lex_state = 12},
  [1445] = {.lex_state = 15, .external_lex_state = 13},
  [1446] = {.lex_state = 14, .external_lex_state = 11},
  [1447] = {.lex_state = 14, .external_lex_state = 15},
  [1448] = {.lex_state = 14, .external_lex_state = 11},
  [1449] = {.lex_state = 14, .external_lex_state = 15},
  [1450] = {.lex_state = 14, .external_lex_state = 11},
  [1451] = {.lex_state = 14, .external_lex_state = 11},
  [1452] = {.lex_state = 15, .external_lex_state = 13},
  [1453] = {.lex_state = 14, .external_lex_state = 11},
  [1454] = {.lex_state = 14, .external_lex_state = 11},
  [1455] = {.lex_state = 14, .external_lex_state = 11},
  [1456] = {.lex_state = 14, .external_lex_state = 11},
  [1457] = {.lex_state = 14, .external_lex_state = 13},
  [1458] = {.lex_state = 14, .external_lex_state = 11},
  [1459] = {.lex_state = 14, .external_lex_state = 11},
  [1460] = {.lex_state = 15, .external_lex_state = 13},
  [1461] = {.lex_state = 14, .external_lex_state = 11},
  [1462] = {.lex_state = 14, .external_lex_state = 11},
  [1463] = {.lex_state = 14, .external_lex_state = 12},
  [1464] = {.lex_state = 14, .external_lex_state = 12},
  [1465] = {.lex_state = 14, .external_lex_state = 12},
  [1466] = {.lex_state = 14, .external_lex_state = 12},
  [1467] = {.lex_state = 14, .external_lex_state = 12},
  [1468] = {.lex_state = 14, .external_lex_state = 12},
  [1469] = {.lex_state = 14, .external_lex_state = 12},
  [1470] = {.lex_state = 15, .external_lex_state = 13},
  [1471] = {.lex_state = 15, .external_lex_state = 13},
  [1472] = {.lex_state = 15, .external_lex_state = 13},
  [1473] = {.lex_state = 15, .external_lex_state = 13},
  [1474] = {.lex_state = 15, .external_lex_state = 13},
  [1475] = {.lex_state = 15, .external_lex_state = 13},
  [1476] = {.lex_state = 14, .external_lex_state = 12},
  [1477] = {.lex_state = 15, .external_lex_state = 13},
  [1478] = {.lex_state = 14, .external_lex_state = 12},
  [1479] = {.lex_state = 14, .external_lex_state = 12},
  [1480] = {.lex_state = 14, .external_lex_state = 12},
  [1481] = {.lex_state = 14, .external_lex_state = 12},
  [1482] = {.lex_state = 14, .external_lex_state = 12},
  [1483] = {.lex_state = 14, .external_lex_state = 12},
  [1484] = {.lex_state = 14, .external_lex_state = 7},
  [1485] = {.lex_state = 14, .external_lex_state = 12},
  [1486] = {.lex_state = 14, .external_lex_state = 12},
  [1487] = {.lex_state = 15, .external_lex_state = 15},
  [1488] = {.lex_state = 15, .external_lex_state = 14},
  [1489] = {.lex_state = 14, .external_lex_state = 12},
  [1490] = {.lex_state = 14, .external_lex_state = 12},
  [1491] = {.lex_state = 15, .external_lex_state = 14},
  [1492] = {.lex_state = 15, .external_lex_state = 14},
  [1493] = {.lex_state = 14, .external_lex_state = 12},
  [1494] = {.lex_state = 14, .external_lex_state = 12},
  [1495] = {.lex_state = 14, .external_lex_state = 12},
  [1496] = {.lex_state = 14, .external_lex_state = 12},
  [1497] = {.lex_state = 14, .external_lex_state = 12},
  [1498] = {.lex_state = 14, .external_lex_state = 12},
  [1499] = {.lex_state = 14, .external_lex_state = 12},
  [1500] = {.lex_state = 14, .external_lex_state = 8},
  [1501] = {.lex_state = 15, .external_lex_state = 15},
  [1502] = {.lex_state = 15, .external_lex_state = 15},
  [1503] = {.lex_state = 14, .external_lex_state = 8},
  [1504] = {.lex_state = 14, .external_lex_state = 12},
  [1505] = {.lex_state = 14, .external_lex_state = 12},
  [1506] = {.lex_state = 14, .external_lex_state = 12},
  [1507] = {.lex_state = 14, .external_lex_state = 12},
  [1508] = {.lex_state = 14, .external_lex_state = 12},
  [1509] = {.lex_state = 14, .external_lex_state = 7},
  [1510] = {.lex_state = 15, .external_lex_state = 13},
  [1511] = {.lex_state = 14, .external_lex_state = 2},
  [1512] = {.lex_state = 14, .external_lex_state = 12},
  [1513] = {.lex_state = 14, .external_lex_state = 12},
  [1514] = {.lex_state = 14, .external_lex_state = 12},
  [1515] = {.lex_state = 14, .external_lex_state = 7},
  [1516] = {.lex_state = 14, .external_lex_state = 12},
  [1517] = {.lex_state = 15, .external_lex_state = 15},
  [1518] = {.lex_state = 15, .external_lex_state = 15},
  [1519] = {.lex_state = 15, .external_lex_state = 15},
  [1520] = {.lex_state = 14, .external_lex_state = 12},
  [1521] = {.lex_state = 14, .external_lex_state = 12},
  [1522] = {.lex_state = 15, .external_lex_state = 13},
  [1523] = {.lex_state = 14, .external_lex_state = 12},
  [1524] = {.lex_state = 14, .external_lex_state = 12},
  [1525] = {.lex_state = 14, .external_lex_state = 13},
  [1526] = {.lex_state = 14, .external_lex_state = 13},
  [1527] = {.lex_state = 14, .external_lex_state = 12},
  [1528] = {.lex_state = 15, .external_lex_state = 15},
  [1529] = {.lex_state = 15, .external_lex_state = 15},
  [1530] = {.lex_state = 14, .external_lex_state = 12},
  [1531] = {.lex_state = 15, .external_lex_state = 15},
  [1532] = {.lex_state = 14, .external_lex_state = 12},
  [1533] = {.lex_state = 15, .external_lex_state = 14},
  [1534] = {.lex_state = 14, .external_lex_state = 12},
  [1535] = {.lex_state = 14, .external_lex_state = 12},
  [1536] = {.lex_state = 14, .external_lex_state = 12},
  [1537] = {.lex_state = 14, .external_lex_state = 12},
  [1538] = {.lex_state = 15, .external_lex_state = 15},
  [1539] = {.lex_state = 14, .external_lex_state = 12},
  [1540] = {.lex_state = 14, .external_lex_state = 12},
  [1541] = {.lex_state = 14, .external_lex_state = 12},
  [1542] = {.lex_state = 14, .external_lex_state = 12},
  [1543] = {.lex_state = 14, .external_lex_state = 7},
  [1544] = {.lex_state = 14, .external_lex_state = 12},
  [1545] = {.lex_state = 14, .external_lex_state = 12},
  [1546] = {.lex_state = 14, .external_lex_state = 12},
  [1547] = {.lex_state = 14, .external_lex_state = 12},
  [1548] = {.lex_state = 14, .external_lex_state = 12},
  [1549] = {.lex_state = 14, .external_lex_state = 12},
  [1550] = {.lex_state = 14, .external_lex_state = 12},
  [1551] = {.lex_state = 14, .external_lex_state = 12},
  [1552] = {.lex_state = 14, .external_lex_state = 13},
  [1553] = {.lex_state = 14, .external_lex_state = 13},
  [1554] = {.lex_state = 14, .external_lex_state = 13},
  [1555] = {.lex_state = 14, .external_lex_state = 13},
  [1556] = {.lex_state = 14, .external_lex_state = 12},
  [1557] = {.lex_state = 14, .external_lex_state = 12},
  [1558] = {.lex_state = 14, .external_lex_state = 12},
  [1559] = {.lex_state = 14, .external_lex_state = 12},
  [1560] = {.lex_state = 14, .external_lex_state = 12},
  [1561] = {.lex_state = 14, .external_lex_state = 2},
  [1562] = {.lex_state = 15, .external_lex_state = 13},
  [1563] = {.lex_state = 15, .external_lex_state = 13},
  [1564] = {.lex_state = 15, .external_lex_state = 13},
  [1565] = {.lex_state = 14, .external_lex_state = 13},
  [1566] = {.lex_state = 14, .external_lex_state = 12},
  [1567] = {.lex_state = 14, .external_lex_state = 12},
  [1568] = {.lex_state = 14, .external_lex_state = 12},
  [1569] = {.lex_state = 14, .external_lex_state = 12},
  [1570] = {.lex_state = 15, .external_lex_state = 15},
  [1571] = {.lex_state = 14, .external_lex_state = 12},
  [1572] = {.lex_state = 14, .external_lex_state = 12},
  [1573] = {.lex_state = 14, .external_lex_state = 12},
  [1574] = {.lex_state = 14, .external_lex_state = 12},
  [1575] = {.lex_state = 15, .external_lex_state = 15},
  [1576] = {.lex_state = 15, .external_lex_state = 15},
  [1577] = {.lex_state = 14, .external_lex_state = 12},
  [1578] = {.lex_state = 14, .external_lex_state = 12},
  [1579] = {.lex_state = 14, .external_lex_state = 12},
  [1580] = {.lex_state = 14, .external_lex_state = 12},
  [1581] = {.lex_state = 14, .external_lex_state = 12},
  [1582] = {.lex_state = 14, .external_lex_state = 12},
  [1583] = {.lex_state = 14, .external_lex_state = 12},
  [1584] = {.lex_state = 14, .external_lex_state = 12},
  [1585] = {.lex_state = 14, .external_lex_state = 12},
  [1586] = {.lex_state = 14, .external_lex_state = 12},
  [1587] = {.lex_state = 14, .external_lex_state = 12},
  [1588] = {.lex_state = 14, .external_lex_state = 13},
  [1589] = {.lex_state = 14, .external_lex_state = 13},
  [1590] = {.lex_state = 14, .external_lex_state = 12},
  [1591] = {.lex_state = 14, .external_lex_state = 14},
  [1592] = {.lex_state = 14, .external_lex_state = 14},
  [1593] = {.lex_state = 14, .external_lex_state = 15},
  [1594] = {.lex_state = 14, .external_lex_state = 15},
  [1595] = {.lex_state = 14, .external_lex_state = 14},
  [1596] = {.lex_state = 14, .external_lex_state = 13},
  [1597] = {.lex_state = 14, .external_lex_state = 13},
  [1598] = {.lex_state = 14, .external_lex_state = 8},
  [1599] = {.lex_state = 14, .external_lex_state = 13},
  [1600] = {.lex_state = 14, .external_lex_state = 13},
  [1601] = {.lex_state = 14, .external_lex_state = 15},
  [1602] = {.lex_state = 14, .external_lex_state = 15},
  [1603] = {.lex_state = 14, .external_lex_state = 8},
  [1604] = {.lex_state = 14, .external_lex_state = 13},
  [1605] = {.lex_state = 14, .external_lex_state = 14},
  [1606] = {.lex_state = 14, .external_lex_state = 14},
  [1607] = {.lex_state = 15, .external_lex_state = 13},
  [1608] = {.lex_state = 15, .external_lex_state = 13},
  [1609] = {.lex_state = 15, .external_lex_state = 13},
  [1610] = {.lex_state = 14, .external_lex_state = 13},
  [1611] = {.lex_state = 14, .external_lex_state = 14},
  [1612] = {.lex_state = 14, .external_lex_state = 13},
  [1613] = {.lex_state = 14, .external_lex_state = 13},
  [1614] = {.lex_state = 14, .external_lex_state = 13},
  [1615] = {.lex_state = 14, .external_lex_state = 13},
  [1616] = {.lex_state = 14, .external_lex_state = 14},
  [1617] = {.lex_state = 14, .external_lex_state = 11},
  [1618] = {.lex_state = 14, .external_lex_state = 13},
  [1619] = {.lex_state = 14, .external_lex_state = 13},
  [1620] = {.lex_state = 14, .external_lex_state = 14},
  [1621] = {.lex_state = 14, .external_lex_state = 13},
  [1622] = {.lex_state = 14, .external_lex_state = 13},
  [1623] = {.lex_state = 14, .external_lex_state = 13},
  [1624] = {.lex_state = 14, .external_lex_state = 13},
  [1625] = {.lex_state = 14, .external_lex_state = 13},
  [1626] = {.lex_state = 14, .external_lex_state = 13},
  [1627] = {.lex_state = 14, .external_lex_state = 13},
  [1628] = {.lex_state = 14, .external_lex_state = 13},
  [1629] = {.lex_state = 14, .external_lex_state = 13},
  [1630] = {.lex_state = 14, .external_lex_state = 13},
  [1631] = {.lex_state = 14, .external_lex_state = 14},
  [1632] = {.lex_state = 14, .external_lex_state = 13},
  [1633] = {.lex_state = 14, .external_lex_state = 14},
  [1634] = {.lex_state = 14, .external_lex_state = 13},
  [1635] = {.lex_state = 14, .external_lex_state = 14},
  [1636] = {.lex_state = 14, .external_lex_state = 13},
  [1637] = {.lex_state = 14, .external_lex_state = 13},
  [1638] = {.lex_state = 14, .external_lex_state = 14},
  [1639] = {.lex_state = 14, .external_lex_state = 14},
  [1640] = {.lex_state = 14, .external_lex_state = 14},
  [1641] = {.lex_state = 14, .external_lex_state = 14},
  [1642] = {.lex_state = 14, .external_lex_state = 14},
  [1643] = {.lex_state = 14, .external_lex_state = 14},
  [1644] = {.lex_state = 14, .external_lex_state = 14},
  [1645] = {.lex_state = 14, .external_lex_state = 14},
  [1646] = {.lex_state = 14, .external_lex_state = 14},
  [1647] = {.lex_state = 14, .external_lex_state = 13},
  [1648] = {.lex_state = 14, .external_lex_state = 13},
  [1649] = {.lex_state = 14, .external_lex_state = 13},
  [1650] = {.lex_state = 14, .external_lex_state = 13},
  [1651] = {.lex_state = 14, .external_lex_state = 13},
  [1652] = {.lex_state = 14, .external_lex_state = 13},
  [1653] = {.lex_state = 14, .external_lex_state = 14},
  [1654] = {.lex_state = 14, .external_lex_state = 13},
  [1655] = {.lex_state = 14, .external_lex_state = 14},
  [1656] = {.lex_state = 14, .external_lex_state = 13},
  [1657] = {.lex_state = 14, .external_lex_state = 14},
  [1658] = {.lex_state = 14, .external_lex_state = 14},
  [1659] = {.lex_state = 14, .external_lex_state = 14},
  [1660] = {.lex_state = 14, .external_lex_state = 13},
  [1661] = {.lex_state = 14, .external_lex_state = 13},
  [1662] = {.lex_state = 15, .external_lex_state = 15},
  [1663] = {.lex_state = 15, .external_lex_state = 15},
  [1664] = {.lex_state = 15, .external_lex_state = 15},
  [1665] = {.lex_state = 14, .external_lex_state = 13},
  [1666] = {.lex_state = 14, .external_lex_state = 13},
  [1667] = {.lex_state = 14, .external_lex_state = 13},
  [1668] = {.lex_state = 14, .external_lex_state = 13},
  [1669] = {.lex_state = 14, .external_lex_state = 13},
  [1670] = {.lex_state = 14, .external_lex_state = 13},
  [1671] = {.lex_state = 14, .external_lex_state = 13},
  [1672] = {.lex_state = 14, .external_lex_state = 14},
  [1673] = {.lex_state = 14, .external_lex_state = 13},
  [1674] = {.lex_state = 14, .external_lex_state = 13},
  [1675] = {.lex_state = 14, .external_lex_state = 14},
  [1676] = {.lex_state = 14, .external_lex_state = 14},
  [1677] = {.lex_state = 14, .external_lex_state = 14},
  [1678] = {.lex_state = 14, .external_lex_state = 13},
  [1679] = {.lex_state = 14, .external_lex_state = 13},
  [1680] = {.lex_state = 14, .external_lex_state = 14},
  [1681] = {.lex_state = 14, .external_lex_state = 13},
  [1682] = {.lex_state = 14, .external_lex_state = 13},
  [1683] = {.lex_state = 14, .external_lex_state = 13},
  [1684] = {.lex_state = 14, .external_lex_state = 13},
  [1685] = {.lex_state = 14, .external_lex_state = 15},
  [1686] = {.lex_state = 14, .external_lex_state = 15},
  [1687] = {.lex_state = 14, .external_lex_state = 13},
  [1688] = {.lex_state = 14, .external_lex_state = 13},
  [1689] = {.lex_state = 14, .external_lex_state = 13},
  [1690] = {.lex_state = 14, .external_lex_state = 13},
  [1691] = {.lex_state = 14, .external_lex_state = 15},
  [1692] = {.lex_state = 14, .external_lex_state = 13},
  [1693] = {.lex_state = 14, .external_lex_state = 13},
  [1694] = {.lex_state = 14, .external_lex_state = 15},
  [1695] = {.lex_state = 14, .external_lex_state = 13},
  [1696] = {.lex_state = 14, .external_lex_state = 13},
  [1697] = {.lex_state = 14, .external_lex_state = 13},
  [1698] = {.lex_state = 14, .external_lex_state = 15},
  [1699] = {.lex_state = 14, .external_lex_state = 15},
  [1700] = {.lex_state = 14, .external_lex_state = 15},
  [1701] = {.lex_state = 14, .external_lex_state = 15},
  [1702] = {.lex_state = 14, .external_lex_state = 15},
  [1703] = {.lex_state = 14, .external_lex_state = 15},
  [1704] = {.lex_state = 14, .external_lex_state = 15},
  [1705] = {.lex_state = 14, .external_lex_state = 15},
  [1706] = {.lex_state = 14, .external_lex_state = 13},
  [1707] = {.lex_state = 14, .external_lex_state = 13},
  [1708] = {.lex_state = 14, .external_lex_state = 13},
  [1709] = {.lex_state = 14, .external_lex_state = 15},
  [1710] = {.lex_state = 14, .external_lex_state = 13},
  [1711] = {.lex_state = 14, .external_lex_state = 13},
  [1712] = {.lex_state = 14, .external_lex_state = 13},
  [1713] = {.lex_state = 14, .external_lex_state = 13},
  [1714] = {.lex_state = 14, .external_lex_state = 13},
  [1715] = {.lex_state = 14, .external_lex_state = 13},
  [1716] = {.lex_state = 14, .external_lex_state = 13},
  [1717] = {.lex_state = 14, .external_lex_state = 13},
  [1718] = {.lex_state = 14, .external_lex_state = 13},
  [1719] = {.lex_state = 14, .external_lex_state = 13},
  [1720] = {.lex_state = 14, .external_lex_state = 15},
  [1721] = {.lex_state = 14, .external_lex_state = 13},
  [1722] = {.lex_state = 14, .external_lex_state = 15},
  [1723] = {.lex_state = 14, .external_lex_state = 13},
  [1724] = {.lex_state = 14, .external_lex_state = 14},
  [1725] = {.lex_state = 14, .external_lex_state = 14},
  [1726] = {.lex_state = 14, .external_lex_state = 15},
  [1727] = {.lex_state = 14, .external_lex_state = 14},
  [1728] = {.lex_state = 14, .external_lex_state = 15},
  [1729] = {.lex_state = 14, .external_lex_state = 15},
  [1730] = {.lex_state = 14, .external_lex_state = 14},
  [1731] = {.lex_state = 14, .external_lex_state = 15},
  [1732] = {.lex_state = 14, .external_lex_state = 14},
  [1733] = {.lex_state = 14, .external_lex_state = 15},
  [1734] = {.lex_state = 14, .external_lex_state = 15},
  [1735] = {.lex_state = 14, .external_lex_state = 15},
  [1736] = {.lex_state = 14, .external_lex_state = 14},
  [1737] = {.lex_state = 14, .external_lex_state = 14},
  [1738] = {.lex_state = 14, .external_lex_state = 15},
  [1739] = {.lex_state = 14, .external_lex_state = 15},
  [1740] = {.lex_state = 14, .external_lex_state = 14},
  [1741] = {.lex_state = 14, .external_lex_state = 15},
  [1742] = {.lex_state = 14, .external_lex_state = 15},
  [1743] = {.lex_state = 14, .external_lex_state = 14},
  [1744] = {.lex_state = 14, .external_lex_state = 14},
  [1745] = {.lex_state = 14, .external_lex_state = 15},
  [1746] = {.lex_state = 14, .external_lex_state = 13},
  [1747] = {.lex_state = 14, .external_lex_state = 15},
  [1748] = {.lex_state = 14, .external_lex_state = 15},
  [1749] = {.lex_state = 14, .external_lex_state = 15},
  [1750] = {.lex_state = 14, .external_lex_state = 15},
  [1751] = {.lex_state = 14, .external_lex_state = 15},
  [1752] = {.lex_state = 14, .external_lex_state = 13},
  [1753] = {.lex_state = 14, .external_lex_state = 15},
  [1754] = {.lex_state = 14, .external_lex_state = 13},
  [1755] = {.lex_state = 14, .external_lex_state = 15},
  [1756] = {.lex_state = 14, .external_lex_state = 15},
  [1757] = {.lex_state = 14, .external_lex_state = 13},
  [1758] = {.lex_state = 14, .external_lex_state = 15},
  [1759] = {.lex_state = 14, .external_lex_state = 14},
  [1760] = {.lex_state = 14, .external_lex_state = 15},
  [1761] = {.lex_state = 14, .external_lex_state = 15},
  [1762] = {.lex_state = 14, .external_lex_state = 14},
  [1763] = {.lex_state = 14, .external_lex_state = 15},
  [1764] = {.lex_state = 14, .external_lex_state = 15},
  [1765] = {.lex_state = 14, .external_lex_state = 15},
  [1766] = {.lex_state = 14, .external_lex_state = 13},
  [1767] = {.lex_state = 14, .external_lex_state = 13},
  [1768] = {.lex_state = 14, .external_lex_state = 15},
  [1769] = {.lex_state = 14, .external_lex_state = 13},
  [1770] = {.lex_state = 14, .external_lex_state = 13},
  [1771] = {.lex_state = 14, .external_lex_state = 15},
  [1772] = {.lex_state = 14, .external_lex_state = 15},
  [1773] = {.lex_state = 15, .external_lex_state = 15},
  [1774] = {.lex_state = 15, .external_lex_state = 15},
  [1775] = {.lex_state = 15, .external_lex_state = 15},
  [1776] = {.lex_state = 14, .external_lex_state = 15},
  [1777] = {.lex_state = 14, .external_lex_state = 15},
  [1778] = {.lex_state = 14, .external_lex_state = 15},
  [1779] = {.lex_state = 15, .external_lex_state = 12},
  [1780] = {.lex_state = 15, .external_lex_state = 12},
  [1781] = {.lex_state = 14, .external_lex_state = 15},
  [1782] = {.lex_state = 14, .external_lex_state = 15},
  [1783] = {.lex_state = 14, .external_lex_state = 15},
  [1784] = {.lex_state = 14, .external_lex_state = 15},
  [1785] = {.lex_state = 14, .external_lex_state = 14},
  [1786] = {.lex_state = 14, .external_lex_state = 15},
  [1787] = {.lex_state = 14, .external_lex_state = 15},
  [1788] = {.lex_state = 14, .external_lex_state = 15},
  [1789] = {.lex_state = 14, .external_lex_state = 15},
  [1790] = {.lex_state = 14, .external_lex_state = 15},
  [1791] = {.lex_state = 14, .external_lex_state = 15},
  [1792] = {.lex_state = 14, .external_lex_state = 15},
  [1793] = {.lex_state = 14, .external_lex_state = 15},
  [1794] = {.lex_state = 14, .external_lex_state = 15},
  [1795] = {.lex_state = 14, .external_lex_state = 15},
  [1796] = {.lex_state = 14, .external_lex_state = 15},
  [1797] = {.lex_state = 14, .external_lex_state = 15},
  [1798] = {.lex_state = 14, .external_lex_state = 15},
  [1799] = {.lex_state = 14, .external_lex_state = 15},
  [1800] = {.lex_state = 14, .external_lex_state = 15},
  [1801] = {.lex_state = 14, .external_lex_state = 15},
  [1802] = {.lex_state = 14, .external_lex_state = 15},
  [1803] = {.lex_state = 14, .external_lex_state = 15},
  [1804] = {.lex_state = 14, .external_lex_state = 15},
  [1805] = {.lex_state = 15, .external_lex_state = 13},
  [1806] = {.lex_state = 15, .external_lex_state = 13},
  [1807] = {.lex_state = 15, .external_lex_state = 13},
  [1808] = {.lex_state = 14, .external_lex_state = 15},
  [1809] = {.lex_state = 14, .external_lex_state = 15},
  [1810] = {.lex_state = 14, .external_lex_state = 15},
  [1811] = {.lex_state = 14, .external_lex_state = 15},
  [1812] = {.lex_state = 14, .external_lex_state = 15},
  [1813] = {.lex_state = 14, .external_lex_state = 15},
  [1814] = {.lex_state = 14, .external_lex_state = 15},
  [1815] = {.lex_state = 14, .external_lex_state = 15},
  [1816] = {.lex_state = 14, .external_lex_state = 15},
  [1817] = {.lex_state = 14, .external_lex_state = 15},
  [1818] = {.lex_state = 14, .external_lex_state = 15},
  [1819] = {.lex_state = 15, .external_lex_state = 12},
  [1820] = {.lex_state = 14, .external_lex_state = 15},
  [1821] = {.lex_state = 14, .external_lex_state = 15},
  [1822] = {.lex_state = 14, .external_lex_state = 15},
  [1823] = {.lex_state = 14, .external_lex_state = 15},
  [1824] = {.lex_state = 14, .external_lex_state = 15},
  [1825] = {.lex_state = 14, .external_lex_state = 15},
  [1826] = {.lex_state = 14, .external_lex_state = 15},
  [1827] = {.lex_state = 14, .external_lex_state = 15},
  [1828] = {.lex_state = 14, .external_lex_state = 15},
  [1829] = {.lex_state = 7, .external_lex_state = 11},
  [1830] = {.lex_state = 7, .external_lex_state = 11},
  [1831] = {.lex_state = 14, .external_lex_state = 13},
  [1832] = {.lex_state = 14, .external_lex_state = 13},
  [1833] = {.lex_state = 14, .external_lex_state = 12},
  [1834] = {.lex_state = 7, .external_lex_state = 11},
  [1835] = {.lex_state = 7, .external_lex_state = 11},
  [1836] = {.lex_state = 7, .external_lex_state = 11},
  [1837] = {.lex_state = 14, .external_lex_state = 12},
  [1838] = {.lex_state = 7, .external_lex_state = 11},
  [1839] = {.lex_state = 7, .external_lex_state = 11},
  [1840] = {.lex_state = 13, .external_lex_state = 2},
  [1841] = {.lex_state = 13, .external_lex_state = 2},
  [1842] = {.lex_state = 7, .external_lex_state = 14},
  [1843] = {.lex_state = 7, .external_lex_state = 14},
  [1844] = {.lex_state = 7, .external_lex_state = 14},
  [1845] = {.lex_state = 7, .external_lex_state = 14},
  [1846] = {.lex_state = 7, .external_lex_state = 14},
  [1847] = {.lex_state = 7, .external_lex_state = 14},
  [1848] = {.lex_state = 7, .external_lex_state = 14},
  [1849] = {.lex_state = 7, .external_lex_state = 14},
  [1850] = {.lex_state = 7, .external_lex_state = 14},
  [1851] = {.lex_state = 7, .external_lex_state = 14},
  [1852] = {.lex_state = 7, .external_lex_state = 14},
  [1853] = {.lex_state = 7, .external_lex_state = 14},
  [1854] = {.lex_state = 7, .external_lex_state = 14},
  [1855] = {.lex_state = 7, .external_lex_state = 14},
  [1856] = {.lex_state = 7, .external_lex_state = 14},
  [1857] = {.lex_state = 7, .external_lex_state = 14},
  [1858] = {.lex_state = 7, .external_lex_state = 14},
  [1859] = {.lex_state = 7, .external_lex_state = 14},
  [1860] = {.lex_state = 7, .external_lex_state = 14},
  [1861] = {.lex_state = 7, .external_lex_state = 14},
  [1862] = {.lex_state = 5, .external_lex_state = 7},
  [1863] = {.lex_state = 5, .external_lex_state = 7},
  [1864] = {.lex_state = 5, .external_lex_state = 7},
  [1865] = {.lex_state = 5, .external_lex_state = 7},
  [1866] = {.lex_state = 5, .external_lex_state = 7},
  [1867] = {.lex_state = 5, .external_lex_state = 8},
  [1868] = {.lex_state = 5, .external_lex_state = 7},
  [1869] = {.lex_state = 5, .external_lex_state = 8},
  [1870] = {.lex_state = 5, .external_lex_state = 8},
  [1871] = {.lex_state = 5, .external_lex_state = 8},
  [1872] = {.lex_state = 5, .external_lex_state = 7},
  [1873] = {.lex_state = 5, .external_lex_state = 8},
  [1874] = {.lex_state = 5, .external_lex_state = 7},
  [1875] = {.lex_state = 5, .external_lex_state = 7},
  [1876] = {.lex_state = 5, .external_lex_state = 7},
  [1877] = {.lex_state = 5, .external_lex_state = 7},
  [1878] = {.lex_state = 5, .external_lex_state = 7},
  [1879] = {.lex_state = 5, .external_lex_state = 7},
  [1880] = {.lex_state = 5, .external_lex_state = 7},
  [1881] = {.lex_state = 5, .external_lex_state = 7},
  [1882] = {.lex_state = 5, .external_lex_state = 8},
  [1883] = {.lex_state = 5, .external_lex_state = 8},
  [1884] = {.lex_state = 5, .external_lex_state = 7},
  [1885] = {.lex_state = 5, .external_lex_state = 8},
  [1886] = {.lex_state = 5, .external_lex_state = 7},
  [1887] = {.lex_state = 5, .external_lex_state = 7},
  [1888] = {.lex_state = 5, .external_lex_state = 8},
  [1889] = {.lex_state = 5, .external_lex_state = 7},
  [1890] = {.lex_state = 5, .external_lex_state = 8},
  [1891] = {.lex_state = 5, .external_lex_state = 7},
  [1892] = {.lex_state = 5, .external_lex_state = 7},
  [1893] = {.lex_state = 5, .external_lex_state = 7},
  [1894] = {.lex_state = 5, .external_lex_state = 8},
  [1895] = {.lex_state = 5, .external_lex_state = 7},
  [1896] = {.lex_state = 5, .external_lex_state = 7},
  [1897] = {.lex_state = 5, .external_lex_state = 8},
  [1898] = {.lex_state = 5, .external_lex_state = 2},
  [1899] = {.lex_state = 5, .external_lex_state = 2},
  [1900] = {.lex_state = 5, .external_lex_state = 2},
  [1901] = {.lex_state = 5, .external_lex_state = 2},
  [1902] = {.lex_state = 5, .external_lex_state = 2},
  [1903] = {.lex_state = 5, .external_lex_state = 6},
  [1904] = {.lex_state = 5, .external_lex_state = 6},
  [1905] = {.lex_state = 5, .external_lex_state = 6},
  [1906] = {.lex_state = 5, .external_lex_state = 6},
  [1907] = {.lex_state = 5, .external_lex_state = 6},
  [1908] = {.lex_state = 5, .external_lex_state = 6},
  [1909] = {.lex_state = 5, .external_lex_state = 6},
  [1910] = {.lex_state = 5, .external_lex_state = 6},
  [1911] = {.lex_state = 5, .external_lex_state = 6},
  [1912] = {.lex_state = 5, .external_lex_state = 6},
  [1913] = {.lex_state = 5, .external_lex_state = 6},
  [1914] = {.lex_state = 5, .external_lex_state = 6},
  [1915] = {.lex_state = 5, .external_lex_state = 6},
  [1916] = {.lex_state = 5, .external_lex_state = 6},
  [1917] = {.lex_state = 5, .external_lex_state = 6},
  [1918] = {.lex_state = 5, .external_lex_state = 6},
  [1919] = {.lex_state = 5, .external_lex_state = 6},
  [1920] = {.lex_state = 5, .external_lex_state = 6},
  [1921] = {.lex_state = 5, .external_lex_state = 6},
  [1922] = {.lex_state = 5, .external_lex_state = 6},
  [1923] = {.lex_state = 5, .external_lex_state = 2},
  [1924] = {.lex_state = 5, .external_lex_state = 2},
  [1925] = {.lex_state = 5, .external_lex_state = 2},
  [1926] = {.lex_state = 5, .external_lex_state = 2},
  [1927] = {.lex_state = 5, .external_lex_state = 2},
  [1928] = {.lex_state = 5, .external_lex_state = 2},
  [1929] = {.lex_state = 5, .external_lex_state = 2},
  [1930] = {.lex_state = 5, .external_lex_state = 2},
  [1931] = {.lex_state = 5, .external_lex_state = 2},
  [1932] = {.lex_state = 8, .external_lex_state = 11},
  [1933] = {.lex_state = 8, .external_lex_state = 11},
  [1934] = {.lex_state = 14, .external_lex_state = 12},
  [1935] = {.lex_state = 14, .external_lex_state = 12},
  [1936] = {.lex_state = 14, .external_lex_state = 12},
  [1937] = {.lex_state = 14, .external_lex_state = 12},
  [1938] = {.lex_state = 14, .external_lex_state = 12},
  [1939] = {.lex_state = 8, .external_lex_state = 14},
  [1940] = {.lex_state = 14, .external_lex_state = 12},
  [1941] = {.lex_state = 14, .external_lex_state = 12},
  [1942] = {.lex_state = 8, .external_lex_state = 14},
  [1943] = {.lex_state = 8, .external_lex_state = 13},
  [1944] = {.lex_state = 8, .external_lex_state = 13},
  [1945] = {.lex_state = 13, .external_lex_state = 14},
  [1946] = {.lex_state = 14, .external_lex_state = 14},
  [1947] = {.lex_state = 56, .external_lex_state = 12},
  [1948] = {.lex_state = 13, .external_lex_state = 14},
  [1949] = {.lex_state = 56, .external_lex_state = 12},
  [1950] = {.lex_state = 13, .external_lex_state = 14},
  [1951] = {.lex_state = 13, .external_lex_state = 14},
  [1952] = {.lex_state = 13, .external_lex_state = 14},
  [1953] = {.lex_state = 14, .external_lex_state = 14},
  [1954] = {.lex_state = 13, .external_lex_state = 14},
  [1955] = {.lex_state = 13, .external_lex_state = 14},
  [1956] = {.lex_state = 14, .external_lex_state = 14},
  [1957] = {.lex_state = 14, .external_lex_state = 14},
  [1958] = {.lex_state = 13, .external_lex_state = 14},
  [1959] = {.lex_state = 8, .external_lex_state = 15},
  [1960] = {.lex_state = 13, .external_lex_state = 14},
  [1961] = {.lex_state = 14, .external_lex_state = 14},
  [1962] = {.lex_state = 13, .external_lex_state = 14},
  [1963] = {.lex_state = 14, .external_lex_state = 14},
  [1964] = {.lex_state = 8, .external_lex_state = 15},
  [1965] = {.lex_state = 14, .external_lex_state = 14},
  [1966] = {.lex_state = 13, .external_lex_state = 14},
  [1967] = {.lex_state = 56, .external_lex_state = 12},
  [1968] = {.lex_state = 56, .external_lex_state = 12},
  [1969] = {.lex_state = 56, .external_lex_state = 13},
  [1970] = {.lex_state = 14, .external_lex_state = 14},
  [1971] = {.lex_state = 14, .external_lex_state = 14},
  [1972] = {.lex_state = 56, .external_lex_state = 13},
  [1973] = {.lex_state = 14, .external_lex_state = 13},
  [1974] = {.lex_state = 14, .external_lex_state = 13},
  [1975] = {.lex_state = 14, .external_lex_state = 14},
  [1976] = {.lex_state = 14, .external_lex_state = 13},
  [1977] = {.lex_state = 14, .external_lex_state = 14},
  [1978] = {.lex_state = 5, .external_lex_state = 13},
  [1979] = {.lex_state = 14, .external_lex_state = 13},
  [1980] = {.lex_state = 5, .external_lex_state = 13},
  [1981] = {.lex_state = 14, .external_lex_state = 14},
  [1982] = {.lex_state = 14, .external_lex_state = 13},
  [1983] = {.lex_state = 14, .external_lex_state = 14},
  [1984] = {.lex_state = 14, .external_lex_state = 13},
  [1985] = {.lex_state = 14, .external_lex_state = 14},
  [1986] = {.lex_state = 14, .external_lex_state = 13},
  [1987] = {.lex_state = 14, .external_lex_state = 14},
  [1988] = {.lex_state = 14, .external_lex_state = 13},
  [1989] = {.lex_state = 56, .external_lex_state = 15},
  [1990] = {.lex_state = 14, .external_lex_state = 14},
  [1991] = {.lex_state = 14, .external_lex_state = 14},
  [1992] = {.lex_state = 56, .external_lex_state = 15},
  [1993] = {.lex_state = 14, .external_lex_state = 13},
  [1994] = {.lex_state = 14, .external_lex_state = 15},
  [1995] = {.lex_state = 14, .external_lex_state = 14},
  [1996] = {.lex_state = 5, .external_lex_state = 13},
  [1997] = {.lex_state = 14, .external_lex_state = 14},
  [1998] = {.lex_state = 14, .external_lex_state = 15},
  [1999] = {.lex_state = 14, .external_lex_state = 14},
  [2000] = {.lex_state = 14, .external_lex_state = 14},
  [2001] = {.lex_state = 14, .external_lex_state = 13},
  [2002] = {.lex_state = 14, .external_lex_state = 15},
  [2003] = {.lex_state = 14, .external_lex_state = 14},
  [2004] = {.lex_state = 14, .external_lex_state = 15},
  [2005] = {.lex_state = 13, .external_lex_state = 14},
  [2006] = {.lex_state = 5, .external_lex_state = 13},
  [2007] = {.lex_state = 14, .external_lex_state = 13},
  [2008] = {.lex_state = 14, .external_lex_state = 15},
  [2009] = {.lex_state = 14, .external_lex_state = 15},
  [2010] = {.lex_state = 14, .external_lex_state = 14},
  [2011] = {.lex_state = 14, .external_lex_state = 15},
  [2012] = {.lex_state = 13, .external_lex_state = 14},
  [2013] = {.lex_state = 14, .external_lex_state = 13},
  [2014] = {.lex_state = 14, .external_lex_state = 14},
  [2015] = {.lex_state = 14, .external_lex_state = 13},
  [2016] = {.lex_state = 14, .external_lex_state = 14},
  [2017] = {.lex_state = 14, .external_lex_state = 13},
  [2018] = {.lex_state = 14, .external_lex_state = 13},
  [2019] = {.lex_state = 12, .external_lex_state = 14},
  [2020] = {.lex_state = 12, .external_lex_state = 14},
  [2021] = {.lex_state = 5, .external_lex_state = 14},
  [2022] = {.lex_state = 4, .external_lex_state = 11},
  [2023] = {.lex_state = 12, .external_lex_state = 14},
  [2024] = {.lex_state = 4, .external_lex_state = 11},
  [2025] = {.lex_state = 12, .external_lex_state = 14},
  [2026] = {.lex_state = 5, .external_lex_state = 14},
  [2027] = {.lex_state = 4, .external_lex_state = 11},
  [2028] = {.lex_state = 4, .external_lex_state = 11},
  [2029] = {.lex_state = 4, .external_lex_state = 11},
  [2030] = {.lex_state = 4, .external_lex_state = 11},
  [2031] = {.lex_state = 4, .external_lex_state = 14},
  [2032] = {.lex_state = 4, .external_lex_state = 11},
  [2033] = {.lex_state = 4, .external_lex_state = 14},
  [2034] = {.lex_state = 4, .external_lex_state = 14},
  [2035] = {.lex_state = 4, .external_lex_state = 14},
  [2036] = {.lex_state = 4, .external_lex_state = 14},
  [2037] = {.lex_state = 8, .external_lex_state = 11},
  [2038] = {.lex_state = 8, .external_lex_state = 11},
  [2039] = {.lex_state = 8, .external_lex_state = 11},
  [2040] = {.lex_state = 56, .external_lex_state = 12},
  [2041] = {.lex_state = 56, .external_lex_state = 12},
  [2042] = {.lex_state = 8, .external_lex_state = 11},
  [2043] = {.lex_state = 56, .external_lex_state = 12},
  [2044] = {.lex_state = 56, .external_lex_state = 12},
  [2045] = {.lex_state = 8, .external_lex_state = 11},
  [2046] = {.lex_state = 56, .external_lex_state = 12},
  [2047] = {.lex_state = 56, .external_lex_state = 12},
  [2048] = {.lex_state = 8, .external_lex_state = 11},
  [2049] = {.lex_state = 56, .external_lex_state = 12},
  [2050] = {.lex_state = 56, .external_lex_state = 12},
  [2051] = {.lex_state = 8, .external_lex_state = 11},
  [2052] = {.lex_state = 8, .external_lex_state = 11},
  [2053] = {.lex_state = 8, .external_lex_state = 11},
  [2054] = {.lex_state = 56, .external_lex_state = 13},
  [2055] = {.lex_state = 56, .external_lex_state = 13},
  [2056] = {.lex_state = 56, .external_lex_state = 13},
  [2057] = {.lex_state = 56, .external_lex_state = 13},
  [2058] = {.lex_state = 56, .external_lex_state = 13},
  [2059] = {.lex_state = 56, .external_lex_state = 13},
  [2060] = {.lex_state = 56, .external_lex_state = 13},
  [2061] = {.lex_state = 56, .external_lex_state = 13},
  [2062] = {.lex_state = 56, .external_lex_state = 13},
  [2063] = {.lex_state = 56, .external_lex_state = 13},
  [2064] = {.lex_state = 56, .external_lex_state = 15},
  [2065] = {.lex_state = 56, .external_lex_state = 13},
  [2066] = {.lex_state = 56, .external_lex_state = 15},
  [2067] = {.lex_state = 56, .external_lex_state = 15},
  [2068] = {.lex_state = 56, .external_lex_state = 15},
  [2069] = {.lex_state = 56, .external_lex_state = 15},
  [2070] = {.lex_state = 56, .external_lex_state = 13},
  [2071] = {.lex_state = 56, .external_lex_state = 15},
  [2072] = {.lex_state = 8, .external_lex_state = 11},
  [2073] = {.lex_state = 56, .external_lex_state = 13},
  [2074] = {.lex_state = 56, .external_lex_state = 13},
  [2075] = {.lex_state = 56, .external_lex_state = 15},
  [2076] = {.lex_state = 56, .external_lex_state = 15},
  [2077] = {.lex_state = 56, .external_lex_state = 13},
  [2078] = {.lex_state = 56, .external_lex_state = 13},
  [2079] = {.lex_state = 56, .external_lex_state = 13},
  [2080] = {.lex_state = 8, .external_lex_state = 13},
  [2081] = {.lex_state = 0, .external_lex_state = 16},
  [2082] = {.lex_state = 8, .external_lex_state = 11},
  [2083] = {.lex_state = 0, .external_lex_state = 16},
  [2084] = {.lex_state = 0, .external_lex_state = 16},
  [2085] = {.lex_state = 0, .external_lex_state = 16},
  [2086] = {.lex_state = 8, .external_lex_state = 14},
  [2087] = {.lex_state = 56, .external_lex_state = 12},
  [2088] = {.lex_state = 8, .external_lex_state = 13},
  [2089] = {.lex_state = 8, .external_lex_state = 14},
  [2090] = {.lex_state = 0, .external_lex_state = 16},
  [2091] = {.lex_state = 8, .external_lex_state = 14},
  [2092] = {.lex_state = 0, .external_lex_state = 16},
  [2093] = {.lex_state = 0, .external_lex_state = 16},
  [2094] = {.lex_state = 56, .external_lex_state = 14},
  [2095] = {.lex_state = 0, .external_lex_state = 16},
  [2096] = {.lex_state = 8, .external_lex_state = 14},
  [2097] = {.lex_state = 8, .external_lex_state = 13},
  [2098] = {.lex_state = 0, .external_lex_state = 16},
  [2099] = {.lex_state = 8, .external_lex_state = 13},
  [2100] = {.lex_state = 8, .external_lex_state = 14},
  [2101] = {.lex_state = 8, .external_lex_state = 14},
  [2102] = {.lex_state = 0, .external_lex_state = 16},
  [2103] = {.lex_state = 8, .external_lex_state = 13},
  [2104] = {.lex_state = 8, .external_lex_state = 13},
  [2105] = {.lex_state = 56, .external_lex_state = 14},
  [2106] = {.lex_state = 0, .external_lex_state = 16},
  [2107] = {.lex_state = 0, .external_lex_state = 16},
  [2108] = {.lex_state = 56, .external_lex_state = 12},
  [2109] = {.lex_state = 0, .external_lex_state = 16},
  [2110] = {.lex_state = 0, .external_lex_state = 16},
  [2111] = {.lex_state = 8, .external_lex_state = 13},
  [2112] = {.lex_state = 8, .external_lex_state = 14},
  [2113] = {.lex_state = 8, .external_lex_state = 14},
  [2114] = {.lex_state = 8, .external_lex_state = 13},
  [2115] = {.lex_state = 0, .external_lex_state = 16},
  [2116] = {.lex_state = 8, .external_lex_state = 13},
  [2117] = {.lex_state = 8, .external_lex_state = 13},
  [2118] = {.lex_state = 0, .external_lex_state = 16},
  [2119] = {.lex_state = 8, .external_lex_state = 14},
  [2120] = {.lex_state = 0, .external_lex_state = 16},
  [2121] = {.lex_state = 0, .external_lex_state = 16},
  [2122] = {.lex_state = 0, .external_lex_state = 16},
  [2123] = {.lex_state = 56, .external_lex_state = 12},
  [2124] = {.lex_state = 8, .external_lex_state = 15},
  [2125] = {.lex_state = 8, .external_lex_state = 14},
  [2126] = {.lex_state = 56, .external_lex_state = 12},
  [2127] = {.lex_state = 56, .external_lex_state = 12},
  [2128] = {.lex_state = 56, .external_lex_state = 12},
  [2129] = {.lex_state = 56, .external_lex_state = 12},
  [2130] = {.lex_state = 8, .external_lex_state = 15},
  [2131] = {.lex_state = 56, .external_lex_state = 15},
  [2132] = {.lex_state = 8, .external_lex_state = 15},
  [2133] = {.lex_state = 8, .external_lex_state = 15},
  [2134] = {.lex_state = 56, .external_lex_state = 12},
  [2135] = {.lex_state = 56, .external_lex_state = 15},
  [2136] = {.lex_state = 56, .external_lex_state = 12},
  [2137] = {.lex_state = 56, .external_lex_state = 12},
  [2138] = {.lex_state = 56, .external_lex_state = 12},
  [2139] = {.lex_state = 56, .external_lex_state = 12},
  [2140] = {.lex_state = 56, .external_lex_state = 12},
  [2141] = {.lex_state = 8, .external_lex_state = 14},
  [2142] = {.lex_state = 56, .external_lex_state = 15},
  [2143] = {.lex_state = 56, .external_lex_state = 12},
  [2144] = {.lex_state = 56, .external_lex_state = 15},
  [2145] = {.lex_state = 56, .external_lex_state = 12},
  [2146] = {.lex_state = 56, .external_lex_state = 11},
  [2147] = {.lex_state = 56, .external_lex_state = 12},
  [2148] = {.lex_state = 56, .external_lex_state = 15},
  [2149] = {.lex_state = 56, .external_lex_state = 15},
  [2150] = {.lex_state = 56, .external_lex_state = 15},
  [2151] = {.lex_state = 8, .external_lex_state = 15},
  [2152] = {.lex_state = 8, .external_lex_state = 15},
  [2153] = {.lex_state = 8, .external_lex_state = 14},
  [2154] = {.lex_state = 56, .external_lex_state = 12},
  [2155] = {.lex_state = 56, .external_lex_state = 15},
  [2156] = {.lex_state = 8, .external_lex_state = 14},
  [2157] = {.lex_state = 8, .external_lex_state = 15},
  [2158] = {.lex_state = 56, .external_lex_state = 15},
  [2159] = {.lex_state = 8, .external_lex_state = 14},
  [2160] = {.lex_state = 8, .external_lex_state = 15},
  [2161] = {.lex_state = 56, .external_lex_state = 12},
  [2162] = {.lex_state = 8, .external_lex_state = 15},
  [2163] = {.lex_state = 56, .external_lex_state = 15},
  [2164] = {.lex_state = 8, .external_lex_state = 15},
  [2165] = {.lex_state = 56, .external_lex_state = 12},
  [2166] = {.lex_state = 56, .external_lex_state = 12},
  [2167] = {.lex_state = 56, .external_lex_state = 12},
  [2168] = {.lex_state = 56, .external_lex_state = 12},
  [2169] = {.lex_state = 56, .external_lex_state = 15},
  [2170] = {.lex_state = 56, .external_lex_state = 13},
  [2171] = {.lex_state = 9, .external_lex_state = 17},
  [2172] = {.lex_state = 56, .external_lex_state = 13},
  [2173] = {.lex_state = 9, .external_lex_state = 17},
  [2174] = {.lex_state = 7, .external_lex_state = 13},
  [2175] = {.lex_state = 56, .external_lex_state = 11},
  [2176] = {.lex_state = 56, .external_lex_state = 12},
  [2177] = {.lex_state = 56, .external_lex_state = 13},
  [2178] = {.lex_state = 56, .external_lex_state = 15},
  [2179] = {.lex_state = 56, .external_lex_state = 15},
  [2180] = {.lex_state = 8, .external_lex_state = 14},
  [2181] = {.lex_state = 56, .external_lex_state = 12},
  [2182] = {.lex_state = 7, .external_lex_state = 15},
  [2183] = {.lex_state = 9, .external_lex_state = 17},
  [2184] = {.lex_state = 56, .external_lex_state = 13},
  [2185] = {.lex_state = 56, .external_lex_state = 12},
  [2186] = {.lex_state = 56, .external_lex_state = 14},
  [2187] = {.lex_state = 7, .external_lex_state = 12},
  [2188] = {.lex_state = 56, .external_lex_state = 11},
  [2189] = {.lex_state = 56, .external_lex_state = 11},
  [2190] = {.lex_state = 56, .external_lex_state = 13},
  [2191] = {.lex_state = 56, .external_lex_state = 15},
  [2192] = {.lex_state = 9, .external_lex_state = 17},
  [2193] = {.lex_state = 56, .external_lex_state = 13},
  [2194] = {.lex_state = 56, .external_lex_state = 13},
  [2195] = {.lex_state = 56, .external_lex_state = 15},
  [2196] = {.lex_state = 56, .external_lex_state = 11},
  [2197] = {.lex_state = 56, .external_lex_state = 11},
  [2198] = {.lex_state = 56, .external_lex_state = 13},
  [2199] = {.lex_state = 56, .external_lex_state = 11},
  [2200] = {.lex_state = 56, .external_lex_state = 15},
  [2201] = {.lex_state = 56, .external_lex_state = 11},
  [2202] = {.lex_state = 56, .external_lex_state = 12},
  [2203] = {.lex_state = 56, .external_lex_state = 15},
  [2204] = {.lex_state = 56, .external_lex_state = 2},
  [2205] = {.lex_state = 56, .external_lex_state = 11},
  [2206] = {.lex_state = 56, .external_lex_state = 15},
  [2207] = {.lex_state = 56, .external_lex_state = 15},
  [2208] = {.lex_state = 56, .external_lex_state = 13},
  [2209] = {.lex_state = 56, .external_lex_state = 15},
  [2210] = {.lex_state = 56, .external_lex_state = 13},
  [2211] = {.lex_state = 56, .external_lex_state = 15},
  [2212] = {.lex_state = 56, .external_lex_state = 13},
  [2213] = {.lex_state = 56, .external_lex_state = 13},
  [2214] = {.lex_state = 56, .external_lex_state = 15},
  [2215] = {.lex_state = 56, .external_lex_state = 11},
  [2216] = {.lex_state = 56, .external_lex_state = 6},
  [2217] = {.lex_state = 0, .external_lex_state = 16},
  [2218] = {.lex_state = 56, .external_lex_state = 8},
  [2219] = {.lex_state = 56, .external_lex_state = 13},
  [2220] = {.lex_state = 56, .external_lex_state = 15},
  [2221] = {.lex_state = 7, .external_lex_state = 14},
  [2222] = {.lex_state = 56, .external_lex_state = 15},
  [2223] = {.lex_state = 7, .external_lex_state = 13},
  [2224] = {.lex_state = 0, .external_lex_state = 16},
  [2225] = {.lex_state = 7, .external_lex_state = 12},
  [2226] = {.lex_state = 56, .external_lex_state = 12},
  [2227] = {.lex_state = 56, .external_lex_state = 15},
  [2228] = {.lex_state = 56, .external_lex_state = 15},
  [2229] = {.lex_state = 56, .external_lex_state = 14},
  [2230] = {.lex_state = 56, .external_lex_state = 12},
  [2231] = {.lex_state = 56, .external_lex_state = 12},
  [2232] = {.lex_state = 56, .external_lex_state = 12},
  [2233] = {.lex_state = 56, .external_lex_state = 13},
  [2234] = {.lex_state = 56, .external_lex_state = 15},
  [2235] = {.lex_state = 56, .external_lex_state = 11},
  [2236] = {.lex_state = 56, .external_lex_state = 14},
  [2237] = {.lex_state = 56, .external_lex_state = 14},
  [2238] = {.lex_state = 56, .external_lex_state = 12},
  [2239] = {.lex_state = 56, .external_lex_state = 12},
  [2240] = {.lex_state = 56, .external_lex_state = 15},
  [2241] = {.lex_state = 56, .external_lex_state = 11},
  [2242] = {.lex_state = 56, .external_lex_state = 12},
  [2243] = {.lex_state = 56, .external_lex_state = 15},
  [2244] = {.lex_state = 56, .external_lex_state = 12},
  [2245] = {.lex_state = 56, .external_lex_state = 14},
  [2246] = {.lex_state = 7, .external_lex_state = 13},
  [2247] = {.lex_state = 56, .external_lex_state = 14},
  [2248] = {.lex_state = 7, .external_lex_state = 15},
  [2249] = {.lex_state = 56, .external_lex_state = 12},
  [2250] = {.lex_state = 56, .external_lex_state = 13},
  [2251] = {.lex_state = 56, .external_lex_state = 13},
  [2252] = {.lex_state = 56, .external_lex_state = 13},
  [2253] = {.lex_state = 7, .external_lex_state = 12},
  [2254] = {.lex_state = 56, .external_lex_state = 15},
  [2255] = {.lex_state = 7, .external_lex_state = 13},
  [2256] = {.lex_state = 7, .external_lex_state = 15},
  [2257] = {.lex_state = 56, .external_lex_state = 12},
  [2258] = {.lex_state = 56, .external_lex_state = 7},
  [2259] = {.lex_state = 7, .external_lex_state = 12},
  [2260] = {.lex_state = 56, .external_lex_state = 13},
  [2261] = {.lex_state = 56, .external_lex_state = 15},
  [2262] = {.lex_state = 56, .external_lex_state = 14},
  [2263] = {.lex_state = 7, .external_lex_state = 15},
  [2264] = {.lex_state = 56, .external_lex_state = 14},
  [2265] = {.lex_state = 56, .external_lex_state = 14},
  [2266] = {.lex_state = 56, .external_lex_state = 12},
  [2267] = {.lex_state = 56, .external_lex_state = 14},
  [2268] = {.lex_state = 56, .external_lex_state = 12},
  [2269] = {.lex_state = 8, .external_lex_state = 11},
  [2270] = {.lex_state = 56, .external_lex_state = 15},
  [2271] = {.lex_state = 7, .external_lex_state = 11},
  [2272] = {.lex_state = 56, .external_lex_state = 15},
  [2273] = {.lex_state = 56, .external_lex_state = 14},
  [2274] = {.lex_state = 56, .external_lex_state = 14},
  [2275] = {.lex_state = 8, .external_lex_state = 15},
  [2276] = {.lex_state = 56, .external_lex_state = 15},
  [2277] = {.lex_state = 7, .external_lex_state = 12},
  [2278] = {.lex_state = 56, .external_lex_state = 14},
  [2279] = {.lex_state = 56, .external_lex_state = 14},
  [2280] = {.lex_state = 8, .external_lex_state = 11},
  [2281] = {.lex_state = 8, .external_lex_state = 11},
  [2282] = {.lex_state = 0, .external_lex_state = 16},
  [2283] = {.lex_state = 56, .external_lex_state = 14},
  [2284] = {.lex_state = 0, .external_lex_state = 16},
  [2285] = {.lex_state = 56, .external_lex_state = 12},
  [2286] = {.lex_state = 56, .external_lex_state = 15},
  [2287] = {.lex_state = 56, .external_lex_state = 14},
  [2288] = {.lex_state = 56, .external_lex_state = 11},
  [2289] = {.lex_state = 56, .external_lex_state = 14},
  [2290] = {.lex_state = 8, .external_lex_state = 15},
  [2291] = {.lex_state = 56, .external_lex_state = 15},
  [2292] = {.lex_state = 56, .external_lex_state = 13},
  [2293] = {.lex_state = 56, .external_lex_state = 14},
  [2294] = {.lex_state = 8, .external_lex_state = 14},
  [2295] = {.lex_state = 0, .external_lex_state = 16},
  [2296] = {.lex_state = 56, .external_lex_state = 14},
  [2297] = {.lex_state = 56, .external_lex_state = 11},
  [2298] = {.lex_state = 8, .external_lex_state = 13},
  [2299] = {.lex_state = 8, .external_lex_state = 13},
  [2300] = {.lex_state = 56, .external_lex_state = 13},
  [2301] = {.lex_state = 56, .external_lex_state = 13},
  [2302] = {.lex_state = 56, .external_lex_state = 15},
  [2303] = {.lex_state = 56, .external_lex_state = 13},
  [2304] = {.lex_state = 56, .external_lex_state = 13},
  [2305] = {.lex_state = 56, .external_lex_state = 15},
  [2306] = {.lex_state = 56, .external_lex_state = 12},
  [2307] = {.lex_state = 56, .external_lex_state = 12},
  [2308] = {.lex_state = 56, .external_lex_state = 12},
  [2309] = {.lex_state = 56, .external_lex_state = 12},
  [2310] = {.lex_state = 56, .external_lex_state = 12},
  [2311] = {.lex_state = 0, .external_lex_state = 16},
  [2312] = {.lex_state = 7, .external_lex_state = 13},
  [2313] = {.lex_state = 56, .external_lex_state = 15},
  [2314] = {.lex_state = 0, .external_lex_state = 16},
  [2315] = {.lex_state = 0, .external_lex_state = 16},
  [2316] = {.lex_state = 7, .external_lex_state = 11},
  [2317] = {.lex_state = 8, .external_lex_state = 13},
  [2318] = {.lex_state = 56, .external_lex_state = 13},
  [2319] = {.lex_state = 56, .external_lex_state = 13},
  [2320] = {.lex_state = 56, .external_lex_state = 13},
  [2321] = {.lex_state = 8, .external_lex_state = 11},
  [2322] = {.lex_state = 0, .external_lex_state = 16},
  [2323] = {.lex_state = 56, .external_lex_state = 13},
  [2324] = {.lex_state = 56, .external_lex_state = 15},
  [2325] = {.lex_state = 8, .external_lex_state = 13},
  [2326] = {.lex_state = 56, .external_lex_state = 12},
  [2327] = {.lex_state = 8, .external_lex_state = 14},
  [2328] = {.lex_state = 56, .external_lex_state = 14},
  [2329] = {.lex_state = 56, .external_lex_state = 14},
  [2330] = {.lex_state = 56, .external_lex_state = 12},
  [2331] = {.lex_state = 56, .external_lex_state = 14},
  [2332] = {.lex_state = 56, .external_lex_state = 13},
  [2333] = {.lex_state = 8, .external_lex_state = 15},
  [2334] = {.lex_state = 56, .external_lex_state = 12},
  [2335] = {.lex_state = 8, .external_lex_state = 15},
  [2336] = {.lex_state = 56, .external_lex_state = 15},
  [2337] = {.lex_state = 8, .external_lex_state = 14},
  [2338] = {.lex_state = 56, .external_lex_state = 15},
  [2339] = {.lex_state = 56, .external_lex_state = 12},
  [2340] = {.lex_state = 56, .external_lex_state = 15},
  [2341] = {.lex_state = 56, .external_lex_state = 14},
  [2342] = {.lex_state = 8, .external_lex_state = 11},
  [2343] = {.lex_state = 8, .external_lex_state = 11},
  [2344] = {.lex_state = 56, .external_lex_state = 14},
  [2345] = {.lex_state = 7, .external_lex_state = 15},
  [2346] = {.lex_state = 8, .external_lex_state = 11},
  [2347] = {.lex_state = 56, .external_lex_state = 15},
  [2348] = {.lex_state = 56, .external_lex_state = 13},
  [2349] = {.lex_state = 56, .external_lex_state = 13},
  [2350] = {.lex_state = 56, .external_lex_state = 15},
  [2351] = {.lex_state = 56, .external_lex_state = 15},
  [2352] = {.lex_state = 0, .external_lex_state = 16},
  [2353] = {.lex_state = 56, .external_lex_state = 12},
  [2354] = {.lex_state = 8, .external_lex_state = 11},
  [2355] = {.lex_state = 8, .external_lex_state = 13},
  [2356] = {.lex_state = 8, .external_lex_state = 13},
  [2357] = {.lex_state = 56, .external_lex_state = 13},
  [2358] = {.lex_state = 56, .external_lex_state = 15},
  [2359] = {.lex_state = 56, .external_lex_state = 15},
  [2360] = {.lex_state = 8, .external_lex_state = 13},
  [2361] = {.lex_state = 8, .external_lex_state = 11},
  [2362] = {.lex_state = 56, .external_lex_state = 13},
  [2363] = {.lex_state = 56, .external_lex_state = 12},
  [2364] = {.lex_state = 56, .external_lex_state = 13},
  [2365] = {.lex_state = 56, .external_lex_state = 11},
  [2366] = {.lex_state = 56, .external_lex_state = 13},
  [2367] = {.lex_state = 8, .external_lex_state = 11},
  [2368] = {.lex_state = 7, .external_lex_state = 11},
  [2369] = {.lex_state = 56, .external_lex_state = 13},
  [2370] = {.lex_state = 8, .external_lex_state = 13},
  [2371] = {.lex_state = 56, .external_lex_state = 12},
  [2372] = {.lex_state = 56, .external_lex_state = 12},
  [2373] = {.lex_state = 56, .external_lex_state = 15},
  [2374] = {.lex_state = 56, .external_lex_state = 14},
  [2375] = {.lex_state = 8, .external_lex_state = 13},
  [2376] = {.lex_state = 56, .external_lex_state = 13},
  [2377] = {.lex_state = 56, .external_lex_state = 12},
  [2378] = {.lex_state = 8, .external_lex_state = 13},
  [2379] = {.lex_state = 56, .external_lex_state = 14},
  [2380] = {.lex_state = 8, .external_lex_state = 14},
  [2381] = {.lex_state = 56, .external_lex_state = 15},
  [2382] = {.lex_state = 56, .external_lex_state = 13},
  [2383] = {.lex_state = 56, .external_lex_state = 14},
  [2384] = {.lex_state = 56, .external_lex_state = 14},
  [2385] = {.lex_state = 56, .external_lex_state = 12},
  [2386] = {.lex_state = 8, .external_lex_state = 14},
  [2387] = {.lex_state = 8, .external_lex_state = 14},
  [2388] = {.lex_state = 8, .external_lex_state = 11},
  [2389] = {.lex_state = 8, .external_lex_state = 14},
  [2390] = {.lex_state = 56, .external_lex_state = 14},
  [2391] = {.lex_state = 8, .external_lex_state = 14},
  [2392] = {.lex_state = 56, .external_lex_state = 13},
  [2393] = {.lex_state = 3, .external_lex_state = 12},
  [2394] = {.lex_state = 56, .external_lex_state = 12},
  [2395] = {.lex_state = 56, .external_lex_state = 12},
  [2396] = {.lex_state = 56, .external_lex_state = 14},
  [2397] = {.lex_state = 56, .external_lex_state = 11},
  [2398] = {.lex_state = 56, .external_lex_state = 12},
  [2399] = {.lex_state = 56, .external_lex_state = 15},
  [2400] = {.lex_state = 56, .external_lex_state = 14},
  [2401] = {.lex_state = 56, .external_lex_state = 14},
  [2402] = {.lex_state = 56, .external_lex_state = 14},
  [2403] = {.lex_state = 56, .external_lex_state = 14},
  [2404] = {.lex_state = 56, .external_lex_state = 14},
  [2405] = {.lex_state = 56, .external_lex_state = 13},
  [2406] = {.lex_state = 56, .external_lex_state = 15},
  [2407] = {.lex_state = 56, .external_lex_state = 13},
  [2408] = {.lex_state = 56, .external_lex_state = 12},
  [2409] = {.lex_state = 56, .external_lex_state = 14},
  [2410] = {.lex_state = 56, .external_lex_state = 12},
  [2411] = {.lex_state = 56, .external_lex_state = 11},
  [2412] = {.lex_state = 56, .external_lex_state = 12},
  [2413] = {.lex_state = 56, .external_lex_state = 15},
  [2414] = {.lex_state = 8, .external_lex_state = 15},
  [2415] = {.lex_state = 56, .external_lex_state = 14},
  [2416] = {.lex_state = 56, .external_lex_state = 14},
  [2417] = {.lex_state = 56, .external_lex_state = 14},
  [2418] = {.lex_state = 56, .external_lex_state = 14},
  [2419] = {.lex_state = 56, .external_lex_state = 14},
  [2420] = {.lex_state = 8, .external_lex_state = 14},
  [2421] = {.lex_state = 8, .external_lex_state = 14},
  [2422] = {.lex_state = 56, .external_lex_state = 14},
  [2423] = {.lex_state = 56, .external_lex_state = 12},
  [2424] = {.lex_state = 56, .external_lex_state = 12},
  [2425] = {.lex_state = 56, .external_lex_state = 14},
  [2426] = {.lex_state = 56, .external_lex_state = 11},
  [2427] = {.lex_state = 56, .external_lex_state = 14},
  [2428] = {.lex_state = 56, .external_lex_state = 14},
  [2429] = {.lex_state = 56, .external_lex_state = 14},
  [2430] = {.lex_state = 56, .external_lex_state = 12},
  [2431] = {.lex_state = 56, .external_lex_state = 12},
  [2432] = {.lex_state = 56, .external_lex_state = 12},
  [2433] = {.lex_state = 56, .external_lex_state = 12},
  [2434] = {.lex_state = 56, .external_lex_state = 12},
  [2435] = {.lex_state = 56, .external_lex_state = 14},
  [2436] = {.lex_state = 56, .external_lex_state = 14},
  [2437] = {.lex_state = 56, .external_lex_state = 12},
  [2438] = {.lex_state = 56, .external_lex_state = 14},
  [2439] = {.lex_state = 8, .external_lex_state = 15},
  [2440] = {.lex_state = 56, .external_lex_state = 11},
  [2441] = {.lex_state = 8, .external_lex_state = 15},
  [2442] = {.lex_state = 56, .external_lex_state = 14},
  [2443] = {.lex_state = 56, .external_lex_state = 14},
  [2444] = {.lex_state = 8, .external_lex_state = 15},
  [2445] = {.lex_state = 56, .external_lex_state = 11},
  [2446] = {.lex_state = 56, .external_lex_state = 14},
  [2447] = {.lex_state = 56, .external_lex_state = 12},
  [2448] = {.lex_state = 56, .external_lex_state = 13},
  [2449] = {.lex_state = 56, .external_lex_state = 14},
  [2450] = {.lex_state = 56, .external_lex_state = 14},
  [2451] = {.lex_state = 8, .external_lex_state = 15},
  [2452] = {.lex_state = 56, .external_lex_state = 14},
  [2453] = {.lex_state = 56, .external_lex_state = 13},
  [2454] = {.lex_state = 56, .external_lex_state = 14},
  [2455] = {.lex_state = 56, .external_lex_state = 14},
  [2456] = {.lex_state = 56, .external_lex_state = 14},
  [2457] = {.lex_state = 56, .external_lex_state = 13},
  [2458] = {.lex_state = 56, .external_lex_state = 15},
  [2459] = {.lex_state = 56, .external_lex_state = 12},
  [2460] = {.lex_state = 56, .external_lex_state = 12},
  [2461] = {.lex_state = 3, .external_lex_state = 12},
  [2462] = {.lex_state = 56, .external_lex_state = 14},
  [2463] = {.lex_state = 56, .external_lex_state = 14},
  [2464] = {.lex_state = 56, .external_lex_state = 14},
  [2465] = {.lex_state = 56, .external_lex_state = 11},
  [2466] = {.lex_state = 56, .external_lex_state = 13},
  [2467] = {.lex_state = 56, .external_lex_state = 14},
  [2468] = {.lex_state = 56, .external_lex_state = 15},
  [2469] = {.lex_state = 56, .external_lex_state = 12},
  [2470] = {.lex_state = 56, .external_lex_state = 14},
  [2471] = {.lex_state = 56, .external_lex_state = 13},
  [2472] = {.lex_state = 56, .external_lex_state = 14},
  [2473] = {.lex_state = 7, .external_lex_state = 11},
  [2474] = {.lex_state = 56, .external_lex_state = 15},
  [2475] = {.lex_state = 8, .external_lex_state = 15},
  [2476] = {.lex_state = 56, .external_lex_state = 12},
  [2477] = {.lex_state = 56, .external_lex_state = 14},
  [2478] = {.lex_state = 8, .external_lex_state = 13},
  [2479] = {.lex_state = 3, .external_lex_state = 12},
  [2480] = {.lex_state = 56, .external_lex_state = 14},
  [2481] = {.lex_state = 56, .external_lex_state = 14},
  [2482] = {.lex_state = 56, .external_lex_state = 14},
  [2483] = {.lex_state = 56, .external_lex_state = 14},
  [2484] = {.lex_state = 56, .external_lex_state = 14},
  [2485] = {.lex_state = 56, .external_lex_state = 12},
  [2486] = {.lex_state = 56, .external_lex_state = 14},
  [2487] = {.lex_state = 56, .external_lex_state = 14},
  [2488] = {.lex_state = 56, .external_lex_state = 14},
  [2489] = {.lex_state = 56, .external_lex_state = 14},
  [2490] = {.lex_state = 56, .external_lex_state = 15},
  [2491] = {.lex_state = 8, .external_lex_state = 13},
  [2492] = {.lex_state = 8, .external_lex_state = 15},
  [2493] = {.lex_state = 8, .external_lex_state = 15},
  [2494] = {.lex_state = 56, .external_lex_state = 14},
  [2495] = {.lex_state = 56, .external_lex_state = 14},
  [2496] = {.lex_state = 56, .external_lex_state = 14},
  [2497] = {.lex_state = 56, .external_lex_state = 15},
  [2498] = {.lex_state = 8, .external_lex_state = 15},
  [2499] = {.lex_state = 56, .external_lex_state = 11},
  [2500] = {.lex_state = 8, .external_lex_state = 15},
  [2501] = {.lex_state = 56, .external_lex_state = 15},
  [2502] = {.lex_state = 56, .external_lex_state = 14},
  [2503] = {.lex_state = 56, .external_lex_state = 13},
  [2504] = {.lex_state = 56, .external_lex_state = 14},
  [2505] = {.lex_state = 56, .external_lex_state = 14},
  [2506] = {.lex_state = 56, .external_lex_state = 13},
  [2507] = {.lex_state = 56, .external_lex_state = 12},
  [2508] = {.lex_state = 56, .external_lex_state = 13},
  [2509] = {.lex_state = 56, .external_lex_state = 14},
  [2510] = {.lex_state = 56, .external_lex_state = 13},
  [2511] = {.lex_state = 56, .external_lex_state = 12},
  [2512] = {.lex_state = 56, .external_lex_state = 18},
  [2513] = {.lex_state = 56, .external_lex_state = 13},
  [2514] = {.lex_state = 56, .external_lex_state = 14},
  [2515] = {.lex_state = 56, .external_lex_state = 14},
  [2516] = {.lex_state = 56, .external_lex_state = 15},
  [2517] = {.lex_state = 56, .external_lex_state = 14},
  [2518] = {.lex_state = 56, .external_lex_state = 13},
  [2519] = {.lex_state = 56, .external_lex_state = 15},
  [2520] = {.lex_state = 56, .external_lex_state = 15},
  [2521] = {.lex_state = 56, .external_lex_state = 14},
  [2522] = {.lex_state = 56, .external_lex_state = 15},
  [2523] = {.lex_state = 56, .external_lex_state = 13},
  [2524] = {.lex_state = 56, .external_lex_state = 15},
  [2525] = {.lex_state = 56, .external_lex_state = 12},
  [2526] = {.lex_state = 56, .external_lex_state = 14},
  [2527] = {.lex_state = 56, .external_lex_state = 13},
  [2528] = {.lex_state = 56, .external_lex_state = 18},
  [2529] = {.lex_state = 56, .external_lex_state = 12},
  [2530] = {.lex_state = 56, .external_lex_state = 15},
  [2531] = {.lex_state = 56, .external_lex_state = 13},
  [2532] = {.lex_state = 56, .external_lex_state = 15},
  [2533] = {.lex_state = 56, .external_lex_state = 14},
  [2534] = {.lex_state = 7, .external_lex_state = 14},
  [2535] = {.lex_state = 56, .external_lex_state = 15},
  [2536] = {.lex_state = 56, .external_lex_state = 13},
  [2537] = {.lex_state = 56, .external_lex_state = 15},
  [2538] = {.lex_state = 56, .external_lex_state = 13},
  [2539] = {.lex_state = 56, .external_lex_state = 11},
  [2540] = {.lex_state = 56, .external_lex_state = 15},
  [2541] = {.lex_state = 56, .external_lex_state = 11},
  [2542] = {.lex_state = 56, .external_lex_state = 13},
  [2543] = {.lex_state = 56, .external_lex_state = 15},
  [2544] = {.lex_state = 56, .external_lex_state = 15},
  [2545] = {.lex_state = 56, .external_lex_state = 13},
  [2546] = {.lex_state = 56, .external_lex_state = 15},
  [2547] = {.lex_state = 56, .external_lex_state = 13},
  [2548] = {.lex_state = 56, .external_lex_state = 12},
  [2549] = {.lex_state = 56, .external_lex_state = 13},
  [2550] = {.lex_state = 56, .external_lex_state = 13},
  [2551] = {.lex_state = 56, .external_lex_state = 13},
  [2552] = {.lex_state = 56, .external_lex_state = 11},
  [2553] = {.lex_state = 56, .external_lex_state = 15},
  [2554] = {.lex_state = 56, .external_lex_state = 13},
  [2555] = {.lex_state = 56, .external_lex_state = 15},
  [2556] = {.lex_state = 56, .external_lex_state = 15},
  [2557] = {.lex_state = 56, .external_lex_state = 13},
  [2558] = {.lex_state = 56, .external_lex_state = 15},
  [2559] = {.lex_state = 56, .external_lex_state = 15},
  [2560] = {.lex_state = 56, .external_lex_state = 14},
  [2561] = {.lex_state = 56, .external_lex_state = 15},
  [2562] = {.lex_state = 56, .external_lex_state = 13},
  [2563] = {.lex_state = 56, .external_lex_state = 15},
  [2564] = {.lex_state = 56, .external_lex_state = 11},
  [2565] = {.lex_state = 56, .external_lex_state = 11},
  [2566] = {.lex_state = 56, .external_lex_state = 15},
  [2567] = {.lex_state = 8, .external_lex_state = 14},
  [2568] = {.lex_state = 56, .external_lex_state = 11},
  [2569] = {.lex_state = 56, .external_lex_state = 11},
  [2570] = {.lex_state = 56, .external_lex_state = 13},
  [2571] = {.lex_state = 56, .external_lex_state = 13},
  [2572] = {.lex_state = 56, .external_lex_state = 18},
  [2573] = {.lex_state = 56, .external_lex_state = 11},
  [2574] = {.lex_state = 56, .external_lex_state = 11},
  [2575] = {.lex_state = 56, .external_lex_state = 15},
  [2576] = {.lex_state = 7, .external_lex_state = 14},
  [2577] = {.lex_state = 56, .external_lex_state = 15},
  [2578] = {.lex_state = 56, .external_lex_state = 15},
  [2579] = {.lex_state = 56, .external_lex_state = 14},
  [2580] = {.lex_state = 56, .external_lex_state = 13},
  [2581] = {.lex_state = 56, .external_lex_state = 15},
  [2582] = {.lex_state = 56, .external_lex_state = 14},
  [2583] = {.lex_state = 56, .external_lex_state = 13},
  [2584] = {.lex_state = 56, .external_lex_state = 13},
  [2585] = {.lex_state = 56, .external_lex_state = 12},
  [2586] = {.lex_state = 56, .external_lex_state = 14},
  [2587] = {.lex_state = 56, .external_lex_state = 15},
  [2588] = {.lex_state = 56, .external_lex_state = 14},
  [2589] = {.lex_state = 56, .external_lex_state = 12},
  [2590] = {.lex_state = 56, .external_lex_state = 14},
  [2591] = {.lex_state = 56, .external_lex_state = 12},
  [2592] = {.lex_state = 56, .external_lex_state = 12},
  [2593] = {.lex_state = 56, .external_lex_state = 12},
  [2594] = {.lex_state = 56, .external_lex_state = 12},
  [2595] = {.lex_state = 56, .external_lex_state = 11},
  [2596] = {.lex_state = 56, .external_lex_state = 13},
  [2597] = {.lex_state = 56, .external_lex_state = 15},
  [2598] = {.lex_state = 56, .external_lex_state = 11},
  [2599] = {.lex_state = 56, .external_lex_state = 12},
  [2600] = {.lex_state = 56, .external_lex_state = 14},
  [2601] = {.lex_state = 56, .external_lex_state = 13},
  [2602] = {.lex_state = 56, .external_lex_state = 12},
  [2603] = {.lex_state = 56, .external_lex_state = 12},
  [2604] = {.lex_state = 56, .external_lex_state = 18},
  [2605] = {.lex_state = 56, .external_lex_state = 12},
  [2606] = {.lex_state = 56, .external_lex_state = 14},
  [2607] = {.lex_state = 56, .external_lex_state = 12},
  [2608] = {.lex_state = 56, .external_lex_state = 12},
  [2609] = {.lex_state = 56, .external_lex_state = 13},
  [2610] = {.lex_state = 56, .external_lex_state = 12},
  [2611] = {.lex_state = 8, .external_lex_state = 14},
  [2612] = {.lex_state = 56, .external_lex_state = 13},
  [2613] = {.lex_state = 56, .external_lex_state = 14},
  [2614] = {.lex_state = 56, .external_lex_state = 11},
  [2615] = {.lex_state = 56, .external_lex_state = 14},
  [2616] = {.lex_state = 56, .external_lex_state = 13},
  [2617] = {.lex_state = 56, .external_lex_state = 18},
  [2618] = {.lex_state = 56, .external_lex_state = 13},
  [2619] = {.lex_state = 56, .external_lex_state = 13},
  [2620] = {.lex_state = 56, .external_lex_state = 14},
  [2621] = {.lex_state = 56, .external_lex_state = 12},
  [2622] = {.lex_state = 56, .external_lex_state = 13},
  [2623] = {.lex_state = 56, .external_lex_state = 11},
  [2624] = {.lex_state = 8, .external_lex_state = 14},
  [2625] = {.lex_state = 56, .external_lex_state = 13},
  [2626] = {.lex_state = 56, .external_lex_state = 13},
  [2627] = {.lex_state = 56, .external_lex_state = 12},
  [2628] = {.lex_state = 56, .external_lex_state = 12},
  [2629] = {.lex_state = 56, .external_lex_state = 13},
  [2630] = {.lex_state = 56, .external_lex_state = 12},
  [2631] = {.lex_state = 56, .external_lex_state = 11},
  [2632] = {.lex_state = 56, .external_lex_state = 12},
  [2633] = {.lex_state = 56, .external_lex_state = 13},
  [2634] = {.lex_state = 56, .external_lex_state = 11},
  [2635] = {.lex_state = 56, .external_lex_state = 14},
  [2636] = {.lex_state = 56, .external_lex_state = 14},
  [2637] = {.lex_state = 56, .external_lex_state = 11},
  [2638] = {.lex_state = 56, .external_lex_state = 14},
  [2639] = {.lex_state = 56, .external_lex_state = 11},
  [2640] = {.lex_state = 56, .external_lex_state = 12},
  [2641] = {.lex_state = 56, .external_lex_state = 12},
  [2642] = {.lex_state = 56, .external_lex_state = 12},
  [2643] = {.lex_state = 56, .external_lex_state = 14},
  [2644] = {.lex_state = 10, .external_lex_state = 14},
  [2645] = {.lex_state = 56, .external_lex_state = 12},
  [2646] = {.lex_state = 56, .external_lex_state = 14},
  [2647] = {.lex_state = 56, .external_lex_state = 14},
  [2648] = {.lex_state = 3, .external_lex_state = 12},
  [2649] = {.lex_state = 56, .external_lex_state = 12},
  [2650] = {.lex_state = 56, .external_lex_state = 15},
  [2651] = {.lex_state = 56, .external_lex_state = 15},
  [2652] = {.lex_state = 56, .external_lex_state = 13},
  [2653] = {.lex_state = 56, .external_lex_state = 15},
  [2654] = {.lex_state = 56, .external_lex_state = 15},
  [2655] = {.lex_state = 56, .external_lex_state = 13},
  [2656] = {.lex_state = 56, .external_lex_state = 15},
  [2657] = {.lex_state = 56, .external_lex_state = 14},
  [2658] = {.lex_state = 56, .external_lex_state = 14},
  [2659] = {.lex_state = 56, .external_lex_state = 13},
  [2660] = {.lex_state = 56, .external_lex_state = 11},
  [2661] = {.lex_state = 10, .external_lex_state = 14},
  [2662] = {.lex_state = 56, .external_lex_state = 11},
  [2663] = {.lex_state = 56, .external_lex_state = 13},
  [2664] = {.lex_state = 56, .external_lex_state = 12},
  [2665] = {.lex_state = 10, .external_lex_state = 14},
  [2666] = {.lex_state = 56, .external_lex_state = 12},
  [2667] = {.lex_state = 56, .external_lex_state = 15},
  [2668] = {.lex_state = 56, .external_lex_state = 14},
  [2669] = {.lex_state = 56, .external_lex_state = 12},
  [2670] = {.lex_state = 56, .external_lex_state = 15},
  [2671] = {.lex_state = 56, .external_lex_state = 13},
  [2672] = {.lex_state = 56, .external_lex_state = 15},
  [2673] = {.lex_state = 56, .external_lex_state = 15},
  [2674] = {.lex_state = 9, .external_lex_state = 17},
  [2675] = {.lex_state = 56, .external_lex_state = 13},
  [2676] = {.lex_state = 56, .external_lex_state = 13},
  [2677] = {.lex_state = 56, .external_lex_state = 14},
  [2678] = {.lex_state = 56, .external_lex_state = 11},
  [2679] = {.lex_state = 56, .external_lex_state = 13},
  [2680] = {.lex_state = 56, .external_lex_state = 14},
  [2681] = {.lex_state = 56, .external_lex_state = 15},
  [2682] = {.lex_state = 56, .external_lex_state = 13},
  [2683] = {.lex_state = 56, .external_lex_state = 13},
  [2684] = {.lex_state = 56, .external_lex_state = 13},
  [2685] = {.lex_state = 56, .external_lex_state = 15},
  [2686] = {.lex_state = 56, .external_lex_state = 13},
  [2687] = {.lex_state = 10, .external_lex_state = 14},
  [2688] = {.lex_state = 3, .external_lex_state = 12},
  [2689] = {.lex_state = 56, .external_lex_state = 12},
  [2690] = {.lex_state = 56, .external_lex_state = 12},
  [2691] = {.lex_state = 3, .external_lex_state = 12},
  [2692] = {.lex_state = 56, .external_lex_state = 14},
  [2693] = {.lex_state = 3, .external_lex_state = 12},
  [2694] = {.lex_state = 56, .external_lex_state = 19},
  [2695] = {.lex_state = 56, .external_lex_state = 12},
  [2696] = {.lex_state = 3, .external_lex_state = 12},
  [2697] = {.lex_state = 56, .external_lex_state = 11},
  [2698] = {.lex_state = 56, .external_lex_state = 15},
  [2699] = {.lex_state = 56, .external_lex_state = 13},
  [2700] = {.lex_state = 56, .external_lex_state = 11},
  [2701] = {.lex_state = 56, .external_lex_state = 11},
  [2702] = {.lex_state = 56, .external_lex_state = 13},
  [2703] = {.lex_state = 56, .external_lex_state = 19},
  [2704] = {.lex_state = 56, .external_lex_state = 14},
  [2705] = {.lex_state = 56, .external_lex_state = 14},
  [2706] = {.lex_state = 56, .external_lex_state = 13},
  [2707] = {.lex_state = 56, .external_lex_state = 13},
  [2708] = {.lex_state = 3, .external_lex_state = 12},
  [2709] = {.lex_state = 3, .external_lex_state = 12},
  [2710] = {.lex_state = 3, .external_lex_state = 12},
  [2711] = {.lex_state = 56, .external_lex_state = 19},
  [2712] = {.lex_state = 56, .external_lex_state = 12},
  [2713] = {.lex_state = 9, .external_lex_state = 17},
  [2714] = {.lex_state = 56, .external_lex_state = 13},
  [2715] = {.lex_state = 56, .external_lex_state = 11},
  [2716] = {.lex_state = 56, .external_lex_state = 19},
  [2717] = {.lex_state = 56, .external_lex_state = 14},
  [2718] = {.lex_state = 56, .external_lex_state = 13},
  [2719] = {.lex_state = 56, .external_lex_state = 13},
  [2720] = {.lex_state = 56, .external_lex_state = 13},
  [2721] = {.lex_state = 56, .external_lex_state = 13},
  [2722] = {.lex_state = 56, .external_lex_state = 15},
  [2723] = {.lex_state = 56, .external_lex_state = 14},
  [2724] = {.lex_state = 56, .external_lex_state = 19},
  [2725] = {.lex_state = 10, .external_lex_state = 14},
  [2726] = {.lex_state = 56, .external_lex_state = 12},
  [2727] = {.lex_state = 56, .external_lex_state = 14},
  [2728] = {.lex_state = 56, .external_lex_state = 14},
  [2729] = {.lex_state = 56, .external_lex_state = 13},
  [2730] = {.lex_state = 56, .external_lex_state = 13},
  [2731] = {.lex_state = 56, .external_lex_state = 13},
  [2732] = {.lex_state = 56, .external_lex_state = 12},
  [2733] = {.lex_state = 56, .external_lex_state = 15},
  [2734] = {.lex_state = 56, .external_lex_state = 15},
  [2735] = {.lex_state = 56, .external_lex_state = 15},
  [2736] = {.lex_state = 56, .external_lex_state = 13},
  [2737] = {.lex_state = 56, .external_lex_state = 14},
  [2738] = {.lex_state = 56, .external_lex_state = 14},
  [2739] = {.lex_state = 56, .external_lex_state = 15},
  [2740] = {.lex_state = 56, .external_lex_state = 14},
  [2741] = {.lex_state = 3, .external_lex_state = 12},
  [2742] = {.lex_state = 56, .external_lex_state = 13},
  [2743] = {.lex_state = 9, .external_lex_state = 17},
  [2744] = {.lex_state = 56, .external_lex_state = 15},
  [2745] = {.lex_state = 56, .external_lex_state = 13},
  [2746] = {.lex_state = 8, .external_lex_state = 14},
  [2747] = {.lex_state = 9, .external_lex_state = 17},
  [2748] = {.lex_state = 8, .external_lex_state = 14},
  [2749] = {.lex_state = 8, .external_lex_state = 14},
  [2750] = {.lex_state = 8, .external_lex_state = 14},
  [2751] = {.lex_state = 56, .external_lex_state = 11},
  [2752] = {.lex_state = 8, .external_lex_state = 14},
  [2753] = {.lex_state = 10, .external_lex_state = 14},
  [2754] = {.lex_state = 56, .external_lex_state = 12},
  [2755] = {.lex_state = 56, .external_lex_state = 15},
  [2756] = {.lex_state = 8, .external_lex_state = 14},
  [2757] = {.lex_state = 8, .external_lex_state = 14},
  [2758] = {.lex_state = 8, .external_lex_state = 14},
  [2759] = {.lex_state = 8, .external_lex_state = 14},
  [2760] = {.lex_state = 8, .external_lex_state = 14},
  [2761] = {.lex_state = 56, .external_lex_state = 13},
  [2762] = {.lex_state = 56, .external_lex_state = 12},
  [2763] = {.lex_state = 56, .external_lex_state = 15},
  [2764] = {.lex_state = 8, .external_lex_state = 14},
  [2765] = {.lex_state = 8, .external_lex_state = 14},
  [2766] = {.lex_state = 56, .external_lex_state = 12},
  [2767] = {.lex_state = 8, .external_lex_state = 14},
  [2768] = {.lex_state = 56, .external_lex_state = 12},
  [2769] = {.lex_state = 56, .external_lex_state = 13},
  [2770] = {.lex_state = 8, .external_lex_state = 14},
  [2771] = {.lex_state = 8, .external_lex_state = 14},
  [2772] = {.lex_state = 10, .external_lex_state = 14},
  [2773] = {.lex_state = 8, .external_lex_state = 14},
  [2774] = {.lex_state = 10, .external_lex_state = 14},
  [2775] = {.lex_state = 8, .external_lex_state = 14},
  [2776] = {.lex_state = 56, .external_lex_state = 13},
  [2777] = {.lex_state = 56, .external_lex_state = 15},
  [2778] = {.lex_state = 10, .external_lex_state = 14},
  [2779] = {.lex_state = 56, .external_lex_state = 11},
  [2780] = {.lex_state = 10, .external_lex_state = 14},
  [2781] = {.lex_state = 10, .external_lex_state = 14},
  [2782] = {.lex_state = 56, .external_lex_state = 15},
  [2783] = {.lex_state = 10, .external_lex_state = 14},
  [2784] = {.lex_state = 56, .external_lex_state = 12},
  [2785] = {.lex_state = 8, .external_lex_state = 14},
  [2786] = {.lex_state = 10, .external_lex_state = 14},
  [2787] = {.lex_state = 8, .external_lex_state = 14},
  [2788] = {.lex_state = 56, .external_lex_state = 11},
  [2789] = {.lex_state = 10, .external_lex_state = 14},
  [2790] = {.lex_state = 56, .external_lex_state = 13},
  [2791] = {.lex_state = 56, .external_lex_state = 12},
  [2792] = {.lex_state = 8, .external_lex_state = 14},
  [2793] = {.lex_state = 56, .external_lex_state = 15},
  [2794] = {.lex_state = 56, .external_lex_state = 13},
  [2795] = {.lex_state = 8, .external_lex_state = 14},
  [2796] = {.lex_state = 56, .external_lex_state = 15},
  [2797] = {.lex_state = 56, .external_lex_state = 15},
  [2798] = {.lex_state = 8, .external_lex_state = 14},
  [2799] = {.lex_state = 8, .external_lex_state = 14},
  [2800] = {.lex_state = 56, .external_lex_state = 13},
  [2801] = {.lex_state = 8, .external_lex_state = 14},
  [2802] = {.lex_state = 56, .external_lex_state = 15},
  [2803] = {.lex_state = 56, .external_lex_state = 13},
  [2804] = {.lex_state = 56, .external_lex_state = 12},
  [2805] = {.lex_state = 56, .external_lex_state = 13},
  [2806] = {.lex_state = 8, .external_lex_state = 14},
  [2807] = {.lex_state = 56, .external_lex_state = 15},
  [2808] = {.lex_state = 56, .external_lex_state = 15},
  [2809] = {.lex_state = 56, .external_lex_state = 11},
  [2810] = {.lex_state = 56, .external_lex_state = 13},
  [2811] = {.lex_state = 56, .external_lex_state = 15},
  [2812] = {.lex_state = 56, .external_lex_state = 14},
  [2813] = {.lex_state = 56, .external_lex_state = 14},
  [2814] = {.lex_state = 10, .external_lex_state = 14},
  [2815] = {.lex_state = 10, .external_lex_state = 14},
  [2816] = {.lex_state = 56, .external_lex_state = 14},
  [2817] = {.lex_state = 56, .external_lex_state = 14},
  [2818] = {.lex_state = 10, .external_lex_state = 14},
  [2819] = {.lex_state = 56, .external_lex_state = 12},
  [2820] = {.lex_state = 56, .external_lex_state = 13},
  [2821] = {.lex_state = 56, .external_lex_state = 13},
  [2822] = {.lex_state = 56, .external_lex_state = 11},
  [2823] = {.lex_state = 9, .external_lex_state = 17},
  [2824] = {.lex_state = 56, .external_lex_state = 13},
  [2825] = {.lex_state = 56, .external_lex_state = 13},
  [2826] = {.lex_state = 56, .external_lex_state = 13},
  [2827] = {.lex_state = 8, .external_lex_state = 14},
  [2828] = {.lex_state = 56, .external_lex_state = 13},
  [2829] = {.lex_state = 56, .external_lex_state = 15},
  [2830] = {.lex_state = 56, .external_lex_state = 13},
  [2831] = {.lex_state = 56, .external_lex_state = 13},
  [2832] = {.lex_state = 56, .external_lex_state = 15},
  [2833] = {.lex_state = 56, .external_lex_state = 13},
  [2834] = {.lex_state = 56, .external_lex_state = 15},
  [2835] = {.lex_state = 56, .external_lex_state = 15},
  [2836] = {.lex_state = 56, .external_lex_state = 13},
  [2837] = {.lex_state = 56, .external_lex_state = 19},
  [2838] = {.lex_state = 56, .external_lex_state = 13},
  [2839] = {.lex_state = 8, .external_lex_state = 14},
  [2840] = {.lex_state = 56, .external_lex_state = 15},
  [2841] = {.lex_state = 8, .external_lex_state = 14},
  [2842] = {.lex_state = 56, .external_lex_state = 15},
  [2843] = {.lex_state = 56, .external_lex_state = 13},
  [2844] = {.lex_state = 56, .external_lex_state = 15},
  [2845] = {.lex_state = 56, .external_lex_state = 12},
  [2846] = {.lex_state = 56, .external_lex_state = 15},
  [2847] = {.lex_state = 8, .external_lex_state = 14},
  [2848] = {.lex_state = 56, .external_lex_state = 13},
  [2849] = {.lex_state = 56, .external_lex_state = 13},
  [2850] = {.lex_state = 56, .external_lex_state = 12},
  [2851] = {.lex_state = 56, .external_lex_state = 15},
  [2852] = {.lex_state = 56, .external_lex_state = 15},
  [2853] = {.lex_state = 8, .external_lex_state = 14},
  [2854] = {.lex_state = 8, .external_lex_state = 14},
  [2855] = {.lex_state = 56, .external_lex_state = 15},
  [2856] = {.lex_state = 56, .external_lex_state = 15},
  [2857] = {.lex_state = 56, .external_lex_state = 12},
  [2858] = {.lex_state = 56, .external_lex_state = 14},
  [2859] = {.lex_state = 56, .external_lex_state = 15},
  [2860] = {.lex_state = 56, .external_lex_state = 12},
  [2861] = {.lex_state = 8, .external_lex_state = 14},
  [2862] = {.lex_state = 8, .external_lex_state = 14},
  [2863] = {.lex_state = 56, .external_lex_state = 13},
  [2864] = {.lex_state = 56, .external_lex_state = 14},
  [2865] = {.lex_state = 56, .external_lex_state = 15},
  [2866] = {.lex_state = 56, .external_lex_state = 14},
  [2867] = {.lex_state = 56, .external_lex_state = 15},
  [2868] = {.lex_state = 56, .external_lex_state = 12},
  [2869] = {.lex_state = 8, .external_lex_state = 14},
  [2870] = {.lex_state = 56, .external_lex_state = 12},
  [2871] = {.lex_state = 56, .external_lex_state = 19},
  [2872] = {.lex_state = 56, .external_lex_state = 15},
  [2873] = {.lex_state = 56, .external_lex_state = 13},
  [2874] = {.lex_state = 56, .external_lex_state = 13},
  [2875] = {.lex_state = 56, .external_lex_state = 13},
  [2876] = {.lex_state = 56, .external_lex_state = 13},
  [2877] = {.lex_state = 56, .external_lex_state = 13},
  [2878] = {.lex_state = 56, .external_lex_state = 14},
  [2879] = {.lex_state = 56, .external_lex_state = 11},
  [2880] = {.lex_state = 8, .external_lex_state = 14},
  [2881] = {.lex_state = 56, .external_lex_state = 11},
  [2882] = {.lex_state = 56, .external_lex_state = 15},
  [2883] = {.lex_state = 56, .external_lex_state = 11},
  [2884] = {.lex_state = 56, .external_lex_state = 14},
  [2885] = {.lex_state = 8, .external_lex_state = 14},
  [2886] = {.lex_state = 8, .external_lex_state = 14},
  [2887] = {.lex_state = 56, .external_lex_state = 11},
  [2888] = {.lex_state = 56, .external_lex_state = 13},
  [2889] = {.lex_state = 56, .external_lex_state = 12},
  [2890] = {.lex_state = 56, .external_lex_state = 13},
  [2891] = {.lex_state = 56, .external_lex_state = 15},
  [2892] = {.lex_state = 56, .external_lex_state = 12},
  [2893] = {.lex_state = 56, .external_lex_state = 13},
  [2894] = {.lex_state = 56, .external_lex_state = 14},
  [2895] = {.lex_state = 56, .external_lex_state = 11},
  [2896] = {.lex_state = 56, .external_lex_state = 14},
  [2897] = {.lex_state = 8, .external_lex_state = 14},
  [2898] = {.lex_state = 56, .external_lex_state = 12},
  [2899] = {.lex_state = 8, .external_lex_state = 14},
  [2900] = {.lex_state = 56, .external_lex_state = 13},
  [2901] = {.lex_state = 56, .external_lex_state = 12},
  [2902] = {.lex_state = 56, .external_lex_state = 11},
  [2903] = {.lex_state = 8, .external_lex_state = 14},
  [2904] = {.lex_state = 8, .external_lex_state = 14},
  [2905] = {.lex_state = 56, .external_lex_state = 14},
  [2906] = {.lex_state = 56, .external_lex_state = 11},
  [2907] = {.lex_state = 8, .external_lex_state = 14},
  [2908] = {.lex_state = 56, .external_lex_state = 12},
  [2909] = {.lex_state = 10, .external_lex_state = 14},
  [2910] = {.lex_state = 56, .external_lex_state = 14},
  [2911] = {.lex_state = 8, .external_lex_state = 14},
  [2912] = {.lex_state = 56, .external_lex_state = 15},
  [2913] = {.lex_state = 56, .external_lex_state = 15},
  [2914] = {.lex_state = 56, .external_lex_state = 14},
  [2915] = {.lex_state = 56, .external_lex_state = 12},
  [2916] = {.lex_state = 56, .external_lex_state = 13},
  [2917] = {.lex_state = 56, .external_lex_state = 13},
  [2918] = {.lex_state = 10, .external_lex_state = 14},
  [2919] = {.lex_state = 56, .external_lex_state = 15},
  [2920] = {.lex_state = 8, .external_lex_state = 14},
  [2921] = {.lex_state = 56, .external_lex_state = 13},
  [2922] = {.lex_state = 56, .external_lex_state = 13},
  [2923] = {.lex_state = 56, .external_lex_state = 13},
  [2924] = {.lex_state = 56, .external_lex_state = 13},
  [2925] = {.lex_state = 56, .external_lex_state = 15},
  [2926] = {.lex_state = 56, .external_lex_state = 13},
  [2927] = {.lex_state = 56, .external_lex_state = 12},
  [2928] = {.lex_state = 56, .external_lex_state = 13},
  [2929] = {.lex_state = 56, .external_lex_state = 12},
  [2930] = {.lex_state = 56, .external_lex_state = 13},
  [2931] = {.lex_state = 56, .external_lex_state = 13},
  [2932] = {.lex_state = 56, .external_lex_state = 13},
  [2933] = {.lex_state = 56, .external_lex_state = 14},
  [2934] = {.lex_state = 56, .external_lex_state = 15},
  [2935] = {.lex_state = 56, .external_lex_state = 14},
  [2936] = {.lex_state = 56, .external_lex_state = 15},
  [2937] = {.lex_state = 56, .external_lex_state = 11},
  [2938] = {.lex_state = 10, .external_lex_state = 14},
  [2939] = {.lex_state = 56, .external_lex_state = 11},
  [2940] = {.lex_state = 56, .external_lex_state = 13},
  [2941] = {.lex_state = 56, .external_lex_state = 12},
  [2942] = {.lex_state = 8, .external_lex_state = 14},
  [2943] = {.lex_state = 10, .external_lex_state = 14},
  [2944] = {.lex_state = 56, .external_lex_state = 12},
  [2945] = {.lex_state = 10, .external_lex_state = 14},
  [2946] = {.lex_state = 56, .external_lex_state = 13},
  [2947] = {.lex_state = 10, .external_lex_state = 14},
  [2948] = {.lex_state = 56, .external_lex_state = 13},
  [2949] = {.lex_state = 56, .external_lex_state = 11},
  [2950] = {.lex_state = 56, .external_lex_state = 11},
  [2951] = {.lex_state = 8, .external_lex_state = 14},
  [2952] = {.lex_state = 56, .external_lex_state = 13},
  [2953] = {.lex_state = 56, .external_lex_state = 15},
  [2954] = {.lex_state = 56, .external_lex_state = 13},
  [2955] = {.lex_state = 56, .external_lex_state = 13},
  [2956] = {.lex_state = 8, .external_lex_state = 14},
  [2957] = {.lex_state = 56, .external_lex_state = 14},
  [2958] = {.lex_state = 56, .external_lex_state = 12},
  [2959] = {.lex_state = 56, .external_lex_state = 12},
  [2960] = {.lex_state = 10, .external_lex_state = 14},
  [2961] = {.lex_state = 56, .external_lex_state = 12},
  [2962] = {.lex_state = 56, .external_lex_state = 12},
  [2963] = {.lex_state = 10, .external_lex_state = 14},
  [2964] = {.lex_state = 56, .external_lex_state = 15},
  [2965] = {.lex_state = 56, .external_lex_state = 13},
  [2966] = {.lex_state = 56, .external_lex_state = 11},
  [2967] = {.lex_state = 8, .external_lex_state = 14},
  [2968] = {.lex_state = 56, .external_lex_state = 15},
  [2969] = {.lex_state = 56, .external_lex_state = 19},
  [2970] = {.lex_state = 56, .external_lex_state = 14},
  [2971] = {.lex_state = 56, .external_lex_state = 13},
  [2972] = {.lex_state = 56, .external_lex_state = 14},
  [2973] = {.lex_state = 56, .external_lex_state = 13},
  [2974] = {.lex_state = 56, .external_lex_state = 12},
  [2975] = {.lex_state = 56, .external_lex_state = 14},
  [2976] = {.lex_state = 56, .external_lex_state = 15},
  [2977] = {.lex_state = 10, .external_lex_state = 14},
  [2978] = {.lex_state = 56, .external_lex_state = 13},
  [2979] = {.lex_state = 56, .external_lex_state = 13},
  [2980] = {.lex_state = 56, .external_lex_state = 18},
  [2981] = {.lex_state = 56, .external_lex_state = 18},
  [2982] = {.lex_state = 56, .external_lex_state = 14},
  [2983] = {.lex_state = 56, .external_lex_state = 14},
  [2984] = {.lex_state = 56, .external_lex_state = 14},
  [2985] = {.lex_state = 56, .external_lex_state = 15},
  [2986] = {.lex_state = 56, .external_lex_state = 12},
  [2987] = {.lex_state = 56, .external_lex_state = 14},
  [2988] = {.lex_state = 56, .external_lex_state = 14},
  [2989] = {.lex_state = 56, .external_lex_state = 14},
  [2990] = {.lex_state = 56, .external_lex_state = 11},
  [2991] = {.lex_state = 56, .external_lex_state = 11},
  [2992] = {.lex_state = 56, .external_lex_state = 11},
  [2993] = {.lex_state = 56, .external_lex_state = 14},
  [2994] = {.lex_state = 56, .external_lex_state = 15},
  [2995] = {.lex_state = 56, .external_lex_state = 12},
  [2996] = {.lex_state = 56, .external_lex_state = 12},
  [2997] = {.lex_state = 56, .external_lex_state = 12},
  [2998] = {.lex_state = 56, .external_lex_state = 14},
  [2999] = {.lex_state = 56, .external_lex_state = 11},
  [3000] = {.lex_state = 56, .external_lex_state = 12},
  [3001] = {.lex_state = 56, .external_lex_state = 14},
  [3002] = {.lex_state = 56, .external_lex_state = 14},
  [3003] = {.lex_state = 56, .external_lex_state = 18},
  [3004] = {.lex_state = 56, .external_lex_state = 15},
  [3005] = {.lex_state = 56, .external_lex_state = 14},
  [3006] = {.lex_state = 56, .external_lex_state = 18},
  [3007] = {.lex_state = 56, .external_lex_state = 14},
  [3008] = {.lex_state = 56, .external_lex_state = 14},
  [3009] = {.lex_state = 56, .external_lex_state = 18},
  [3010] = {.lex_state = 56, .external_lex_state = 11},
  [3011] = {.lex_state = 56, .external_lex_state = 14},
  [3012] = {.lex_state = 56, .external_lex_state = 14},
  [3013] = {.lex_state = 56, .external_lex_state = 14},
  [3014] = {.lex_state = 56, .external_lex_state = 14},
  [3015] = {.lex_state = 56, .external_lex_state = 11},
  [3016] = {.lex_state = 56, .external_lex_state = 15},
  [3017] = {.lex_state = 56, .external_lex_state = 18},
  [3018] = {.lex_state = 56, .external_lex_state = 14},
  [3019] = {.lex_state = 56, .external_lex_state = 14},
  [3020] = {.lex_state = 56, .external_lex_state = 14},
  [3021] = {.lex_state = 56, .external_lex_state = 15},
  [3022] = {.lex_state = 56, .external_lex_state = 11},
  [3023] = {.lex_state = 56, .external_lex_state = 11},
  [3024] = {.lex_state = 56, .external_lex_state = 15},
  [3025] = {.lex_state = 56, .external_lex_state = 15},
  [3026] = {.lex_state = 56, .external_lex_state = 13},
  [3027] = {.lex_state = 56, .external_lex_state = 14},
  [3028] = {.lex_state = 56, .external_lex_state = 13},
  [3029] = {.lex_state = 56, .external_lex_state = 14},
  [3030] = {.lex_state = 56, .external_lex_state = 13},
  [3031] = {.lex_state = 56, .external_lex_state = 15},
  [3032] = {.lex_state = 56, .external_lex_state = 15},
  [3033] = {.lex_state = 56, .external_lex_state = 14},
  [3034] = {.lex_state = 56, .external_lex_state = 14},
  [3035] = {.lex_state = 56, .external_lex_state = 15},
  [3036] = {.lex_state = 56, .external_lex_state = 13},
  [3037] = {.lex_state = 56, .external_lex_state = 13},
  [3038] = {.lex_state = 56, .external_lex_state = 13},
  [3039] = {.lex_state = 56, .external_lex_state = 11},
  [3040] = {.lex_state = 56, .external_lex_state = 11},
  [3041] = {.lex_state = 56, .external_lex_state = 13},
  [3042] = {.lex_state = 56, .external_lex_state = 11},
  [3043] = {.lex_state = 56, .external_lex_state = 14},
  [3044] = {.lex_state = 56, .external_lex_state = 13},
  [3045] = {.lex_state = 56, .external_lex_state = 18},
  [3046] = {.lex_state = 56, .external_lex_state = 11},
  [3047] = {.lex_state = 56, .external_lex_state = 18},
  [3048] = {.lex_state = 56, .external_lex_state = 14},
  [3049] = {.lex_state = 56, .external_lex_state = 14},
  [3050] = {.lex_state = 56, .external_lex_state = 14},
  [3051] = {.lex_state = 56, .external_lex_state = 18},
  [3052] = {.lex_state = 56, .external_lex_state = 14},
  [3053] = {.lex_state = 56, .external_lex_state = 14},
  [3054] = {.lex_state = 56, .external_lex_state = 13},
  [3055] = {.lex_state = 56, .external_lex_state = 13},
  [3056] = {.lex_state = 56, .external_lex_state = 14},
  [3057] = {.lex_state = 56, .external_lex_state = 14},
  [3058] = {.lex_state = 56, .external_lex_state = 15},
  [3059] = {.lex_state = 56, .external_lex_state = 11},
  [3060] = {.lex_state = 56, .external_lex_state = 14},
  [3061] = {.lex_state = 56, .external_lex_state = 11},
  [3062] = {.lex_state = 56, .external_lex_state = 18},
  [3063] = {.lex_state = 56, .external_lex_state = 14},
  [3064] = {.lex_state = 56, .external_lex_state = 13},
  [3065] = {.lex_state = 56, .external_lex_state = 18},
  [3066] = {.lex_state = 56, .external_lex_state = 18},
  [3067] = {.lex_state = 56, .external_lex_state = 14},
  [3068] = {.lex_state = 56, .external_lex_state = 18},
  [3069] = {.lex_state = 56, .external_lex_state = 14},
  [3070] = {.lex_state = 56, .external_lex_state = 13},
  [3071] = {.lex_state = 56, .external_lex_state = 13},
  [3072] = {.lex_state = 56, .external_lex_state = 13},
  [3073] = {.lex_state = 56, .external_lex_state = 18},
  [3074] = {.lex_state = 56, .external_lex_state = 18},
  [3075] = {.lex_state = 56, .external_lex_state = 18},
  [3076] = {.lex_state = 56, .external_lex_state = 11},
  [3077] = {.lex_state = 56, .external_lex_state = 14},
  [3078] = {.lex_state = 56, .external_lex_state = 14},
  [3079] = {.lex_state = 56, .external_lex_state = 13},
  [3080] = {.lex_state = 56, .external_lex_state = 14},
  [3081] = {.lex_state = 56, .external_lex_state = 18},
  [3082] = {.lex_state = 56, .external_lex_state = 11},
  [3083] = {.lex_state = 56, .external_lex_state = 14},
  [3084] = {.lex_state = 56, .external_lex_state = 14},
  [3085] = {.lex_state = 56, .external_lex_state = 18},
  [3086] = {.lex_state = 56, .external_lex_state = 14},
  [3087] = {.lex_state = 56, .external_lex_state = 11},
  [3088] = {.lex_state = 56, .external_lex_state = 14},
  [3089] = {.lex_state = 56, .external_lex_state = 11},
  [3090] = {.lex_state = 56, .external_lex_state = 14},
  [3091] = {.lex_state = 56, .external_lex_state = 14},
  [3092] = {.lex_state = 56, .external_lex_state = 14},
  [3093] = {.lex_state = 56, .external_lex_state = 14},
  [3094] = {.lex_state = 56, .external_lex_state = 12},
  [3095] = {.lex_state = 56, .external_lex_state = 12},
  [3096] = {.lex_state = 56, .external_lex_state = 13},
  [3097] = {.lex_state = 9, .external_lex_state = 14},
  [3098] = {.lex_state = 56, .external_lex_state = 13},
  [3099] = {.lex_state = 56, .external_lex_state = 14},
  [3100] = {.lex_state = 4, .external_lex_state = 14},
  [3101] = {.lex_state = 56, .external_lex_state = 12},
  [3102] = {.lex_state = 56, .external_lex_state = 14},
  [3103] = {.lex_state = 56, .external_lex_state = 14},
  [3104] = {.lex_state = 56, .external_lex_state = 14},
  [3105] = {.lex_state = 56, .external_lex_state = 14},
  [3106] = {.lex_state = 56, .external_lex_state = 14},
  [3107] = {.lex_state = 56, .external_lex_state = 13},
  [3108] = {.lex_state = 56, .external_lex_state = 14},
  [3109] = {.lex_state = 56, .external_lex_state = 15},
  [3110] = {.lex_state = 56, .external_lex_state = 14},
  [3111] = {.lex_state = 56, .external_lex_state = 14},
  [3112] = {.lex_state = 56, .external_lex_state = 14},
  [3113] = {.lex_state = 56, .external_lex_state = 14},
  [3114] = {.lex_state = 56, .external_lex_state = 12},
  [3115] = {.lex_state = 56, .external_lex_state = 14},
  [3116] = {.lex_state = 56, .external_lex_state = 14},
  [3117] = {.lex_state = 56, .external_lex_state = 14},
  [3118] = {.lex_state = 56, .external_lex_state = 14},
  [3119] = {.lex_state = 56, .external_lex_state = 12},
  [3120] = {.lex_state = 56, .external_lex_state = 14},
  [3121] = {.lex_state = 56, .external_lex_state = 12},
  [3122] = {.lex_state = 56, .external_lex_state = 15},
  [3123] = {.lex_state = 56, .external_lex_state = 14},
  [3124] = {.lex_state = 56, .external_lex_state = 12},
  [3125] = {.lex_state = 56, .external_lex_state = 13},
  [3126] = {.lex_state = 56, .external_lex_state = 14},
  [3127] = {.lex_state = 56, .external_lex_state = 13},
  [3128] = {.lex_state = 56, .external_lex_state = 14},
  [3129] = {.lex_state = 56, .external_lex_state = 14},
  [3130] = {.lex_state = 56, .external_lex_state = 13},
  [3131] = {.lex_state = 56, .external_lex_state = 14},
  [3132] = {.lex_state = 56, .external_lex_state = 14},
  [3133] = {.lex_state = 56, .external_lex_state = 12},
  [3134] = {.lex_state = 56, .external_lex_state = 14},
  [3135] = {.lex_state = 56, .external_lex_state = 12},
  [3136] = {.lex_state = 56, .external_lex_state = 12},
  [3137] = {.lex_state = 56, .external_lex_state = 14},
  [3138] = {.lex_state = 56, .external_lex_state = 13},
  [3139] = {.lex_state = 56, .external_lex_state = 15},
  [3140] = {.lex_state = 56, .external_lex_state = 15},
  [3141] = {.lex_state = 56, .external_lex_state = 14},
  [3142] = {.lex_state = 56, .external_lex_state = 14},
  [3143] = {.lex_state = 9, .external_lex_state = 14},
  [3144] = {.lex_state = 56, .external_lex_state = 12},
  [3145] = {.lex_state = 56, .external_lex_state = 13},
  [3146] = {.lex_state = 56, .external_lex_state = 14},
  [3147] = {.lex_state = 56, .external_lex_state = 15},
  [3148] = {.lex_state = 56, .external_lex_state = 15},
  [3149] = {.lex_state = 56, .external_lex_state = 14},
  [3150] = {.lex_state = 56, .external_lex_state = 14},
  [3151] = {.lex_state = 56, .external_lex_state = 12},
  [3152] = {.lex_state = 56, .external_lex_state = 12},
  [3153] = {.lex_state = 56, .external_lex_state = 15},
  [3154] = {.lex_state = 56, .external_lex_state = 14},
  [3155] = {.lex_state = 56, .external_lex_state = 14},
  [3156] = {.lex_state = 56, .external_lex_state = 15},
  [3157] = {.lex_state = 56, .external_lex_state = 14},
  [3158] = {.lex_state = 56, .external_lex_state = 13},
  [3159] = {.lex_state = 56, .external_lex_state = 14},
  [3160] = {.lex_state = 56, .external_lex_state = 15},
  [3161] = {.lex_state = 56, .external_lex_state = 15},
  [3162] = {.lex_state = 56, .external_lex_state = 13},
  [3163] = {.lex_state = 56, .external_lex_state = 14},
  [3164] = {.lex_state = 56, .external_lex_state = 14},
  [3165] = {.lex_state = 56, .external_lex_state = 14},
  [3166] = {.lex_state = 56, .external_lex_state = 14},
  [3167] = {.lex_state = 56, .external_lex_state = 14},
  [3168] = {.lex_state = 56, .external_lex_state = 14},
  [3169] = {.lex_state = 56, .external_lex_state = 14},
  [3170] = {.lex_state = 56, .external_lex_state = 13},
  [3171] = {.lex_state = 56, .external_lex_state = 14},
  [3172] = {.lex_state = 56, .external_lex_state = 14},
  [3173] = {.lex_state = 56, .external_lex_state = 12},
  [3174] = {.lex_state = 56, .external_lex_state = 12},
  [3175] = {.lex_state = 56, .external_lex_state = 12},
  [3176] = {.lex_state = 56, .external_lex_state = 14},
  [3177] = {.lex_state = 56, .external_lex_state = 15},
  [3178] = {.lex_state = 56, .external_lex_state = 15},
  [3179] = {.lex_state = 56, .external_lex_state = 14},
  [3180] = {.lex_state = 56, .external_lex_state = 13},
  [3181] = {.lex_state = 56, .external_lex_state = 13},
  [3182] = {.lex_state = 56, .external_lex_state = 12},
  [3183] = {.lex_state = 4, .external_lex_state = 14},
  [3184] = {.lex_state = 56, .external_lex_state = 12},
  [3185] = {.lex_state = 9, .external_lex_state = 14},
  [3186] = {.lex_state = 4, .external_lex_state = 14},
  [3187] = {.lex_state = 56, .external_lex_state = 12},
  [3188] = {.lex_state = 56, .external_lex_state = 15},
  [3189] = {.lex_state = 9, .external_lex_state = 14},
  [3190] = {.lex_state = 56, .external_lex_state = 12},
  [3191] = {.lex_state = 56, .external_lex_state = 12},
  [3192] = {.lex_state = 56, .external_lex_state = 12},
  [3193] = {.lex_state = 56, .external_lex_state = 14},
  [3194] = {.lex_state = 56, .external_lex_state = 14},
  [3195] = {.lex_state = 56, .external_lex_state = 14},
  [3196] = {.lex_state = 56, .external_lex_state = 14},
  [3197] = {.lex_state = 56, .external_lex_state = 14},
  [3198] = {.lex_state = 9, .external_lex_state = 14},
  [3199] = {.lex_state = 56, .external_lex_state = 14},
  [3200] = {.lex_state = 9, .external_lex_state = 14},
  [3201] = {.lex_state = 56, .external_lex_state = 14},
  [3202] = {.lex_state = 56, .external_lex_state = 14},
  [3203] = {.lex_state = 56, .external_lex_state = 14},
  [3204] = {.lex_state = 56, .external_lex_state = 15},
  [3205] = {.lex_state = 56, .external_lex_state = 14},
  [3206] = {.lex_state = 56, .external_lex_state = 14},
  [3207] = {.lex_state = 56, .external_lex_state = 13},
  [3208] = {.lex_state = 56, .external_lex_state = 14},
  [3209] = {.lex_state = 56, .external_lex_state = 15},
  [3210] = {.lex_state = 56, .external_lex_state = 15},
  [3211] = {.lex_state = 56, .external_lex_state = 12},
  [3212] = {.lex_state = 56, .external_lex_state = 12},
  [3213] = {.lex_state = 56, .external_lex_state = 14},
  [3214] = {.lex_state = 9, .external_lex_state = 14},
  [3215] = {.lex_state = 56, .external_lex_state = 14},
  [3216] = {.lex_state = 56, .external_lex_state = 15},
  [3217] = {.lex_state = 56, .external_lex_state = 14},
  [3218] = {.lex_state = 56, .external_lex_state = 13},
  [3219] = {.lex_state = 56, .external_lex_state = 12},
  [3220] = {.lex_state = 9, .external_lex_state = 14},
  [3221] = {.lex_state = 56, .external_lex_state = 14},
  [3222] = {.lex_state = 56, .external_lex_state = 13},
  [3223] = {.lex_state = 56, .external_lex_state = 14},
  [3224] = {.lex_state = 56, .external_lex_state = 13},
  [3225] = {.lex_state = 56, .external_lex_state = 12},
  [3226] = {.lex_state = 56, .external_lex_state = 13},
  [3227] = {.lex_state = 56, .external_lex_state = 14},
  [3228] = {.lex_state = 56, .external_lex_state = 12},
  [3229] = {.lex_state = 56, .external_lex_state = 14},
  [3230] = {.lex_state = 56, .external_lex_state = 12},
  [3231] = {.lex_state = 56, .external_lex_state = 14},
  [3232] = {.lex_state = 9, .external_lex_state = 14},
  [3233] = {.lex_state = 4, .external_lex_state = 14},
  [3234] = {.lex_state = 56, .external_lex_state = 14},
  [3235] = {.lex_state = 56, .external_lex_state = 15},
  [3236] = {.lex_state = 56, .external_lex_state = 14},
  [3237] = {.lex_state = 56, .external_lex_state = 13},
  [3238] = {.lex_state = 56, .external_lex_state = 13},
  [3239] = {.lex_state = 56, .external_lex_state = 15},
  [3240] = {.lex_state = 56, .external_lex_state = 13},
  [3241] = {.lex_state = 56, .external_lex_state = 12},
  [3242] = {.lex_state = 56, .external_lex_state = 12},
  [3243] = {.lex_state = 56, .external_lex_state = 14},
  [3244] = {.lex_state = 56, .external_lex_state = 15},
  [3245] = {.lex_state = 56, .external_lex_state = 13},
  [3246] = {.lex_state = 56, .external_lex_state = 14},
  [3247] = {.lex_state = 56, .external_lex_state = 15},
  [3248] = {.lex_state = 56, .external_lex_state = 14},
  [3249] = {.lex_state = 56, .external_lex_state = 14},
  [3250] = {.lex_state = 56, .external_lex_state = 14},
  [3251] = {.lex_state = 56, .external_lex_state = 14},
  [3252] = {.lex_state = 56, .external_lex_state = 14},
  [3253] = {.lex_state = 56, .external_lex_state = 14},
  [3254] = {.lex_state = 56, .external_lex_state = 12},
  [3255] = {.lex_state = 56, .external_lex_state = 14},
  [3256] = {.lex_state = 56, .external_lex_state = 14},
  [3257] = {.lex_state = 56, .external_lex_state = 14},
  [3258] = {.lex_state = 56, .external_lex_state = 12},
  [3259] = {.lex_state = 56, .external_lex_state = 14},
  [3260] = {.lex_state = 56, .external_lex_state = 14},
  [3261] = {.lex_state = 56, .external_lex_state = 14},
  [3262] = {.lex_state = 56, .external_lex_state = 15},
  [3263] = {.lex_state = 56, .external_lex_state = 14},
  [3264] = {.lex_state = 56, .external_lex_state = 15},
  [3265] = {.lex_state = 56, .external_lex_state = 14},
  [3266] = {.lex_state = 56, .external_lex_state = 13},
  [3267] = {.lex_state = 56, .external_lex_state = 14},
  [3268] = {.lex_state = 56, .external_lex_state = 12},
  [3269] = {.lex_state = 56, .external_lex_state = 13},
  [3270] = {.lex_state = 56, .external_lex_state = 14},
  [3271] = {.lex_state = 56, .external_lex_state = 13},
  [3272] = {.lex_state = 56, .external_lex_state = 13},
  [3273] = {.lex_state = 56, .external_lex_state = 14},
  [3274] = {.lex_state = 56, .external_lex_state = 14},
  [3275] = {.lex_state = 56, .external_lex_state = 12},
  [3276] = {.lex_state = 56, .external_lex_state = 14},
  [3277] = {.lex_state = 4, .external_lex_state = 14},
  [3278] = {.lex_state = 56, .external_lex_state = 13},
  [3279] = {.lex_state = 56, .external_lex_state = 14},
  [3280] = {.lex_state = 56, .external_lex_state = 15},
  [3281] = {.lex_state = 56, .external_lex_state = 12},
  [3282] = {.lex_state = 56, .external_lex_state = 15},
  [3283] = {.lex_state = 56, .external_lex_state = 12},
  [3284] = {.lex_state = 9, .external_lex_state = 14},
  [3285] = {.lex_state = 56, .external_lex_state = 14},
  [3286] = {.lex_state = 56, .external_lex_state = 13},
  [3287] = {.lex_state = 56, .external_lex_state = 14},
  [3288] = {.lex_state = 4, .external_lex_state = 14},
  [3289] = {.lex_state = 4, .external_lex_state = 14},
  [3290] = {.lex_state = 56, .external_lex_state = 15},
  [3291] = {.lex_state = 56, .external_lex_state = 14},
  [3292] = {.lex_state = 56, .external_lex_state = 13},
  [3293] = {.lex_state = 56, .external_lex_state = 13},
  [3294] = {.lex_state = 56, .external_lex_state = 13},
  [3295] = {.lex_state = 56, .external_lex_state = 15},
  [3296] = {.lex_state = 56, .external_lex_state = 12},
  [3297] = {.lex_state = 4, .external_lex_state = 14},
  [3298] = {.lex_state = 56, .external_lex_state = 12},
  [3299] = {.lex_state = 9, .external_lex_state = 14},
  [3300] = {.lex_state = 56, .external_lex_state = 14},
  [3301] = {.lex_state = 9, .external_lex_state = 14},
  [3302] = {.lex_state = 56, .external_lex_state = 14},
  [3303] = {.lex_state = 56, .external_lex_state = 14},
  [3304] = {.lex_state = 56, .external_lex_state = 14},
  [3305] = {.lex_state = 56, .external_lex_state = 14},
  [3306] = {.lex_state = 56, .external_lex_state = 14},
  [3307] = {.lex_state = 56, .external_lex_state = 14},
  [3308] = {.lex_state = 56, .external_lex_state = 14},
  [3309] = {.lex_state = 56, .external_lex_state = 14},
  [3310] = {.lex_state = 56, .external_lex_state = 13},
  [3311] = {.lex_state = 56, .external_lex_state = 15},
  [3312] = {.lex_state = 56, .external_lex_state = 14},
  [3313] = {.lex_state = 56, .external_lex_state = 14},
  [3314] = {.lex_state = 56, .external_lex_state = 14},
  [3315] = {.lex_state = 56, .external_lex_state = 14},
  [3316] = {.lex_state = 56, .external_lex_state = 13},
  [3317] = {.lex_state = 56, .external_lex_state = 14},
  [3318] = {.lex_state = 9, .external_lex_state = 14},
  [3319] = {.lex_state = 9, .external_lex_state = 14},
  [3320] = {.lex_state = 56, .external_lex_state = 14},
  [3321] = {.lex_state = 9, .external_lex_state = 14},
  [3322] = {.lex_state = 56, .external_lex_state = 14},
  [3323] = {.lex_state = 9, .external_lex_state = 14},
  [3324] = {.lex_state = 56, .external_lex_state = 14},
  [3325] = {.lex_state = 56, .external_lex_state = 14},
  [3326] = {.lex_state = 9, .external_lex_state = 14},
  [3327] = {.lex_state = 9, .external_lex_state = 14},
  [3328] = {.lex_state = 9, .external_lex_state = 14},
  [3329] = {.lex_state = 9, .external_lex_state = 14},
  [3330] = {.lex_state = 9, .external_lex_state = 14},
  [3331] = {.lex_state = 9, .external_lex_state = 14},
  [3332] = {.lex_state = 9, .external_lex_state = 14},
  [3333] = {.lex_state = 9, .external_lex_state = 14},
  [3334] = {.lex_state = 56, .external_lex_state = 14},
  [3335] = {.lex_state = 56, .external_lex_state = 14},
  [3336] = {.lex_state = 56, .external_lex_state = 14},
  [3337] = {.lex_state = 56, .external_lex_state = 15},
  [3338] = {.lex_state = 56, .external_lex_state = 15},
  [3339] = {.lex_state = 56, .external_lex_state = 15},
  [3340] = {.lex_state = 56, .external_lex_state = 15},
  [3341] = {.lex_state = 56, .external_lex_state = 12},
  [3342] = {.lex_state = 56, .external_lex_state = 14},
  [3343] = {.lex_state = 56, .external_lex_state = 14},
  [3344] = {.lex_state = 56, .external_lex_state = 12},
  [3345] = {.lex_state = 56, .external_lex_state = 14},
  [3346] = {.lex_state = 56, .external_lex_state = 14},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym___future__] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_del] = ACTIONS(1),
    [anon_sym_raise] = ACTIONS(1),
    [anon_sym_pass] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_except] = ACTIONS(1),
    [anon_sym_except_STAR] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_raises] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_nonlocal] = ACTIONS(1),
    [anon_sym_exec] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_lambda] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_alias] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AT_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [sym_ellipsis] = ACTIONS(1),
    [anon_sym_inout] = ACTIONS(1),
    [anon_sym_owned] = ACTIONS(1),
    [anon_sym_borrowed] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym__not_escape_sequence] = ACTIONS(1),
    [sym_type_conversion] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(5),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym_string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym_escape_interpolation] = ACTIONS(1),
    [sym_string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_module] = STATE(3300),
    [sym__statement] = STATE(123),
    [sym__simple_statements] = STATE(123),
    [sym_import_statement] = STATE(2662),
    [sym_future_import_statement] = STATE(2662),
    [sym_import_from_statement] = STATE(2662),
    [sym_print_statement] = STATE(2662),
    [sym_assert_statement] = STATE(2662),
    [sym_expression_statement] = STATE(2662),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2662),
    [sym_delete_statement] = STATE(2662),
    [sym_raise_statement] = STATE(2662),
    [sym_pass_statement] = STATE(2662),
    [sym_break_statement] = STATE(2662),
    [sym_continue_statement] = STATE(2662),
    [sym_if_statement] = STATE(123),
    [sym_match_statement] = STATE(123),
    [sym_for_statement] = STATE(123),
    [sym_while_statement] = STATE(123),
    [sym_try_statement] = STATE(123),
    [sym_with_statement] = STATE(123),
    [sym_function_definition] = STATE(123),
    [sym_global_statement] = STATE(2662),
    [sym_nonlocal_statement] = STATE(2662),
    [sym_exec_statement] = STATE(2662),
    [sym_type_alias_statement] = STATE(2662),
    [sym_class_definition] = STATE(123),
    [sym_decorated_definition] = STATE(123),
    [sym_decorator] = STATE(2105),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(123),
    [aux_sym_decorated_definition_repeat1] = STATE(2105),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_match] = ACTIONS(37),
    [anon_sym_async] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_def] = ACTIONS(49),
    [anon_sym_fn] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_struct] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(83),
  },
  [2] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(933),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [3] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(875),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [4] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(873),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [5] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(872),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [6] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(870),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [7] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(869),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [8] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1055),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [9] = {
    [sym__statement] = STATE(127),
    [sym__simple_statements] = STATE(127),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(127),
    [sym_match_statement] = STATE(127),
    [sym_for_statement] = STATE(127),
    [sym_while_statement] = STATE(127),
    [sym_try_statement] = STATE(127),
    [sym_with_statement] = STATE(127),
    [sym_function_definition] = STATE(127),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(127),
    [sym_decorated_definition] = STATE(127),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(753),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(127),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(83),
  },
  [10] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(840),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [11] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(931),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [12] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(939),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [13] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(942),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [14] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1071),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [15] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(852),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [16] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1025),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [17] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(985),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [18] = {
    [sym__statement] = STATE(121),
    [sym__simple_statements] = STATE(121),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(121),
    [sym_match_statement] = STATE(121),
    [sym_for_statement] = STATE(121),
    [sym_while_statement] = STATE(121),
    [sym_try_statement] = STATE(121),
    [sym_with_statement] = STATE(121),
    [sym_function_definition] = STATE(121),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(121),
    [sym_decorated_definition] = STATE(121),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(3006),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(121),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(83),
  },
  [19] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(857),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [20] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(893),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [21] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1059),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [22] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(616),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [23] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1054),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [24] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(882),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [25] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(909),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [26] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(938),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [27] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1020),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [28] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1083),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [29] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(912),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [30] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(948),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [31] = {
    [sym__statement] = STATE(121),
    [sym__simple_statements] = STATE(121),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(121),
    [sym_match_statement] = STATE(121),
    [sym_for_statement] = STATE(121),
    [sym_while_statement] = STATE(121),
    [sym_try_statement] = STATE(121),
    [sym_with_statement] = STATE(121),
    [sym_function_definition] = STATE(121),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(121),
    [sym_decorated_definition] = STATE(121),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(3081),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(121),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(83),
  },
  [32] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(884),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [33] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(886),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [34] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(891),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [35] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(894),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [36] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(901),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [37] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(904),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [38] = {
    [sym__statement] = STATE(121),
    [sym__simple_statements] = STATE(121),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(121),
    [sym_match_statement] = STATE(121),
    [sym_for_statement] = STATE(121),
    [sym_while_statement] = STATE(121),
    [sym_try_statement] = STATE(121),
    [sym_with_statement] = STATE(121),
    [sym_function_definition] = STATE(121),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(121),
    [sym_decorated_definition] = STATE(121),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(3047),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(121),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(83),
  },
  [39] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(934),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [40] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(937),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [41] = {
    [sym__statement] = STATE(127),
    [sym__simple_statements] = STATE(127),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(127),
    [sym_match_statement] = STATE(127),
    [sym_for_statement] = STATE(127),
    [sym_while_statement] = STATE(127),
    [sym_try_statement] = STATE(127),
    [sym_with_statement] = STATE(127),
    [sym_function_definition] = STATE(127),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(127),
    [sym_decorated_definition] = STATE(127),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(772),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(127),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(83),
  },
  [42] = {
    [sym__statement] = STATE(128),
    [sym__simple_statements] = STATE(128),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(128),
    [sym_match_statement] = STATE(128),
    [sym_for_statement] = STATE(128),
    [sym_while_statement] = STATE(128),
    [sym_try_statement] = STATE(128),
    [sym_with_statement] = STATE(128),
    [sym_function_definition] = STATE(128),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(128),
    [sym_decorated_definition] = STATE(128),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(2192),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(128),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(83),
  },
  [43] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(940),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [44] = {
    [sym__statement] = STATE(124),
    [sym__simple_statements] = STATE(124),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(124),
    [sym_match_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_with_statement] = STATE(124),
    [sym_function_definition] = STATE(124),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(124),
    [sym_decorated_definition] = STATE(124),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(832),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(124),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(113),
    [sym_string_start] = ACTIONS(83),
  },
  [45] = {
    [sym__statement] = STATE(127),
    [sym__simple_statements] = STATE(127),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(127),
    [sym_match_statement] = STATE(127),
    [sym_for_statement] = STATE(127),
    [sym_while_statement] = STATE(127),
    [sym_try_statement] = STATE(127),
    [sym_with_statement] = STATE(127),
    [sym_function_definition] = STATE(127),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(127),
    [sym_decorated_definition] = STATE(127),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(831),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(127),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(83),
  },
  [46] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(954),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [47] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1015),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [48] = {
    [sym__statement] = STATE(121),
    [sym__simple_statements] = STATE(121),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(121),
    [sym_match_statement] = STATE(121),
    [sym_for_statement] = STATE(121),
    [sym_while_statement] = STATE(121),
    [sym_try_statement] = STATE(121),
    [sym_with_statement] = STATE(121),
    [sym_function_definition] = STATE(121),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(121),
    [sym_decorated_definition] = STATE(121),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(3062),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(121),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(83),
  },
  [49] = {
    [sym__statement] = STATE(121),
    [sym__simple_statements] = STATE(121),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(121),
    [sym_match_statement] = STATE(121),
    [sym_for_statement] = STATE(121),
    [sym_while_statement] = STATE(121),
    [sym_try_statement] = STATE(121),
    [sym_with_statement] = STATE(121),
    [sym_function_definition] = STATE(121),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(121),
    [sym_decorated_definition] = STATE(121),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(3065),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(121),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(83),
  },
  [50] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(960),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [51] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(862),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [52] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(975),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [53] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(878),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [54] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(965),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [55] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(850),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [56] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1084),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [57] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(920),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [58] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(925),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [59] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(927),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [60] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(974),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [61] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(868),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [62] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(981),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [63] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(930),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [64] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(953),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [65] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1073),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [66] = {
    [sym__statement] = STATE(124),
    [sym__simple_statements] = STATE(124),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(124),
    [sym_match_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_with_statement] = STATE(124),
    [sym_function_definition] = STATE(124),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(124),
    [sym_decorated_definition] = STATE(124),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(773),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(124),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(113),
    [sym_string_start] = ACTIONS(83),
  },
  [67] = {
    [sym__statement] = STATE(121),
    [sym__simple_statements] = STATE(121),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(121),
    [sym_match_statement] = STATE(121),
    [sym_for_statement] = STATE(121),
    [sym_while_statement] = STATE(121),
    [sym_try_statement] = STATE(121),
    [sym_with_statement] = STATE(121),
    [sym_function_definition] = STATE(121),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(121),
    [sym_decorated_definition] = STATE(121),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(2980),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(121),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(83),
  },
  [68] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(957),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [69] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(860),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [70] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(961),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [71] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(992),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [72] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(995),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [73] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(970),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [74] = {
    [sym__statement] = STATE(118),
    [sym__simple_statements] = STATE(118),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(118),
    [sym_match_statement] = STATE(118),
    [sym_for_statement] = STATE(118),
    [sym_while_statement] = STATE(118),
    [sym_try_statement] = STATE(118),
    [sym_with_statement] = STATE(118),
    [sym_function_definition] = STATE(118),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(118),
    [sym_decorated_definition] = STATE(118),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(829),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(118),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(115),
    [sym_string_start] = ACTIONS(83),
  },
  [75] = {
    [sym__statement] = STATE(128),
    [sym__simple_statements] = STATE(128),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(128),
    [sym_match_statement] = STATE(128),
    [sym_for_statement] = STATE(128),
    [sym_while_statement] = STATE(128),
    [sym_try_statement] = STATE(128),
    [sym_with_statement] = STATE(128),
    [sym_function_definition] = STATE(128),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(128),
    [sym_decorated_definition] = STATE(128),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(2171),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(128),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(83),
  },
  [76] = {
    [sym__statement] = STATE(120),
    [sym__simple_statements] = STATE(120),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(120),
    [sym_match_statement] = STATE(120),
    [sym_for_statement] = STATE(120),
    [sym_while_statement] = STATE(120),
    [sym_try_statement] = STATE(120),
    [sym_with_statement] = STATE(120),
    [sym_function_definition] = STATE(120),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(120),
    [sym_decorated_definition] = STATE(120),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(823),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(120),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(117),
    [sym_string_start] = ACTIONS(83),
  },
  [77] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(968),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [78] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(980),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [79] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1068),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [80] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(845),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [81] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(916),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [82] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(986),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [83] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(865),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [84] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(994),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [85] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(997),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [86] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1004),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [87] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(607),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [88] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1011),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [89] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(913),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [90] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1016),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [91] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1012),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [92] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1066),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [93] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(932),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [94] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(842),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [95] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1079),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [96] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1023),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [97] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1026),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [98] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1028),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [99] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1057),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [100] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1030),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [101] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(841),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [102] = {
    [sym__statement] = STATE(120),
    [sym__simple_statements] = STATE(120),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(120),
    [sym_match_statement] = STATE(120),
    [sym_for_statement] = STATE(120),
    [sym_while_statement] = STATE(120),
    [sym_try_statement] = STATE(120),
    [sym_with_statement] = STATE(120),
    [sym_function_definition] = STATE(120),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(120),
    [sym_decorated_definition] = STATE(120),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(761),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(120),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(117),
    [sym_string_start] = ACTIONS(83),
  },
  [103] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1033),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [104] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1036),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [105] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1039),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [106] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1043),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [107] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1044),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [108] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(978),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [109] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1047),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [110] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1048),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [111] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1049),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [112] = {
    [sym__statement] = STATE(126),
    [sym__simple_statements] = STATE(126),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(126),
    [sym_match_statement] = STATE(126),
    [sym_for_statement] = STATE(126),
    [sym_while_statement] = STATE(126),
    [sym_try_statement] = STATE(126),
    [sym_with_statement] = STATE(126),
    [sym_function_definition] = STATE(126),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(126),
    [sym_decorated_definition] = STATE(126),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1062),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(126),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(83),
  },
  [113] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1053),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [114] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1051),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [115] = {
    [sym__statement] = STATE(122),
    [sym__simple_statements] = STATE(122),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(122),
    [sym_match_statement] = STATE(122),
    [sym_for_statement] = STATE(122),
    [sym_while_statement] = STATE(122),
    [sym_try_statement] = STATE(122),
    [sym_with_statement] = STATE(122),
    [sym_function_definition] = STATE(122),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(122),
    [sym_decorated_definition] = STATE(122),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(1052),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(122),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(83),
  },
  [116] = {
    [sym__statement] = STATE(118),
    [sym__simple_statements] = STATE(118),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(118),
    [sym_match_statement] = STATE(118),
    [sym_for_statement] = STATE(118),
    [sym_while_statement] = STATE(118),
    [sym_try_statement] = STATE(118),
    [sym_with_statement] = STATE(118),
    [sym_function_definition] = STATE(118),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(118),
    [sym_decorated_definition] = STATE(118),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(795),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(118),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(115),
    [sym_string_start] = ACTIONS(83),
  },
  [117] = {
    [sym__statement] = STATE(120),
    [sym__simple_statements] = STATE(120),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(120),
    [sym_match_statement] = STATE(120),
    [sym_for_statement] = STATE(120),
    [sym_while_statement] = STATE(120),
    [sym_try_statement] = STATE(120),
    [sym_with_statement] = STATE(120),
    [sym_function_definition] = STATE(120),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(120),
    [sym_decorated_definition] = STATE(120),
    [sym_decorator] = STATE(2094),
    [sym_block] = STATE(783),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(120),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(117),
    [sym_string_start] = ACTIONS(83),
  },
  [118] = {
    [sym__statement] = STATE(125),
    [sym__simple_statements] = STATE(125),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(125),
    [sym_match_statement] = STATE(125),
    [sym_for_statement] = STATE(125),
    [sym_while_statement] = STATE(125),
    [sym_try_statement] = STATE(125),
    [sym_with_statement] = STATE(125),
    [sym_function_definition] = STATE(125),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(125),
    [sym_decorated_definition] = STATE(125),
    [sym_decorator] = STATE(2094),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(125),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(119),
    [sym_string_start] = ACTIONS(83),
  },
  [119] = {
    [sym__statement] = STATE(119),
    [sym__simple_statements] = STATE(119),
    [sym_import_statement] = STATE(2662),
    [sym_future_import_statement] = STATE(2662),
    [sym_import_from_statement] = STATE(2662),
    [sym_print_statement] = STATE(2662),
    [sym_assert_statement] = STATE(2662),
    [sym_expression_statement] = STATE(2662),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2662),
    [sym_delete_statement] = STATE(2662),
    [sym_raise_statement] = STATE(2662),
    [sym_pass_statement] = STATE(2662),
    [sym_break_statement] = STATE(2662),
    [sym_continue_statement] = STATE(2662),
    [sym_if_statement] = STATE(119),
    [sym_match_statement] = STATE(119),
    [sym_for_statement] = STATE(119),
    [sym_while_statement] = STATE(119),
    [sym_try_statement] = STATE(119),
    [sym_with_statement] = STATE(119),
    [sym_function_definition] = STATE(119),
    [sym_global_statement] = STATE(2662),
    [sym_nonlocal_statement] = STATE(2662),
    [sym_exec_statement] = STATE(2662),
    [sym_type_alias_statement] = STATE(2662),
    [sym_class_definition] = STATE(119),
    [sym_decorated_definition] = STATE(119),
    [sym_decorator] = STATE(2105),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(119),
    [aux_sym_decorated_definition_repeat1] = STATE(2105),
    [ts_builtin_sym_end] = ACTIONS(121),
    [sym_identifier] = ACTIONS(123),
    [anon_sym_import] = ACTIONS(126),
    [anon_sym_from] = ACTIONS(129),
    [anon_sym_LPAREN] = ACTIONS(132),
    [anon_sym_STAR] = ACTIONS(135),
    [anon_sym_print] = ACTIONS(138),
    [anon_sym_assert] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(144),
    [anon_sym_del] = ACTIONS(147),
    [anon_sym_raise] = ACTIONS(150),
    [anon_sym_pass] = ACTIONS(153),
    [anon_sym_break] = ACTIONS(156),
    [anon_sym_continue] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(162),
    [anon_sym_match] = ACTIONS(165),
    [anon_sym_async] = ACTIONS(168),
    [anon_sym_for] = ACTIONS(171),
    [anon_sym_while] = ACTIONS(174),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_with] = ACTIONS(180),
    [anon_sym_def] = ACTIONS(183),
    [anon_sym_fn] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(186),
    [anon_sym_global] = ACTIONS(189),
    [anon_sym_nonlocal] = ACTIONS(192),
    [anon_sym_exec] = ACTIONS(195),
    [anon_sym_type] = ACTIONS(198),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_struct] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(204),
    [anon_sym_DASH] = ACTIONS(207),
    [anon_sym_LBRACE] = ACTIONS(210),
    [anon_sym_PLUS] = ACTIONS(207),
    [anon_sym_not] = ACTIONS(213),
    [anon_sym_TILDE] = ACTIONS(207),
    [anon_sym_lambda] = ACTIONS(216),
    [anon_sym_var] = ACTIONS(219),
    [anon_sym_alias] = ACTIONS(219),
    [anon_sym_yield] = ACTIONS(222),
    [sym_ellipsis] = ACTIONS(225),
    [sym_integer] = ACTIONS(228),
    [sym_float] = ACTIONS(225),
    [anon_sym_await] = ACTIONS(231),
    [sym_true] = ACTIONS(228),
    [sym_false] = ACTIONS(228),
    [sym_none] = ACTIONS(228),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(234),
  },
  [120] = {
    [sym__statement] = STATE(125),
    [sym__simple_statements] = STATE(125),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(125),
    [sym_match_statement] = STATE(125),
    [sym_for_statement] = STATE(125),
    [sym_while_statement] = STATE(125),
    [sym_try_statement] = STATE(125),
    [sym_with_statement] = STATE(125),
    [sym_function_definition] = STATE(125),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(125),
    [sym_decorated_definition] = STATE(125),
    [sym_decorator] = STATE(2094),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(125),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(237),
    [sym_string_start] = ACTIONS(83),
  },
  [121] = {
    [sym__statement] = STATE(125),
    [sym__simple_statements] = STATE(125),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(125),
    [sym_match_statement] = STATE(125),
    [sym_for_statement] = STATE(125),
    [sym_while_statement] = STATE(125),
    [sym_try_statement] = STATE(125),
    [sym_with_statement] = STATE(125),
    [sym_function_definition] = STATE(125),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(125),
    [sym_decorated_definition] = STATE(125),
    [sym_decorator] = STATE(2094),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(125),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(239),
    [sym_string_start] = ACTIONS(83),
  },
  [122] = {
    [sym__statement] = STATE(125),
    [sym__simple_statements] = STATE(125),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(125),
    [sym_match_statement] = STATE(125),
    [sym_for_statement] = STATE(125),
    [sym_while_statement] = STATE(125),
    [sym_try_statement] = STATE(125),
    [sym_with_statement] = STATE(125),
    [sym_function_definition] = STATE(125),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(125),
    [sym_decorated_definition] = STATE(125),
    [sym_decorator] = STATE(2094),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(125),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(241),
    [sym_string_start] = ACTIONS(83),
  },
  [123] = {
    [sym__statement] = STATE(119),
    [sym__simple_statements] = STATE(119),
    [sym_import_statement] = STATE(2662),
    [sym_future_import_statement] = STATE(2662),
    [sym_import_from_statement] = STATE(2662),
    [sym_print_statement] = STATE(2662),
    [sym_assert_statement] = STATE(2662),
    [sym_expression_statement] = STATE(2662),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2662),
    [sym_delete_statement] = STATE(2662),
    [sym_raise_statement] = STATE(2662),
    [sym_pass_statement] = STATE(2662),
    [sym_break_statement] = STATE(2662),
    [sym_continue_statement] = STATE(2662),
    [sym_if_statement] = STATE(119),
    [sym_match_statement] = STATE(119),
    [sym_for_statement] = STATE(119),
    [sym_while_statement] = STATE(119),
    [sym_try_statement] = STATE(119),
    [sym_with_statement] = STATE(119),
    [sym_function_definition] = STATE(119),
    [sym_global_statement] = STATE(2662),
    [sym_nonlocal_statement] = STATE(2662),
    [sym_exec_statement] = STATE(2662),
    [sym_type_alias_statement] = STATE(2662),
    [sym_class_definition] = STATE(119),
    [sym_decorated_definition] = STATE(119),
    [sym_decorator] = STATE(2105),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(119),
    [aux_sym_decorated_definition_repeat1] = STATE(2105),
    [ts_builtin_sym_end] = ACTIONS(243),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_match] = ACTIONS(37),
    [anon_sym_async] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_def] = ACTIONS(49),
    [anon_sym_fn] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_struct] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(83),
  },
  [124] = {
    [sym__statement] = STATE(125),
    [sym__simple_statements] = STATE(125),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(125),
    [sym_match_statement] = STATE(125),
    [sym_for_statement] = STATE(125),
    [sym_while_statement] = STATE(125),
    [sym_try_statement] = STATE(125),
    [sym_with_statement] = STATE(125),
    [sym_function_definition] = STATE(125),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(125),
    [sym_decorated_definition] = STATE(125),
    [sym_decorator] = STATE(2094),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(125),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(245),
    [sym_string_start] = ACTIONS(83),
  },
  [125] = {
    [sym__statement] = STATE(125),
    [sym__simple_statements] = STATE(125),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(125),
    [sym_match_statement] = STATE(125),
    [sym_for_statement] = STATE(125),
    [sym_while_statement] = STATE(125),
    [sym_try_statement] = STATE(125),
    [sym_with_statement] = STATE(125),
    [sym_function_definition] = STATE(125),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(125),
    [sym_decorated_definition] = STATE(125),
    [sym_decorator] = STATE(2094),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(125),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(123),
    [anon_sym_import] = ACTIONS(126),
    [anon_sym_from] = ACTIONS(129),
    [anon_sym_LPAREN] = ACTIONS(132),
    [anon_sym_STAR] = ACTIONS(135),
    [anon_sym_print] = ACTIONS(138),
    [anon_sym_assert] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(144),
    [anon_sym_del] = ACTIONS(147),
    [anon_sym_raise] = ACTIONS(150),
    [anon_sym_pass] = ACTIONS(153),
    [anon_sym_break] = ACTIONS(156),
    [anon_sym_continue] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_match] = ACTIONS(250),
    [anon_sym_async] = ACTIONS(253),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_while] = ACTIONS(259),
    [anon_sym_try] = ACTIONS(262),
    [anon_sym_with] = ACTIONS(265),
    [anon_sym_def] = ACTIONS(268),
    [anon_sym_fn] = ACTIONS(268),
    [anon_sym_LBRACK] = ACTIONS(186),
    [anon_sym_global] = ACTIONS(189),
    [anon_sym_nonlocal] = ACTIONS(192),
    [anon_sym_exec] = ACTIONS(195),
    [anon_sym_type] = ACTIONS(198),
    [anon_sym_class] = ACTIONS(271),
    [anon_sym_struct] = ACTIONS(271),
    [anon_sym_AT] = ACTIONS(204),
    [anon_sym_DASH] = ACTIONS(207),
    [anon_sym_LBRACE] = ACTIONS(210),
    [anon_sym_PLUS] = ACTIONS(207),
    [anon_sym_not] = ACTIONS(213),
    [anon_sym_TILDE] = ACTIONS(207),
    [anon_sym_lambda] = ACTIONS(216),
    [anon_sym_var] = ACTIONS(219),
    [anon_sym_alias] = ACTIONS(219),
    [anon_sym_yield] = ACTIONS(222),
    [sym_ellipsis] = ACTIONS(225),
    [sym_integer] = ACTIONS(228),
    [sym_float] = ACTIONS(225),
    [anon_sym_await] = ACTIONS(231),
    [sym_true] = ACTIONS(228),
    [sym_false] = ACTIONS(228),
    [sym_none] = ACTIONS(228),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(121),
    [sym_string_start] = ACTIONS(234),
  },
  [126] = {
    [sym__statement] = STATE(125),
    [sym__simple_statements] = STATE(125),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(125),
    [sym_match_statement] = STATE(125),
    [sym_for_statement] = STATE(125),
    [sym_while_statement] = STATE(125),
    [sym_try_statement] = STATE(125),
    [sym_with_statement] = STATE(125),
    [sym_function_definition] = STATE(125),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(125),
    [sym_decorated_definition] = STATE(125),
    [sym_decorator] = STATE(2094),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(125),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(274),
    [sym_string_start] = ACTIONS(83),
  },
  [127] = {
    [sym__statement] = STATE(125),
    [sym__simple_statements] = STATE(125),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(125),
    [sym_match_statement] = STATE(125),
    [sym_for_statement] = STATE(125),
    [sym_while_statement] = STATE(125),
    [sym_try_statement] = STATE(125),
    [sym_with_statement] = STATE(125),
    [sym_function_definition] = STATE(125),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(125),
    [sym_decorated_definition] = STATE(125),
    [sym_decorator] = STATE(2094),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(125),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(276),
    [sym_string_start] = ACTIONS(83),
  },
  [128] = {
    [sym__statement] = STATE(125),
    [sym__simple_statements] = STATE(125),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_if_statement] = STATE(125),
    [sym_match_statement] = STATE(125),
    [sym_for_statement] = STATE(125),
    [sym_while_statement] = STATE(125),
    [sym_try_statement] = STATE(125),
    [sym_with_statement] = STATE(125),
    [sym_function_definition] = STATE(125),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_class_definition] = STATE(125),
    [sym_decorated_definition] = STATE(125),
    [sym_decorator] = STATE(2094),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2199),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [aux_sym_module_repeat1] = STATE(125),
    [aux_sym_decorated_definition_repeat1] = STATE(2094),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_match] = ACTIONS(87),
    [anon_sym_async] = ACTIONS(89),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(95),
    [anon_sym_with] = ACTIONS(97),
    [anon_sym_def] = ACTIONS(99),
    [anon_sym_fn] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(101),
    [anon_sym_struct] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(278),
    [sym_string_start] = ACTIONS(83),
  },
  [129] = {
    [sym_named_expression] = STATE(2091),
    [sym__named_expression_lhs] = STATE(3277),
    [sym_list_splat_pattern] = STATE(1762),
    [sym_as_pattern] = STATE(2091),
    [sym_expression] = STATE(2156),
    [sym_primary_expression] = STATE(1294),
    [sym_not_operator] = STATE(2091),
    [sym_boolean_operator] = STATE(2091),
    [sym_binary_operator] = STATE(1740),
    [sym_unary_operator] = STATE(1740),
    [sym_comparison_operator] = STATE(2091),
    [sym_lambda] = STATE(2091),
    [sym_attribute] = STATE(1740),
    [sym_subscript] = STATE(1680),
    [sym_call] = STATE(1725),
    [sym_type] = STATE(2611),
    [sym_splat_type] = STATE(2380),
    [sym_generic_type] = STATE(2380),
    [sym_union_type] = STATE(2380),
    [sym_constrained_type] = STATE(2380),
    [sym_member_type] = STATE(2380),
    [sym_list] = STATE(1740),
    [sym_set] = STATE(1740),
    [sym_tuple] = STATE(1740),
    [sym_dictionary] = STATE(1740),
    [sym_list_comprehension] = STATE(1740),
    [sym_dictionary_comprehension] = STATE(1740),
    [sym_set_comprehension] = STATE(1740),
    [sym_generator_expression] = STATE(1740),
    [sym_parenthesized_expression] = STATE(1740),
    [sym_conditional_expression] = STATE(2091),
    [sym_concatenated_string] = STATE(1740),
    [sym_string] = STATE(1371),
    [sym_await] = STATE(1740),
    [sym_identifier] = ACTIONS(280),
    [anon_sym_SEMI] = ACTIONS(282),
    [anon_sym_DOT] = ACTIONS(284),
    [anon_sym_LPAREN] = ACTIONS(286),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_as] = ACTIONS(284),
    [anon_sym_STAR] = ACTIONS(292),
    [anon_sym_print] = ACTIONS(295),
    [anon_sym_GT_GT] = ACTIONS(284),
    [anon_sym_COLON_EQ] = ACTIONS(297),
    [anon_sym_if] = ACTIONS(284),
    [anon_sym_COLON] = ACTIONS(284),
    [anon_sym_match] = ACTIONS(295),
    [anon_sym_async] = ACTIONS(295),
    [anon_sym_in] = ACTIONS(284),
    [anon_sym_LBRACK] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(302),
    [anon_sym_exec] = ACTIONS(295),
    [anon_sym_type] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(284),
    [anon_sym_DASH] = ACTIONS(307),
    [anon_sym_PIPE] = ACTIONS(284),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_PLUS] = ACTIONS(307),
    [anon_sym_not] = ACTIONS(312),
    [anon_sym_and] = ACTIONS(284),
    [anon_sym_or] = ACTIONS(284),
    [anon_sym_SLASH] = ACTIONS(284),
    [anon_sym_PERCENT] = ACTIONS(284),
    [anon_sym_SLASH_SLASH] = ACTIONS(284),
    [anon_sym_AMP] = ACTIONS(284),
    [anon_sym_CARET] = ACTIONS(284),
    [anon_sym_LT_LT] = ACTIONS(284),
    [anon_sym_TILDE] = ACTIONS(315),
    [anon_sym_LT] = ACTIONS(284),
    [anon_sym_LT_EQ] = ACTIONS(282),
    [anon_sym_EQ_EQ] = ACTIONS(282),
    [anon_sym_BANG_EQ] = ACTIONS(282),
    [anon_sym_GT_EQ] = ACTIONS(282),
    [anon_sym_GT] = ACTIONS(284),
    [anon_sym_LT_GT] = ACTIONS(282),
    [anon_sym_is] = ACTIONS(284),
    [anon_sym_lambda] = ACTIONS(317),
    [anon_sym_PLUS_EQ] = ACTIONS(319),
    [anon_sym_DASH_EQ] = ACTIONS(319),
    [anon_sym_STAR_EQ] = ACTIONS(319),
    [anon_sym_SLASH_EQ] = ACTIONS(319),
    [anon_sym_AT_EQ] = ACTIONS(319),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(319),
    [anon_sym_PERCENT_EQ] = ACTIONS(319),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(319),
    [anon_sym_GT_GT_EQ] = ACTIONS(319),
    [anon_sym_LT_LT_EQ] = ACTIONS(319),
    [anon_sym_AMP_EQ] = ACTIONS(319),
    [anon_sym_CARET_EQ] = ACTIONS(319),
    [anon_sym_PIPE_EQ] = ACTIONS(319),
    [sym_ellipsis] = ACTIONS(321),
    [sym_integer] = ACTIONS(323),
    [sym_float] = ACTIONS(321),
    [anon_sym_await] = ACTIONS(325),
    [sym_true] = ACTIONS(323),
    [sym_false] = ACTIONS(323),
    [sym_none] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(282),
    [sym_string_start] = ACTIONS(327),
  },
  [130] = {
    [sym__simple_statements] = STATE(979),
    [sym_import_statement] = STATE(2662),
    [sym_future_import_statement] = STATE(2662),
    [sym_import_from_statement] = STATE(2662),
    [sym_print_statement] = STATE(2662),
    [sym_assert_statement] = STATE(2662),
    [sym_expression_statement] = STATE(2662),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2662),
    [sym_delete_statement] = STATE(2662),
    [sym_raise_statement] = STATE(2662),
    [sym_pass_statement] = STATE(2662),
    [sym_break_statement] = STATE(2662),
    [sym_continue_statement] = STATE(2662),
    [sym_global_statement] = STATE(2662),
    [sym_nonlocal_statement] = STATE(2662),
    [sym_exec_statement] = STATE(2662),
    [sym_type_alias_statement] = STATE(2662),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2072),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_type] = STATE(2387),
    [sym_splat_type] = STATE(2380),
    [sym_generic_type] = STATE(2380),
    [sym_union_type] = STATE(2380),
    [sym_constrained_type] = STATE(2380),
    [sym_member_type] = STATE(2380),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(331),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(333),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(335),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(337),
    [sym__indent] = ACTIONS(339),
    [sym_string_start] = ACTIONS(83),
  },
  [131] = {
    [sym__simple_statements] = STATE(982),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2072),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_type] = STATE(2387),
    [sym_splat_type] = STATE(2380),
    [sym_generic_type] = STATE(2380),
    [sym_union_type] = STATE(2380),
    [sym_constrained_type] = STATE(2380),
    [sym_member_type] = STATE(2380),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(331),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(333),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(335),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(341),
    [sym__indent] = ACTIONS(343),
    [sym_string_start] = ACTIONS(83),
  },
  [132] = {
    [sym__simple_statements] = STATE(950),
    [sym_import_statement] = STATE(2662),
    [sym_future_import_statement] = STATE(2662),
    [sym_import_from_statement] = STATE(2662),
    [sym_print_statement] = STATE(2662),
    [sym_assert_statement] = STATE(2662),
    [sym_expression_statement] = STATE(2662),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2662),
    [sym_delete_statement] = STATE(2662),
    [sym_raise_statement] = STATE(2662),
    [sym_pass_statement] = STATE(2662),
    [sym_break_statement] = STATE(2662),
    [sym_continue_statement] = STATE(2662),
    [sym_global_statement] = STATE(2662),
    [sym_nonlocal_statement] = STATE(2662),
    [sym_exec_statement] = STATE(2662),
    [sym_type_alias_statement] = STATE(2662),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2072),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_type] = STATE(2387),
    [sym_splat_type] = STATE(2380),
    [sym_generic_type] = STATE(2380),
    [sym_union_type] = STATE(2380),
    [sym_constrained_type] = STATE(2380),
    [sym_member_type] = STATE(2380),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(331),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(333),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(335),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(345),
    [sym__indent] = ACTIONS(347),
    [sym_string_start] = ACTIONS(83),
  },
  [133] = {
    [sym__simple_statements] = STATE(889),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STATE(2019),
    [sym_list_splat_pattern] = STATE(1101),
    [sym_as_pattern] = STATE(2038),
    [sym_expression] = STATE(2072),
    [sym_primary_expression] = STATE(1295),
    [sym_not_operator] = STATE(2038),
    [sym_boolean_operator] = STATE(2038),
    [sym_binary_operator] = STATE(1388),
    [sym_unary_operator] = STATE(1388),
    [sym_comparison_operator] = STATE(2038),
    [sym_lambda] = STATE(2038),
    [sym_assignment] = STATE(2999),
    [sym_augmented_assignment] = STATE(2999),
    [sym_pattern_list] = STATE(2036),
    [sym_yield] = STATE(2999),
    [sym_attribute] = STATE(1107),
    [sym_subscript] = STATE(1109),
    [sym_call] = STATE(1416),
    [sym_type] = STATE(2387),
    [sym_splat_type] = STATE(2380),
    [sym_generic_type] = STATE(2380),
    [sym_union_type] = STATE(2380),
    [sym_constrained_type] = STATE(2380),
    [sym_member_type] = STATE(2380),
    [sym_list] = STATE(1388),
    [sym_set] = STATE(1388),
    [sym_tuple] = STATE(1388),
    [sym_dictionary] = STATE(1388),
    [sym_list_comprehension] = STATE(1388),
    [sym_dictionary_comprehension] = STATE(1388),
    [sym_set_comprehension] = STATE(1388),
    [sym_generator_expression] = STATE(1388),
    [sym_parenthesized_expression] = STATE(1388),
    [sym_conditional_expression] = STATE(2038),
    [sym_concatenated_string] = STATE(1388),
    [sym_string] = STATE(1271),
    [sym_await] = STATE(1388),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(331),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(333),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_STAR_STAR] = ACTIONS(335),
    [anon_sym_global] = ACTIONS(53),
    [anon_sym_nonlocal] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_var] = ACTIONS(73),
    [anon_sym_alias] = ACTIONS(73),
    [anon_sym_yield] = ACTIONS(75),
    [sym_ellipsis] = ACTIONS(77),
    [sym_integer] = ACTIONS(79),
    [sym_float] = ACTIONS(77),
    [anon_sym_await] = ACTIONS(81),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_none] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(349),
    [sym__indent] = ACTIONS(351),
    [sym_string_start] = ACTIONS(83),
  },
  [134] = {
    [sym__simple_statements] = STATE(896),
    [sym_import_statement] = STATE(2678),
    [sym_future_import_statement] = STATE(2678),
    [sym_import_from_statement] = STATE(2678),
    [sym_print_statement] = STATE(2678),
    [sym_assert_statement] = STATE(2678),
    [sym_expression_statement] = STATE(2678),
    [sym_named_expression] = STATE(2038),
    [sym__named_expression_lhs] = STATE(3297),
    [sym_return_statement] = STATE(2678),
    [sym_delete_statement] = STATE(2678),
    [sym_raise_statement] = STATE(2678),
    [sym_pass_statement] = STATE(2678),
    [sym_break_statement] = STATE(2678),
    [sym_continue_statement] = STATE(2678),
    [sym_global_statement] = STATE(2678),
    [sym_nonlocal_statement] = STATE(2678),
    [sym_exec_statement] = STATE(2678),
    [sym_type_alias_statement] = STATE(2678),
    [sym_pattern] = STATE(2035),
    [sym_tuple_pattern] = STATE(2019),
    [sym_list_pattern] = STAT