/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.SessionConfiguration;
import uk.ac.ed.ph.snuggletex.SnugglePackage;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.SnuggleSimpleMathRunner;
import uk.ac.ed.ph.snuggletex.XMLStringOutputOptions;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.CorePackageDefinitions;
import uk.ac.ed.ph.snuggletex.internal.util.ConstraintUtilities;
import uk.ac.ed.ph.snuggletex.utilities.DefaultTransformerFactoryChooser;
import uk.ac.ed.ph.snuggletex.utilities.SimpleStylesheetCache;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetCache;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetManager;
import uk.ac.ed.ph.snuggletex.utilities.TransformerFactoryChooser;

public final class SnuggleEngine {
    private final List<SnugglePackage> packages = Collections.synchronizedList(new ArrayList());
    private final StylesheetManager stylesheetManager;
    private SessionConfiguration defaultSessionConfiguration = new SessionConfiguration();
    private DOMOutputOptions defaultDOMOutputOptions = new DOMOutputOptions();
    private XMLStringOutputOptions defaultXMLStringOutputOptions = new XMLStringOutputOptions();

    public SnuggleEngine() {
        this(DefaultTransformerFactoryChooser.getInstance(), new SimpleStylesheetCache());
    }

    public SnuggleEngine(StylesheetCache stylesheetCache) {
        this(DefaultTransformerFactoryChooser.getInstance(), stylesheetCache);
    }

    public SnuggleEngine(TransformerFactoryChooser transformerFactoryChooser, StylesheetCache stylesheetCache) {
        this(new StylesheetManager(transformerFactoryChooser, stylesheetCache));
    }

    public SnuggleEngine(StylesheetManager stylesheetManager) {
        this.stylesheetManager = stylesheetManager;
        this.packages.add(CorePackageDefinitions.getPackage());
    }

    public StylesheetManager getStylesheetManager() {
        return this.stylesheetManager;
    }

    public List<SnugglePackage> getPackages() {
        return this.packages;
    }

    public void addPackage(SnugglePackage snugglePackage) {
        ConstraintUtilities.ensureNotNull(snugglePackage, "snugglePackage");
        this.packages.add(snugglePackage);
    }

    public SnuggleSession createSession() {
        return this.createSession(this.defaultSessionConfiguration);
    }

    public SnuggleSession createSession(SessionConfiguration sessionConfiguration) {
        ConstraintUtilities.ensureNotNull(sessionConfiguration, "sessionConfiguration");
        return new SnuggleSession(this, sessionConfiguration);
    }

    public SnuggleSimpleMathRunner createSimpleMathRunner() {
        return new SnuggleSimpleMathRunner(this.createSession());
    }

    public SnuggleSimpleMathRunner createSimpleMathRunner(SessionConfiguration sessionConfiguration) {
        return new SnuggleSimpleMathRunner(this.createSession(sessionConfiguration));
    }

    public BuiltinCommand getBuiltinCommandByTeXName(String texName) {
        SnugglePackage snugglePackage;
        ConstraintUtilities.ensureNotNull(texName, "texName");
        BuiltinCommand result = null;
        Iterator<SnugglePackage> iterator = this.packages.iterator();
        while (iterator.hasNext() && (result = (snugglePackage = iterator.next()).getBuiltinCommandByTeXName(texName)) == null) {
        }
        return result;
    }

    public BuiltinEnvironment getBuiltinEnvironmentByTeXName(String texName) {
        SnugglePackage snugglePackage;
        ConstraintUtilities.ensureNotNull(texName, "texName");
        BuiltinEnvironment result = null;
        Iterator<SnugglePackage> iterator = this.packages.iterator();
        while (iterator.hasNext() && (result = (snugglePackage = iterator.next()).getBuiltinEnvironmentByTeXName(texName)) == null) {
        }
        return result;
    }

    public SessionConfiguration getDefaultSessionConfiguration() {
        return this.defaultSessionConfiguration;
    }

    public void setDefaultSessionConfiguration(SessionConfiguration defaultSessionConfiguration) {
        ConstraintUtilities.ensureNotNull(defaultSessionConfiguration, "defaultSessionConfiguration");
        this.defaultSessionConfiguration = defaultSessionConfiguration;
    }

    public DOMOutputOptions getDefaultDOMOutputOptions() {
        return this.defaultDOMOutputOptions;
    }

    public void setDefaultDOMOutputOptions(DOMOutputOptions defaultDOMOutputOptions) {
        ConstraintUtilities.ensureNotNull(defaultDOMOutputOptions, "defaultDOMOutputOptions");
        this.defaultDOMOutputOptions = defaultDOMOutputOptions;
    }

    public XMLStringOutputOptions getDefaultXMLStringOutputOptions() {
        return this.defaultXMLStringOutputOptions;
    }

    public void setDefaultXMLStringOutputOptions(XMLStringOutputOptions defaultXMLOutputOptions) {
        ConstraintUtilities.ensureNotNull(defaultXMLOutputOptions, "defaultXMLOutputOptions");
        this.defaultXMLStringOutputOptions = defaultXMLOutputOptions;
    }

    @Deprecated
    public DOMOutputOptions getDefaultDOMOptions() {
        return this.defaultDOMOutputOptions;
    }

    @Deprecated
    public void setDefaultDOMOptions(DOMOutputOptions defaultDOMOptions) {
        ConstraintUtilities.ensureNotNull(defaultDOMOptions, "defaultDOMOptions");
        this.defaultDOMOutputOptions = defaultDOMOptions;
    }
}

