/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.treeview.link;

import com.dlsc.gemsfx.treeview.TreeNode;
import com.dlsc.gemsfx.treeview.TreeNodeView;
import com.dlsc.gemsfx.treeview.link.LinkStrategy;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.QuadCurve;

public abstract class AbstractLinkStrategy<T>
implements LinkStrategy<T> {
    protected double startX;
    protected double startY;
    protected double endX;
    protected double endY;

    protected void calculateEndPoints(TreeNodeView.LayoutDirection direction, Point2D parentPoint, double parentW, double parentH, Point2D childPoint, double childW, double childH, double nodeLineGap) {
        if (direction == TreeNodeView.LayoutDirection.BOTTOM_TO_TOP) {
            this.startX = parentPoint.getX() + parentW / 2.0;
            this.startY = parentPoint.getY() - nodeLineGap;
            this.endX = childPoint.getX() + childW / 2.0;
            this.endY = childPoint.getY() + childH + nodeLineGap;
        } else if (direction == TreeNodeView.LayoutDirection.TOP_TO_BOTTOM) {
            this.startX = parentPoint.getX() + parentW / 2.0;
            this.startY = parentPoint.getY() + parentH + nodeLineGap;
            this.endX = childPoint.getX() + childW / 2.0;
            this.endY = childPoint.getY() - nodeLineGap;
        } else if (direction == TreeNodeView.LayoutDirection.LEFT_TO_RIGHT) {
            this.startX = parentPoint.getX() + parentW + nodeLineGap;
            this.startY = parentPoint.getY() + parentH / 2.0;
            this.endX = childPoint.getX() - nodeLineGap;
            this.endY = childPoint.getY() + childH / 2.0;
        } else if (direction == TreeNodeView.LayoutDirection.RIGHT_TO_LEFT) {
            this.startX = parentPoint.getX() - nodeLineGap;
            this.startY = parentPoint.getY() + parentH / 2.0;
            this.endX = childPoint.getX() + childW + nodeLineGap;
            this.endY = childPoint.getY() + childH / 2.0;
        }
    }

    @Override
    public ArrayList<Node> drawNodeLink(TreeNodeView.LayoutDirection direction, double maxDimensionInLine, TreeNode<T> parent, Point2D parentPoint, double parentW, double parentH, TreeNode<T> child, Point2D childPoint, double childW, double childH, double nodeLineGap, double vgap, double hgap) {
        this.calculateEndPoints(direction, parentPoint, parentW, parentH, childPoint, childW, childH, nodeLineGap);
        return this.drawLink(direction, maxDimensionInLine, this.startX, this.startY, this.endX, this.endY, vgap, hgap);
    }

    protected abstract ArrayList<Node> drawLink(TreeNodeView.LayoutDirection var1, double var2, double var4, double var6, double var8, double var10, double var12, double var14);

    protected Node createSimpleArrow() {
        Region arrow = new Region();
        arrow.getStyleClass().add((Object)"link-arrow");
        arrow.setPrefSize(8.0, 8.0);
        arrow.setMaxSize(8.0, 8.0);
        arrow.layoutXProperty().bind((ObservableValue)arrow.widthProperty().divide(-2).add(this.endX));
        arrow.layoutYProperty().bind((ObservableValue)arrow.heightProperty().divide(-2).add(this.endY));
        return arrow;
    }

    protected double calculateAngle() {
        return this.calculateAngle(this.startX, this.startY, this.endX, this.endY);
    }

    protected double calculateAngle(double p1X, double p1Y, double p2X, double p2Y) {
        double dx = p2X - p1X;
        double dy = p2Y - p1Y;
        return Math.toDegrees(Math.atan2(dy, dx));
    }

    protected double calculateAngle(Point2D p1, Point2D p2) {
        return this.calculateAngle(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    protected double calculateAngle(LineTo lineTo1, LineTo lineTo2) {
        return this.calculateAngle(lineTo1.getX(), lineTo1.getY(), lineTo2.getX(), lineTo2.getY());
    }

    protected double getTangentAngle(CubicCurve curve, double t) {
        double dx = this.bezierDerivative(curve.getStartX(), curve.getControlX1(), curve.getControlX2(), curve.getEndX(), t);
        double dy = this.bezierDerivative(curve.getStartY(), curve.getControlY1(), curve.getControlY2(), curve.getEndY(), t);
        return Math.toDegrees(Math.atan2(dy, dx));
    }

    protected double getTangentAngle(CubicCurveTo curveTo, double t) {
        double dx = this.bezierDerivative(this.startX, curveTo.getControlX1(), curveTo.getControlX2(), curveTo.getX(), t);
        double dy = this.bezierDerivative(this.startY, curveTo.getControlY1(), curveTo.getControlY2(), curveTo.getY(), t);
        return Math.toDegrees(Math.atan2(dy, dx));
    }

    private double bezierDerivative(double p0, double p1, double p2, double p3, double t) {
        return 3.0 * (1.0 - t) * (1.0 - t) * (p1 - p0) + 6.0 * (1.0 - t) * t * (p2 - p1) + 3.0 * t * t * (p3 - p2);
    }

    protected double getTangentAngle(QuadCurve curve, double t) {
        double dx = this.bezierDerivative(curve.getStartX(), curve.getControlX(), curve.getEndX(), t);
        double dy = this.bezierDerivative(curve.getStartY(), curve.getControlY(), curve.getEndY(), t);
        return Math.toDegrees(Math.atan2(dy, dx));
    }

    private double bezierDerivative(double p0, double p1, double p2, double t) {
        return 2.0 * (1.0 - t) * (p1 - p0) + 2.0 * t * (p2 - p1);
    }
}

