/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.csl.CSLNameBuilder;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonObject;
import java.util.Map;

public class CSLName
implements JsonObject {
    private final String family;
    private final String given;
    private final String droppingParticle;
    private final String nonDroppingParticle;
    private final String suffix;
    private final Boolean commaPrefix;
    private final Boolean commaSuffix;
    private final Boolean staticOrdering;
    private final Boolean staticParticles;
    private final String literal;
    private final Boolean parseNames;
    private final Boolean isInstitution;

    public CSLName() {
        this.family = null;
        this.given = null;
        this.droppingParticle = null;
        this.nonDroppingParticle = null;
        this.suffix = null;
        this.commaPrefix = null;
        this.commaSuffix = null;
        this.staticOrdering = null;
        this.staticParticles = null;
        this.literal = null;
        this.parseNames = null;
        this.isInstitution = null;
    }

    public CSLName(String family, String given, String droppingParticle, String nonDroppingParticle, String suffix, Boolean commaPrefix, Boolean commaSuffix, Boolean staticOrdering, Boolean staticParticles, String literal, Boolean parseNames, Boolean isInstitution) {
        this.family = family;
        this.given = given;
        this.droppingParticle = droppingParticle;
        this.nonDroppingParticle = nonDroppingParticle;
        this.suffix = suffix;
        this.commaPrefix = commaPrefix;
        this.commaSuffix = commaSuffix;
        this.staticOrdering = staticOrdering;
        this.staticParticles = staticParticles;
        this.literal = literal;
        this.parseNames = parseNames;
        this.isInstitution = isInstitution;
    }

    public String getFamily() {
        return this.family;
    }

    public String getGiven() {
        return this.given;
    }

    public String getDroppingParticle() {
        return this.droppingParticle;
    }

    public String getNonDroppingParticle() {
        return this.nonDroppingParticle;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Boolean getCommaPrefix() {
        return this.commaPrefix;
    }

    public Boolean getCommaSuffix() {
        return this.commaSuffix;
    }

    public Boolean getStaticOrdering() {
        return this.staticOrdering;
    }

    public Boolean getStaticParticles() {
        return this.staticParticles;
    }

    public String getLiteral() {
        return this.literal;
    }

    public Boolean getParseNames() {
        return this.parseNames;
    }

    public Boolean getIsInstitution() {
        return this.isInstitution;
    }

    @Override
    public Object toJson(JsonBuilder builder) {
        if (this.family != null) {
            builder.add("family", this.family);
        }
        if (this.given != null) {
            builder.add("given", this.given);
        }
        if (this.droppingParticle != null) {
            builder.add("dropping-particle", this.droppingParticle);
        }
        if (this.nonDroppingParticle != null) {
            builder.add("non-dropping-particle", this.nonDroppingParticle);
        }
        if (this.suffix != null) {
            builder.add("suffix", this.suffix);
        }
        if (this.commaPrefix != null) {
            builder.add("comma-prefix", this.commaPrefix);
        }
        if (this.commaSuffix != null) {
            builder.add("comma-suffix", this.commaSuffix);
        }
        if (this.staticOrdering != null) {
            builder.add("static-ordering", this.staticOrdering);
        }
        if (this.staticParticles != null) {
            builder.add("static-particles", this.staticParticles);
        }
        if (this.literal != null) {
            builder.add("literal", this.literal);
        }
        if (this.parseNames != null) {
            builder.add("parse-names", this.parseNames);
        }
        if (this.isInstitution != null) {
            builder.add("isInstitution", this.isInstitution);
        }
        return builder.build();
    }

    public static CSLName fromJson(Map<String, Object> obj) {
        Map vc;
        Object vcmain;
        CSLNameBuilder builder = new CSLNameBuilder();
        Object v = obj.get("family");
        if (v != null) {
            String family = v.toString();
            builder.family(family);
        }
        if ((v = obj.get("given")) != null) {
            String given = v.toString();
            builder.given(given);
        }
        if ((v = obj.get("dropping-particle")) != null) {
            String droppingParticle = v.toString();
            builder.droppingParticle(droppingParticle);
        }
        if ((v = obj.get("non-dropping-particle")) != null) {
            String nonDroppingParticle = v.toString();
            builder.nonDroppingParticle(nonDroppingParticle);
        }
        if ((v = obj.get("suffix")) != null) {
            String suffix = v.toString();
            builder.suffix(suffix);
        }
        if ((v = obj.get("comma-prefix")) != null) {
            Boolean commaPrefix = CSLName.toBool(v);
            builder.commaPrefix(commaPrefix);
        }
        if ((v = obj.get("comma-suffix")) != null) {
            Boolean commaSuffix = CSLName.toBool(v);
            builder.commaSuffix(commaSuffix);
        }
        if ((v = obj.get("static-ordering")) != null) {
            Boolean staticOrdering = CSLName.toBool(v);
            builder.staticOrdering(staticOrdering);
        }
        if ((v = obj.get("static-particles")) != null) {
            Boolean staticParticles = CSLName.toBool(v);
            builder.staticParticles(staticParticles);
        }
        if ((v = obj.get("literal")) != null) {
            String literal = v.toString();
            builder.literal(literal);
        }
        if ((v = obj.get("parse-names")) != null) {
            Boolean parseNames = CSLName.toBool(v);
            builder.parseNames(parseNames);
        }
        if ((v = obj.get("isInstitution")) != null) {
            Boolean isInstitution = CSLName.toBool(v);
            builder.isInstitution(isInstitution);
        }
        if ((v = obj.get("multi")) != null && v instanceof Map && (vcmain = (vc = (Map)v).get("main")) != null && vcmain instanceof String) {
            String mstr = (String)vcmain;
            if ((mstr = mstr.toLowerCase().substring(0, 2)).equals("hu") || mstr.equals("vi")) {
                builder.staticOrdering(true);
            }
        }
        return builder.build();
    }

    private static boolean isFalsy(Object o) {
        if (o == null) {
            return true;
        }
        if (Boolean.FALSE.equals(o)) {
            return true;
        }
        if ("".equals(o)) {
            return true;
        }
        if (Integer.valueOf(0).equals(o)) {
            return true;
        }
        if (Long.valueOf(0L).equals(o)) {
            return true;
        }
        if (o instanceof Float && (Float.valueOf(0.0f).equals(o) || ((Float)o).isNaN())) {
            return true;
        }
        if (o instanceof Double && (Double.valueOf(0.0).equals(o) || ((Double)o).isNaN())) {
            return true;
        }
        if (Byte.valueOf((byte)0).equals(o)) {
            return true;
        }
        return Short.valueOf((short)0).equals(o);
    }

    private static int toInt(Object o) {
        if (o instanceof CharSequence) {
            return Integer.parseInt(o.toString());
        }
        return ((Number)o).intValue();
    }

    private static boolean toBool(Object o) {
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        return (Boolean)o;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.family == null ? 0 : this.family.hashCode());
        result = 31 * result + (this.given == null ? 0 : this.given.hashCode());
        result = 31 * result + (this.droppingParticle == null ? 0 : this.droppingParticle.hashCode());
        result = 31 * result + (this.nonDroppingParticle == null ? 0 : this.nonDroppingParticle.hashCode());
        result = 31 * result + (this.suffix == null ? 0 : this.suffix.hashCode());
        result = 31 * result + (this.commaPrefix == null ? 0 : this.commaPrefix.hashCode());
        result = 31 * result + (this.commaSuffix == null ? 0 : this.commaSuffix.hashCode());
        result = 31 * result + (this.staticOrdering == null ? 0 : this.staticOrdering.hashCode());
        result = 31 * result + (this.staticParticles == null ? 0 : this.staticParticles.hashCode());
        result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
        result = 31 * result + (this.parseNames == null ? 0 : this.parseNames.hashCode());
        result = 31 * result + (this.isInstitution == null ? 0 : this.isInstitution.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CSLName)) {
            return false;
        }
        CSLName other = (CSLName)obj;
        if (this.family == null ? other.family != null : !this.family.equals(other.family)) {
            return false;
        }
        if (this.given == null ? other.given != null : !this.given.equals(other.given)) {
            return false;
        }
        if (this.droppingParticle == null ? other.droppingParticle != null : !this.droppingParticle.equals(other.droppingParticle)) {
            return false;
        }
        if (this.nonDroppingParticle == null ? other.nonDroppingParticle != null : !this.nonDroppingParticle.equals(other.nonDroppingParticle)) {
            return false;
        }
        if (this.suffix == null ? other.suffix != null : !this.suffix.equals(other.suffix)) {
            return false;
        }
        if (this.commaPrefix == null ? other.commaPrefix != null : !this.commaPrefix.equals(other.commaPrefix)) {
            return false;
        }
        if (this.commaSuffix == null ? other.commaSuffix != null : !this.commaSuffix.equals(other.commaSuffix)) {
            return false;
        }
        if (this.staticOrdering == null ? other.staticOrdering != null : !this.staticOrdering.equals(other.staticOrdering)) {
            return false;
        }
        if (this.staticParticles == null ? other.staticParticles != null : !this.staticParticles.equals(other.staticParticles)) {
            return false;
        }
        if (this.literal == null ? other.literal != null : !this.literal.equals(other.literal)) {
            return false;
        }
        if (this.parseNames == null ? other.parseNames != null : !this.parseNames.equals(other.parseNames)) {
            return false;
        }
        return !(this.isInstitution == null ? other.isInstitution != null : !this.isInstitution.equals(other.isInstitution));
    }
}

