/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.format;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SBibliography;
import de.undercouch.citeproc.csl.internal.TokenBuffer;
import de.undercouch.citeproc.csl.internal.format.BaseFormat;
import de.undercouch.citeproc.output.Bibliography;
import de.undercouch.citeproc.output.SecondFieldAlign;

public class AsciiDocFormat
extends BaseFormat {
    @Override
    public String getName() {
        return "asciidoc";
    }

    @Override
    protected String doFormatCitation(TokenBuffer buffer, RenderContext ctx) {
        return this.format(buffer);
    }

    @Override
    protected String doFormatBibliographyEntry(TokenBuffer buffer, RenderContext ctx, int index) {
        Object result;
        String pre = index > 0 ? "\n" : "";
        SecondFieldAlign sfa = ctx.getStyle().getBibliography().getSecondFieldAlign();
        if (sfa != SecondFieldAlign.FALSE && !buffer.getTokens().isEmpty()) {
            int i = 0;
            while (buffer.getTokens().get(i).isFirstField()) {
                ++i;
            }
            TokenBuffer firstBuffer = buffer.copy(0, i);
            TokenBuffer restBuffer = buffer.copy(i, buffer.getTokens().size());
            result = "[.csl-left-margin]##" + this.format(firstBuffer) + "##[.csl-right-inline]##" + this.format(restBuffer) + "##";
        } else {
            result = this.format(buffer);
        }
        return pre + "[.csl-entry]\n" + (String)result + "\n";
    }

    @Override
    protected String doFormatLink(String text, String uri) {
        return uri;
    }

    @Override
    public Bibliography makeBibliography(String[] entries, SBibliography bibliographyElement) {
        SecondFieldAlign sfa = bibliographyElement.getSecondFieldAlign();
        return new Bibliography(entries, null, null, null, null, null, null, null, null, sfa);
    }

    @Override
    protected String escape(String str) {
        return str.replace("*", "pass:[*]").replace("_", "pass:[_]").replace("#", "pass:[#]").replace("^", "pass:[^]").replace("~", "pass:[~]").replace("[[", "pass:[[[]").replace("  ", "&#160; ");
    }

    @Override
    protected String openFontStyle(int fontStyle) {
        return "__";
    }

    @Override
    protected String closeFontStyle(int fontStyle) {
        return "__";
    }

    @Override
    protected String openFontVariant(int fontVariant) {
        return "[.small-caps]#";
    }

    @Override
    protected String closeFontVariant(int fontVariant) {
        return "#";
    }

    @Override
    protected String openFontWeight(int fontWeight) {
        if (fontWeight == 2) {
            return "**";
        }
        return "";
    }

    @Override
    protected String closeFontWeight(int fontWeight) {
        if (fontWeight == 2) {
            return "**";
        }
        return "";
    }

    @Override
    protected String openTextDecoration(int textDecoration) {
        return "[.underline]#";
    }

    @Override
    protected String closeTextDecoration(int textDecoration) {
        return "#";
    }

    @Override
    protected String openVerticalAlign(int verticalAlign) {
        if (verticalAlign == 2) {
            return "^";
        }
        return "~";
    }

    @Override
    protected String closeVerticalAlign(int verticalAlign) {
        if (verticalAlign == 2) {
            return "^";
        }
        return "~";
    }
}

