/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper.json;

import java.io.IOException;
import java.io.Reader;

public class JsonLexer {
    private final Reader r;
    private int currentCharacter = -1;

    public JsonLexer(Reader r) {
        this.r = r;
    }

    public Type readNextToken() throws IOException {
        Type currentTokenType;
        int c;
        if (this.currentCharacter >= 0 && !Character.isWhitespace(this.currentCharacter)) {
            c = this.currentCharacter;
            this.currentCharacter = -1;
        } else {
            c = this.skipWhitespace();
        }
        if (c < 0) {
            return null;
        }
        if (c == 123) {
            currentTokenType = Type.START_OBJECT;
        } else if (c == 125) {
            currentTokenType = Type.END_OBJECT;
        } else if (c == 91) {
            currentTokenType = Type.START_ARRAY;
        } else if (c == 93) {
            currentTokenType = Type.END_ARRAY;
        } else if (c == 58) {
            currentTokenType = Type.COLON;
        } else if (c == 44) {
            currentTokenType = Type.COMMA;
        } else if (c == 34) {
            currentTokenType = Type.STRING;
        } else if (c == 45 || c >= 48 && c <= 57) {
            currentTokenType = Type.NUMBER;
            this.currentCharacter = c;
        } else if (c == 116) {
            int c2 = this.r.read();
            int c3 = this.r.read();
            int c4 = this.r.read();
            currentTokenType = c2 == 114 && c3 == 117 & c4 == 101 ? Type.TRUE : null;
        } else if (c == 102) {
            int c2 = this.r.read();
            int c3 = this.r.read();
            int c4 = this.r.read();
            int c5 = this.r.read();
            currentTokenType = c2 == 97 && c3 == 108 & c4 == 115 && c5 == 101 ? Type.FALSE : null;
        } else if (c == 110) {
            int c2 = this.r.read();
            int c3 = this.r.read();
            int c4 = this.r.read();
            currentTokenType = c2 == 117 && c3 == 108 & c4 == 108 ? Type.NULL : null;
        } else {
            currentTokenType = null;
        }
        if (currentTokenType == null) {
            throw new IllegalStateException("Unrecognized token: " + (char)c);
        }
        return currentTokenType;
    }

    private int skipWhitespace() throws IOException {
        int c;
        do {
            if ((c = this.r.read()) >= 0) continue;
            return -1;
        } while (Character.isWhitespace(c));
        return c;
    }

    public String readString() throws IOException {
        StringBuilder result = new StringBuilder();
        while (true) {
            int c;
            if ((c = this.r.read()) < 0) {
                throw new IllegalStateException("Premature end of stream");
            }
            if (c == 34) break;
            if (c == 92) {
                int c2 = this.r.read();
                if (c2 == 34 || c2 == 92 || c2 == 47) {
                    result.append((char)c2);
                    continue;
                }
                if (c2 == 98) {
                    result.append("\b");
                    continue;
                }
                if (c2 == 102) {
                    result.append("\f");
                    continue;
                }
                if (c2 == 110) {
                    result.append("\n");
                    continue;
                }
                if (c2 == 114) {
                    result.append("\r");
                    continue;
                }
                if (c2 == 116) {
                    result.append("\t");
                    continue;
                }
                if (c2 != 117) continue;
                int d1 = this.r.read();
                int d2 = this.r.read();
                int d3 = this.r.read();
                int d4 = this.r.read();
                JsonLexer.checkHexDigit(d1);
                JsonLexer.checkHexDigit(d2);
                JsonLexer.checkHexDigit(d3);
                JsonLexer.checkHexDigit(d4);
                int e = Character.digit(d1, 16);
                e = (e << 4) + Character.digit(d2, 16);
                e = (e << 4) + Character.digit(d3, 16);
                e = (e << 4) + Character.digit(d4, 16);
                result.append((char)e);
                continue;
            }
            result.append((char)c);
        }
        return result.toString();
    }

    private static void checkHexDigit(int c) {
        if (!(Character.isDigit(c) || c >= 97 && c <= 102 || c >= 65 && c <= 70)) {
            throw new IllegalStateException("Not a hexadecimal digit: " + c);
        }
    }

    public Number readNumber() throws IOException {
        if (this.currentCharacter < 0) {
            throw new IllegalStateException("Missed first digit");
        }
        boolean negative = false;
        if (this.currentCharacter == 45) {
            negative = true;
            this.currentCharacter = this.r.read();
        }
        long result = 0L;
        while (this.currentCharacter >= 0) {
            if (this.currentCharacter < 48 || this.currentCharacter > 57) {
                if (this.currentCharacter != 46) break;
                return this.readReal(result, negative);
            }
            result = result * 10L + (long)this.currentCharacter - 48L;
            this.currentCharacter = this.r.read();
        }
        return negative ? -result : result;
    }

    private Number readReal(long prev, boolean negative) throws IOException {
        StringBuilder b = new StringBuilder(prev + ".");
        boolean exponent = false;
        boolean expsign = false;
        do {
            this.currentCharacter = this.r.read();
            if (this.currentCharacter >= 48 && this.currentCharacter <= 57) {
                b.append((char)this.currentCharacter);
                continue;
            }
            if (this.currentCharacter == 101 || this.currentCharacter == 69) {
                if (exponent) break;
                b.append((char)this.currentCharacter);
                exponent = true;
                continue;
            }
            if (this.currentCharacter != 45 && this.currentCharacter != 43 || expsign) break;
            b.append((char)this.currentCharacter);
            expsign = true;
        } while (this.currentCharacter >= 0);
        double result = Double.parseDouble(b.toString());
        return negative ? -result : result;
    }

    public static enum Type {
        START_OBJECT,
        START_ARRAY,
        END_OBJECT,
        END_ARRAY,
        COLON,
        COMMA,
        STRING,
        NUMBER,
        TRUE,
        FALSE,
        NULL;

    }
}

