/*
 * Copyright (c) 2018, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 *
 */

/*
 * @test
 * @bug 8205422
 * @summary Test that the JVM does not assert when printing a stack map table
 *          containing a stack map with a bad verification type.
 * @compile badStackMapTable.jcod
 * @run main/othervm -Xverify:all StackMapTableTest
 */

public class StackMapTableTest {

    public static void main(String args[]) throws Throwable {
        System.out.println("Regression test for bug 8205422");
        try {
            Class newClass = Class.forName("badStackMapTable");
            throw new RuntimeException("Expected VerifyError exception not thrown");
        } catch (java.lang.VerifyError e) {
            if (!e.getMessage().contains("same_locals_1_stack_item_frame(@18,BAD:9)")) {
               throw new RuntimeException(
                   "Unexpected VerifyError message: " + e.getMessage());
            }
        }
    }
}
