//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `warn!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn warn() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::warn!(target: "my::module", ident = 3); // DEBUG:warn,t,-,-,-,"ident","3"
    tracing::warn!(target: "my::module", foo = true, ident = 3); // DEBUG:warn,t,-,p,-,"ident","3"
    tracing::warn!(target: "my::module", ident = 3, qux = 3); // DEBUG:warn,t,-,f,-,"ident","3"
    tracing::warn!(target: "my::module", foo = true, ident = 3, qux = 3); // DEBUG:warn,t,-,pf,-,"ident","3"
    tracing::warn!(target: "my::module", ident = 3, "msg without args"); // DEBUG:warn,t,-,-,m,"ident","3"
    tracing::warn!(target: "my::module", foo = true, ident = 3, "msg without args"); // DEBUG:warn,t,-,p,m,"ident","3"
    tracing::warn!(target: "my::module", ident = 3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"ident","3"
    tracing::warn!(target: "my::module", foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"ident","3"
    tracing::warn!(target: "my::module", { ident = 3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"ident","3"
    tracing::warn!(target: "my::module", { foo = true, ident = 3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"ident","3"
    tracing::warn!(target: "my::module", { ident = 3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"ident","3"
    tracing::warn!(target: "my::module", { foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"ident","3"
    tracing::warn!(target: "my::module", ident = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"ident","3"
    tracing::warn!(target: "my::module", foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"ident","3"
    tracing::warn!(target: "my::module", ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"ident","3"
    tracing::warn!(target: "my::module", foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"ident","3"
    tracing::warn!(target: "my::module", { ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"ident","3"
    tracing::warn!(target: "my::module", { foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"ident","3"
    tracing::warn!(target: "my::module", { ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"ident","3"
    tracing::warn!(target: "my::module", { foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"ident","3"
    tracing::warn!(target: "my::module", ident = false); // DEBUG:warn,t,-,-,-,"ident","false"
    tracing::warn!(target: "my::module", foo = true, ident = false); // DEBUG:warn,t,-,p,-,"ident","false"
    tracing::warn!(target: "my::module", ident = false, qux = 3); // DEBUG:warn,t,-,f,-,"ident","false"
    tracing::warn!(target: "my::module", foo = true, ident = false, qux = 3); // DEBUG:warn,t,-,pf,-,"ident","false"
    tracing::warn!(target: "my::module", ident = false, "msg without args"); // DEBUG:warn,t,-,-,m,"ident","false"
    tracing::warn!(target: "my::module", foo = true, ident = false, "msg without args"); // DEBUG:warn,t,-,p,m,"ident","false"
    tracing::warn!(target: "my::module", ident = false, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"ident","false"
    tracing::warn!(target: "my::module", foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"ident","false"
    tracing::warn!(target: "my::module", { ident = false }, "msg without args"); // DEBUG:warn,t,{},-,m,"ident","false"
    tracing::warn!(target: "my::module", { foo = true, ident = false }, "msg without args"); // DEBUG:warn,t,{},p,m,"ident","false"
    tracing::warn!(target: "my::module", { ident = false, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"ident","false"
    tracing::warn!(target: "my::module", { foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"ident","false"
    tracing::warn!(target: "my::module", ident = false, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"ident","false"
    tracing::warn!(target: "my::module", foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"ident","false"
    tracing::warn!(target: "my::module", ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"ident","false"
    tracing::warn!(target: "my::module", foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"ident","false"
    tracing::warn!(target: "my::module", { ident = false }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"ident","false"
    tracing::warn!(target: "my::module", { foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"ident","false"
    tracing::warn!(target: "my::module", { ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"ident","false"
    tracing::warn!(target: "my::module", { foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"ident","false"
    tracing::warn!(target: "my::module", ident = ?3); // DEBUG:warn,t,-,-,-,"ident","?3"
    tracing::warn!(target: "my::module", foo = true, ident = ?3); // DEBUG:warn,t,-,p,-,"ident","?3"
    tracing::warn!(target: "my::module", ident = ?3, qux = 3); // DEBUG:warn,t,-,f,-,"ident","?3"
    tracing::warn!(target: "my::module", foo = true, ident = ?3, qux = 3); // DEBUG:warn,t,-,pf,-,"ident","?3"
    tracing::warn!(target: "my::module", ident = ?3, "msg without args"); // DEBUG:warn,t,-,-,m,"ident","?3"
    tracing::warn!(target: "my::module", foo = true, ident = ?3, "msg without args"); // DEBUG:warn,t,-,p,m,"ident","?3"
    tracing::warn!(target: "my::module", ident = ?3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"ident","?3"
    tracing::warn!(target: "my::module", foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"ident","?3"
    tracing::warn!(target: "my::module", { ident = ?3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"ident","?3"
    tracing::warn!(target: "my::module", { foo = true, ident = ?3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"ident","?3"
    tracing::warn!(target: "my::module", { ident = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"ident","?3"
    tracing::warn!(target: "my::module", { foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"ident","?3"
    tracing::warn!(target: "my::module", ident = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"ident","?3"
    tracing::warn!(target: "my::module", foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"ident","?3"
    tracing::warn!(target: "my::module", ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"ident","?3"
    tracing::warn!(target: "my::module", foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"ident","?3"
    tracing::warn!(target: "my::module", { ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"ident","?3"
    tracing::warn!(target: "my::module", { foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"ident","?3"
    tracing::warn!(target: "my::module", { ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"ident","?3"
    tracing::warn!(target: "my::module", { foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"ident","?3"
    tracing::warn!(target: "my::module", ident = %3); // DEBUG:warn,t,-,-,-,"ident","%3"
    tracing::warn!(target: "my::module", foo = true, ident = %3); // DEBUG:warn,t,-,p,-,"ident","%3"
    tracing::warn!(target: "my::module", ident = %3, qux = 3); // DEBUG:warn,t,-,f,-,"ident","%3"
    tracing::warn!(target: "my::module", foo = true, ident = %3, qux = 3); // DEBUG:warn,t,-,pf,-,"ident","%3"
    tracing::warn!(target: "my::module", ident = %3, "msg without args"); // DEBUG:warn,t,-,-,m,"ident","%3"
    tracing::warn!(target: "my::module", foo = true, ident = %3, "msg without args"); // DEBUG:warn,t,-,p,m,"ident","%3"
    tracing::warn!(target: "my::module", ident = %3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"ident","%3"
    tracing::warn!(target: "my::module", foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"ident","%3"
    tracing::warn!(target: "my::module", { ident = %3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"ident","%3"
    tracing::warn!(target: "my::module", { foo = true, ident = %3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"ident","%3"
    tracing::warn!(target: "my::module", { ident = %3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"ident","%3"
    tracing::warn!(target: "my::module", { foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"ident","%3"
    tracing::warn!(target: "my::module", ident = %3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"ident","%3"
    tracing::warn!(target: "my::module", foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"ident","%3"
    tracing::warn!(target: "my::module", ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"ident","%3"
    tracing::warn!(target: "my::module", foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"ident","%3"
    tracing::warn!(target: "my::module", { ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"ident","%3"
    tracing::warn!(target: "my::module", { foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"ident","%3"
    tracing::warn!(target: "my::module", { ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"ident","%3"
    tracing::warn!(target: "my::module", { foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"ident","%3"
    tracing::warn!(target: "my::module", ident = ?deb); // DEBUG:warn,t,-,-,-,"ident","?deb"
    tracing::warn!(target: "my::module", foo = true, ident = ?deb); // DEBUG:warn,t,-,p,-,"ident","?deb"
    tracing::warn!(target: "my::module", ident = ?deb, qux = 3); // DEBUG:warn,t,-,f,-,"ident","?deb"
    tracing::warn!(target: "my::module", foo = true, ident = ?deb, qux = 3); // DEBUG:warn,t,-,pf,-,"ident","?deb"
    tracing::warn!(target: "my::module", ident = ?deb, "msg without args"); // DEBUG:warn,t,-,-,m,"ident","?deb"
    tracing::warn!(target: "my::module", foo = true, ident = ?deb, "msg without args"); // DEBUG:warn,t,-,p,m,"ident","?deb"
    tracing::warn!(target: "my::module", ident = ?deb, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"ident","?deb"
    tracing::warn!(target: "my::module", foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"ident","?deb"
    tracing::warn!(target: "my::module", { ident = ?deb }, "msg without args"); // DEBUG:warn,t,{},-,m,"ident","?deb"
    tracing::warn!(target: "my::module", { foo = true, ident = ?deb }, "msg without args"); // DEBUG:warn,t,{},p,m,"ident","?deb"
    tracing::warn!(target: "my::module", { ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"ident","?deb"
    tracing::warn!(target: "my::module", { foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"ident","?deb"
    tracing::warn!(target: "my::module", ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"ident","?deb"
    tracing::warn!(target: "my::module", foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"ident","?deb"
    tracing::warn!(target: "my::module", ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"ident","?deb"
    tracing::warn!(target: "my::module", foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"ident","?deb"
    tracing::warn!(target: "my::module", { ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"ident","?deb"
    tracing::warn!(target: "my::module", { foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"ident","?deb"
    tracing::warn!(target: "my::module", { ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"ident","?deb"
    tracing::warn!(target: "my::module", { foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"ident","?deb"
    tracing::warn!(target: "my::module", ident = %disp); // DEBUG:warn,t,-,-,-,"ident","%disp"
    tracing::warn!(target: "my::module", foo = true, ident = %disp); // DEBUG:warn,t,-,p,-,"ident","%disp"
    tracing::warn!(target: "my::module", ident = %disp, qux = 3); // DEBUG:warn,t,-,f,-,"ident","%disp"
    tracing::warn!(target: "my::module", foo = true, ident = %disp, qux = 3); // DEBUG:warn,t,-,pf,-,"ident","%disp"
    tracing::warn!(target: "my::module", ident = %disp, "msg without args"); // DEBUG:warn,t,-,-,m,"ident","%disp"
    tracing::warn!(target: "my::module", foo = true, ident = %disp, "msg without args"); // DEBUG:warn,t,-,p,m,"ident","%disp"
    tracing::warn!(target: "my::module", ident = %disp, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"ident","%disp"
    tracing::warn!(target: "my::module", foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"ident","%disp"
    tracing::warn!(target: "my::module", { ident = %disp }, "msg without args"); // DEBUG:warn,t,{},-,m,"ident","%disp"
    tracing::warn!(target: "my::module", { foo = true, ident = %disp }, "msg without args"); // DEBUG:warn,t,{},p,m,"ident","%disp"
    tracing::warn!(target: "my::module", { ident = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"ident","%disp"
    tracing::warn!(target: "my::module", { foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"ident","%disp"
    tracing::warn!(target: "my::module", ident = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"ident","%disp"
    tracing::warn!(target: "my::module", foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"ident","%disp"
    tracing::warn!(target: "my::module", ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"ident","%disp"
    tracing::warn!(target: "my::module", foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"ident","%disp"
    tracing::warn!(target: "my::module", { ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"ident","%disp"
    tracing::warn!(target: "my::module", { foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"ident","%disp"
    tracing::warn!(target: "my::module", { ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"ident","%disp"
    tracing::warn!(target: "my::module", { foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"ident","%disp"
    tracing::warn!(target: "my::module", ident = ?sub.field); // DEBUG:warn,t,-,-,-,"ident","?sub.field"
    tracing::warn!(target: "my::module", foo = true, ident = ?sub.field); // DEBUG:warn,t,-,p,-,"ident","?sub.field"
    tracing::warn!(target: "my::module", ident = ?sub.field, qux = 3); // DEBUG:warn,t,-,f,-,"ident","?sub.field"
    tracing::warn!(target: "my::module", foo = true, ident = ?sub.field, qux = 3); // DEBUG:warn,t,-,pf,-,"ident","?sub.field"
    tracing::warn!(target: "my::module", ident = ?sub.field, "msg without args"); // DEBUG:warn,t,-,-,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", foo = true, ident = ?sub.field, "msg without args"); // DEBUG:warn,t,-,p,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", { ident = ?sub.field }, "msg without args"); // DEBUG:warn,t,{},-,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:warn,t,{},p,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", { ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", { ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", { ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", ident = %sub.field); // DEBUG:warn,t,-,-,-,"ident","%sub.field"
    tracing::warn!(target: "my::module", foo = true, ident = %sub.field); // DEBUG:warn,t,-,p,-,"ident","%sub.field"
    tracing::warn!(target: "my::module", ident = %sub.field, qux = 3); // DEBUG:warn,t,-,f,-,"ident","%sub.field"
    tracing::warn!(target: "my::module", foo = true, ident = %sub.field, qux = 3); // DEBUG:warn,t,-,pf,-,"ident","%sub.field"
    tracing::warn!(target: "my::module", ident = %sub.field, "msg without args"); // DEBUG:warn,t,-,-,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", foo = true, ident = %sub.field, "msg without args"); // DEBUG:warn,t,-,p,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", ident = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", { ident = %sub.field }, "msg without args"); // DEBUG:warn,t,{},-,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, ident = %sub.field }, "msg without args"); // DEBUG:warn,t,{},p,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", { ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", { ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", { ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", ident = debug(&deb)); // DEBUG:warn,t,-,-,-,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, ident = debug(&deb)); // DEBUG:warn,t,-,p,-,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", ident = debug(&deb), qux = 3); // DEBUG:warn,t,-,f,-,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, ident = debug(&deb), qux = 3); // DEBUG:warn,t,-,pf,-,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", ident = debug(&deb), "msg without args"); // DEBUG:warn,t,-,-,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, ident = debug(&deb), "msg without args"); // DEBUG:warn,t,-,p,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", { ident = debug(&deb) }, "msg without args"); // DEBUG:warn,t,{},-,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:warn,t,{},p,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", { ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", { ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", { ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", ident = display(&disp)); // DEBUG:warn,t,-,-,-,"ident","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, ident = display(&disp)); // DEBUG:warn,t,-,p,-,"ident","display(&disp)"
    tracing::warn!(target: "my::module", ident = display(&disp), qux = 3); // DEBUG:warn,t,-,f,-,"ident","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, ident = display(&disp), qux = 3); // DEBUG:warn,t,-,pf,-,"ident","display(&disp)"
    tracing::warn!(target: "my::module", ident = display(&disp), "msg without args"); // DEBUG:warn,t,-,-,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, ident = display(&disp), "msg without args"); // DEBUG:warn,t,-,p,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", ident = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", { ident = display(&disp) }, "msg without args"); // DEBUG:warn,t,{},-,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:warn,t,{},p,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", { ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", { ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", { ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", ident = tracing::field::Empty); // DEBUG:warn,t,-,-,-,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, ident = tracing::field::Empty); // DEBUG:warn,t,-,p,-,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", ident = tracing::field::Empty, qux = 3); // DEBUG:warn,t,-,f,-,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:warn,t,-,pf,-,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", ident = tracing::field::Empty, "msg without args"); // DEBUG:warn,t,-,-,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:warn,t,-,p,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { ident = tracing::field::Empty }, "msg without args"); // DEBUG:warn,t,{},-,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:warn,t,{},p,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", dotted.ident = 3); // DEBUG:warn,t,-,-,-,"dotted.ident","3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = 3); // DEBUG:warn,t,-,p,-,"dotted.ident","3"
    tracing::warn!(target: "my::module", dotted.ident = 3, qux = 3); // DEBUG:warn,t,-,f,-,"dotted.ident","3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = 3, qux = 3); // DEBUG:warn,t,-,pf,-,"dotted.ident","3"
    tracing::warn!(target: "my::module", dotted.ident = 3, "msg without args"); // DEBUG:warn,t,-,-,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = 3, "msg without args"); // DEBUG:warn,t,-,p,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", { dotted.ident = 3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", { dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", { dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", { dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", dotted.ident = false); // DEBUG:warn,t,-,-,-,"dotted.ident","false"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = false); // DEBUG:warn,t,-,p,-,"dotted.ident","false"
    tracing::warn!(target: "my::module", dotted.ident = false, qux = 3); // DEBUG:warn,t,-,f,-,"dotted.ident","false"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = false, qux = 3); // DEBUG:warn,t,-,pf,-,"dotted.ident","false"
    tracing::warn!(target: "my::module", dotted.ident = false, "msg without args"); // DEBUG:warn,t,-,-,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = false, "msg without args"); // DEBUG:warn,t,-,p,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", dotted.ident = false, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", { dotted.ident = false }, "msg without args"); // DEBUG:warn,t,{},-,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = false }, "msg without args"); // DEBUG:warn,t,{},p,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", { dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", { dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", { dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", dotted.ident = ?3); // DEBUG:warn,t,-,-,-,"dotted.ident","?3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?3); // DEBUG:warn,t,-,p,-,"dotted.ident","?3"
    tracing::warn!(target: "my::module", dotted.ident = ?3, qux = 3); // DEBUG:warn,t,-,f,-,"dotted.ident","?3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?3, qux = 3); // DEBUG:warn,t,-,pf,-,"dotted.ident","?3"
    tracing::warn!(target: "my::module", dotted.ident = ?3, "msg without args"); // DEBUG:warn,t,-,-,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:warn,t,-,p,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", { dotted.ident = ?3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", { dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", { dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", { dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", dotted.ident = %3); // DEBUG:warn,t,-,-,-,"dotted.ident","%3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %3); // DEBUG:warn,t,-,p,-,"dotted.ident","%3"
    tracing::warn!(target: "my::module", dotted.ident = %3, qux = 3); // DEBUG:warn,t,-,f,-,"dotted.ident","%3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %3, qux = 3); // DEBUG:warn,t,-,pf,-,"dotted.ident","%3"
    tracing::warn!(target: "my::module", dotted.ident = %3, "msg without args"); // DEBUG:warn,t,-,-,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %3, "msg without args"); // DEBUG:warn,t,-,p,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", { dotted.ident = %3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", { dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", { dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", { dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", dotted.ident = ?deb); // DEBUG:warn,t,-,-,-,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?deb); // DEBUG:warn,t,-,p,-,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", dotted.ident = ?deb, qux = 3); // DEBUG:warn,t,-,f,-,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:warn,t,-,pf,-,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", dotted.ident = ?deb, "msg without args"); // DEBUG:warn,t,-,-,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:warn,t,-,p,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", { dotted.ident = ?deb }, "msg without args"); // DEBUG:warn,t,{},-,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:warn,t,{},p,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", { dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", { dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", { dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", dotted.ident = %disp); // DEBUG:warn,t,-,-,-,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %disp); // DEBUG:warn,t,-,p,-,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", dotted.ident = %disp, qux = 3); // DEBUG:warn,t,-,f,-,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %disp, qux = 3); // DEBUG:warn,t,-,pf,-,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", dotted.ident = %disp, "msg without args"); // DEBUG:warn,t,-,-,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:warn,t,-,p,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", { dotted.ident = %disp }, "msg without args"); // DEBUG:warn,t,{},-,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:warn,t,{},p,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", { dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", { dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", { dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", dotted.ident = ?sub.field); // DEBUG:warn,t,-,-,-,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?sub.field); // DEBUG:warn,t,-,p,-,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", dotted.ident = ?sub.field, qux = 3); // DEBUG:warn,t,-,f,-,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:warn,t,-,pf,-,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", dotted.ident = ?sub.field, "msg without args"); // DEBUG:warn,t,-,-,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:warn,t,-,p,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", { dotted.ident = ?sub.field }, "msg without args"); // DEBUG:warn,t,{},-,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:warn,t,{},p,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", { dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", { dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", { dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", dotted.ident = %sub.field); // DEBUG:warn,t,-,-,-,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %sub.field); // DEBUG:warn,t,-,p,-,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", dotted.ident = %sub.field, qux = 3); // DEBUG:warn,t,-,f,-,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:warn,t,-,pf,-,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", dotted.ident = %sub.field, "msg without args"); // DEBUG:warn,t,-,-,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:warn,t,-,p,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", { dotted.ident = %sub.field }, "msg without args"); // DEBUG:warn,t,{},-,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:warn,t,{},p,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", { dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", { dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", { dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", dotted.ident = debug(&deb)); // DEBUG:warn,t,-,-,-,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = debug(&deb)); // DEBUG:warn,t,-,p,-,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", dotted.ident = debug(&deb), qux = 3); // DEBUG:warn,t,-,f,-,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:warn,t,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", dotted.ident = debug(&deb), "msg without args"); // DEBUG:warn,t,-,-,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:warn,t,-,p,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", { dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:warn,t,{},-,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:warn,t,{},p,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", { dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", { dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", { dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", dotted.ident = display(&disp)); // DEBUG:warn,t,-,-,-,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = display(&disp)); // DEBUG:warn,t,-,p,-,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", dotted.ident = display(&disp), qux = 3); // DEBUG:warn,t,-,f,-,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:warn,t,-,pf,-,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", dotted.ident = display(&disp), "msg without args"); // DEBUG:warn,t,-,-,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:warn,t,-,p,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", { dotted.ident = display(&disp) }, "msg without args"); // DEBUG:warn,t,{},-,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:warn,t,{},p,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", { dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", { dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", { dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", dotted.ident = tracing::field::Empty); // DEBUG:warn,t,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = tracing::field::Empty); // DEBUG:warn,t,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:warn,t,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:warn,t,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:warn,t,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:warn,t,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:warn,t,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:warn,t,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", "literal" = 3); // DEBUG:warn,t,-,-,-,"\"literal\"","3"
    tracing::warn!(target: "my::module", foo = true, "literal" = 3); // DEBUG:warn,t,-,p,-,"\"literal\"","3"
    tracing::warn!(target: "my::module", "literal" = 3, qux = 3); // DEBUG:warn,t,-,f,-,"\"literal\"","3"
    tracing::warn!(target: "my::module", foo = true, "literal" = 3, qux = 3); // DEBUG:warn,t,-,pf,-,"\"literal\"","3"
    tracing::warn!(target: "my::module", "literal" = 3, "msg without args"); // DEBUG:warn,t,-,-,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", foo = true, "literal" = 3, "msg without args"); // DEBUG:warn,t,-,p,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", "literal" = 3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", { "literal" = 3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", { foo = true, "literal" = 3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", { "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", { foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", { "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", { foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", { "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", { foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", "literal" = false); // DEBUG:warn,t,-,-,-,"\"literal\"","false"
    tracing::warn!(target: "my::module", foo = true, "literal" = false); // DEBUG:warn,t,-,p,-,"\"literal\"","false"
    tracing::warn!(target: "my::module", "literal" = false, qux = 3); // DEBUG:warn,t,-,f,-,"\"literal\"","false"
    tracing::warn!(target: "my::module", foo = true, "literal" = false, qux = 3); // DEBUG:warn,t,-,pf,-,"\"literal\"","false"
    tracing::warn!(target: "my::module", "literal" = false, "msg without args"); // DEBUG:warn,t,-,-,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", foo = true, "literal" = false, "msg without args"); // DEBUG:warn,t,-,p,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", "literal" = false, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", { "literal" = false }, "msg without args"); // DEBUG:warn,t,{},-,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", { foo = true, "literal" = false }, "msg without args"); // DEBUG:warn,t,{},p,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", { "literal" = false, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", { foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", "literal" = false, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", { "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", { foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", { "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", { foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", "literal" = ?3); // DEBUG:warn,t,-,-,-,"\"literal\"","?3"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?3); // DEBUG:warn,t,-,p,-,"\"literal\"","?3"
    tracing::warn!(target: "my::module", "literal" = ?3, qux = 3); // DEBUG:warn,t,-,f,-,"\"literal\"","?3"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?3, qux = 3); // DEBUG:warn,t,-,pf,-,"\"literal\"","?3"
    tracing::warn!(target: "my::module", "literal" = ?3, "msg without args"); // DEBUG:warn,t,-,-,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?3, "msg without args"); // DEBUG:warn,t,-,p,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", "literal" = ?3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", { "literal" = ?3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", { foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", { "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", { foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", { "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", { foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", { "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", { foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", "literal" = %3); // DEBUG:warn,t,-,-,-,"\"literal\"","%3"
    tracing::warn!(target: "my::module", foo = true, "literal" = %3); // DEBUG:warn,t,-,p,-,"\"literal\"","%3"
    tracing::warn!(target: "my::module", "literal" = %3, qux = 3); // DEBUG:warn,t,-,f,-,"\"literal\"","%3"
    tracing::warn!(target: "my::module", foo = true, "literal" = %3, qux = 3); // DEBUG:warn,t,-,pf,-,"\"literal\"","%3"
    tracing::warn!(target: "my::module", "literal" = %3, "msg without args"); // DEBUG:warn,t,-,-,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", foo = true, "literal" = %3, "msg without args"); // DEBUG:warn,t,-,p,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", "literal" = %3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", { "literal" = %3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", { foo = true, "literal" = %3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", { "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", { foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", { "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", { foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", { "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", { foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", "literal" = ?deb); // DEBUG:warn,t,-,-,-,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?deb); // DEBUG:warn,t,-,p,-,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", "literal" = ?deb, qux = 3); // DEBUG:warn,t,-,f,-,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?deb, qux = 3); // DEBUG:warn,t,-,pf,-,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", "literal" = ?deb, "msg without args"); // DEBUG:warn,t,-,-,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?deb, "msg without args"); // DEBUG:warn,t,-,p,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", { "literal" = ?deb }, "msg without args"); // DEBUG:warn,t,{},-,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", { foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:warn,t,{},p,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", { "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", { foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", { "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", { foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", { "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", { foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", "literal" = %disp); // DEBUG:warn,t,-,-,-,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", foo = true, "literal" = %disp); // DEBUG:warn,t,-,p,-,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", "literal" = %disp, qux = 3); // DEBUG:warn,t,-,f,-,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", foo = true, "literal" = %disp, qux = 3); // DEBUG:warn,t,-,pf,-,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", "literal" = %disp, "msg without args"); // DEBUG:warn,t,-,-,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", foo = true, "literal" = %disp, "msg without args"); // DEBUG:warn,t,-,p,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", "literal" = %disp, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", { "literal" = %disp }, "msg without args"); // DEBUG:warn,t,{},-,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", { foo = true, "literal" = %disp }, "msg without args"); // DEBUG:warn,t,{},p,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", { "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", { foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", { "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", { foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", { "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", { foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", "literal" = ?sub.field); // DEBUG:warn,t,-,-,-,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?sub.field); // DEBUG:warn,t,-,p,-,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", "literal" = ?sub.field, qux = 3); // DEBUG:warn,t,-,f,-,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:warn,t,-,pf,-,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", "literal" = ?sub.field, "msg without args"); // DEBUG:warn,t,-,-,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:warn,t,-,p,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", { "literal" = ?sub.field }, "msg without args"); // DEBUG:warn,t,{},-,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:warn,t,{},p,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", { "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", { "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", { "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", "literal" = %sub.field); // DEBUG:warn,t,-,-,-,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", foo = true, "literal" = %sub.field); // DEBUG:warn,t,-,p,-,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", "literal" = %sub.field, qux = 3); // DEBUG:warn,t,-,f,-,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", foo = true, "literal" = %sub.field, qux = 3); // DEBUG:warn,t,-,pf,-,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", "literal" = %sub.field, "msg without args"); // DEBUG:warn,t,-,-,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:warn,t,-,p,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", { "literal" = %sub.field }, "msg without args"); // DEBUG:warn,t,{},-,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:warn,t,{},p,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", { "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", { "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", { "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", "literal" = debug(&deb)); // DEBUG:warn,t,-,-,-,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, "literal" = debug(&deb)); // DEBUG:warn,t,-,p,-,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", "literal" = debug(&deb), qux = 3); // DEBUG:warn,t,-,f,-,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:warn,t,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", "literal" = debug(&deb), "msg without args"); // DEBUG:warn,t,-,-,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:warn,t,-,p,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", { "literal" = debug(&deb) }, "msg without args"); // DEBUG:warn,t,{},-,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:warn,t,{},p,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", { "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", { "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", { "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", "literal" = display(&disp)); // DEBUG:warn,t,-,-,-,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, "literal" = display(&disp)); // DEBUG:warn,t,-,p,-,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", "literal" = display(&disp), qux = 3); // DEBUG:warn,t,-,f,-,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, "literal" = display(&disp), qux = 3); // DEBUG:warn,t,-,pf,-,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", "literal" = display(&disp), "msg without args"); // DEBUG:warn,t,-,-,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:warn,t,-,p,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", { "literal" = display(&disp) }, "msg without args"); // DEBUG:warn,t,{},-,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:warn,t,{},p,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", { "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", { "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", { "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", "literal" = tracing::field::Empty); // DEBUG:warn,t,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, "literal" = tracing::field::Empty); // DEBUG:warn,t,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", "literal" = tracing::field::Empty, qux = 3); // DEBUG:warn,t,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:warn,t,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", "literal" = tracing::field::Empty, "msg without args"); // DEBUG:warn,t,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:warn,t,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", { "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:warn,t,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:warn,t,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", { "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", { "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", { "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", { CONST_VAR } = 3); // DEBUG:warn,t,-,-,-,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = 3); // DEBUG:warn,t,-,p,-,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", { CONST_VAR } = 3, qux = 3); // DEBUG:warn,t,-,f,-,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:warn,t,-,pf,-,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", { CONST_VAR } = 3, "msg without args"); // DEBUG:warn,t,-,-,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:warn,t,-,p,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", { { CONST_VAR } = 3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", { { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", { { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", { { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", { CONST_VAR } = false); // DEBUG:warn,t,-,-,-,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = false); // DEBUG:warn,t,-,p,-,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", { CONST_VAR } = false, qux = 3); // DEBUG:warn,t,-,f,-,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:warn,t,-,pf,-,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", { CONST_VAR } = false, "msg without args"); // DEBUG:warn,t,-,-,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:warn,t,-,p,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", { { CONST_VAR } = false }, "msg without args"); // DEBUG:warn,t,{},-,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:warn,t,{},p,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", { { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", { { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", { { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?3); // DEBUG:warn,t,-,-,-,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?3); // DEBUG:warn,t,-,p,-,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?3, qux = 3); // DEBUG:warn,t,-,f,-,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:warn,t,-,pf,-,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?3, "msg without args"); // DEBUG:warn,t,-,-,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:warn,t,-,p,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", { { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", { { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", { { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", { { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", { CONST_VAR } = %3); // DEBUG:warn,t,-,-,-,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %3); // DEBUG:warn,t,-,p,-,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", { CONST_VAR } = %3, qux = 3); // DEBUG:warn,t,-,f,-,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:warn,t,-,pf,-,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", { CONST_VAR } = %3, "msg without args"); // DEBUG:warn,t,-,-,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:warn,t,-,p,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", { { CONST_VAR } = %3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", { { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", { { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", { { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?deb); // DEBUG:warn,t,-,-,-,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?deb); // DEBUG:warn,t,-,p,-,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?deb, qux = 3); // DEBUG:warn,t,-,f,-,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:warn,t,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?deb, "msg without args"); // DEBUG:warn,t,-,-,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:warn,t,-,p,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", { { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:warn,t,{},-,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:warn,t,{},p,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", { { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", { { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", { { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", { CONST_VAR } = %disp); // DEBUG:warn,t,-,-,-,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %disp); // DEBUG:warn,t,-,p,-,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", { CONST_VAR } = %disp, qux = 3); // DEBUG:warn,t,-,f,-,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:warn,t,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", { CONST_VAR } = %disp, "msg without args"); // DEBUG:warn,t,-,-,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:warn,t,-,p,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", { { CONST_VAR } = %disp }, "msg without args"); // DEBUG:warn,t,{},-,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:warn,t,{},p,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", { { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", { { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", { { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?sub.field); // DEBUG:warn,t,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?sub.field); // DEBUG:warn,t,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:warn,t,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:warn,t,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:warn,t,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:warn,t,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", { { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:warn,t,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:warn,t,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", { { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", { { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", { { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", { CONST_VAR } = %sub.field); // DEBUG:warn,t,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %sub.field); // DEBUG:warn,t,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", { CONST_VAR } = %sub.field, qux = 3); // DEBUG:warn,t,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:warn,t,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:warn,t,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:warn,t,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", { { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:warn,t,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:warn,t,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", { { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", { { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", { { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", { CONST_VAR } = debug(&deb)); // DEBUG:warn,t,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:warn,t,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:warn,t,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:warn,t,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:warn,t,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:warn,t,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", { { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:warn,t,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:warn,t,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", { { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", { { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", { { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", { CONST_VAR } = display(&disp)); // DEBUG:warn,t,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = display(&disp)); // DEBUG:warn,t,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", { CONST_VAR } = display(&disp), qux = 3); // DEBUG:warn,t,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:warn,t,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:warn,t,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:warn,t,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", { { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:warn,t,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:warn,t,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", { { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", { { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", { { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", { CONST_VAR } = tracing::field::Empty); // DEBUG:warn,t,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:warn,t,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:warn,t,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:warn,t,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:warn,t,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:warn,t,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", { { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:warn,t,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:warn,t,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", { { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", r#type = 3); // DEBUG:warn,t,-,-,-,"r#type","3"
    tracing::warn!(target: "my::module", foo = true, r#type = 3); // DEBUG:warn,t,-,p,-,"r#type","3"
    tracing::warn!(target: "my::module", r#type = 3, qux = 3); // DEBUG:warn,t,-,f,-,"r#type","3"
    tracing::warn!(target: "my::module", foo = true, r#type = 3, qux = 3); // DEBUG:warn,t,-,pf,-,"r#type","3"
    tracing::warn!(target: "my::module", r#type = 3, "msg without args"); // DEBUG:warn,t,-,-,m,"r#type","3"
    tracing::warn!(target: "my::module", foo = true, r#type = 3, "msg without args"); // DEBUG:warn,t,-,p,m,"r#type","3"
    tracing::warn!(target: "my::module", r#type = 3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"r#type","3"
    tracing::warn!(target: "my::module", foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"r#type","3"
    tracing::warn!(target: "my::module", { r#type = 3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"r#type","3"
    tracing::warn!(target: "my::module", { foo = true, r#type = 3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"r#type","3"
    tracing::warn!(target: "my::module", { r#type = 3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"r#type","3"
    tracing::warn!(target: "my::module", { foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"r#type","3"
    tracing::warn!(target: "my::module", r#type = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"r#type","3"
    tracing::warn!(target: "my::module", foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"r#type","3"
    tracing::warn!(target: "my::module", r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"r#type","3"
    tracing::warn!(target: "my::module", foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"r#type","3"
    tracing::warn!(target: "my::module", { r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"r#type","3"
    tracing::warn!(target: "my::module", { foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"r#type","3"
    tracing::warn!(target: "my::module", { r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"r#type","3"
    tracing::warn!(target: "my::module", { foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"r#type","3"
    tracing::warn!(target: "my::module", r#type = false); // DEBUG:warn,t,-,-,-,"r#type","false"
    tracing::warn!(target: "my::module", foo = true, r#type = false); // DEBUG:warn,t,-,p,-,"r#type","false"
    tracing::warn!(target: "my::module", r#type = false, qux = 3); // DEBUG:warn,t,-,f,-,"r#type","false"
    tracing::warn!(target: "my::module", foo = true, r#type = false, qux = 3); // DEBUG:warn,t,-,pf,-,"r#type","false"
    tracing::warn!(target: "my::module", r#type = false, "msg without args"); // DEBUG:warn,t,-,-,m,"r#type","false"
    tracing::warn!(target: "my::module", foo = true, r#type = false, "msg without args"); // DEBUG:warn,t,-,p,m,"r#type","false"
    tracing::warn!(target: "my::module", r#type = false, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"r#type","false"
    tracing::warn!(target: "my::module", foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"r#type","false"
    tracing::warn!(target: "my::module", { r#type = false }, "msg without args"); // DEBUG:warn,t,{},-,m,"r#type","false"
    tracing::warn!(target: "my::module", { foo = true, r#type = false }, "msg without args"); // DEBUG:warn,t,{},p,m,"r#type","false"
    tracing::warn!(target: "my::module", { r#type = false, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"r#type","false"
    tracing::warn!(target: "my::module", { foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"r#type","false"
    tracing::warn!(target: "my::module", r#type = false, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"r#type","false"
    tracing::warn!(target: "my::module", foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"r#type","false"
    tracing::warn!(target: "my::module", r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"r#type","false"
    tracing::warn!(target: "my::module", foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"r#type","false"
    tracing::warn!(target: "my::module", { r#type = false }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"r#type","false"
    tracing::warn!(target: "my::module", { foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"r#type","false"
    tracing::warn!(target: "my::module", { r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"r#type","false"
    tracing::warn!(target: "my::module", { foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"r#type","false"
    tracing::warn!(target: "my::module", r#type = ?3); // DEBUG:warn,t,-,-,-,"r#type","?3"
    tracing::warn!(target: "my::module", foo = true, r#type = ?3); // DEBUG:warn,t,-,p,-,"r#type","?3"
    tracing::warn!(target: "my::module", r#type = ?3, qux = 3); // DEBUG:warn,t,-,f,-,"r#type","?3"
    tracing::warn!(target: "my::module", foo = true, r#type = ?3, qux = 3); // DEBUG:warn,t,-,pf,-,"r#type","?3"
    tracing::warn!(target: "my::module", r#type = ?3, "msg without args"); // DEBUG:warn,t,-,-,m,"r#type","?3"
    tracing::warn!(target: "my::module", foo = true, r#type = ?3, "msg without args"); // DEBUG:warn,t,-,p,m,"r#type","?3"
    tracing::warn!(target: "my::module", r#type = ?3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"r#type","?3"
    tracing::warn!(target: "my::module", foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"r#type","?3"
    tracing::warn!(target: "my::module", { r#type = ?3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"r#type","?3"
    tracing::warn!(target: "my::module", { foo = true, r#type = ?3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"r#type","?3"
    tracing::warn!(target: "my::module", { r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"r#type","?3"
    tracing::warn!(target: "my::module", { foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"r#type","?3"
    tracing::warn!(target: "my::module", r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"r#type","?3"
    tracing::warn!(target: "my::module", foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"r#type","?3"
    tracing::warn!(target: "my::module", r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"r#type","?3"
    tracing::warn!(target: "my::module", foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"r#type","?3"
    tracing::warn!(target: "my::module", { r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"r#type","?3"
    tracing::warn!(target: "my::module", { foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"r#type","?3"
    tracing::warn!(target: "my::module", { r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"r#type","?3"
    tracing::warn!(target: "my::module", { foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"r#type","?3"
    tracing::warn!(target: "my::module", r#type = %3); // DEBUG:warn,t,-,-,-,"r#type","%3"
    tracing::warn!(target: "my::module", foo = true, r#type = %3); // DEBUG:warn,t,-,p,-,"r#type","%3"
    tracing::warn!(target: "my::module", r#type = %3, qux = 3); // DEBUG:warn,t,-,f,-,"r#type","%3"
    tracing::warn!(target: "my::module", foo = true, r#type = %3, qux = 3); // DEBUG:warn,t,-,pf,-,"r#type","%3"
    tracing::warn!(target: "my::module", r#type = %3, "msg without args"); // DEBUG:warn,t,-,-,m,"r#type","%3"
    tracing::warn!(target: "my::module", foo = true, r#type = %3, "msg without args"); // DEBUG:warn,t,-,p,m,"r#type","%3"
    tracing::warn!(target: "my::module", r#type = %3, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"r#type","%3"
    tracing::warn!(target: "my::module", foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"r#type","%3"
    tracing::warn!(target: "my::module", { r#type = %3 }, "msg without args"); // DEBUG:warn,t,{},-,m,"r#type","%3"
    tracing::warn!(target: "my::module", { foo = true, r#type = %3 }, "msg without args"); // DEBUG:warn,t,{},p,m,"r#type","%3"
    tracing::warn!(target: "my::module", { r#type = %3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"r#type","%3"
    tracing::warn!(target: "my::module", { foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"r#type","%3"
    tracing::warn!(target: "my::module", r#type = %3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"r#type","%3"
    tracing::warn!(target: "my::module", foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"r#type","%3"
    tracing::warn!(target: "my::module", r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"r#type","%3"
    tracing::warn!(target: "my::module", foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"r#type","%3"
    tracing::warn!(target: "my::module", { r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"r#type","%3"
    tracing::warn!(target: "my::module", { foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"r#type","%3"
    tracing::warn!(target: "my::module", { r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"r#type","%3"
    tracing::warn!(target: "my::module", { foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"r#type","%3"
    tracing::warn!(target: "my::module", r#type = ?deb); // DEBUG:warn,t,-,-,-,"r#type","?deb"
    tracing::warn!(target: "my::module", foo = true, r#type = ?deb); // DEBUG:warn,t,-,p,-,"r#type","?deb"
    tracing::warn!(target: "my::module", r#type = ?deb, qux = 3); // DEBUG:warn,t,-,f,-,"r#type","?deb"
    tracing::warn!(target: "my::module", foo = true, r#type = ?deb, qux = 3); // DEBUG:warn,t,-,pf,-,"r#type","?deb"
    tracing::warn!(target: "my::module", r#type = ?deb, "msg without args"); // DEBUG:warn,t,-,-,m,"r#type","?deb"
    tracing::warn!(target: "my::module", foo = true, r#type = ?deb, "msg without args"); // DEBUG:warn,t,-,p,m,"r#type","?deb"
    tracing::warn!(target: "my::module", r#type = ?deb, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"r#type","?deb"
    tracing::warn!(target: "my::module", foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"r#type","?deb"
    tracing::warn!(target: "my::module", { r#type = ?deb }, "msg without args"); // DEBUG:warn,t,{},-,m,"r#type","?deb"
    tracing::warn!(target: "my::module", { foo = true, r#type = ?deb }, "msg without args"); // DEBUG:warn,t,{},p,m,"r#type","?deb"
    tracing::warn!(target: "my::module", { r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"r#type","?deb"
    tracing::warn!(target: "my::module", { foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"r#type","?deb"
    tracing::warn!(target: "my::module", r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", { r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", { foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", { r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", { foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", r#type = %disp); // DEBUG:warn,t,-,-,-,"r#type","%disp"
    tracing::warn!(target: "my::module", foo = true, r#type = %disp); // DEBUG:warn,t,-,p,-,"r#type","%disp"
    tracing::warn!(target: "my::module", r#type = %disp, qux = 3); // DEBUG:warn,t,-,f,-,"r#type","%disp"
    tracing::warn!(target: "my::module", foo = true, r#type = %disp, qux = 3); // DEBUG:warn,t,-,pf,-,"r#type","%disp"
    tracing::warn!(target: "my::module", r#type = %disp, "msg without args"); // DEBUG:warn,t,-,-,m,"r#type","%disp"
    tracing::warn!(target: "my::module", foo = true, r#type = %disp, "msg without args"); // DEBUG:warn,t,-,p,m,"r#type","%disp"
    tracing::warn!(target: "my::module", r#type = %disp, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"r#type","%disp"
    tracing::warn!(target: "my::module", foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"r#type","%disp"
    tracing::warn!(target: "my::module", { r#type = %disp }, "msg without args"); // DEBUG:warn,t,{},-,m,"r#type","%disp"
    tracing::warn!(target: "my::module", { foo = true, r#type = %disp }, "msg without args"); // DEBUG:warn,t,{},p,m,"r#type","%disp"
    tracing::warn!(target: "my::module", { r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"r#type","%disp"
    tracing::warn!(target: "my::module", { foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"r#type","%disp"
    tracing::warn!(target: "my::module", r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", { r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", { foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", { r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", { foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", r#type = ?sub.field); // DEBUG:warn,t,-,-,-,"r#type","?sub.field"
    tracing::warn!(target: "my::module", foo = true, r#type = ?sub.field); // DEBUG:warn,t,-,p,-,"r#type","?sub.field"
    tracing::warn!(target: "my::module", r#type = ?sub.field, qux = 3); // DEBUG:warn,t,-,f,-,"r#type","?sub.field"
    tracing::warn!(target: "my::module", foo = true, r#type = ?sub.field, qux = 3); // DEBUG:warn,t,-,pf,-,"r#type","?sub.field"
    tracing::warn!(target: "my::module", r#type = ?sub.field, "msg without args"); // DEBUG:warn,t,-,-,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:warn,t,-,p,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", { r#type = ?sub.field }, "msg without args"); // DEBUG:warn,t,{},-,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:warn,t,{},p,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", { r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", { r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", { r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", { foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", r#type = %sub.field); // DEBUG:warn,t,-,-,-,"r#type","%sub.field"
    tracing::warn!(target: "my::module", foo = true, r#type = %sub.field); // DEBUG:warn,t,-,p,-,"r#type","%sub.field"
    tracing::warn!(target: "my::module", r#type = %sub.field, qux = 3); // DEBUG:warn,t,-,f,-,"r#type","%sub.field"
    tracing::warn!(target: "my::module", foo = true, r#type = %sub.field, qux = 3); // DEBUG:warn,t,-,pf,-,"r#type","%sub.field"
    tracing::warn!(target: "my::module", r#type = %sub.field, "msg without args"); // DEBUG:warn,t,-,-,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", foo = true, r#type = %sub.field, "msg without args"); // DEBUG:warn,t,-,p,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", { r#type = %sub.field }, "msg without args"); // DEBUG:warn,t,{},-,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:warn,t,{},p,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", { r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", { r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", { r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", { foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", r#type = debug(&deb)); // DEBUG:warn,t,-,-,-,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, r#type = debug(&deb)); // DEBUG:warn,t,-,p,-,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", r#type = debug(&deb), qux = 3); // DEBUG:warn,t,-,f,-,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, r#type = debug(&deb), qux = 3); // DEBUG:warn,t,-,pf,-,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", r#type = debug(&deb), "msg without args"); // DEBUG:warn,t,-,-,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:warn,t,-,p,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", { r#type = debug(&deb) }, "msg without args"); // DEBUG:warn,t,{},-,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:warn,t,{},p,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", { r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", { r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", { r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", { foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", r#type = display(&disp)); // DEBUG:warn,t,-,-,-,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, r#type = display(&disp)); // DEBUG:warn,t,-,p,-,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", r#type = display(&disp), qux = 3); // DEBUG:warn,t,-,f,-,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, r#type = display(&disp), qux = 3); // DEBUG:warn,t,-,pf,-,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", r#type = display(&disp), "msg without args"); // DEBUG:warn,t,-,-,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, r#type = display(&disp), "msg without args"); // DEBUG:warn,t,-,p,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", { r#type = display(&disp) }, "msg without args"); // DEBUG:warn,t,{},-,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:warn,t,{},p,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", { r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", { r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", { r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", { foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", r#type = tracing::field::Empty); // DEBUG:warn,t,-,-,-,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, r#type = tracing::field::Empty); // DEBUG:warn,t,-,p,-,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", r#type = tracing::field::Empty, qux = 3); // DEBUG:warn,t,-,f,-,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:warn,t,-,pf,-,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", r#type = tracing::field::Empty, "msg without args"); // DEBUG:warn,t,-,-,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:warn,t,-,p,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", { r#type = tracing::field::Empty }, "msg without args"); // DEBUG:warn,t,{},-,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:warn,t,{},p,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", { r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", { r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", { r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", var); // DEBUG:warn,t,-,-,-,-,"var"
    tracing::warn!(target: "my::module", foo = true, var); // DEBUG:warn,t,-,p,-,-,"var"
    tracing::warn!(target: "my::module", var, qux = 3); // DEBUG:warn,t,-,f,-,-,"var"
    tracing::warn!(target: "my::module", foo = true, var, qux = 3); // DEBUG:warn,t,-,pf,-,-,"var"
    tracing::warn!(target: "my::module", var, "msg without args"); // DEBUG:warn,t,-,-,m,-,"var"
    tracing::warn!(target: "my::module", foo = true, var, "msg without args"); // DEBUG:warn,t,-,p,m,-,"var"
    tracing::warn!(target: "my::module", var, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,-,"var"
    tracing::warn!(target: "my::module", foo = true, var, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,-,"var"
    tracing::warn!(target: "my::module", { var }, "msg without args"); // DEBUG:warn,t,{},-,m,-,"var"
    tracing::warn!(target: "my::module", { foo = true, var }, "msg without args"); // DEBUG:warn,t,{},p,m,-,"var"
    tracing::warn!(target: "my::module", { var, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,-,"var"
    tracing::warn!(target: "my::module", { foo = true, var, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,-,"var"
    tracing::warn!(target: "my::module", var, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,-,"var"
    tracing::warn!(target: "my::module", foo = true, var, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,-,"var"
    tracing::warn!(target: "my::module", var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,-,"var"
    tracing::warn!(target: "my::module", foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,-,"var"
    tracing::warn!(target: "my::module", { var }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,-,"var"
    tracing::warn!(target: "my::module", { foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,-,"var"
    tracing::warn!(target: "my::module", { var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,-,"var"
    tracing::warn!(target: "my::module", { foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,-,"var"
    tracing::warn!(target: "my::module", sub.field); // DEBUG:warn,t,-,-,-,-,"sub.field"
    tracing::warn!(target: "my::module", foo = true, sub.field); // DEBUG:warn,t,-,p,-,-,"sub.field"
    tracing::warn!(target: "my::module", sub.field, qux = 3); // DEBUG:warn,t,-,f,-,-,"sub.field"
    tracing::warn!(target: "my::module", foo = true, sub.field, qux = 3); // DEBUG:warn,t,-,pf,-,-,"sub.field"
    tracing::warn!(target: "my::module", sub.field, "msg without args"); // DEBUG:warn,t,-,-,m,-,"sub.field"
    tracing::warn!(target: "my::module", foo = true, sub.field, "msg without args"); // DEBUG:warn,t,-,p,m,-,"sub.field"
    tracing::warn!(target: "my::module", sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,-,"sub.field"
    tracing::warn!(target: "my::module", foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,-,"sub.field"
    tracing::warn!(target: "my::module", { sub.field }, "msg without args"); // DEBUG:warn,t,{},-,m,-,"sub.field"
    tracing::warn!(target: "my::module", { foo = true, sub.field }, "msg without args"); // DEBUG:warn,t,{},p,m,-,"sub.field"
    tracing::warn!(target: "my::module", { sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,-,"sub.field"
    tracing::warn!(target: "my::module", { foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,-,"sub.field"
    tracing::warn!(target: "my::module", sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,-,"sub.field"
    tracing::warn!(target: "my::module", foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,-,"sub.field"
    tracing::warn!(target: "my::module", sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,-,"sub.field"
    tracing::warn!(target: "my::module", foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,-,"sub.field"
    tracing::warn!(target: "my::module", { sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,-,"sub.field"
    tracing::warn!(target: "my::module", { foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,-,"sub.field"
    tracing::warn!(target: "my::module", { sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,-,"sub.field"
    tracing::warn!(target: "my::module", { foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,-,"sub.field"
    tracing::warn!(target: "my::module", %disp); // DEBUG:warn,t,-,-,-,-,"%disp"
    tracing::warn!(target: "my::module", foo = true, %disp); // DEBUG:warn,t,-,p,-,-,"%disp"
    tracing::warn!(target: "my::module", %disp, qux = 3); // DEBUG:warn,t,-,f,-,-,"%disp"
    tracing::warn!(target: "my::module", foo = true, %disp, qux = 3); // DEBUG:warn,t,-,pf,-,-,"%disp"
    tracing::warn!(target: "my::module", %disp, "msg without args"); // DEBUG:warn,t,-,-,m,-,"%disp"
    tracing::warn!(target: "my::module", foo = true, %disp, "msg without args"); // DEBUG:warn,t,-,p,m,-,"%disp"
    tracing::warn!(target: "my::module", %disp, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,-,"%disp"
    tracing::warn!(target: "my::module", foo = true, %disp, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,-,"%disp"
    tracing::warn!(target: "my::module", { %disp }, "msg without args"); // DEBUG:warn,t,{},-,m,-,"%disp"
    tracing::warn!(target: "my::module", { foo = true, %disp }, "msg without args"); // DEBUG:warn,t,{},p,m,-,"%disp"
    tracing::warn!(target: "my::module", { %disp, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,-,"%disp"
    tracing::warn!(target: "my::module", { foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,-,"%disp"
    tracing::warn!(target: "my::module", %disp, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,-,"%disp"
    tracing::warn!(target: "my::module", foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,-,"%disp"
    tracing::warn!(target: "my::module", %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,-,"%disp"
    tracing::warn!(target: "my::module", foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,-,"%disp"
    tracing::warn!(target: "my::module", { %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,-,"%disp"
    tracing::warn!(target: "my::module", { foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,-,"%disp"
    tracing::warn!(target: "my::module", { %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,-,"%disp"
    tracing::warn!(target: "my::module", { foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,-,"%disp"
    tracing::warn!(target: "my::module", ?deb); // DEBUG:warn,t,-,-,-,-,"?deb"
    tracing::warn!(target: "my::module", foo = true, ?deb); // DEBUG:warn,t,-,p,-,-,"?deb"
    tracing::warn!(target: "my::module", ?deb, qux = 3); // DEBUG:warn,t,-,f,-,-,"?deb"
    tracing::warn!(target: "my::module", foo = true, ?deb, qux = 3); // DEBUG:warn,t,-,pf,-,-,"?deb"
    tracing::warn!(target: "my::module", ?deb, "msg without args"); // DEBUG:warn,t,-,-,m,-,"?deb"
    tracing::warn!(target: "my::module", foo = true, ?deb, "msg without args"); // DEBUG:warn,t,-,p,m,-,"?deb"
    tracing::warn!(target: "my::module", ?deb, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,-,"?deb"
    tracing::warn!(target: "my::module", foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,-,"?deb"
    tracing::warn!(target: "my::module", { ?deb }, "msg without args"); // DEBUG:warn,t,{},-,m,-,"?deb"
    tracing::warn!(target: "my::module", { foo = true, ?deb }, "msg without args"); // DEBUG:warn,t,{},p,m,-,"?deb"
    tracing::warn!(target: "my::module", { ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,-,"?deb"
    tracing::warn!(target: "my::module", { foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,-,"?deb"
    tracing::warn!(target: "my::module", ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,-,"?deb"
    tracing::warn!(target: "my::module", foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,-,"?deb"
    tracing::warn!(target: "my::module", ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,-,"?deb"
    tracing::warn!(target: "my::module", foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,-,"?deb"
    tracing::warn!(target: "my::module", { ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,-,"?deb"
    tracing::warn!(target: "my::module", { foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,-,"?deb"
    tracing::warn!(target: "my::module", { ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,-,"?deb"
    tracing::warn!(target: "my::module", { foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,-,"?deb"
    tracing::warn!(target: "my::module", %sub.field); // DEBUG:warn,t,-,-,-,-,"%sub.field"
    tracing::warn!(target: "my::module", foo = true, %sub.field); // DEBUG:warn,t,-,p,-,-,"%sub.field"
    tracing::warn!(target: "my::module", %sub.field, qux = 3); // DEBUG:warn,t,-,f,-,-,"%sub.field"
    tracing::warn!(target: "my::module", foo = true, %sub.field, qux = 3); // DEBUG:warn,t,-,pf,-,-,"%sub.field"
    tracing::warn!(target: "my::module", %sub.field, "msg without args"); // DEBUG:warn,t,-,-,m,-,"%sub.field"
    tracing::warn!(target: "my::module", foo = true, %sub.field, "msg without args"); // DEBUG:warn,t,-,p,m,-,"%sub.field"
    tracing::warn!(target: "my::module", %sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,-,"%sub.field"
    tracing::warn!(target: "my::module", foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,-,"%sub.field"
    tracing::warn!(target: "my::module", { %sub.field }, "msg without args"); // DEBUG:warn,t,{},-,m,-,"%sub.field"
    tracing::warn!(target: "my::module", { foo = true, %sub.field }, "msg without args"); // DEBUG:warn,t,{},p,m,-,"%sub.field"
    tracing::warn!(target: "my::module", { %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,-,"%sub.field"
    tracing::warn!(target: "my::module", { foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,-,"%sub.field"
    tracing::warn!(target: "my::module", %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", { %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", { foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", { %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", { foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", ?sub.field); // DEBUG:warn,t,-,-,-,-,"?sub.field"
    tracing::warn!(target: "my::module", foo = true, ?sub.field); // DEBUG:warn,t,-,p,-,-,"?sub.field"
    tracing::warn!(target: "my::module", ?sub.field, qux = 3); // DEBUG:warn,t,-,f,-,-,"?sub.field"
    tracing::warn!(target: "my::module", foo = true, ?sub.field, qux = 3); // DEBUG:warn,t,-,pf,-,-,"?sub.field"
    tracing::warn!(target: "my::module", ?sub.field, "msg without args"); // DEBUG:warn,t,-,-,m,-,"?sub.field"
    tracing::warn!(target: "my::module", foo = true, ?sub.field, "msg without args"); // DEBUG:warn,t,-,p,m,-,"?sub.field"
    tracing::warn!(target: "my::module", ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,f,m,-,"?sub.field"
    tracing::warn!(target: "my::module", foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,t,-,pf,m,-,"?sub.field"
    tracing::warn!(target: "my::module", { ?sub.field }, "msg without args"); // DEBUG:warn,t,{},-,m,-,"?sub.field"
    tracing::warn!(target: "my::module", { foo = true, ?sub.field }, "msg without args"); // DEBUG:warn,t,{},p,m,-,"?sub.field"
    tracing::warn!(target: "my::module", { ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},f,m,-,"?sub.field"
    tracing::warn!(target: "my::module", { foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,t,{},pf,m,-,"?sub.field"
    tracing::warn!(target: "my::module", ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,-,ma,-,"?sub.field"
    tracing::warn!(target: "my::module", foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,p,ma,-,"?sub.field"
    tracing::warn!(target: "my::module", ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,f,ma,-,"?sub.field"
    tracing::warn!(target: "my::module", foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,t,-,pf,ma,-,"?sub.field"
    tracing::warn!(target: "my::module", { ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},-,ma,-,"?sub.field"
    tracing::warn!(target: "my::module", { foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},p,ma,-,"?sub.field"
    tracing::warn!(target: "my::module", { ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},f,ma,-,"?sub.field"
    tracing::warn!(target: "my::module", { foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,t,{},pf,ma,-,"?sub.field"
}
