;;; make-digit.el --- Generate weight information for characters known as digits

;; Copyright (C) 2021 Free Software Foundation, (C) 2010 Ben Wing

;; Keywords: multilingual, digit, Unicode

;; This file is part of XEmacs.

;; XEmacs is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.

;; XEmacs is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Commentary:

;; Generate mule/digit.el. To do this, parse the UnicodeData.txt file. This
;; only needs to be done when UnicodeData.txt is updated.

;; Based on make-case-conv.el, which was in turn based on Ben's
;; make-case-conv.py, now removed from our sources.

(require 'descr-text)

(let* ((output-filename "digit.el")
       (output-buffer (get-buffer-create output-filename))
       case-fold-search fixnum)
  (format-into output-buffer
               ";;; mule/%s --- Weight information for characters known \
to be digits.
;;
;; Copyright (C) 2015, 2021 Free Software Foundation

;; Author: Aidan Kehoe

;; This file is part of XEmacs.

;; XEmacs is free software: you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by the
;; Free Software Foundation, either version 3 of the License, or (at your
;; option) any later version.

;; XEmacs is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; DO NOT MODIFY THIS FILE!!!!!!!!!!!!!!!!
;; This file is autogenerated by %s.  Modify that file instead.

" output-filename (subseq (file-name-nondirectory load-file-name) 0
                          (if (eql (aref load-file-name
                                         (1- (length load-file-name)))
                                   ?c)
                              -1)))

  ;; This is a separate call just for the sake of indentation, so we don't
  ;; have a ?( in the first column.
  (write-sequence "(loop for (character . fixnum)
  ;; Those characters from UnicodeData.txt that are of category \"decimal
  ;; digit\":
  in '(" output-buffer)
  (labels ((tounichar (value)
             (format (if (<= value #xFFFF) #r"?\u%04X" #r"?\U%08X") value)))
    (with-temp-buffer
      (insert-file-contents describe-char-unicodedata-file nil)
      (goto-char (point-min))
      (while (re-search-forward #r"
\([0-9A-F]+\);[^;]+;Nd;\([^;]*;\)\{9,9\}\([^;]*\);\([^;]*\);" nil t)
	(setq fixnum (parse-integer (match-string 1) :radix 16))
	(format-into output-buffer "(%s . %s) ;; %s\n       "
		     (tounichar fixnum)
		     (cadr (assoc "Decimal digit value"
				  (describe-char-unicode-data fixnum)))
		     (cadr (assoc "Name" (describe-char-unicode-data fixnum)))))
      (write-string "\n       ;; Latin ASCII characters. To do; consider \
separating the Unicode
       ;; decimal digits into their own table, and having another table with
       ;; ASCII equivalents, checking that within digit-char-p. This does not
       ;; support the fullwidth Latin characters currently, and supporting a
       ;; radix above 36 with Greek, Hebrew, Cyrillic etc. would be
       ;; reasonable.\n       " output-buffer)
      (loop for upper from ?A to ?Z
	    do (format-into output-buffer "(%s . %s) ;; %s\n       "
			    (tounichar upper) (+ 10 (- upper ?A))
			    (cadr (assoc "Name"
					 (describe-char-unicode-data upper)))))
      (loop for lower from ?a to ?z
	    do (progn (format-into output-buffer "(%s . %s)"
				   (tounichar lower) (+ 10 (- lower ?a)))
		      (if (eql lower (char-int ?z))
			  (format-into output-buffer ") ;; %s\n  "
				       (cadr (assoc "Name"
						    (describe-char-unicode-data
						     lower))))
			(format-into output-buffer " ;; %s\n       "
				     (cadr (assoc "Name"
						  (describe-char-unicode-data
						   lower)))))))
				     
      (format-into output-buffer
		   "with char-table = (copy-char-table digit-fixnum-map)
  do (put-char-table character fixnum char-table)
  finally (set-digit-fixnum-map char-table))

;; end of mule/%s\n" output-filename))))

;; make-digit.el ends here
