# Copyright 2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

CRATES="
	aho-corasick@1.1.4
	allocator-api2@0.2.21
	anstream@0.6.21
	anstyle-parse@0.2.7
	anstyle-query@1.1.5
	anstyle-wincon@3.0.11
	anstyle@1.0.13
	anyhow@1.0.100
	assert_cmd@2.1.1
	atomic@0.6.1
	autocfg@1.5.0
	base64@0.22.1
	bit-set@0.5.3
	bit-vec@0.6.3
	bitflags@1.3.2
	bitflags@2.10.0
	block-buffer@0.10.4
	block2@0.6.2
	bstr@1.12.1
	bumpalo@3.19.1
	bytemuck@1.24.0
	byteorder@1.5.0
	castaway@0.2.4
	cfg-if@1.0.4
	cfg_aliases@0.1.1
	cfg_aliases@0.2.1
	clap@4.5.53
	clap_builder@4.5.53
	clap_complete@4.5.62
	clap_complete_fig@4.5.2
	clap_complete_nushell@4.5.10
	clap_derive@4.5.49
	clap_lex@0.7.6
	clap_mangen@0.2.31
	colorchoice@1.0.4
	compact_str@0.9.0
	concat-string@1.0.1
	convert_case@0.10.0
	core-foundation-sys@0.8.7
	core-foundation@0.10.1
	cpufeatures@0.2.17
	crossterm@0.29.0
	crossterm_winapi@0.9.1
	crypto-common@0.1.7
	csscolorparser@0.6.2
	ctrlc@3.5.1
	darling@0.20.11
	darling_core@0.20.11
	darling_macro@0.20.11
	deltae@0.3.2
	deranged@0.5.5
	derive_more-impl@2.1.1
	derive_more@2.1.1
	difflib@0.4.0
	digest@0.10.7
	dirs-sys@0.5.0
	dirs@6.0.0
	dispatch2@0.3.0
	document-features@0.2.12
	downcast-rs@1.2.1
	dyn-clone@1.0.20
	either@1.15.0
	enum-as-inner@0.6.1
	equivalent@1.0.2
	errno@0.3.14
	euclid@0.22.11
	fancy-regex@0.11.0
	fastrand@2.3.0
	fern@0.7.1
	filedescriptor@0.8.3
	finl_unicode@1.4.0
	fixedbitset@0.4.2
	float-cmp@0.10.0
	fnv@1.0.7
	foldhash@0.2.0
	generic-array@0.14.7
	getrandom@0.2.16
	getrandom@0.3.4
	hashbrown@0.16.1
	heck@0.5.0
	hex@0.4.3
	humantime@2.3.0
	ident_case@1.0.1
	indexmap@2.12.1
	indoc@2.0.7
	instability@0.3.10
	is_terminal_polyfill@1.70.2
	itertools@0.13.0
	itertools@0.14.0
	itoa@1.0.17
	js-sys@0.3.83
	kasuari@0.4.11
	lab@0.11.0
	lazy_static@1.5.0
	lazycell@1.3.0
	libc@0.2.178
	libloading@0.8.9
	libredox@0.1.12
	line-clipping@0.3.5
	linux-raw-sys@0.11.0
	litrs@1.0.0
	lock_api@0.4.14
	log@0.4.29
	lru@0.16.2
	mac_address@1.1.8
	mach2@0.5.0
	mach2@0.6.0
	memchr@2.7.6
	memmem@0.1.1
	memoffset@0.9.1
	minimal-lexical@0.2.1
	mio@1.1.1
	nix@0.28.0
	nix@0.29.0
	nix@0.30.1
	nohash@0.2.0
	nom@7.1.3
	normalize-line-endings@0.3.0
	ntapi@0.4.2
	num-conv@0.1.0
	num-derive@0.4.2
	num-traits@0.2.19
	num_threads@0.1.7
	nvml-wrapper-sys@0.9.0
	nvml-wrapper@0.11.0
	objc2-core-foundation@0.3.2
	objc2-encode@4.1.0
	objc2-io-kit@0.3.2
	objc2@0.6.3
	once_cell@1.21.3
	once_cell_polyfill@1.70.2
	option-ext@0.2.0
	ordered-float@4.6.0
	parking_lot@0.12.5
	parking_lot_core@0.9.12
	pest@2.8.4
	pest_derive@2.8.4
	pest_generator@2.8.4
	pest_meta@2.8.4
	phf@0.11.3
	phf_codegen@0.11.3
	phf_generator@0.11.3
	phf_macros@0.11.3
	phf_shared@0.11.3
	plist@1.8.0
	portable-atomic@1.13.0
	portable-pty@0.9.0
	powerfmt@0.2.0
	predicates-core@1.0.9
	predicates-tree@1.0.12
	predicates@3.1.3
	proc-macro2@1.0.104
	quick-xml@0.38.4
	quote@1.0.42
	r-efi@5.3.0
	rand@0.8.5
	rand_core@0.6.4
	ratatui-core@0.1.0
	ratatui-crossterm@0.1.0
	ratatui-macros@0.7.0
	ratatui-termwiz@0.1.0
	ratatui-widgets@0.3.0
	ratatui@0.30.0
	redox_syscall@0.5.18
	redox_users@0.5.2
	ref-cast-impl@1.0.25
	ref-cast@1.0.25
	regex-automata@0.4.13
	regex-syntax@0.8.8
	regex@1.12.2
	roff@0.2.2
	rustc-hash@2.1.1
	rustc_version@0.4.1
	rustix@1.1.3
	rustversion@1.0.22
	ryu@1.0.22
	same-file@1.0.6
	schemars@1.2.0
	schemars_derive@1.2.0
	scopeguard@1.2.0
	semver@1.0.27
	serde@1.0.228
	serde_core@1.0.228
	serde_derive@1.0.228
	serde_derive_internals@0.29.1
	serde_json@1.0.148
	serde_spanned@1.0.4
	serial2@0.2.33
	sha2@0.10.9
	shared_library@0.1.9
	shell-words@1.1.1
	signal-hook-mio@0.2.5
	signal-hook-registry@1.4.8
	signal-hook@0.3.18
	siphasher@1.0.1
	smallvec@1.15.1
	starship-battery@0.10.3
	static_assertions@1.1.0
	strsim@0.11.1
	strum@0.27.2
	strum_macros@0.27.2
	syn@1.0.109
	syn@2.0.111
	sysctl@0.7.1
	sysinfo@0.37.2
	tempfile@3.24.0
	terminal_size@0.4.3
	terminfo@0.9.0
	termios@0.3.3
	termtree@0.5.1
	termwiz@0.23.3
	thiserror-impl@1.0.69
	thiserror-impl@2.0.17
	thiserror@1.0.69
	thiserror@2.0.17
	time-core@0.1.6
	time-macros@0.2.24
	time@0.3.44
	timeless@0.0.14-alpha
	toml_datetime@0.7.5+spec-1.1.0
	toml_edit@0.24.0+spec-1.1.0
	toml_parser@1.0.6+spec-1.1.0
	toml_writer@1.0.6+spec-1.1.0
	typenum@1.19.0
	ucd-trie@0.1.7
	unicode-ellipsis@0.3.0
	unicode-ident@1.0.22
	unicode-segmentation@1.12.0
	unicode-truncate@2.0.0
	unicode-width@0.2.2
	uom@0.37.0
	utf8parse@0.2.2
	uuid@1.19.0
	version_check@0.9.5
	vtparse@0.6.2
	wait-timeout@0.2.1
	walkdir@2.5.0
	wasi@0.11.1+wasi-snapshot-preview1
	wasip2@1.0.1+wasi-0.2.4
	wasm-bindgen-macro-support@0.2.106
	wasm-bindgen-macro@0.2.106
	wasm-bindgen-shared@0.2.106
	wasm-bindgen@0.2.106
	wezterm-bidi@0.2.3
	wezterm-blob-leases@0.1.1
	wezterm-color-types@0.3.0
	wezterm-dynamic-derive@0.1.1
	wezterm-dynamic@0.2.1
	wezterm-input-types@0.1.0
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.11
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-collections@0.2.0
	windows-collections@0.3.2
	windows-core@0.61.2
	windows-core@0.62.2
	windows-future@0.2.1
	windows-future@0.3.2
	windows-implement@0.60.2
	windows-interface@0.59.3
	windows-link@0.1.3
	windows-link@0.2.1
	windows-numerics@0.2.0
	windows-numerics@0.3.1
	windows-result@0.3.4
	windows-result@0.4.1
	windows-strings@0.4.2
	windows-strings@0.5.1
	windows-sys@0.60.2
	windows-sys@0.61.2
	windows-targets@0.53.5
	windows-threading@0.1.0
	windows-threading@0.2.1
	windows@0.61.3
	windows@0.62.2
	windows_aarch64_gnullvm@0.53.1
	windows_aarch64_msvc@0.53.1
	windows_i686_gnu@0.53.1
	windows_i686_gnullvm@0.53.1
	windows_i686_msvc@0.53.1
	windows_x86_64_gnu@0.53.1
	windows_x86_64_gnullvm@0.53.1
	windows_x86_64_msvc@0.53.1
	winnow@0.7.14
	winreg@0.10.1
	wit-bindgen@0.46.0
	wrapcenum-derive@0.4.1
	zmij@1.0.2
"

inherit cargo shell-completion

DESCRIPTION="A graphical process/system monitor with a customizable interface"
HOMEPAGE="https://github.com/ClementTsang/bottom"
SRC_URI="
	https://github.com/ClementTsang/bottom/archive/refs/tags/${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+=" Apache-2.0 ISC MIT MPL-2.0 Unicode-DFS-2016"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv"
IUSE="+battery +gpu +zfs"

RUST_MIN_VER="1.89"

# Rust packages ignore CFLAGS and LDFLAGS so let's silence the QA warnings
QA_FLAGS_IGNORED="usr/bin/btm"

src_prepare() {
	# Stripping symbols should be the choice of the user.
	sed -i '/strip = "symbols"/d' Cargo.toml || die "Unable to patch out symbol stripping"

	default
}

src_configure() {
	local myfeatures=(
		$(usev battery)
		$(usev gpu)
		$(usev zfs)
	)

	# This will turn on generation of shell completion scripts
	export BTM_GENERATE=true

	# https://github.com/ClementTsang/bottom/blob/bacaca5548c2b23d261ef961ee6584b609529567/Cargo.toml#L63
	# fern and log features are for debugging only, so disable default features
	cargo_src_configure $(usev !debug --no-default-features)
}

src_install() {
	cargo_src_install

	pushd target/tmp/bottom/completion > /dev/null || die
	newbashcomp btm.bash btm
	dofishcomp btm.fish
	dozshcomp _btm
	popd > /dev/null || die

	doman target/tmp/bottom/manpage/btm.1

	local DOCS=( README.md )
	einstalldocs
}
