// SPDX-FileCopyrightText: Copyright 2015-2025 go-swagger maintainers
// SPDX-License-Identifier: Apache-2.0

// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: matryer

package mocks

import (
	"iter"
	"sync"

	"github.com/go-openapi/swag/jsonutils/adapters/ifaces"
)

// Ensure that MockOrdered does implement ifaces.Ordered.
// If this is not the case, regenerate this file with mockery.
var _ ifaces.Ordered = &MockOrdered{}

// MockOrdered is a mock implementation of ifaces.Ordered.
//
//	func TestSomethingThatUsesOrdered(t *testing.T) {
//
//		// make and configure a mocked ifaces.Ordered
//		mockedOrdered := &MockOrdered{
//			OrderedItemsFunc: func() iter.Seq2[string, any] {
//				panic("mock out the OrderedItems method")
//			},
//		}
//
//		// use mockedOrdered in code that requires ifaces.Ordered
//		// and then make assertions.
//
//	}
type MockOrdered struct {
	// OrderedItemsFunc mocks the OrderedItems method.
	OrderedItemsFunc func() iter.Seq2[string, any]

	// calls tracks calls to the methods.
	calls struct {
		// OrderedItems holds details about calls to the OrderedItems method.
		OrderedItems []struct {
		}
	}
	lockOrderedItems sync.RWMutex
}

// OrderedItems calls OrderedItemsFunc.
func (mock *MockOrdered) OrderedItems() iter.Seq2[string, any] {
	if mock.OrderedItemsFunc == nil {
		panic("MockOrdered.OrderedItemsFunc: method is nil but Ordered.OrderedItems was just called")
	}
	callInfo := struct {
	}{}
	mock.lockOrderedItems.Lock()
	mock.calls.OrderedItems = append(mock.calls.OrderedItems, callInfo)
	mock.lockOrderedItems.Unlock()
	return mock.OrderedItemsFunc()
}

// OrderedItemsCalls gets all the calls that were made to OrderedItems.
// Check the length with:
//
//	len(mockedOrdered.OrderedItemsCalls())
func (mock *MockOrdered) OrderedItemsCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockOrderedItems.RLock()
	calls = mock.calls.OrderedItems
	mock.lockOrderedItems.RUnlock()
	return calls
}

// Ensure that MockSetOrdered does implement ifaces.SetOrdered.
// If this is not the case, regenerate this file with mockery.
var _ ifaces.SetOrdered = &MockSetOrdered{}

// MockSetOrdered is a mock implementation of ifaces.SetOrdered.
//
//	func TestSomethingThatUsesSetOrdered(t *testing.T) {
//
//		// make and configure a mocked ifaces.SetOrdered
//		mockedSetOrdered := &MockSetOrdered{
//			SetOrderedItemsFunc: func(seq2 iter.Seq2[string, any])  {
//				panic("mock out the SetOrderedItems method")
//			},
//		}
//
//		// use mockedSetOrdered in code that requires ifaces.SetOrdered
//		// and then make assertions.
//
//	}
type MockSetOrdered struct {
	// SetOrderedItemsFunc mocks the SetOrderedItems method.
	SetOrderedItemsFunc func(seq2 iter.Seq2[string, any])

	// calls tracks calls to the methods.
	calls struct {
		// SetOrderedItems holds details about calls to the SetOrderedItems method.
		SetOrderedItems []struct {
			// Seq2 is the seq2 argument value.
			Seq2 iter.Seq2[string, any]
		}
	}
	lockSetOrderedItems sync.RWMutex
}

// SetOrderedItems calls SetOrderedItemsFunc.
func (mock *MockSetOrdered) SetOrderedItems(seq2 iter.Seq2[string, any]) {
	if mock.SetOrderedItemsFunc == nil {
		panic("MockSetOrdered.SetOrderedItemsFunc: method is nil but SetOrdered.SetOrderedItems was just called")
	}
	callInfo := struct {
		Seq2 iter.Seq2[string, any]
	}{
		Seq2: seq2,
	}
	mock.lockSetOrderedItems.Lock()
	mock.calls.SetOrderedItems = append(mock.calls.SetOrderedItems, callInfo)
	mock.lockSetOrderedItems.Unlock()
	mock.SetOrderedItemsFunc(seq2)
}

// SetOrderedItemsCalls gets all the calls that were made to SetOrderedItems.
// Check the length with:
//
//	len(mockedSetOrdered.SetOrderedItemsCalls())
func (mock *MockSetOrdered) SetOrderedItemsCalls() []struct {
	Seq2 iter.Seq2[string, any]
} {
	var calls []struct {
		Seq2 iter.Seq2[string, any]
	}
	mock.lockSetOrderedItems.RLock()
	calls = mock.calls.SetOrderedItems
	mock.lockSetOrderedItems.RUnlock()
	return calls
}

// Ensure that MockOrderedMap does implement ifaces.OrderedMap.
// If this is not the case, regenerate this file with mockery.
var _ ifaces.OrderedMap = &MockOrderedMap{}

// MockOrderedMap is a mock implementation of ifaces.OrderedMap.
//
//	func TestSomethingThatUsesOrderedMap(t *testing.T) {
//
//		// make and configure a mocked ifaces.OrderedMap
//		mockedOrderedMap := &MockOrderedMap{
//			OrderedItemsFunc: func() iter.Seq2[string, any] {
//				panic("mock out the OrderedItems method")
//			},
//			OrderedMarshalJSONFunc: func() ([]byte, error) {
//				panic("mock out the OrderedMarshalJSON method")
//			},
//			OrderedUnmarshalJSONFunc: func(bytes []byte) error {
//				panic("mock out the OrderedUnmarshalJSON method")
//			},
//			SetOrderedItemsFunc: func(seq2 iter.Seq2[string, any])  {
//				panic("mock out the SetOrderedItems method")
//			},
//		}
//
//		// use mockedOrderedMap in code that requires ifaces.OrderedMap
//		// and then make assertions.
//
//	}
type MockOrderedMap struct {
	// OrderedItemsFunc mocks the OrderedItems method.
	OrderedItemsFunc func() iter.Seq2[string, any]

	// OrderedMarshalJSONFunc mocks the OrderedMarshalJSON method.
	OrderedMarshalJSONFunc func() ([]byte, error)

	// OrderedUnmarshalJSONFunc mocks the OrderedUnmarshalJSON method.
	OrderedUnmarshalJSONFunc func(bytes []byte) error

	// SetOrderedItemsFunc mocks the SetOrderedItems method.
	SetOrderedItemsFunc func(seq2 iter.Seq2[string, any])

	// calls tracks calls to the methods.
	calls struct {
		// OrderedItems holds details about calls to the OrderedItems method.
		OrderedItems []struct {
		}
		// OrderedMarshalJSON holds details about calls to the OrderedMarshalJSON method.
		OrderedMarshalJSON []struct {
		}
		// OrderedUnmarshalJSON holds details about calls to the OrderedUnmarshalJSON method.
		OrderedUnmarshalJSON []struct {
			// Bytes is the bytes argument value.
			Bytes []byte
		}
		// SetOrderedItems holds details about calls to the SetOrderedItems method.
		SetOrderedItems []struct {
			// Seq2 is the seq2 argument value.
			Seq2 iter.Seq2[string, any]
		}
	}
	lockOrderedItems         sync.RWMutex
	lockOrderedMarshalJSON   sync.RWMutex
	lockOrderedUnmarshalJSON sync.RWMutex
	lockSetOrderedItems      sync.RWMutex
}

// OrderedItems calls OrderedItemsFunc.
func (mock *MockOrderedMap) OrderedItems() iter.Seq2[string, any] {
	if mock.OrderedItemsFunc == nil {
		panic("MockOrderedMap.OrderedItemsFunc: method is nil but OrderedMap.OrderedItems was just called")
	}
	callInfo := struct {
	}{}
	mock.lockOrderedItems.Lock()
	mock.calls.OrderedItems = append(mock.calls.OrderedItems, callInfo)
	mock.lockOrderedItems.Unlock()
	return mock.OrderedItemsFunc()
}

// OrderedItemsCalls gets all the calls that were made to OrderedItems.
// Check the length with:
//
//	len(mockedOrderedMap.OrderedItemsCalls())
func (mock *MockOrderedMap) OrderedItemsCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockOrderedItems.RLock()
	calls = mock.calls.OrderedItems
	mock.lockOrderedItems.RUnlock()
	return calls
}

// OrderedMarshalJSON calls OrderedMarshalJSONFunc.
func (mock *MockOrderedMap) OrderedMarshalJSON() ([]byte, error) {
	if mock.OrderedMarshalJSONFunc == nil {
		panic("MockOrderedMap.OrderedMarshalJSONFunc: method is nil but OrderedMap.OrderedMarshalJSON was just called")
	}
	callInfo := struct {
	}{}
	mock.lockOrderedMarshalJSON.Lock()
	mock.calls.OrderedMarshalJSON = append(mock.calls.OrderedMarshalJSON, callInfo)
	mock.lockOrderedMarshalJSON.Unlock()
	return mock.OrderedMarshalJSONFunc()
}

// OrderedMarshalJSONCalls gets all the calls that were made to OrderedMarshalJSON.
// Check the length with:
//
//	len(mockedOrderedMap.OrderedMarshalJSONCalls())
func (mock *MockOrderedMap) OrderedMarshalJSONCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockOrderedMarshalJSON.RLock()
	calls = mock.calls.OrderedMarshalJSON
	mock.lockOrderedMarshalJSON.RUnlock()
	return calls
}

// OrderedUnmarshalJSON calls OrderedUnmarshalJSONFunc.
func (mock *MockOrderedMap) OrderedUnmarshalJSON(bytes []byte) error {
	if mock.OrderedUnmarshalJSONFunc == nil {
		panic("MockOrderedMap.OrderedUnmarshalJSONFunc: method is nil but OrderedMap.OrderedUnmarshalJSON was just called")
	}
	callInfo := struct {
		Bytes []byte
	}{
		Bytes: bytes,
	}
	mock.lockOrderedUnmarshalJSON.Lock()
	mock.calls.OrderedUnmarshalJSON = append(mock.calls.OrderedUnmarshalJSON, callInfo)
	mock.lockOrderedUnmarshalJSON.Unlock()
	return mock.OrderedUnmarshalJSONFunc(bytes)
}

// OrderedUnmarshalJSONCalls gets all the calls that were made to OrderedUnmarshalJSON.
// Check the length with:
//
//	len(mockedOrderedMap.OrderedUnmarshalJSONCalls())
func (mock *MockOrderedMap) OrderedUnmarshalJSONCalls() []struct {
	Bytes []byte
} {
	var calls []struct {
		Bytes []byte
	}
	mock.lockOrderedUnmarshalJSON.RLock()
	calls = mock.calls.OrderedUnmarshalJSON
	mock.lockOrderedUnmarshalJSON.RUnlock()
	return calls
}

// SetOrderedItems calls SetOrderedItemsFunc.
func (mock *MockOrderedMap) SetOrderedItems(seq2 iter.Seq2[string, any]) {
	if mock.SetOrderedItemsFunc == nil {
		panic("MockOrderedMap.SetOrderedItemsFunc: method is nil but OrderedMap.SetOrderedItems was just called")
	}
	callInfo := struct {
		Seq2 iter.Seq2[string, any]
	}{
		Seq2: seq2,
	}
	mock.lockSetOrderedItems.Lock()
	mock.calls.SetOrderedItems = append(mock.calls.SetOrderedItems, callInfo)
	mock.lockSetOrderedItems.Unlock()
	mock.SetOrderedItemsFunc(seq2)
}

// SetOrderedItemsCalls gets all the calls that were made to SetOrderedItems.
// Check the length with:
//
//	len(mockedOrderedMap.SetOrderedItemsCalls())
func (mock *MockOrderedMap) SetOrderedItemsCalls() []struct {
	Seq2 iter.Seq2[string, any]
} {
	var calls []struct {
		Seq2 iter.Seq2[string, any]
	}
	mock.lockSetOrderedItems.RLock()
	calls = mock.calls.SetOrderedItems
	mock.lockSetOrderedItems.RUnlock()
	return calls
}

// Ensure that MockMarshalAdapter does implement ifaces.MarshalAdapter.
// If this is not the case, regenerate this file with mockery.
var _ ifaces.MarshalAdapter = &MockMarshalAdapter{}

// MockMarshalAdapter is a mock implementation of ifaces.MarshalAdapter.
//
//	func TestSomethingThatUsesMarshalAdapter(t *testing.T) {
//
//		// make and configure a mocked ifaces.MarshalAdapter
//		mockedMarshalAdapter := &MockMarshalAdapter{
//			MarshalFunc: func(v any) ([]byte, error) {
//				panic("mock out the Marshal method")
//			},
//			RedeemFunc: func()  {
//				panic("mock out the Redeem method")
//			},
//			ResetFunc: func()  {
//				panic("mock out the Reset method")
//			},
//		}
//
//		// use mockedMarshalAdapter in code that requires ifaces.MarshalAdapter
//		// and then make assertions.
//
//	}
type MockMarshalAdapter struct {
	// MarshalFunc mocks the Marshal method.
	MarshalFunc func(v any) ([]byte, error)

	// RedeemFunc mocks the Redeem method.
	RedeemFunc func()

	// ResetFunc mocks the Reset method.
	ResetFunc func()

	// calls tracks calls to the methods.
	calls struct {
		// Marshal holds details about calls to the Marshal method.
		Marshal []struct {
			// V is the v argument value.
			V any
		}
		// Redeem holds details about calls to the Redeem method.
		Redeem []struct {
		}
		// Reset holds details about calls to the Reset method.
		Reset []struct {
		}
	}
	lockMarshal sync.RWMutex
	lockRedeem  sync.RWMutex
	lockReset   sync.RWMutex
}

// Marshal calls MarshalFunc.
func (mock *MockMarshalAdapter) Marshal(v any) ([]byte, error) {
	if mock.MarshalFunc == nil {
		panic("MockMarshalAdapter.MarshalFunc: method is nil but MarshalAdapter.Marshal was just called")
	}
	callInfo := struct {
		V any
	}{
		V: v,
	}
	mock.lockMarshal.Lock()
	mock.calls.Marshal = append(mock.calls.Marshal, callInfo)
	mock.lockMarshal.Unlock()
	return mock.MarshalFunc(v)
}

// MarshalCalls gets all the calls that were made to Marshal.
// Check the length with:
//
//	len(mockedMarshalAdapter.MarshalCalls())
func (mock *MockMarshalAdapter) MarshalCalls() []struct {
	V any
} {
	var calls []struct {
		V any
	}
	mock.lockMarshal.RLock()
	calls = mock.calls.Marshal
	mock.lockMarshal.RUnlock()
	return calls
}

// Redeem calls RedeemFunc.
func (mock *MockMarshalAdapter) Redeem() {
	if mock.RedeemFunc == nil {
		panic("MockMarshalAdapter.RedeemFunc: method is nil but MarshalAdapter.Redeem was just called")
	}
	callInfo := struct {
	}{}
	mock.lockRedeem.Lock()
	mock.calls.Redeem = append(mock.calls.Redeem, callInfo)
	mock.lockRedeem.Unlock()
	mock.RedeemFunc()
}

// RedeemCalls gets all the calls that were made to Redeem.
// Check the length with:
//
//	len(mockedMarshalAdapter.RedeemCalls())
func (mock *MockMarshalAdapter) RedeemCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockRedeem.RLock()
	calls = mock.calls.Redeem
	mock.lockRedeem.RUnlock()
	return calls
}

// Reset calls ResetFunc.
func (mock *MockMarshalAdapter) Reset() {
	if mock.ResetFunc == nil {
		panic("MockMarshalAdapter.ResetFunc: method is nil but MarshalAdapter.Reset was just called")
	}
	callInfo := struct {
	}{}
	mock.lockReset.Lock()
	mock.calls.Reset = append(mock.calls.Reset, callInfo)
	mock.lockReset.Unlock()
	mock.ResetFunc()
}

// ResetCalls gets all the calls that were made to Reset.
// Check the length with:
//
//	len(mockedMarshalAdapter.ResetCalls())
func (mock *MockMarshalAdapter) ResetCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockReset.RLock()
	calls = mock.calls.Reset
	mock.lockReset.RUnlock()
	return calls
}

// Ensure that MockOrderedMarshalAdapter does implement ifaces.OrderedMarshalAdapter.
// If this is not the case, regenerate this file with mockery.
var _ ifaces.OrderedMarshalAdapter = &MockOrderedMarshalAdapter{}

// MockOrderedMarshalAdapter is a mock implementation of ifaces.OrderedMarshalAdapter.
//
//	func TestSomethingThatUsesOrderedMarshalAdapter(t *testing.T) {
//
//		// make and configure a mocked ifaces.OrderedMarshalAdapter
//		mockedOrderedMarshalAdapter := &MockOrderedMarshalAdapter{
//			OrderedMarshalFunc: func(ordered ifaces.Ordered) ([]byte, error) {
//				panic("mock out the OrderedMarshal method")
//			},
//			RedeemFunc: func()  {
//				panic("mock out the Redeem method")
//			},
//			ResetFunc: func()  {
//				panic("mock out the Reset method")
//			},
//		}
//
//		// use mockedOrderedMarshalAdapter in code that requires ifaces.OrderedMarshalAdapter
//		// and then make assertions.
//
//	}
type MockOrderedMarshalAdapter struct {
	// OrderedMarshalFunc mocks the OrderedMarshal method.
	OrderedMarshalFunc func(ordered ifaces.Ordered) ([]byte, error)

	// RedeemFunc mocks the Redeem method.
	RedeemFunc func()

	// ResetFunc mocks the Reset method.
	ResetFunc func()

	// calls tracks calls to the methods.
	calls struct {
		// OrderedMarshal holds details about calls to the OrderedMarshal method.
		OrderedMarshal []struct {
			// Ordered is the ordered argument value.
			Ordered ifaces.Ordered
		}
		// Redeem holds details about calls to the Redeem method.
		Redeem []struct {
		}
		// Reset holds details about calls to the Reset method.
		Reset []struct {
		}
	}
	lockOrderedMarshal sync.RWMutex
	lockRedeem         sync.RWMutex
	lockReset          sync.RWMutex
}

// OrderedMarshal calls OrderedMarshalFunc.
func (mock *MockOrderedMarshalAdapter) OrderedMarshal(ordered ifaces.Ordered) ([]byte, error) {
	if mock.OrderedMarshalFunc == nil {
		panic("MockOrderedMarshalAdapter.OrderedMarshalFunc: method is nil but OrderedMarshalAdapter.OrderedMarshal was just called")
	}
	callInfo := struct {
		Ordered ifaces.Ordered
	}{
		Ordered: ordered,
	}
	mock.lockOrderedMarshal.Lock()
	mock.calls.OrderedMarshal = append(mock.calls.OrderedMarshal, callInfo)
	mock.lockOrderedMarshal.Unlock()
	return mock.OrderedMarshalFunc(ordered)
}

// OrderedMarshalCalls gets all the calls that were made to OrderedMarshal.
// Check the length with:
//
//	len(mockedOrderedMarshalAdapter.OrderedMarshalCalls())
func (mock *MockOrderedMarshalAdapter) OrderedMarshalCalls() []struct {
	Ordered ifaces.Ordered
} {
	var calls []struct {
		Ordered ifaces.Ordered
	}
	mock.lockOrderedMarshal.RLock()
	calls = mock.calls.OrderedMarshal
	mock.lockOrderedMarshal.RUnlock()
	return calls
}

// Redeem calls RedeemFunc.
func (mock *MockOrderedMarshalAdapter) Redeem() {
	if mock.RedeemFunc == nil {
		panic("MockOrderedMarshalAdapter.RedeemFunc: method is nil but OrderedMarshalAdapter.Redeem was just called")
	}
	callInfo := struct {
	}{}
	mock.lockRedeem.Lock()
	mock.calls.Redeem = append(mock.calls.Redeem, callInfo)
	mock.lockRedeem.Unlock()
	mock.RedeemFunc()
}

// RedeemCalls gets all the calls that were made to Redeem.
// Check the length with:
//
//	len(mockedOrderedMarshalAdapter.RedeemCalls())
func (mock *MockOrderedMarshalAdapter) RedeemCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockRedeem.RLock()
	calls = mock.calls.Redeem
	mock.lockRedeem.RUnlock()
	return calls
}

// Reset calls ResetFunc.
func (mock *MockOrderedMarshalAdapter) Reset() {
	if mock.ResetFunc == nil {
		panic("MockOrderedMarshalAdapter.ResetFunc: method is nil but OrderedMarshalAdapter.Reset was just called")
	}
	callInfo := struct {
	}{}
	mock.lockReset.Lock()
	mock.calls.Reset = append(mock.calls.Reset, callInfo)
	mock.lockReset.Unlock()
	mock.ResetFunc()
}

// ResetCalls gets all the calls that were made to Reset.
// Check the length with:
//
//	len(mockedOrderedMarshalAdapter.ResetCalls())
func (mock *MockOrderedMarshalAdapter) ResetCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockReset.RLock()
	calls = mock.calls.Reset
	mock.lockReset.RUnlock()
	return calls
}

// Ensure that MockUnmarshalAdapter does implement ifaces.UnmarshalAdapter.
// If this is not the case, regenerate this file with mockery.
var _ ifaces.UnmarshalAdapter = &MockUnmarshalAdapter{}

// MockUnmarshalAdapter is a mock implementation of ifaces.UnmarshalAdapter.
//
//	func TestSomethingThatUsesUnmarshalAdapter(t *testing.T) {
//
//		// make and configure a mocked ifaces.UnmarshalAdapter
//		mockedUnmarshalAdapter := &MockUnmarshalAdapter{
//			RedeemFunc: func()  {
//				panic("mock out the Redeem method")
//			},
//			ResetFunc: func()  {
//				panic("mock out the Reset method")
//			},
//			UnmarshalFunc: func(bytes []byte, v any) error {
//				panic("mock out the Unmarshal method")
//			},
//		}
//
//		// use mockedUnmarshalAdapter in code that requires ifaces.UnmarshalAdapter
//		// and then make assertions.
//
//	}
type MockUnmarshalAdapter struct {
	// RedeemFunc mocks the Redeem method.
	RedeemFunc func()

	// ResetFunc mocks the Reset method.
	ResetFunc func()

	// UnmarshalFunc mocks the Unmarshal method.
	UnmarshalFunc func(bytes []byte, v any) error

	// calls tracks calls to the methods.
	calls struct {
		// Redeem holds details about calls to the Redeem method.
		Redeem []struct {
		}
		// Reset holds details about calls to the Reset method.
		Reset []struct {
		}
		// Unmarshal holds details about calls to the Unmarshal method.
		Unmarshal []struct {
			// Bytes is the bytes argument value.
			Bytes []byte
			// V is the v argument value.
			V any
		}
	}
	lockRedeem    sync.RWMutex
	lockReset     sync.RWMutex
	lockUnmarshal sync.RWMutex
}

// Redeem calls RedeemFunc.
func (mock *MockUnmarshalAdapter) Redeem() {
	if mock.RedeemFunc == nil {
		panic("MockUnmarshalAdapter.RedeemFunc: method is nil but UnmarshalAdapter.Redeem was just called")
	}
	callInfo := struct {
	}{}
	mock.lockRedeem.Lock()
	mock.calls.Redeem = append(mock.calls.Redeem, callInfo)
	mock.lockRedeem.Unlock()
	mock.RedeemFunc()
}

// RedeemCalls gets all the calls that were made to Redeem.
// Check the length with:
//
//	len(mockedUnmarshalAdapter.RedeemCalls())
func (mock *MockUnmarshalAdapter) RedeemCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockRedeem.RLock()
	calls = mock.calls.Redeem
	mock.lockRedeem.RUnlock()
	return calls
}

// Reset calls ResetFunc.
func (mock *MockUnmarshalAdapter) Reset() {
	if mock.ResetFunc == nil {
		panic("MockUnmarshalAdapter.ResetFunc: method is nil but UnmarshalAdapter.Reset was just called")
	}
	callInfo := struct {
	}{}
	mock.lockReset.Lock()
	mock.calls.Reset = append(mock.calls.Reset, callInfo)
	mock.lockReset.Unlock()
	mock.ResetFunc()
}

// ResetCalls gets all the calls that were made to Reset.
// Check the length with:
//
//	len(mockedUnmarshalAdapter.ResetCalls())
func (mock *MockUnmarshalAdapter) ResetCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockReset.RLock()
	calls = mock.calls.Reset
	mock.lockReset.RUnlock()
	return calls
}

// Unmarshal calls UnmarshalFunc.
func (mock *MockUnmarshalAdapter) Unmarshal(bytes []byte, v any) error {
	if mock.UnmarshalFunc == nil {
		panic("MockUnmarshalAdapter.UnmarshalFunc: method is nil but UnmarshalAdapter.Unmarshal was just called")
	}
	callInfo := struct {
		Bytes []byte
		V     any
	}{
		Bytes: bytes,
		V:     v,
	}
	mock.lockUnmarshal.Lock()
	mock.calls.Unmarshal = append(mock.calls.Unmarshal, callInfo)
	mock.lockUnmarshal.Unlock()
	return mock.UnmarshalFunc(bytes, v)
}

// UnmarshalCalls gets all the calls that were made to Unmarshal.
// Check the length with:
//
//	len(mockedUnmarshalAdapter.UnmarshalCalls())
func (mock *MockUnmarshalAdapter) UnmarshalCalls() []struct {
	Bytes []byte
	V     any
} {
	var calls []struct {
		Bytes []byte
		V     any
	}
	mock.lockUnmarshal.RLock()
	calls = mock.calls.Unmarshal
	mock.lockUnmarshal.RUnlock()
	return calls
}

// Ensure that MockOrderedUnmarshalAdapter does implement ifaces.OrderedUnmarshalAdapter.
// If this is not the case, regenerate this file with mockery.
var _ ifaces.OrderedUnmarshalAdapter = &MockOrderedUnmarshalAdapter{}

// MockOrderedUnmarshalAdapter is a mock implementation of ifaces.OrderedUnmarshalAdapter.
//
//	func TestSomethingThatUsesOrderedUnmarshalAdapter(t *testing.T) {
//
//		// make and configure a mocked ifaces.OrderedUnmarshalAdapter
//		mockedOrderedUnmarshalAdapter := &MockOrderedUnmarshalAdapter{
//			OrderedUnmarshalFunc: func(bytes []byte, setOrdered ifaces.SetOrdered) error {
//				panic("mock out the OrderedUnmarshal method")
//			},
//			RedeemFunc: func()  {
//				panic("mock out the Redeem method")
//			},
//			ResetFunc: func()  {
//				panic("mock out the Reset method")
//			},
//		}
//
//		// use mockedOrderedUnmarshalAdapter in code that requires ifaces.OrderedUnmarshalAdapter
//		// and then make assertions.
//
//	}
type MockOrderedUnmarshalAdapter struct {
	// OrderedUnmarshalFunc mocks the OrderedUnmarshal method.
	OrderedUnmarshalFunc func(bytes []byte, setOrdered ifaces.SetOrdered) error

	// RedeemFunc mocks the Redeem method.
	RedeemFunc func()

	// ResetFunc mocks the Reset method.
	ResetFunc func()

	// calls tracks calls to the methods.
	calls struct {
		// OrderedUnmarshal holds details about calls to the OrderedUnmarshal method.
		OrderedUnmarshal []struct {
			// Bytes is the bytes argument value.
			Bytes []byte
			// SetOrdered is the setOrdered argument value.
			SetOrdered ifaces.SetOrdered
		}
		// Redeem holds details about calls to the Redeem method.
		Redeem []struct {
		}
		// Reset holds details about calls to the Reset method.
		Reset []struct {
		}
	}
	lockOrderedUnmarshal sync.RWMutex
	lockRedeem           sync.RWMutex
	lockReset            sync.RWMutex
}

// OrderedUnmarshal calls OrderedUnmarshalFunc.
func (mock *MockOrderedUnmarshalAdapter) OrderedUnmarshal(bytes []byte, setOrdered ifaces.SetOrdered) error {
	if mock.OrderedUnmarshalFunc == nil {
		panic("MockOrderedUnmarshalAdapter.OrderedUnmarshalFunc: method is nil but OrderedUnmarshalAdapter.OrderedUnmarshal was just called")
	}
	callInfo := struct {
		Bytes      []byte
		SetOrdered ifaces.SetOrdered
	}{
		Bytes:      bytes,
		SetOrdered: setOrdered,
	}
	mock.lockOrderedUnmarshal.Lock()
	mock.calls.OrderedUnmarshal = append(mock.calls.OrderedUnmarshal, callInfo)
	mock.lockOrderedUnmarshal.Unlock()
	return mock.OrderedUnmarshalFunc(bytes, setOrdered)
}

// OrderedUnmarshalCalls gets all the calls that were made to OrderedUnmarshal.
// Check the length with:
//
//	len(mockedOrderedUnmarshalAdapter.OrderedUnmarshalCalls())
func (mock *MockOrderedUnmarshalAdapter) OrderedUnmarshalCalls() []struct {
	Bytes      []byte
	SetOrdered ifaces.SetOrdered
} {
	var calls []struct {
		Bytes      []byte
		SetOrdered ifaces.SetOrdered
	}
	mock.lockOrderedUnmarshal.RLock()
	calls = mock.calls.OrderedUnmarshal
	mock.lockOrderedUnmarshal.RUnlock()
	return calls
}

// Redeem calls RedeemFunc.
func (mock *MockOrderedUnmarshalAdapter) Redeem() {
	if mock.RedeemFunc == nil {
		panic("MockOrderedUnmarshalAdapter.RedeemFunc: method is nil but OrderedUnmarshalAdapter.Redeem was just called")
	}
	callInfo := struct {
	}{}
	mock.lockRedeem.Lock()
	mock.calls.Redeem = append(mock.calls.Redeem, callInfo)
	mock.lockRedeem.Unlock()
	mock.RedeemFunc()
}

// RedeemCalls gets all the calls that were made to Redeem.
// Check the length with:
//
//	len(mockedOrderedUnmarshalAdapter.RedeemCalls())
func (mock *MockOrderedUnmarshalAdapter) RedeemCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockRedeem.RLock()
	calls = mock.calls.Redeem
	mock.lockRedeem.RUnlock()
	return calls
}

// Reset calls ResetFunc.
func (mock *MockOrderedUnmarshalAdapter) Reset() {
	if mock.ResetFunc == nil {
		panic("MockOrderedUnmarshalAdapter.ResetFunc: method is nil but OrderedUnmarshalAdapter.Reset was just called")
	}
	callInfo := struct {
	}{}
	mock.lockReset.Lock()
	mock.calls.Reset = append(mock.calls.Reset, callInfo)
	mock.lockReset.Unlock()
	mock.ResetFunc()
}

// ResetCalls gets all the calls that were made to Reset.
// Check the length with:
//
//	len(mockedOrderedUnmarshalAdapter.ResetCalls())
func (mock *MockOrderedUnmarshalAdapter) ResetCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockReset.RLock()
	calls = mock.calls.Reset
	mock.lockReset.RUnlock()
	return calls
}

// Ensure that MockAdapter does implement ifaces.Adapter.
// If this is not the case, regenerate this file with mockery.
var _ ifaces.Adapter = &MockAdapter{}

// MockAdapter is a mock implementation of ifaces.Adapter.
//
//	func TestSomethingThatUsesAdapter(t *testing.T) {
//
//		// make and configure a mocked ifaces.Adapter
//		mockedAdapter := &MockAdapter{
//			MarshalFunc: func(v any) ([]byte, error) {
//				panic("mock out the Marshal method")
//			},
//			NewOrderedMapFunc: func(capacity int) ifaces.OrderedMap {
//				panic("mock out the NewOrderedMap method")
//			},
//			OrderedMarshalFunc: func(ordered ifaces.Ordered) ([]byte, error) {
//				panic("mock out the OrderedMarshal method")
//			},
//			OrderedUnmarshalFunc: func(bytes []byte, setOrdered ifaces.SetOrdered) error {
//				panic("mock out the OrderedUnmarshal method")
//			},
//			RedeemFunc: func()  {
//				panic("mock out the Redeem method")
//			},
//			ResetFunc: func()  {
//				panic("mock out the Reset method")
//			},
//			UnmarshalFunc: func(bytes []byte, v any) error {
//				panic("mock out the Unmarshal method")
//			},
//		}
//
//		// use mockedAdapter in code that requires ifaces.Adapter
//		// and then make assertions.
//
//	}
type MockAdapter struct {
	// MarshalFunc mocks the Marshal method.
	MarshalFunc func(v any) ([]byte, error)

	// NewOrderedMapFunc mocks the NewOrderedMap method.
	NewOrderedMapFunc func(capacity int) ifaces.OrderedMap

	// OrderedMarshalFunc mocks the OrderedMarshal method.
	OrderedMarshalFunc func(ordered ifaces.Ordered) ([]byte, error)

	// OrderedUnmarshalFunc mocks the OrderedUnmarshal method.
	OrderedUnmarshalFunc func(bytes []byte, setOrdered ifaces.SetOrdered) error

	// RedeemFunc mocks the Redeem method.
	RedeemFunc func()

	// ResetFunc mocks the Reset method.
	ResetFunc func()

	// UnmarshalFunc mocks the Unmarshal method.
	UnmarshalFunc func(bytes []byte, v any) error

	// calls tracks calls to the methods.
	calls struct {
		// Marshal holds details about calls to the Marshal method.
		Marshal []struct {
			// V is the v argument value.
			V any
		}
		// NewOrderedMap holds details about calls to the NewOrderedMap method.
		NewOrderedMap []struct {
			// Capacity is the capacity argument value.
			Capacity int
		}
		// OrderedMarshal holds details about calls to the OrderedMarshal method.
		OrderedMarshal []struct {
			// Ordered is the ordered argument value.
			Ordered ifaces.Ordered
		}
		// OrderedUnmarshal holds details about calls to the OrderedUnmarshal method.
		OrderedUnmarshal []struct {
			// Bytes is the bytes argument value.
			Bytes []byte
			// SetOrdered is the setOrdered argument value.
			SetOrdered ifaces.SetOrdered
		}
		// Redeem holds details about calls to the Redeem method.
		Redeem []struct {
		}
		// Reset holds details about calls to the Reset method.
		Reset []struct {
		}
		// Unmarshal holds details about calls to the Unmarshal method.
		Unmarshal []struct {
			// Bytes is the bytes argument value.
			Bytes []byte
			// V is the v argument value.
			V any
		}
	}
	lockMarshal          sync.RWMutex
	lockNewOrderedMap    sync.RWMutex
	lockOrderedMarshal   sync.RWMutex
	lockOrderedUnmarshal sync.RWMutex
	lockRedeem           sync.RWMutex
	lockReset            sync.RWMutex
	lockUnmarshal        sync.RWMutex
}

// Marshal calls MarshalFunc.
func (mock *MockAdapter) Marshal(v any) ([]byte, error) {
	if mock.MarshalFunc == nil {
		panic("MockAdapter.MarshalFunc: method is nil but Adapter.Marshal was just called")
	}
	callInfo := struct {
		V any
	}{
		V: v,
	}
	mock.lockMarshal.Lock()
	mock.calls.Marshal = append(mock.calls.Marshal, callInfo)
	mock.lockMarshal.Unlock()
	return mock.MarshalFunc(v)
}

// MarshalCalls gets all the calls that were made to Marshal.
// Check the length with:
//
//	len(mockedAdapter.MarshalCalls())
func (mock *MockAdapter) MarshalCalls() []struct {
	V any
} {
	var calls []struct {
		V any
	}
	mock.lockMarshal.RLock()
	calls = mock.calls.Marshal
	mock.lockMarshal.RUnlock()
	return calls
}

// NewOrderedMap calls NewOrderedMapFunc.
func (mock *MockAdapter) NewOrderedMap(capacity int) ifaces.OrderedMap {
	if mock.NewOrderedMapFunc == nil {
		panic("MockAdapter.NewOrderedMapFunc: method is nil but Adapter.NewOrderedMap was just called")
	}
	callInfo := struct {
		Capacity int
	}{
		Capacity: capacity,
	}
	mock.lockNewOrderedMap.Lock()
	mock.calls.NewOrderedMap = append(mock.calls.NewOrderedMap, callInfo)
	mock.lockNewOrderedMap.Unlock()
	return mock.NewOrderedMapFunc(capacity)
}

// NewOrderedMapCalls gets all the calls that were made to NewOrderedMap.
// Check the length with:
//
//	len(mockedAdapter.NewOrderedMapCalls())
func (mock *MockAdapter) NewOrderedMapCalls() []struct {
	Capacity int
} {
	var calls []struct {
		Capacity int
	}
	mock.lockNewOrderedMap.RLock()
	calls = mock.calls.NewOrderedMap
	mock.lockNewOrderedMap.RUnlock()
	return calls
}

// OrderedMarshal calls OrderedMarshalFunc.
func (mock *MockAdapter) OrderedMarshal(ordered ifaces.Ordered) ([]byte, error) {
	if mock.OrderedMarshalFunc == nil {
		panic("MockAdapter.OrderedMarshalFunc: method is nil but Adapter.OrderedMarshal was just called")
	}
	callInfo := struct {
		Ordered ifaces.Ordered
	}{
		Ordered: ordered,
	}
	mock.lockOrderedMarshal.Lock()
	mock.calls.OrderedMarshal = append(mock.calls.OrderedMarshal, callInfo)
	mock.lockOrderedMarshal.Unlock()
	return mock.OrderedMarshalFunc(ordered)
}

// OrderedMarshalCalls gets all the calls that were made to OrderedMarshal.
// Check the length with:
//
//	len(mockedAdapter.OrderedMarshalCalls())
func (mock *MockAdapter) OrderedMarshalCalls() []struct {
	Ordered ifaces.Ordered
} {
	var calls []struct {
		Ordered ifaces.Ordered
	}
	mock.lockOrderedMarshal.RLock()
	calls = mock.calls.OrderedMarshal
	mock.lockOrderedMarshal.RUnlock()
	return calls
}

// OrderedUnmarshal calls OrderedUnmarshalFunc.
func (mock *MockAdapter) OrderedUnmarshal(bytes []byte, setOrdered ifaces.SetOrdered) error {
	if mock.OrderedUnmarshalFunc == nil {
		panic("MockAdapter.OrderedUnmarshalFunc: method is nil but Adapter.OrderedUnmarshal was just called")
	}
	callInfo := struct {
		Bytes      []byte
		SetOrdered ifaces.SetOrdered
	}{
		Bytes:      bytes,
		SetOrdered: setOrdered,
	}
	mock.lockOrderedUnmarshal.Lock()
	mock.calls.OrderedUnmarshal = append(mock.calls.OrderedUnmarshal, callInfo)
	mock.lockOrderedUnmarshal.Unlock()
	return mock.OrderedUnmarshalFunc(bytes, setOrdered)
}

// OrderedUnmarshalCalls gets all the calls that were made to OrderedUnmarshal.
// Check the length with:
//
//	len(mockedAdapter.OrderedUnmarshalCalls())
func (mock *MockAdapter) OrderedUnmarshalCalls() []struct {
	Bytes      []byte
	SetOrdered ifaces.SetOrdered
} {
	var calls []struct {
		Bytes      []byte
		SetOrdered ifaces.SetOrdered
	}
	mock.lockOrderedUnmarshal.RLock()
	calls = mock.calls.OrderedUnmarshal
	mock.lockOrderedUnmarshal.RUnlock()
	return calls
}

// Redeem calls RedeemFunc.
func (mock *MockAdapter) Redeem() {
	if mock.RedeemFunc == nil {
		panic("MockAdapter.RedeemFunc: method is nil but Adapter.Redeem was just called")
	}
	callInfo := struct {
	}{}
	mock.lockRedeem.Lock()
	mock.calls.Redeem = append(mock.calls.Redeem, callInfo)
	mock.lockRedeem.Unlock()
	mock.RedeemFunc()
}

// RedeemCalls gets all the calls that were made to Redeem.
// Check the length with:
//
//	len(mockedAdapter.RedeemCalls())
func (mock *MockAdapter) RedeemCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockRedeem.RLock()
	calls = mock.calls.Redeem
	mock.lockRedeem.RUnlock()
	return calls
}

// Reset calls ResetFunc.
func (mock *MockAdapter) Reset() {
	if mock.ResetFunc == nil {
		panic("MockAdapter.ResetFunc: method is nil but Adapter.Reset was just called")
	}
	callInfo := struct {
	}{}
	mock.lockReset.Lock()
	mock.calls.Reset = append(mock.calls.Reset, callInfo)
	mock.lockReset.Unlock()
	mock.ResetFunc()
}

// ResetCalls gets all the calls that were made to Reset.
// Check the length with:
//
//	len(mockedAdapter.ResetCalls())
func (mock *MockAdapter) ResetCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockReset.RLock()
	calls = mock.calls.Reset
	mock.lockReset.RUnlock()
	return calls
}

// Unmarshal calls UnmarshalFunc.
func (mock *MockAdapter) Unmarshal(bytes []byte, v any) error {
	if mock.UnmarshalFunc == nil {
		panic("MockAdapter.UnmarshalFunc: method is nil but Adapter.Unmarshal was just called")
	}
	callInfo := struct {
		Bytes []byte
		V     any
	}{
		Bytes: bytes,
		V:     v,
	}
	mock.lockUnmarshal.Lock()
	mock.calls.Unmarshal = append(mock.calls.Unmarshal, callInfo)
	mock.lockUnmarshal.Unlock()
	return mock.UnmarshalFunc(bytes, v)
}

// UnmarshalCalls gets all the calls that were made to Unmarshal.
// Check the length with:
//
//	len(mockedAdapter.UnmarshalCalls())
func (mock *MockAdapter) UnmarshalCalls() []struct {
	Bytes []byte
	V     any
} {
	var calls []struct {
		Bytes []byte
		V     any
	}
	mock.lockUnmarshal.RLock()
	calls = mock.calls.Unmarshal
	mock.lockUnmarshal.RUnlock()
	return calls
}

// Ensure that MockOrderedAdapter does implement ifaces.OrderedAdapter.
// If this is not the case, regenerate this file with mockery.
var _ ifaces.OrderedAdapter = &MockOrderedAdapter{}

// MockOrderedAdapter is a mock implementation of ifaces.OrderedAdapter.
//
//	func TestSomethingThatUsesOrderedAdapter(t *testing.T) {
//
//		// make and configure a mocked ifaces.OrderedAdapter
//		mockedOrderedAdapter := &MockOrderedAdapter{
//			NewOrderedMapFunc: func(capacity int) ifaces.OrderedMap {
//				panic("mock out the NewOrderedMap method")
//			},
//			OrderedMarshalFunc: func(ordered ifaces.Ordered) ([]byte, error) {
//				panic("mock out the OrderedMarshal method")
//			},
//			OrderedUnmarshalFunc: func(bytes []byte, setOrdered ifaces.SetOrdered) error {
//				panic("mock out the OrderedUnmarshal method")
//			},
//			RedeemFunc: func()  {
//				panic("mock out the Redeem method")
//			},
//			ResetFunc: func()  {
//				panic("mock out the Reset method")
//			},
//		}
//
//		// use mockedOrderedAdapter in code that requires ifaces.OrderedAdapter
//		// and then make assertions.
//
//	}
type MockOrderedAdapter struct {
	// NewOrderedMapFunc mocks the NewOrderedMap method.
	NewOrderedMapFunc func(capacity int) ifaces.OrderedMap

	// OrderedMarshalFunc mocks the OrderedMarshal method.
	OrderedMarshalFunc func(ordered ifaces.Ordered) ([]byte, error)

	// OrderedUnmarshalFunc mocks the OrderedUnmarshal method.
	OrderedUnmarshalFunc func(bytes []byte, setOrdered ifaces.SetOrdered) error

	// RedeemFunc mocks the Redeem method.
	RedeemFunc func()

	// ResetFunc mocks the Reset method.
	ResetFunc func()

	// calls tracks calls to the methods.
	calls struct {
		// NewOrderedMap holds details about calls to the NewOrderedMap method.
		NewOrderedMap []struct {
			// Capacity is the capacity argument value.
			Capacity int
		}
		// OrderedMarshal holds details about calls to the OrderedMarshal method.
		OrderedMarshal []struct {
			// Ordered is the ordered argument value.
			Ordered ifaces.Ordered
		}
		// OrderedUnmarshal holds details about calls to the OrderedUnmarshal method.
		OrderedUnmarshal []struct {
			// Bytes is the bytes argument value.
			Bytes []byte
			// SetOrdered is the setOrdered argument value.
			SetOrdered ifaces.SetOrdered
		}
		// Redeem holds details about calls to the Redeem method.
		Redeem []struct {
		}
		// Reset holds details about calls to the Reset method.
		Reset []struct {
		}
	}
	lockNewOrderedMap    sync.RWMutex
	lockOrderedMarshal   sync.RWMutex
	lockOrderedUnmarshal sync.RWMutex
	lockRedeem           sync.RWMutex
	lockReset            sync.RWMutex
}

// NewOrderedMap calls NewOrderedMapFunc.
func (mock *MockOrderedAdapter) NewOrderedMap(capacity int) ifaces.OrderedMap {
	if mock.NewOrderedMapFunc == nil {
		panic("MockOrderedAdapter.NewOrderedMapFunc: method is nil but OrderedAdapter.NewOrderedMap was just called")
	}
	callInfo := struct {
		Capacity int
	}{
		Capacity: capacity,
	}
	mock.lockNewOrderedMap.Lock()
	mock.calls.NewOrderedMap = append(mock.calls.NewOrderedMap, callInfo)
	mock.lockNewOrderedMap.Unlock()
	return mock.NewOrderedMapFunc(capacity)
}

// NewOrderedMapCalls gets all the calls that were made to NewOrderedMap.
// Check the length with:
//
//	len(mockedOrderedAdapter.NewOrderedMapCalls())
func (mock *MockOrderedAdapter) NewOrderedMapCalls() []struct {
	Capacity int
} {
	var calls []struct {
		Capacity int
	}
	mock.lockNewOrderedMap.RLock()
	calls = mock.calls.NewOrderedMap
	mock.lockNewOrderedMap.RUnlock()
	return calls
}

// OrderedMarshal calls OrderedMarshalFunc.
func (mock *MockOrderedAdapter) OrderedMarshal(ordered ifaces.Ordered) ([]byte, error) {
	if mock.OrderedMarshalFunc == nil {
		panic("MockOrderedAdapter.OrderedMarshalFunc: method is nil but OrderedAdapter.OrderedMarshal was just called")
	}
	callInfo := struct {
		Ordered ifaces.Ordered
	}{
		Ordered: ordered,
	}
	mock.lockOrderedMarshal.Lock()
	mock.calls.OrderedMarshal = append(mock.calls.OrderedMarshal, callInfo)
	mock.lockOrderedMarshal.Unlock()
	return mock.OrderedMarshalFunc(ordered)
}

// OrderedMarshalCalls gets all the calls that were made to OrderedMarshal.
// Check the length with:
//
//	len(mockedOrderedAdapter.OrderedMarshalCalls())
func (mock *MockOrderedAdapter) OrderedMarshalCalls() []struct {
	Ordered ifaces.Ordered
} {
	var calls []struct {
		Ordered ifaces.Ordered
	}
	mock.lockOrderedMarshal.RLock()
	calls = mock.calls.OrderedMarshal
	mock.lockOrderedMarshal.RUnlock()
	return calls
}

// OrderedUnmarshal calls OrderedUnmarshalFunc.
func (mock *MockOrderedAdapter) OrderedUnmarshal(bytes []byte, setOrdered ifaces.SetOrdered) error {
	if mock.OrderedUnmarshalFunc == nil {
		panic("MockOrderedAdapter.OrderedUnmarshalFunc: method is nil but OrderedAdapter.OrderedUnmarshal was just called")
	}
	callInfo := struct {
		Bytes      []byte
		SetOrdered ifaces.SetOrdered
	}{
		Bytes:      bytes,
		SetOrdered: setOrdered,
	}
	mock.lockOrderedUnmarshal.Lock()
	mock.calls.OrderedUnmarshal = append(mock.calls.OrderedUnmarshal, callInfo)
	mock.lockOrderedUnmarshal.Unlock()
	return mock.OrderedUnmarshalFunc(bytes, setOrdered)
}

// OrderedUnmarshalCalls gets all the calls that were made to OrderedUnmarshal.
// Check the length with:
//
//	len(mockedOrderedAdapter.OrderedUnmarshalCalls())
func (mock *MockOrderedAdapter) OrderedUnmarshalCalls() []struct {
	Bytes      []byte
	SetOrdered ifaces.SetOrdered
} {
	var calls []struct {
		Bytes      []byte
		SetOrdered ifaces.SetOrdered
	}
	mock.lockOrderedUnmarshal.RLock()
	calls = mock.calls.OrderedUnmarshal
	mock.lockOrderedUnmarshal.RUnlock()
	return calls
}

// Redeem calls RedeemFunc.
func (mock *MockOrderedAdapter) Redeem() {
	if mock.RedeemFunc == nil {
		panic("MockOrderedAdapter.RedeemFunc: method is nil but OrderedAdapter.Redeem was just called")
	}
	callInfo := struct {
	}{}
	mock.lockRedeem.Lock()
	mock.calls.Redeem = append(mock.calls.Redeem, callInfo)
	mock.lockRedeem.Unlock()
	mock.RedeemFunc()
}

// RedeemCalls gets all the calls that were made to Redeem.
// Check the length with:
//
//	len(mockedOrderedAdapter.RedeemCalls())
func (mock *MockOrderedAdapter) RedeemCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockRedeem.RLock()
	calls = mock.calls.Redeem
	mock.lockRedeem.RUnlock()
	return calls
}

// Reset calls ResetFunc.
func (mock *MockOrderedAdapter) Reset() {
	if mock.ResetFunc == nil {
		panic("MockOrderedAdapter.ResetFunc: method is nil but OrderedAdapter.Reset was just called")
	}
	callInfo := struct {
	}{}
	mock.lockReset.Lock()
	mock.calls.Reset = append(mock.calls.Reset, callInfo)
	mock.lockReset.Unlock()
	mock.ResetFunc()
}

// ResetCalls gets all the calls that were made to Reset.
// Check the length with:
//
//	len(mockedOrderedAdapter.ResetCalls())
func (mock *MockOrderedAdapter) ResetCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockReset.RLock()
	calls = mock.calls.Reset
	mock.lockReset.RUnlock()
	return calls
}

// Ensure that MockPoolable does implement ifaces.Poolable.
// If this is not the case, regenerate this file with mockery.
var _ ifaces.Poolable = &MockPoolable{}

// MockPoolable is a mock implementation of ifaces.Poolable.
//
//	func TestSomethingThatUsesPoolable(t *testing.T) {
//
//		// make and configure a mocked ifaces.Poolable
//		mockedPoolable := &MockPoolable{
//			RedeemFunc: func()  {
//				panic("mock out the Redeem method")
//			},
//			ResetFunc: func()  {
//				panic("mock out the Reset method")
//			},
//		}
//
//		// use mockedPoolable in code that requires ifaces.Poolable
//		// and then make assertions.
//
//	}
type MockPoolable struct {
	// RedeemFunc mocks the Redeem method.
	RedeemFunc func()

	// ResetFunc mocks the Reset method.
	ResetFunc func()

	// calls tracks calls to the methods.
	calls struct {
		// Redeem holds details about calls to the Redeem method.
		Redeem []struct {
		}
		// Reset holds details about calls to the Reset method.
		Reset []struct {
		}
	}
	lockRedeem sync.RWMutex
	lockReset  sync.RWMutex
}

// Redeem calls RedeemFunc.
func (mock *MockPoolable) Redeem() {
	if mock.RedeemFunc == nil {
		panic("MockPoolable.RedeemFunc: method is nil but Poolable.Redeem was just called")
	}
	callInfo := struct {
	}{}
	mock.lockRedeem.Lock()
	mock.calls.Redeem = append(mock.calls.Redeem, callInfo)
	mock.lockRedeem.Unlock()
	mock.RedeemFunc()
}

// RedeemCalls gets all the calls that were made to Redeem.
// Check the length with:
//
//	len(mockedPoolable.RedeemCalls())
func (mock *MockPoolable) RedeemCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockRedeem.RLock()
	calls = mock.calls.Redeem
	mock.lockRedeem.RUnlock()
	return calls
}

// Reset calls ResetFunc.
func (mock *MockPoolable) Reset() {
	if mock.ResetFunc == nil {
		panic("MockPoolable.ResetFunc: method is nil but Poolable.Reset was just called")
	}
	callInfo := struct {
	}{}
	mock.lockReset.Lock()
	mock.calls.Reset = append(mock.calls.Reset, callInfo)
	mock.lockReset.Unlock()
	mock.ResetFunc()
}

// ResetCalls gets all the calls that were made to Reset.
// Check the length with:
//
//	len(mockedPoolable.ResetCalls())
func (mock *MockPoolable) ResetCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockReset.RLock()
	calls = mock.calls.Reset
	mock.lockReset.RUnlock()
	return calls
}

// Ensure that MockRegistrar does implement ifaces.Registrar.
// If this is not the case, regenerate this file with mockery.
var _ ifaces.Registrar = &MockRegistrar{}

// MockRegistrar is a mock implementation of ifaces.Registrar.
//
//	func TestSomethingThatUsesRegistrar(t *testing.T) {
//
//		// make and configure a mocked ifaces.Registrar
//		mockedRegistrar := &MockRegistrar{
//			RegisterForFunc: func(registryEntry ifaces.RegistryEntry)  {
//				panic("mock out the RegisterFor method")
//			},
//		}
//
//		// use mockedRegistrar in code that requires ifaces.Registrar
//		// and then make assertions.
//
//	}
type MockRegistrar struct {
	// RegisterForFunc mocks the RegisterFor method.
	RegisterForFunc func(registryEntry ifaces.RegistryEntry)

	// calls tracks calls to the methods.
	calls struct {
		// RegisterFor holds details about calls to the RegisterFor method.
		RegisterFor []struct {
			// RegistryEntry is the registryEntry argument value.
			RegistryEntry ifaces.RegistryEntry
		}
	}
	lockRegisterFor sync.RWMutex
}

// RegisterFor calls RegisterForFunc.
func (mock *MockRegistrar) RegisterFor(registryEntry ifaces.RegistryEntry) {
	if mock.RegisterForFunc == nil {
		panic("MockRegistrar.RegisterForFunc: method is nil but Registrar.RegisterFor was just called")
	}
	callInfo := struct {
		RegistryEntry ifaces.RegistryEntry
	}{
		RegistryEntry: registryEntry,
	}
	mock.lockRegisterFor.Lock()
	mock.calls.RegisterFor = append(mock.calls.RegisterFor, callInfo)
	mock.lockRegisterFor.Unlock()
	mock.RegisterForFunc(registryEntry)
}

// RegisterForCalls gets all the calls that were made to RegisterFor.
// Check the length with:
//
//	len(mockedRegistrar.RegisterForCalls())
func (mock *MockRegistrar) RegisterForCalls() []struct {
	RegistryEntry ifaces.RegistryEntry
} {
	var calls []struct {
		RegistryEntry ifaces.RegistryEntry
	}
	mock.lockRegisterFor.RLock()
	calls = mock.calls.RegisterFor
	mock.lockRegisterFor.RUnlock()
	return calls
}
