/*
 * Copyright (c) 2005 Reyk Floeter <reyk@openbsd.org>
 * Copyright (c) 2020 Roumen Petrov.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _PORT_TUN_H
#define _PORT_TUN_H

struct Channel;
struct ssh;

#if defined(SSH_TUN_LINUX) || defined(SSH_TUN_FREEBSD) || \
    defined(SSH_TUN_DARWIN)
# define CUSTOM_SYS_TUN_OPEN
int	  sys_tun_open(int, int, char **);
#endif

#if defined(SSH_TUN_COMPAT_AF) || defined(SSH_TUN_PREPEND_AF)
# define SSH_TUN_FILTER
int	 sys_tun_infilter(struct ssh *, struct Channel *, char *, int);
u_char	*sys_tun_outfilter(struct ssh *, struct Channel *, u_char **, size_t *);
#endif

#if defined(SYS_RDOMAIN_LINUX)
# define HAVE_SYS_GET_RDOMAIN
# define HAVE_SYS_SET_RDOMAIN
# define HAVE_SYS_VALID_RDOMAIN
char *sys_get_rdomain(int fd);
int sys_set_rdomain(int fd, const char *name);
int sys_valid_rdomain(const char *name);
#endif

#if defined(SYS_RDOMAIN_XXX)
# define HAVE_SYS_SET_PROCESS_RDOMAIN
void sys_set_process_rdomain(const char *name);
#endif

#ifndef HAVE_SYS_SET_PROCESS_RDOMAIN
# ifdef __OpenBSD__
#  define HAVE_SETRTABLE
# endif
#endif

#if defined(HAVE_SYS_SET_PROCESS_RDOMAIN) || defined(HAVE_SETRTABLE)
# defined ENABLE_ROUTING_DOMAIN
#endif

#endif
