
  $ mkdir lib
  $ cat > dune-project <<EOF
  > (lang dune 3.20)
  > (package (name foo))
  > (using melange 1.0)
  > EOF

  $ cat > lib/dune <<EOF
  > (library
  >  (name foo)
  >  (modes melange))
  > EOF
  $ cat > lib/bar.ml <<EOF
  > let greeting = "hello"
  > EOF

  $ cat > dune <<EOF
  > (melange.emit
  >  (target dist)
  >  (libraries foo)
  >  (emit_stdlib false)
  >  (modules))
  > EOF
  $ cat > lib/bar.ml <<EOF
  > let greeting = "hello"
  > EOF

  $ dune build @melange

No `.js` file present for the library alias `foo.js`

  $ find _build/default/dist/lib -type f | sort
  _build/default/dist/lib/bar.js

Now write a foo.ml file

  $ cat > lib/dune <<EOF
  > (library
  >  (name foo)
  >  (modes melange))
  > EOF
  $ cat > lib/foo.ml <<EOF
  > module Bar = Bar
  > let x = "foo"
  > EOF

  $ dune build @melange

`foo.js` was manually written, therefore it's present

  $ find _build/default/dist/ -type f | sort
  _build/default/dist/lib/bar.js
  _build/default/dist/lib/foo.js
  $ cat _build/default/dist/lib/foo.js
  // Generated by Melange
  'use strict';
  
  
  const x = "foo";
  
  module.exports = {
    x,
  }
  /* No side effect */

`(include_subdirs qualified)`

  $ mkdir lib/sub
  $ cat > lib/dune <<EOF
  > (include_subdirs qualified)
  > (library
  >  (name foo)
  >  (modes melange))
  > EOF
  $ cat > lib/bar.ml <<EOF
  > let hello = Sub.Hello.hello
  > EOF
  $ cat > lib/sub/hello.ml <<EOF
  > let hello = "hello from sub"
  > EOF
  $ cat > lib/foo.ml <<EOF
  > module Bar = Bar
  > let x = "foo"
  > EOF

  $ dune build @melange

`foo.js` was manually written, therefore it's present. `sub.js` is an alias
file, and it's not present

  $ find _build/default/dist/lib -type f | sort
  _build/default/dist/lib/bar.js
  _build/default/dist/lib/foo.js
  _build/default/dist/lib/sub/hello.js

  $ cat > lib/dune <<EOF
  > (include_subdirs qualified)
  > (library
  >  (name foo)
  >  (modes melange))
  > EOF
  $ cat > lib/bar.ml <<EOF
  > let hello = Sub.Hello.hello ^ Sub.world
  > EOF
  $ cat > lib/sub/sub.ml <<EOF
  > module Hello = Hello
  > let world = "world"
  > EOF
  $ cat > lib/sub/hello.ml <<EOF
  > let hello = "hello from sub"
  > EOF
  $ cat > lib/foo.ml <<EOF
  > module Bar = Bar
  > let x = "foo"
  > EOF

  $ dune build @melange

`foo.js` was manually written, therefore it's present. `sub.js` is an alias
file, and it's not present

  $ find _build/default/dist/lib -type f | sort
  _build/default/dist/lib/bar.js
  _build/default/dist/lib/foo.js
  _build/default/dist/lib/sub/hello.js
  _build/default/dist/lib/sub/sub.js


