/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	schedulingv1alpha1 "k8s.io/api/scheduling/v1alpha1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// WorkloadLister helps list Workloads.
// All objects returned here must be treated as read-only.
type WorkloadLister interface {
	// List lists all Workloads in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*schedulingv1alpha1.Workload, err error)
	// Workloads returns an object that can list and get Workloads.
	Workloads(namespace string) WorkloadNamespaceLister
	WorkloadListerExpansion
}

// workloadLister implements the WorkloadLister interface.
type workloadLister struct {
	listers.ResourceIndexer[*schedulingv1alpha1.Workload]
}

// NewWorkloadLister returns a new WorkloadLister.
func NewWorkloadLister(indexer cache.Indexer) WorkloadLister {
	return &workloadLister{listers.New[*schedulingv1alpha1.Workload](indexer, schedulingv1alpha1.Resource("workload"))}
}

// Workloads returns an object that can list and get Workloads.
func (s *workloadLister) Workloads(namespace string) WorkloadNamespaceLister {
	return workloadNamespaceLister{listers.NewNamespaced[*schedulingv1alpha1.Workload](s.ResourceIndexer, namespace)}
}

// WorkloadNamespaceLister helps list and get Workloads.
// All objects returned here must be treated as read-only.
type WorkloadNamespaceLister interface {
	// List lists all Workloads in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*schedulingv1alpha1.Workload, err error)
	// Get retrieves the Workload from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*schedulingv1alpha1.Workload, error)
	WorkloadNamespaceListerExpansion
}

// workloadNamespaceLister implements the WorkloadNamespaceLister
// interface.
type workloadNamespaceLister struct {
	listers.ResourceIndexer[*schedulingv1alpha1.Workload]
}
