/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import javax.servlet.Servlet;
import org.ops4j.pax.web.extender.whiteboard.internal.WhiteboardExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractElementTracker;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.events.ServletEventData;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ResourceTracker
extends AbstractElementTracker<Object, Servlet, ServletEventData, ServletModel> {
    private ResourceTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        super(whiteboardExtenderContext, bundleContext);
    }

    public static ServiceTracker<Object, ServletModel> createTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        return new ResourceTracker(whiteboardExtenderContext, bundleContext).create(String.format("(%s=*)", "osgi.http.whiteboard.resource.pattern"));
    }

    @Override
    protected ServletModel createElementModel(ServiceReference<Object> serviceReference, Integer rank, Long serviceId) {
        this.log.debug("Creating resource model from R7 whiteboard service {} (id={})", serviceReference, (Object)serviceId);
        String[] urlPatterns = (String[])Utils.getPaxWebProperty(serviceReference, null, (String)"osgi.http.whiteboard.resource.pattern", Utils::asStringArray);
        String path = Utils.getStringProperty(serviceReference, (String)"osgi.http.whiteboard.resource.prefix");
        if (path == null || "".equals(path.trim())) {
            path = "/";
        }
        ServletModel.Builder builder = new ServletModel.Builder().withServiceRankAndId(rank.intValue(), serviceId.longValue()).withRegisteringBundle(serviceReference.getBundle()).withUrlPatterns(urlPatterns).withLoadOnStartup(Integer.valueOf(1)).withAsyncSupported(Boolean.valueOf(true)).withRawPath(path).resourceServlet(true);
        return builder.build();
    }
}

