/*
 * Unix library interface
 *
 * Copyright 2023 Paul Gofman for CodeWeavers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "wine/unixlib.h"

enum amd_ags_funcs
{
    unix_init,
    unix_get_device_info,
};

struct get_device_info_params
{
    uint32_t device_id;
    uint32_t _pad;
    /* Output parameters. */
    uint32_t asic_family;
    uint32_t num_cu;
    uint32_t num_wgp;
    uint32_t num_rops;
    uint32_t core_clock;
    uint32_t memory_clock;
    uint32_t memory_bandwidth;
    float teraflops;
};
