#! /bin/env pytest
"""
Tests of the Python bindings for Hamlib

DO NOT EDIT this autogenerated file, run "make generate-pytests" instead
"""
import Hamlib

class TestClass:
    """A pytest class for Hamlib.Rig"""

    @classmethod
    def setup_class(cls):
        """Common initialization before calling test methods"""
        cls.actual_callables, cls.actual_properties = cls.generate_data(Hamlib.Rig)

    def test_callables(self):
        """Check that nothing was added or removed"""
        expected_callables = ['close',
'ext_token_lookup',
'get_ant',
'get_chan_all',
'get_channel',
'get_conf',
'get_ctcss_sql',
'get_ctcss_tone',
'get_dcd',
'get_dcs_code',
'get_dcs_sql',
'get_ext_func',
'get_ext_level',
'get_ext_parm',
'get_freq',
'get_func',
'get_info',
'get_level',
'get_level_f',
'get_level_i',
'get_mem',
'get_mode',
'get_parm',
'get_parm_f',
'get_parm_i',
'get_powerstat',
'get_ptt',
'get_rit',
'get_rptr_offs',
'get_rptr_shift',
'get_split_freq',
'get_split_mode',
'get_split_vfo',
'get_ts',
'get_vfo',
'get_vfo_info',
'get_xit',
'has_get_func',
'has_get_level',
'has_get_parm',
'has_scan',
'has_set_func',
'has_set_parm',
'has_vfo_op',
'lookup_mem_caps',
'mem_count',
'open',
'passband_narrow',
'passband_normal',
'passband_wide',
'recv_dtmf',
'reset',
'scan',
'send_dtmf',
'send_morse',
'send_raw',
'set_ant',
'set_bank',
'set_channel',
'set_conf',
'set_ctcss_sql',
'set_ctcss_tone',
'set_dcd_callback',
'set_dcs_code',
'set_dcs_sql',
'set_ext_func',
'set_ext_level',
'set_ext_parm',
'set_freq',
'set_freq_callback',
'set_func',
'set_level',
'set_mem',
'set_mode',
'set_mode_callback',
'set_parm',
'set_pltune_callback',
'set_powerstat',
'set_ptt',
'set_ptt_callback',
'set_rit',
'set_rptr_offs',
'set_rptr_shift',
'set_spectrum_callback',
'set_split_freq',
'set_split_freq_mode',
'set_split_mode',
'set_split_vfo',
'set_ts',
'set_vfo',
'set_vfo_callback',
'set_vfo_opt',
'set_xit',
'token_lookup',
'vfo_op']
        assert expected_callables == self.actual_callables

    def test_properties(self):
        """Check that nothing was added or removed"""
        expected_properties = ['caps',
'do_exception',
'error_status',
'rig',
'state',
'thisown']
        assert expected_properties == self.actual_properties

    @classmethod
    def generate_data(cls, the_object):
        """Extract callables and properties from the given object"""
        callables = []
        properties = []
        for method_or_property in dir(the_object):
            if not method_or_property.startswith("_"):
                if callable(getattr(the_object, method_or_property)):
                    callables.append(method_or_property)
                else:
                    properties.append(method_or_property)

        callables.sort()
        properties.sort()
        return callables, properties
