# Summary

# Welcome

- [Getting Started](./getting-started.md)
- [Installation](./installation.md)
  - [Update](./update.md)
  - [Uninstall](./uninstall.md)
- [Troubleshooting](./troubleshooting.md)

# AI

- [Overview](./ai/overview.md)
- [Agent Panel](./ai/agent-panel.md)
  - [Tools](./ai/tools.md)
  - [External Agents](./ai/external-agents.md)
- [Inline Assistant](./ai/inline-assistant.md)
- [Edit Prediction](./ai/edit-prediction.md)
- [Text Threads](./ai/text-threads.md)
- [Rules](./ai/rules.md)
- [Model Context Protocol](./ai/mcp.md)
- [Configuration](./ai/configuration.md)
  - [LLM Providers](./ai/llm-providers.md)
  - [Agent Settings](./ai/agent-settings.md)
- [Subscription](./ai/subscription.md)
  - [Models](./ai/models.md)
  - [Plans and Usage](./ai/plans-and-usage.md)
  - [Billing](./ai/billing.md)

# Working with Code

- [Editing Code](./editing-code.md)
  - [Code Completions](./completions.md)
  - [Snippets](./snippets.md)
  - [Diagnostics & Quick Fixes](./diagnostics.md)
  - [Multibuffers](./multibuffers.md)
- [Finding & Navigating](./finding-navigating.md)
  - [Command Palette](./command-palette.md)
  - [Outline Panel](./outline-panel.md)
  - [Tab Switcher](./tab-switcher.md)
- [Running & Testing](./running-testing.md)
  - [Terminal](./terminal.md)
  - [Tasks](./tasks.md)
  - [Debugger](./debugger.md)
  - [REPL](./repl.md)
- [Git](./git.md)

# Collaboration

- [Overview](./collaboration/overview.md)
  - [Channels](./collaboration/channels.md)
  - [Contacts and Private Calls](./collaboration/contacts-and-private-calls.md)

# Remote Development

- [Overview](./remote-development.md)
- [Environment Variables](./environment.md)
- [Dev Containers](./dev-containers.md)

# Platform Support

- [macOS](./macos.md)
- [Windows](./windows.md)
- [Linux](./linux.md)

# Customization

- [Appearance](./appearance.md)
  - [Themes](./themes.md)
  - [Icon Themes](./icon-themes.md)
  - [Fonts & Visual Tweaks](./visual-customization.md)
- [Keybindings](./key-bindings.md)
  - [Vim Mode](./vim.md)
  - [Helix Mode](./helix.md)

# Language Support

- [All Languages](./languages.md)
- [Configuring Languages](./configuring-languages.md)
  - [Toolchains](./toolchains.md)
- [Ansible](./languages/ansible.md)
- [AsciiDoc](./languages/asciidoc.md)
- [Astro](./languages/astro.md)
- [Bash](./languages/bash.md)
- [Biome](./languages/biome.md)
- [C](./languages/c.md)
- [C++](./languages/cpp.md)
- [C#](./languages/csharp.md)
- [Clojure](./languages/clojure.md)
- [CSS](./languages/css.md)
- [Dart](./languages/dart.md)
- [Deno](./languages/deno.md)
- [Diff](./languages/diff.md)
- [Docker](./languages/docker.md)
- [Elixir](./languages/elixir.md)
- [Elm](./languages/elm.md)
- [Emmet](./languages/emmet.md)
- [Erlang](./languages/erlang.md)
- [Fish](./languages/fish.md)
- [GDScript](./languages/gdscript.md)
- [Gleam](./languages/gleam.md)
- [GLSL](./languages/glsl.md)
- [Go](./languages/go.md)
- [Groovy](./languages/groovy.md)
- [Haskell](./languages/haskell.md)
- [Helm](./languages/helm.md)
- [HTML](./languages/html.md)
- [Java](./languages/java.md)
- [JavaScript](./languages/javascript.md)
- [Julia](./languages/julia.md)
- [JSON](./languages/json.md)
- [Jsonnet](./languages/jsonnet.md)
- [Kotlin](./languages/kotlin.md)
- [Lua](./languages/lua.md)
- [Luau](./languages/luau.md)
- [Makefile](./languages/makefile.md)
- [Markdown](./languages/markdown.md)
- [Nim](./languages/nim.md)
- [OCaml](./languages/ocaml.md)
- [OpenTofu](./languages/opentofu.md)
- [PHP](./languages/php.md)
- [PowerShell](./languages/powershell.md)
- [Prisma](./languages/prisma.md)
- [Proto](./languages/proto.md)
- [PureScript](./languages/purescript.md)
- [Python](./languages/python.md)
- [R](./languages/r.md)
- [Rego](./languages/rego.md)
- [ReStructuredText](./languages/rst.md)
- [Racket](./languages/racket.md)
- [Roc](./languages/roc.md)
- [Ruby](./languages/ruby.md)
- [Rust](./languages/rust.md)
- [Scala](./languages/scala.md)
- [Scheme](./languages/scheme.md)
- [Shell Script](./languages/sh.md)
- [SQL](./languages/sql.md)
- [Svelte](./languages/svelte.md)
- [Swift](./languages/swift.md)
- [Tailwind CSS](./languages/tailwindcss.md)
- [Terraform](./languages/terraform.md)
- [TOML](./languages/toml.md)
- [TypeScript](./languages/typescript.md)
- [Uiua](./languages/uiua.md)
- [Vue](./languages/vue.md)
- [XML](./languages/xml.md)
- [YAML](./languages/yaml.md)
- [Yara](./languages/yara.md)
- [Yarn](./languages/yarn.md)
- [Zig](./languages/zig.md)

# Extensions

- [Overview](./extensions.md)
- [Installing Extensions](./extensions/installing-extensions.md)
- [Developing Extensions](./extensions/developing-extensions.md)
- [Extension Capabilities](./extensions/capabilities.md)
- [Language Extensions](./extensions/languages.md)
- [Debugger Extensions](./extensions/debugger-extensions.md)
- [Theme Extensions](./extensions/themes.md)
- [Icon Theme Extensions](./extensions/icon-themes.md)
- [Slash Command Extensions](./extensions/slash-commands.md)
- [Agent Server Extensions](./extensions/agent-servers.md)
- [MCP Server Extensions](./extensions/mcp-extensions.md)

# Coming From…

- [VS Code](./migrate/vs-code.md)
- [IntelliJ IDEA](./migrate/intellij.md)
- [PyCharm](./migrate/pycharm.md)
- [WebStorm](./migrate/webstorm.md)
- [RustRover](./migrate/rustrover.md)

# Reference

- [All Settings](./reference/all-settings.md)
- [All Actions](./all-actions.md)
- [CLI Reference](./reference/cli.md)

# Account & Privacy

- [Authenticate](./authentication.md)
- [Privacy and Security](./ai/privacy-and-security.md)
  - [Worktree Trust](./worktree-trust.md)
  - [AI Improvement](./ai/ai-improvement.md)
- [Telemetry](./telemetry.md)

# Developing Zed

- [Developing Zed](./development.md)
  - [macOS](./development/macos.md)
  - [Linux](./development/linux.md)
  - [Windows](./development/windows.md)
  - [FreeBSD](./development/freebsd.md)
  - [Using Debuggers](./development/debuggers.md)
  - [Performance](./performance.md)
  - [Glossary](./development/glossary.md)
- [Release Notes](./development/release-notes.md)
- [Debugging Crashes](./development/debugging-crashes.md)
